/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.impl;

import ilog.rules.bres.model.IlrAlreadyExistException;
import ilog.rules.bres.model.IlrFormatException;
import ilog.rules.bres.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.bres.model.IlrMutableRuleAppInformation;
import ilog.rules.bres.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.bres.model.IlrNameValidator;
import ilog.rules.bres.model.IlrPathParser;
import ilog.rules.bres.model.IlrRepository;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.model.IlrResourceRuntimeException;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.IlrVersion;
import ilog.rules.bres.model.IlrVersionParser;
import ilog.rules.bres.model.impl.IlrMutableRuleAppInformationImpl;
import ilog.rules.bres.model.impl.IlrMutableRulesetArchiveInformationImpl;
import ilog.rules.bres.model.impl.IlrNameValidatorImpl;
import ilog.rules.bres.model.impl.IlrPathParserImpl;
import ilog.rules.bres.model.impl.IlrRepositoryImpl;
import ilog.rules.bres.model.impl.IlrVersionImpl;
import ilog.rules.bres.model.impl.IlrVersionParserImpl;
import ilog.rules.bres.persistence.IlrResourceProviderException;
import ilog.rules.bres.persistence.IlrTransactionalResourceProvider;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IlrRepositoryFactoryImpl
implements IlrRepositoryFactory {
    private IlrNameValidator nameValidator = new IlrNameValidatorImpl();
    private IlrVersionParser versionParser = new IlrVersionParserImpl();
    private IlrPathParser rulesetPathParser = new IlrPathParserImpl(this.nameValidator, this.versionParser);

    public IlrNameValidator getNameValidator() {
        return this.nameValidator;
    }

    public IlrVersionParser getVersionParser() {
        return this.versionParser;
    }

    public IlrPathParser getPathParser() {
        return this.rulesetPathParser;
    }

    public IlrVersion nextVersion(IlrVersion ilrVersion, String string) {
        if (ilrVersion == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10020");
        }
        return ((IlrVersionImpl)ilrVersion).nextVersion(string);
    }

    public IlrRepository createRepository() {
        return new IlrRepositoryImpl(this);
    }

    public IlrRepository createRepository(IlrTransactionalResourceProvider ilrTransactionalResourceProvider) throws IlrResourceRuntimeException, IlrIllegalArgumentRuntimeException {
        Set set = this.loadRepository(ilrTransactionalResourceProvider);
        return new IlrRepositoryImpl(this, ilrTransactionalResourceProvider, set);
    }

    public IlrMutableRuleAppInformation createRuleApp(String string, IlrVersion ilrVersion) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        return this.createRuleApp(string, ilrVersion, new Date());
    }

    public IlrMutableRuleAppInformation createRuleApp(String string, IlrVersion ilrVersion, Date date) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.checkRuleAppParameters(string, ilrVersion, date);
        return new IlrMutableRuleAppInformationImpl(string, ilrVersion, date);
    }

    public IlrMutableRuleAppInformation createRuleApp(IlrRuleAppInformation ilrRuleAppInformation) throws IlrIllegalArgumentRuntimeException {
        Object object;
        IlrMutableRuleAppInformation ilrMutableRuleAppInformation;
        if (ilrRuleAppInformation == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10029");
        }
        try {
            ilrMutableRuleAppInformation = this.createRuleApp(ilrRuleAppInformation.getName(), ilrRuleAppInformation.getVersion(), ilrRuleAppInformation.getCreationDate());
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IllegalStateException();
        }
        ilrMutableRuleAppInformation.setDisplayName(ilrRuleAppInformation.getDisplayName());
        ilrMutableRuleAppInformation.setDescription(ilrRuleAppInformation.getDescription());
        Set<Map.Entry<Object, Object>> set = ilrRuleAppInformation.getProperties().toProperties().entrySet();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            ilrMutableRuleAppInformation.setProperty((String)object.getKey(), (String)object.getValue());
        }
        object2 = ilrRuleAppInformation.getRulesets();
        object = object2.iterator();
        while (object.hasNext()) {
            IlrRulesetArchiveInformation ilrRulesetArchiveInformation = (IlrRulesetArchiveInformation)object.next();
            IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation = this.createRuleset(ilrRulesetArchiveInformation);
            try {
                ilrMutableRuleAppInformation.addRuleset(ilrMutableRulesetArchiveInformation);
            }
            catch (IlrAlreadyExistException ilrAlreadyExistException) {
                throw new IllegalStateException();
            }
        }
        return ilrMutableRuleAppInformation;
    }

    public IlrMutableRulesetArchiveInformation createRuleset(String string, IlrVersion ilrVersion) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        return this.createRuleset(string, ilrVersion, new Date());
    }

    public IlrMutableRulesetArchiveInformation createRuleset(String string, IlrVersion ilrVersion, Date date) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.checkRulesetParameters(string, ilrVersion, date);
        return new IlrMutableRulesetArchiveInformationImpl(string, ilrVersion, date);
    }

    public IlrMutableRulesetArchiveInformation createRuleset(IlrRulesetArchiveInformation ilrRulesetArchiveInformation) throws IlrIllegalArgumentRuntimeException {
        IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation;
        if (ilrRulesetArchiveInformation == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10030");
        }
        try {
            ilrMutableRulesetArchiveInformation = this.createRuleset(ilrRulesetArchiveInformation.getName(), ilrRulesetArchiveInformation.getVersion(), ilrRulesetArchiveInformation.getCreationDate());
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IllegalStateException();
        }
        ilrMutableRulesetArchiveInformation.setDisplayName(ilrRulesetArchiveInformation.getDisplayName());
        ilrMutableRulesetArchiveInformation.setDescription(ilrRulesetArchiveInformation.getDescription());
        ilrMutableRulesetArchiveInformation.setRulesetArchive(ilrRulesetArchiveInformation.getRulesetArchive());
        Set<Map.Entry<Object, Object>> set = ilrRulesetArchiveInformation.getProperties().toProperties().entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            ilrMutableRulesetArchiveInformation.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return ilrMutableRulesetArchiveInformation;
    }

    protected void checkRuleAppParameters(String string, IlrVersion ilrVersion, Date date) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.nameValidator.validateRuleAppName(string);
        if (ilrVersion == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10020");
        }
        if (date == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10028");
        }
    }

    protected void checkRulesetParameters(String string, IlrVersion ilrVersion, Date date) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.nameValidator.validateRulesetName(string);
        if (ilrVersion == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10020");
        }
        if (date == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10028");
        }
    }

    protected Set loadRepository(IlrTransactionalResourceProvider ilrTransactionalResourceProvider) throws IlrResourceRuntimeException, IlrIllegalArgumentRuntimeException {
        if (ilrTransactionalResourceProvider == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10010");
        }
        try {
            return ilrTransactionalResourceProvider.load(this);
        }
        catch (IlrResourceProviderException ilrResourceProviderException) {
            throw new IlrResourceRuntimeException("ilog.rules.bres.model", "10026", ilrResourceProviderException);
        }
    }
}

