/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.impl;

import ilog.rules.bres.model.IlrAlreadyExistException;
import ilog.rules.bres.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.bres.model.IlrMutableRuleAppInformation;
import ilog.rules.bres.model.IlrRepository;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.model.IlrResourceRuntimeException;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.IlrVersion;
import ilog.rules.bres.model.impl.IlrEntity;
import ilog.rules.bres.model.impl.IlrEntityContainer;
import ilog.rules.bres.model.impl.IlrMutableRuleAppInformationImpl;
import ilog.rules.bres.model.impl.IlrMutableRulesetArchiveInformationImpl;
import ilog.rules.bres.model.impl.IlrPathImpl;
import ilog.rules.bres.model.impl.IlrRuleAppInformationImpl;
import ilog.rules.bres.model.impl.IlrRuleAppsMerger;
import ilog.rules.bres.model.impl.IlrRulesetArchiveInformationImpl;
import ilog.rules.bres.persistence.IlrResourceProviderException;
import ilog.rules.bres.persistence.IlrTransactionalResourceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IlrRepositoryImpl
implements IlrRepository {
    protected IlrRepositoryFactory repositoryFactory;
    protected IlrTransactionalResourceProvider resourceProvider;
    protected IlrEntityContainer ruleAppsContainer;

    protected IlrRepositoryImpl(IlrRepositoryFactory ilrRepositoryFactory) {
        this(ilrRepositoryFactory, null, null);
    }

    protected IlrRepositoryImpl(IlrRepositoryFactory ilrRepositoryFactory, IlrTransactionalResourceProvider ilrTransactionalResourceProvider, Set set) {
        this.repositoryFactory = ilrRepositoryFactory;
        this.resourceProvider = ilrTransactionalResourceProvider;
        this.ruleAppsContainer = new IlrEntityContainer(set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IlrRuleAppInformationImpl ilrRuleAppInformationImpl = (IlrRuleAppInformationImpl)iterator.next();
                ilrRuleAppInformationImpl.linked(this, false);
            }
        }
    }

    public int getNbRuleApps() {
        return this.ruleAppsContainer.getNbEntities();
    }

    public Set getRuleApps() {
        return this.ruleAppsContainer.getEntities();
    }

    public Set getRuleApps(String string) {
        return this.ruleAppsContainer.getEntities(string);
    }

    public IlrRuleAppInformation getGreatestRuleApp(String string) {
        return (IlrRuleAppInformation)((Object)this.ruleAppsContainer.getGreatestEntity(string));
    }

    public IlrRuleAppInformation getRuleApp(String string, IlrVersion ilrVersion) {
        return (IlrRuleAppInformation)((Object)this.ruleAppsContainer.getEntity(string, ilrVersion));
    }

    public IlrRuleAppInformation addRuleApp(IlrRuleAppInformation ilrRuleAppInformation) throws IlrAlreadyExistException, IlrResourceRuntimeException {
        if (ilrRuleAppInformation == null) {
            return null;
        }
        if (ilrRuleAppInformation.getRepository() == this || this.ruleAppsContainer.containsEntity((IlrEntity)((Object)ilrRuleAppInformation))) {
            throw new IlrAlreadyExistException("ilog.rules.bres.model", "10001", new Object[]{ilrRuleAppInformation.toString()});
        }
        ((IlrRuleAppInformationImpl)ilrRuleAppInformation).setRepository(this);
        this.ruleAppsContainer.addEntity((IlrEntity)((Object)ilrRuleAppInformation));
        return ilrRuleAppInformation;
    }

    public boolean removeRuleApp(IlrRuleAppInformation ilrRuleAppInformation) throws IlrResourceRuntimeException {
        if (ilrRuleAppInformation == null || ilrRuleAppInformation.getRepository() != this) {
            return false;
        }
        IlrRuleAppInformationImpl ilrRuleAppInformationImpl = (IlrRuleAppInformationImpl)this.ruleAppsContainer.getEntity(ilrRuleAppInformation.getName(), ilrRuleAppInformation.getVersion());
        if (ilrRuleAppInformationImpl == null || ilrRuleAppInformationImpl != ilrRuleAppInformation) {
            return false;
        }
        ilrRuleAppInformationImpl.setRepository(null);
        this.ruleAppsContainer.removeEntity((IlrEntity)((Object)ilrRuleAppInformation));
        return true;
    }

    public IlrTransactionalResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void update() {
        IlrRuleAppInformationImpl ilrRuleAppInformationImpl;
        IlrEntityContainer ilrEntityContainer;
        Iterator iterator;
        if (this.resourceProvider == null) {
            return;
        }
        try {
            iterator = this.resourceProvider.load(this.repositoryFactory);
            ilrEntityContainer = new IlrEntityContainer((Set)((Object)iterator));
        }
        catch (IlrResourceProviderException ilrResourceProviderException) {
            throw new IlrResourceRuntimeException("ilog.rules.bres.model", "10031", ilrResourceProviderException);
        }
        iterator = this.getRuleApps().iterator();
        while (iterator.hasNext()) {
            IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl;
            ilrRuleAppInformationImpl = (IlrRuleAppInformationImpl)iterator.next();
            IlrRuleAppInformationImpl ilrRuleAppInformationImpl2 = (IlrRuleAppInformationImpl)ilrEntityContainer.removeEntity(ilrRuleAppInformationImpl);
            if (ilrRuleAppInformationImpl2 == null) {
                this.ruleAppsContainer.removeEntity(ilrRuleAppInformationImpl);
                ilrRuleAppInformationImpl.linked(null, true);
                continue;
            }
            Iterator iterator2 = ilrRuleAppInformationImpl.getRulesets().iterator();
            while (iterator2.hasNext()) {
                ilrRulesetArchiveInformationImpl = (IlrRulesetArchiveInformationImpl)iterator2.next();
                IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl2 = (IlrRulesetArchiveInformationImpl)ilrRuleAppInformationImpl2.rulesetsContainer.removeEntity(ilrRulesetArchiveInformationImpl);
                if (ilrRulesetArchiveInformationImpl2 == null) {
                    ilrRuleAppInformationImpl.rulesetsContainer.removeEntity(ilrRulesetArchiveInformationImpl);
                    ilrRulesetArchiveInformationImpl.linked(null, true);
                    continue;
                }
                ilrRulesetArchiveInformationImpl.updateFields(ilrRulesetArchiveInformationImpl2);
            }
            iterator2 = ilrRuleAppInformationImpl2.rulesetsContainer.getEntities().iterator();
            while (iterator2.hasNext()) {
                ilrRulesetArchiveInformationImpl = (IlrRulesetArchiveInformationImpl)iterator2.next();
                ilrRuleAppInformationImpl.rulesetsContainer.addEntity(ilrRulesetArchiveInformationImpl);
                ilrRulesetArchiveInformationImpl.linked(ilrRuleAppInformationImpl, false);
            }
            ilrRuleAppInformationImpl.updateFields(ilrRuleAppInformationImpl2, false);
        }
        iterator = ilrEntityContainer.getEntities().iterator();
        while (iterator.hasNext()) {
            ilrRuleAppInformationImpl = (IlrRuleAppInformationImpl)iterator.next();
            this.ruleAppsContainer.addEntity(ilrRuleAppInformationImpl);
            ilrRuleAppInformationImpl.linked(this, false);
        }
    }

    protected List addAtEndRuleApps(String string, Set set) {
        if (set == null) {
            throw new NullPointerException();
        }
        if (string == null || !string.equals("MAJOR_VERSION_POLICY") && !string.equals("MINOR_VERSION_POLICY")) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10023", new Object[]{string});
        }
        ArrayList<EntityOperation> arrayList = new ArrayList<EntityOperation>();
        IlrEntityContainer ilrEntityContainer = new IlrEntityContainer(this.ruleAppsContainer);
        ArrayList arrayList2 = new ArrayList(set);
        Collections.sort(arrayList2, IlrEntity.CASE_INSENSITIVE_ORDER);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            IlrMutableRuleAppInformationImpl ilrMutableRuleAppInformationImpl = (IlrMutableRuleAppInformationImpl)iterator.next();
            if (ilrEntityContainer.containsEntity(ilrMutableRuleAppInformationImpl)) {
                IlrVersion ilrVersion = this.repositoryFactory.nextVersion(ilrEntityContainer.getGreatestEntity(ilrMutableRuleAppInformationImpl.getName()).getVersion(), string);
                arrayList.add(RuleAppOperation.changePath(ilrEntityContainer, ilrMutableRuleAppInformationImpl, ilrVersion));
                continue;
            }
            arrayList.add(RuleAppOperation.add(ilrEntityContainer, ilrMutableRuleAppInformationImpl));
        }
        return arrayList;
    }

    protected List addAtEndRulesets(String string, Set set) {
        if (set == null) {
            throw new NullPointerException();
        }
        if (string == null || !string.equals("MAJOR_VERSION_POLICY") && !string.equals("MINOR_VERSION_POLICY")) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10023", new Object[]{string});
        }
        ArrayList<EntityOperation> arrayList = new ArrayList<EntityOperation>();
        IlrEntityContainer ilrEntityContainer = new IlrEntityContainer(this.ruleAppsContainer);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IlrMutableRuleAppInformationImpl ilrMutableRuleAppInformationImpl = (IlrMutableRuleAppInformationImpl)iterator.next();
            if (ilrEntityContainer.containsEntity(ilrMutableRuleAppInformationImpl)) {
                IlrMutableRuleAppInformationImpl ilrMutableRuleAppInformationImpl2 = (IlrMutableRuleAppInformationImpl)ilrEntityContainer.getEntity(ilrMutableRuleAppInformationImpl.getName(), ilrMutableRuleAppInformationImpl.getVersion());
                IlrEntityContainer ilrEntityContainer2 = new IlrEntityContainer(ilrMutableRuleAppInformationImpl2.rulesetsContainer);
                ArrayList arrayList2 = new ArrayList(ilrMutableRuleAppInformationImpl.getRulesets());
                Collections.sort(arrayList2, IlrEntity.CASE_INSENSITIVE_ORDER);
                Iterator iterator2 = arrayList2.iterator();
                while (iterator2.hasNext()) {
                    IlrMutableRulesetArchiveInformationImpl ilrMutableRulesetArchiveInformationImpl = (IlrMutableRulesetArchiveInformationImpl)iterator2.next();
                    if (ilrEntityContainer2.containsEntity(ilrMutableRulesetArchiveInformationImpl)) {
                        IlrVersion ilrVersion = this.repositoryFactory.nextVersion(ilrEntityContainer2.getGreatestEntity(ilrMutableRulesetArchiveInformationImpl.getName()).getVersion(), string);
                        arrayList.add(RulesetOperation.changePath(ilrEntityContainer2, ilrMutableRulesetArchiveInformationImpl, ilrVersion));
                        continue;
                    }
                    arrayList.add(RulesetOperation.add(ilrEntityContainer2, ilrMutableRulesetArchiveInformationImpl));
                    ilrEntityContainer2.addEntity(ilrMutableRulesetArchiveInformationImpl);
                }
                arrayList.add(RuleAppOperation.update(ilrMutableRuleAppInformationImpl));
                continue;
            }
            arrayList.add(RuleAppOperation.add(ilrEntityContainer, ilrMutableRuleAppInformationImpl));
        }
        return arrayList;
    }

    protected List replaceRuleApps(Set set) {
        if (set == null) {
            throw new NullPointerException();
        }
        ArrayList<EntityOperation> arrayList = new ArrayList<EntityOperation>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IlrMutableRuleAppInformationImpl ilrMutableRuleAppInformationImpl = (IlrMutableRuleAppInformationImpl)iterator.next();
            if (this.getRuleApp(ilrMutableRuleAppInformationImpl.getName(), ilrMutableRuleAppInformationImpl.getVersion()) != null) {
                arrayList.add(RuleAppOperation.replace(ilrMutableRuleAppInformationImpl));
                continue;
            }
            arrayList.add(RuleAppOperation.add(null, ilrMutableRuleAppInformationImpl));
        }
        return arrayList;
    }

    protected List replaceRulesets(Set set) {
        if (set == null) {
            throw new NullPointerException();
        }
        ArrayList<EntityOperation> arrayList = new ArrayList<EntityOperation>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IlrMutableRuleAppInformationImpl ilrMutableRuleAppInformationImpl = (IlrMutableRuleAppInformationImpl)iterator.next();
            IlrRuleAppInformation ilrRuleAppInformation = this.getRuleApp(ilrMutableRuleAppInformationImpl.getName(), ilrMutableRuleAppInformationImpl.getVersion());
            if (ilrRuleAppInformation != null) {
                Iterator iterator2 = ilrMutableRuleAppInformationImpl.getRulesets().iterator();
                while (iterator2.hasNext()) {
                    IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl = (IlrRulesetArchiveInformationImpl)iterator2.next();
                    if (ilrRuleAppInformation.getRuleset(ilrRulesetArchiveInformationImpl.getName(), ilrRulesetArchiveInformationImpl.getVersion()) != null) {
                        arrayList.add(RulesetOperation.replace(ilrRulesetArchiveInformationImpl));
                        continue;
                    }
                    arrayList.add(RulesetOperation.add(null, ilrRulesetArchiveInformationImpl));
                }
                arrayList.add(RuleAppOperation.update(ilrMutableRuleAppInformationImpl));
                continue;
            }
            arrayList.add(RuleAppOperation.add(null, ilrMutableRuleAppInformationImpl));
        }
        return arrayList;
    }

    protected List commit(List list) {
        try {
            this.commitResources(list);
        }
        catch (IlrResourceProviderException ilrResourceProviderException) {
            throw new IlrResourceRuntimeException("ilog.rules.bres.model", "10019", ilrResourceProviderException);
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityOperation entityOperation = (EntityOperation)iterator.next();
            entityOperation.commitOnRepository(this);
            entityOperation.commitOnReport(arrayList);
        }
        return arrayList;
    }

    private void commitResources(List list) throws IlrResourceProviderException {
        if (this.resourceProvider == null) {
            return;
        }
        int n = this.resourceProvider.startTransaction();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityOperation entityOperation = (EntityOperation)iterator.next();
            entityOperation.commitOnResourceProvider(this.resourceProvider, n);
        }
        this.resourceProvider.endTransaction(n);
    }

    private static class RulesetOperation
    implements EntityOperation {
        private final IlrRulesetArchiveInformationImpl ruleset;
        private final int operation;
        private final IlrVersion oldVersion;

        private RulesetOperation(IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl, int n, IlrVersion ilrVersion) {
            this.ruleset = ilrRulesetArchiveInformationImpl;
            this.operation = n;
            this.oldVersion = ilrVersion;
        }

        private RulesetOperation(IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl, int n) {
            this(ilrRulesetArchiveInformationImpl, n, null);
        }

        static EntityOperation changePath(IlrEntityContainer ilrEntityContainer, IlrMutableRulesetArchiveInformationImpl ilrMutableRulesetArchiveInformationImpl, IlrVersion ilrVersion) {
            IlrVersion ilrVersion2 = ilrMutableRulesetArchiveInformationImpl.getVersion();
            IlrMutableRuleAppInformation ilrMutableRuleAppInformation = (IlrMutableRuleAppInformation)ilrMutableRulesetArchiveInformationImpl.getRuleApp();
            ilrMutableRuleAppInformation.removeRuleset(ilrMutableRulesetArchiveInformationImpl);
            ilrMutableRulesetArchiveInformationImpl.setVersion(ilrVersion);
            try {
                ilrMutableRuleAppInformation.addRuleset(ilrMutableRulesetArchiveInformationImpl);
            }
            catch (IlrAlreadyExistException ilrAlreadyExistException) {
                // empty catch block
            }
            ilrEntityContainer.addEntity(ilrMutableRulesetArchiveInformationImpl);
            return new RulesetOperation(ilrMutableRulesetArchiveInformationImpl, 2, ilrVersion2);
        }

        static EntityOperation add(IlrEntityContainer ilrEntityContainer, IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl) {
            if (ilrEntityContainer != null) {
                ilrEntityContainer.addEntity(ilrRulesetArchiveInformationImpl);
            }
            return new RulesetOperation(ilrRulesetArchiveInformationImpl, 1);
        }

        static EntityOperation replace(IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl) {
            return new RulesetOperation(ilrRulesetArchiveInformationImpl, 3);
        }

        public void commitOnResourceProvider(IlrTransactionalResourceProvider ilrTransactionalResourceProvider, int n) throws IlrResourceProviderException {
            switch (this.operation) {
                case 3: {
                    ilrTransactionalResourceProvider.removeRuleset(new IlrPathImpl(this.ruleset), n);
                }
                case 1: 
                case 2: {
                    ilrTransactionalResourceProvider.addRuleset(new IlrPathImpl(this.ruleset), this.ruleset, n);
                }
            }
        }

        public void commitOnRepository(IlrRepositoryImpl ilrRepositoryImpl) {
            IlrMutableRuleAppInformationImpl ilrMutableRuleAppInformationImpl = (IlrMutableRuleAppInformationImpl)ilrRepositoryImpl.getRuleApp(this.ruleset.getRuleApp().getName(), this.ruleset.getRuleApp().getVersion());
            switch (this.operation) {
                case 3: {
                    IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl = (IlrRulesetArchiveInformationImpl)ilrMutableRuleAppInformationImpl.rulesetsContainer.removeEntity(this.ruleset);
                    ilrRulesetArchiveInformationImpl.linked(null, true);
                }
                case 1: 
                case 2: {
                    ilrMutableRuleAppInformationImpl.rulesetsContainer.addEntity(this.ruleset);
                    this.ruleset.linked(ilrMutableRuleAppInformationImpl, true);
                }
            }
        }

        public void commitOnReport(List list) {
            IlrPathImpl ilrPathImpl = new IlrPathImpl(this.ruleset.getRuleApp().getName(), this.ruleset.getRuleApp().getVersion(), this.ruleset.getName(), this.oldVersion != null ? this.oldVersion : this.ruleset.getVersion());
            IlrPathImpl ilrPathImpl2 = new IlrPathImpl(this.ruleset.getRuleApp().getName(), this.ruleset.getRuleApp().getVersion(), this.ruleset.getName(), this.ruleset.getVersion());
            list.add(new IlrRuleAppsMerger.IlrMergeOperation(ilrPathImpl, this.operation, ilrPathImpl2));
        }
    }

    private static class RuleAppOperation
    implements EntityOperation {
        private final IlrRuleAppInformationImpl ruleApp;
        private final int operation;
        private final IlrVersion oldVersion;

        private RuleAppOperation(IlrRuleAppInformationImpl ilrRuleAppInformationImpl, int n, IlrVersion ilrVersion) {
            this.ruleApp = ilrRuleAppInformationImpl;
            this.operation = n;
            this.oldVersion = ilrVersion;
        }

        private RuleAppOperation(IlrRuleAppInformationImpl ilrRuleAppInformationImpl, int n) {
            this(ilrRuleAppInformationImpl, n, ilrRuleAppInformationImpl.getVersion());
        }

        static EntityOperation changePath(IlrEntityContainer ilrEntityContainer, IlrMutableRuleAppInformationImpl ilrMutableRuleAppInformationImpl, IlrVersion ilrVersion) {
            IlrVersion ilrVersion2 = ilrMutableRuleAppInformationImpl.getVersion();
            ilrMutableRuleAppInformationImpl.setVersion(ilrVersion);
            ilrEntityContainer.addEntity(ilrMutableRuleAppInformationImpl);
            return new RuleAppOperation(ilrMutableRuleAppInformationImpl, 2, ilrVersion2);
        }

        static EntityOperation add(IlrEntityContainer ilrEntityContainer, IlrRuleAppInformationImpl ilrRuleAppInformationImpl) {
            if (ilrEntityContainer != null) {
                ilrEntityContainer.addEntity(ilrRuleAppInformationImpl);
            }
            return new RuleAppOperation(ilrRuleAppInformationImpl, 1);
        }

        static EntityOperation update(IlrRuleAppInformationImpl ilrRuleAppInformationImpl) {
            return new RuleAppOperation(ilrRuleAppInformationImpl, 0);
        }

        static EntityOperation replace(IlrRuleAppInformationImpl ilrRuleAppInformationImpl) {
            return new RuleAppOperation(ilrRuleAppInformationImpl, 3);
        }

        public void commitOnResourceProvider(IlrTransactionalResourceProvider ilrTransactionalResourceProvider, int n) throws IlrResourceProviderException {
            switch (this.operation) {
                case 3: {
                    ilrTransactionalResourceProvider.removeRuleApp(new IlrPathImpl(this.ruleApp), n);
                }
                case 1: 
                case 2: {
                    ilrTransactionalResourceProvider.addRuleApp(this.ruleApp, n);
                    break;
                }
                case 0: {
                    ilrTransactionalResourceProvider.updateRuleApp(this.ruleApp, n);
                }
            }
        }

        public void commitOnRepository(IlrRepositoryImpl ilrRepositoryImpl) {
            switch (this.operation) {
                case 3: {
                    IlrRuleAppInformationImpl ilrRuleAppInformationImpl = (IlrRuleAppInformationImpl)ilrRepositoryImpl.ruleAppsContainer.removeEntity(this.ruleApp);
                    ilrRuleAppInformationImpl.linked(null, true);
                }
                case 1: 
                case 2: {
                    ilrRepositoryImpl.ruleAppsContainer.addEntity(this.ruleApp);
                    this.ruleApp.linked(ilrRepositoryImpl, true);
                    break;
                }
                case 0: {
                    IlrRuleAppInformationImpl ilrRuleAppInformationImpl = (IlrRuleAppInformationImpl)ilrRepositoryImpl.ruleAppsContainer.getEntity(this.ruleApp.getName(), this.ruleApp.getVersion());
                    ilrRuleAppInformationImpl.updateFields(this.ruleApp, true);
                }
            }
        }

        public void commitOnReport(List list) {
            IlrPathImpl ilrPathImpl = new IlrPathImpl(this.ruleApp.getName(), this.oldVersion, null, null);
            IlrPathImpl ilrPathImpl2 = new IlrPathImpl(this.ruleApp);
            list.add(new IlrRuleAppsMerger.IlrMergeOperation(ilrPathImpl, this.operation, ilrPathImpl2));
            if (this.operation != 0) {
                int n = 1;
                if (this.operation == 2) {
                    n = 2;
                }
                Iterator iterator = this.ruleApp.getRulesets().iterator();
                while (iterator.hasNext()) {
                    IlrRulesetArchiveInformation ilrRulesetArchiveInformation = (IlrRulesetArchiveInformation)iterator.next();
                    IlrPathImpl ilrPathImpl3 = new IlrPathImpl(this.ruleApp.getName(), this.oldVersion, ilrRulesetArchiveInformation.getName(), ilrRulesetArchiveInformation.getVersion());
                    IlrPathImpl ilrPathImpl4 = new IlrPathImpl(this.ruleApp.getName(), this.ruleApp.getVersion(), ilrRulesetArchiveInformation.getName(), ilrRulesetArchiveInformation.getVersion());
                    list.add(new IlrRuleAppsMerger.IlrMergeOperation(ilrPathImpl3, n, ilrPathImpl4));
                }
            }
        }
    }

    private static interface EntityOperation {
        public void commitOnResourceProvider(IlrTransactionalResourceProvider var1, int var2) throws IlrResourceProviderException;

        public void commitOnRepository(IlrRepositoryImpl var1);

        public void commitOnReport(List var1);
    }
}

