/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.impl;

import ilog.rules.bres.model.IlrResourceRuntimeException;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRuleAppProperties;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.IlrVersion;
import ilog.rules.bres.model.impl.IlrEntity;
import ilog.rules.bres.model.impl.IlrEntityContainer;
import ilog.rules.bres.model.impl.IlrPathImpl;
import ilog.rules.bres.model.impl.IlrRepositoryImpl;
import ilog.rules.bres.model.impl.IlrRuleAppPropertiesImpl;
import ilog.rules.bres.model.impl.IlrRulesetArchiveInformationImpl;
import ilog.rules.bres.persistence.IlrResourceProviderException;
import ilog.rules.bres.persistence.IlrTransactionalResourceProvider;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IlrRuleAppInformationImpl
extends IlrEntity
implements IlrRuleAppInformation {
    protected IlrRuleAppPropertiesImpl raProperties;
    protected IlrEntityContainer rulesetsContainer;
    private boolean _propertiesLoaded = false;

    IlrRuleAppInformationImpl(IlrRepositoryImpl ilrRepositoryImpl, String string, IlrVersion ilrVersion, Date date, String string2, String string3, Properties properties, Set set) {
        super(ilrRepositoryImpl, string, ilrVersion, date, string2, string3);
        Properties properties2 = new Properties();
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        this.raProperties = new IlrRuleAppPropertiesImpl(properties2);
        this.rulesetsContainer = new IlrEntityContainer(set);
    }

    public IlrRuleAppProperties getProperties() throws IlrResourceRuntimeException {
        if (this.getResourceProvider() != null) {
            this.retreiveProperties(this.getResourceProvider());
        }
        return this.raProperties;
    }

    public String getProperty(String string) throws IlrResourceRuntimeException {
        String string2;
        if (this.getResourceProvider() != null) {
            this.retreiveProperties(this.getResourceProvider());
        }
        if ((string2 = this.raProperties.getValue(string)) != null) {
            return string2;
        }
        return this.raProperties.getDefaultProperties().getProperty(string);
    }

    public int getNbRulesets() {
        return this.rulesetsContainer.getNbEntities();
    }

    public Set getRulesets() {
        return this.rulesetsContainer.getEntities();
    }

    public Set getRulesets(String string) {
        return this.rulesetsContainer.getEntities(string);
    }

    public IlrRulesetArchiveInformation getGreatestRuleset(String string) {
        return (IlrRulesetArchiveInformation)((Object)this.rulesetsContainer.getGreatestEntity(string));
    }

    public IlrRulesetArchiveInformation getRuleset(String string, IlrVersion ilrVersion) {
        return (IlrRulesetArchiveInformation)((Object)this.rulesetsContainer.getEntity(string, ilrVersion));
    }

    protected void setRepository(IlrRepositoryImpl ilrRepositoryImpl) {
        if (this.getRepository() != null && ilrRepositoryImpl != null || this.getRepository() == null && ilrRepositoryImpl == null) {
            throw new IllegalStateException();
        }
        if (ilrRepositoryImpl != null) {
            IlrTransactionalResourceProvider ilrTransactionalResourceProvider = ilrRepositoryImpl.getResourceProvider();
            if (ilrTransactionalResourceProvider != null) {
                try {
                    ilrTransactionalResourceProvider.addRuleApp(this);
                }
                catch (IlrResourceProviderException ilrResourceProviderException) {
                    throw new IlrResourceRuntimeException("ilog.rules.bres.model", "10017", new Object[]{this.toString()}, ilrResourceProviderException);
                }
            }
        } else {
            IlrTransactionalResourceProvider ilrTransactionalResourceProvider = this.getResourceProvider();
            if (ilrTransactionalResourceProvider != null) {
                try {
                    ilrTransactionalResourceProvider.removeRuleApp(new IlrPathImpl(this));
                }
                catch (IlrResourceProviderException ilrResourceProviderException) {
                    throw new IlrResourceRuntimeException("ilog.rules.bres.model", "10018", new Object[]{this.toString()}, ilrResourceProviderException);
                }
            }
        }
        this.linked(ilrRepositoryImpl, true);
    }

    protected void linked(IlrRepositoryImpl ilrRepositoryImpl, boolean bl) {
        this.repository = ilrRepositoryImpl;
        this._propertiesLoaded = bl;
        Iterator iterator = this.getRulesets().iterator();
        while (iterator.hasNext()) {
            IlrRulesetArchiveInformationImpl ilrRulesetArchiveInformationImpl = (IlrRulesetArchiveInformationImpl)iterator.next();
            ilrRulesetArchiveInformationImpl.linked(this, bl);
        }
    }

    protected void updateFields(IlrRuleAppInformationImpl ilrRuleAppInformationImpl, boolean bl) {
        this.displayName = ilrRuleAppInformationImpl.getDisplayName();
        this.description = ilrRuleAppInformationImpl.getDescription();
        this.creationDate = ilrRuleAppInformationImpl.getCreationDate();
        this._propertiesLoaded = bl;
        if (bl) {
            this.raProperties = ilrRuleAppInformationImpl.raProperties;
        }
    }

    protected void retreiveProperties(IlrTransactionalResourceProvider ilrTransactionalResourceProvider) throws IlrResourceRuntimeException {
        if (!this._propertiesLoaded) {
            try {
                Properties properties = ilrTransactionalResourceProvider.getProperties(new IlrPathImpl(this));
                this.raProperties = new IlrRuleAppPropertiesImpl(properties);
                this._propertiesLoaded = true;
            }
            catch (IlrResourceProviderException ilrResourceProviderException) {
                throw new IlrResourceRuntimeException("ilog.rules.bres.model", "10012", new Object[]{this.toString()}, ilrResourceProviderException);
            }
        }
    }
}

