/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.impl;

import ilog.rules.bres.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.IlrRepository;
import ilog.rules.bres.model.impl.IlrRepositoryImpl;
import java.util.List;
import java.util.Set;

public class IlrRuleAppsMerger {
    public static final String ADD_AT_END_MERGING_POLICY = "ADD_AT_END_MERGING_POLICY";
    public static final String REPLACE_MERGING_POLICY = "REPLACE_MERGING_POLICY";
    public static final String ADD_AT_END_RULESET_MERGING_POLICY = "ADD_AT_END_RULESET_MERGING_POLICY";
    public static final String REPLACE_RULESET_MERGING_POLICY = "REPLACE_RULESET_MERGING_POLICY";

    public void validatePolicy(String string) {
        if (!(ADD_AT_END_MERGING_POLICY.equals(string) || REPLACE_MERGING_POLICY.equals(string) || ADD_AT_END_RULESET_MERGING_POLICY.equals(string) || REPLACE_RULESET_MERGING_POLICY.equals(string))) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10022", new Object[]{string});
        }
    }

    public List merge(IlrRepository ilrRepository, String string, String string2, Set set) {
        if (ADD_AT_END_MERGING_POLICY.equals(string)) {
            return this.addAtEndRuleApps(ilrRepository, string2, set);
        }
        if (REPLACE_MERGING_POLICY.equals(string)) {
            return this.replaceRuleApps(ilrRepository, set);
        }
        if (ADD_AT_END_RULESET_MERGING_POLICY.equals(string)) {
            return this.addAtEndRulesets(ilrRepository, string2, set);
        }
        if (REPLACE_RULESET_MERGING_POLICY.equals(string)) {
            return this.replaceRulesets(ilrRepository, set);
        }
        throw new IlrIllegalArgumentRuntimeException("ilog.rules.bres.model", "10022", new Object[]{string});
    }

    public List addAtEndRuleApps(IlrRepository ilrRepository, String string, Set set) {
        List list = ((IlrRepositoryImpl)ilrRepository).addAtEndRuleApps(string, set);
        return ((IlrRepositoryImpl)ilrRepository).commit(list);
    }

    public List addAtEndRulesets(IlrRepository ilrRepository, String string, Set set) {
        List list = ((IlrRepositoryImpl)ilrRepository).addAtEndRulesets(string, set);
        return ((IlrRepositoryImpl)ilrRepository).commit(list);
    }

    public List replaceRuleApps(IlrRepository ilrRepository, Set set) {
        List list = ((IlrRepositoryImpl)ilrRepository).replaceRuleApps(set);
        return ((IlrRepositoryImpl)ilrRepository).commit(list);
    }

    public List replaceRulesets(IlrRepository ilrRepository, Set set) {
        List list = ((IlrRepositoryImpl)ilrRepository).replaceRulesets(set);
        return ((IlrRepositoryImpl)ilrRepository).commit(list);
    }

    public static class IlrMergeOperation {
        public static final int UPDATE = 0;
        public static final int ADD_AS_IS = 1;
        public static final int PATH_CHANGED = 2;
        public static final int REPLACE = 3;
        private final IlrPath originalPath;
        private final int operation;
        private final IlrPath commitedPath;

        public IlrMergeOperation(IlrPath ilrPath, int n, IlrPath ilrPath2) {
            this.originalPath = ilrPath;
            this.operation = n;
            this.commitedPath = ilrPath2;
        }

        public IlrPath getCommitedPath() {
            return this.commitedPath;
        }

        public int getOperation() {
            return this.operation;
        }

        public IlrPath getOriginalPath() {
            return this.originalPath;
        }

        public String toString() {
            String string = null;
            switch (this.operation) {
                case 0: {
                    string = "UPDATE";
                    break;
                }
                case 1: {
                    string = "ADD_AS_IS";
                    break;
                }
                case 2: {
                    string = "PATH_CHANGED";
                    break;
                }
                case 3: {
                    string = "REPLACE";
                }
            }
            return string + ": " + this.originalPath + " -> " + this.commitedPath;
        }
    }
}

