/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.mbean.impl;

import ilog.rules.bres.mbean.util.IlrMBeanManager;
import ilog.rules.bres.model.IlrAlreadyExistException;
import ilog.rules.bres.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.bres.model.IlrRepository;
import ilog.rules.bres.model.IlrResourceRuntimeException;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrVersion;
import ilog.rules.bres.model.IlrVersionParser;
import ilog.rules.bres.model.impl.IlrRepositoryFactoryImpl;
import ilog.rules.bres.model.mbean.IlrJmxModelMBean;
import ilog.rules.bres.model.mbean.impl.IlrJmxProxyMutableRuleAppInformationImp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import javax.management.OperationsException;

public class IlrJmxProxyRepositoryImpl
implements IlrRepository {
    final IlrMBeanManager mbeanManager;
    private final IlrJmxModelMBean proxy;
    final IlrVersionParser versionParser;

    protected IlrJmxProxyRepositoryImpl(IlrMBeanManager ilrMBeanManager, IlrJmxModelMBean ilrJmxModelMBean) {
        this.mbeanManager = ilrMBeanManager;
        this.proxy = ilrJmxModelMBean;
        this.versionParser = new IlrRepositoryFactoryImpl().getVersionParser();
    }

    public Set getRuleApps() {
        Set set = this.proxy.getRuleAppObjectNames();
        HashSet<IlrJmxProxyMutableRuleAppInformationImp> hashSet = new HashSet<IlrJmxProxyMutableRuleAppInformationImp>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            hashSet.add(new IlrJmxProxyMutableRuleAppInformationImp(this, objectName));
        }
        return hashSet;
    }

    public Set getRuleApps(String string) {
        HashSet<IlrJmxProxyMutableRuleAppInformationImp> hashSet = new HashSet<IlrJmxProxyMutableRuleAppInformationImp>();
        if (string == null) {
            return hashSet;
        }
        Set set = this.proxy.getRuleAppObjectNames(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            hashSet.add(new IlrJmxProxyMutableRuleAppInformationImp(this, objectName));
        }
        return hashSet;
    }

    public IlrRuleAppInformation getGreatestRuleApp(String string) {
        if (string == null) {
            return null;
        }
        ObjectName objectName = this.proxy.getGreatestRuleAppObjectName(string);
        if (objectName == null) {
            return null;
        }
        return new IlrJmxProxyMutableRuleAppInformationImp(this, objectName);
    }

    public IlrRuleAppInformation getRuleApp(String string, IlrVersion ilrVersion) {
        if (string == null || ilrVersion == null) {
            return null;
        }
        ObjectName objectName = this.proxy.getRuleAppObjectName(string, ilrVersion.toString());
        if (objectName == null) {
            return null;
        }
        return new IlrJmxProxyMutableRuleAppInformationImp(this, objectName);
    }

    public IlrRuleAppInformation addRuleApp(IlrRuleAppInformation ilrRuleAppInformation) throws IlrAlreadyExistException {
        if (ilrRuleAppInformation == null) {
            return null;
        }
        if (ilrRuleAppInformation.getRepository() != null && ilrRuleAppInformation.getRepository() != this) {
            throw new IllegalStateException();
        }
        try {
            ObjectName objectName = this.proxy.addRuleApp(ilrRuleAppInformation.getName(), ilrRuleAppInformation.getVersion().toString());
            if (objectName == null) {
                return null;
            }
            ((IlrJmxProxyMutableRuleAppInformationImp)ilrRuleAppInformation).added(this, objectName);
            return ilrRuleAppInformation;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw new IlrAlreadyExistException(instanceAlreadyExistsException.getMessage());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new IlrIllegalArgumentRuntimeException(invalidAttributeValueException.getMessage());
        }
        catch (OperationsException operationsException) {
            throw new IlrResourceRuntimeException(operationsException.getMessage());
        }
    }

    public boolean removeRuleApp(IlrRuleAppInformation ilrRuleAppInformation) {
        if (ilrRuleAppInformation == null) {
            return false;
        }
        try {
            boolean bl = this.proxy.removeRuleApp(ilrRuleAppInformation.getName(), ilrRuleAppInformation.getVersion().toString());
            ((IlrJmxProxyMutableRuleAppInformationImp)ilrRuleAppInformation).removed();
            return bl;
        }
        catch (OperationsException operationsException) {
            throw new IlrResourceRuntimeException(operationsException.getMessage());
        }
    }
}

