/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IlrErrorHandlerImpl
implements ErrorHandler {
    private ErrorHandler delegationHandle = null;
    private List warnings = new ArrayList();
    private List errors = new ArrayList();
    private List fatalErrors = new ArrayList();
    private SAXParseException firstErrorException = null;

    public IlrErrorHandlerImpl() {
        this(null);
    }

    public IlrErrorHandlerImpl(ErrorHandler errorHandler) {
        this.delegationHandle = errorHandler;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasFatalErrors() {
        return this.fatalErrors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public SAXParseException getFirstErrorException() {
        return this.firstErrorException;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public List getErrors() {
        return this.errors;
    }

    public List getFatalErrors() {
        return this.fatalErrors;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.errors.add(sAXParseException);
        if (this.firstErrorException == null) {
            this.firstErrorException = sAXParseException;
        }
        if (this.delegationHandle != null) {
            this.delegationHandle.error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.fatalErrors.add(sAXParseException);
        if (this.firstErrorException == null) {
            this.firstErrorException = sAXParseException;
        }
        if (this.delegationHandle != null) {
            this.delegationHandle.fatalError(sAXParseException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.warnings.add(sAXParseException);
        if (this.delegationHandle != null) {
            this.delegationHandle.warning(sAXParseException);
        }
    }
}

