/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.xml;

import ilog.rules.bres.model.IlrAlreadyExistException;
import ilog.rules.bres.model.IlrFormatException;
import ilog.rules.bres.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.bres.model.IlrMutableRuleAppInformation;
import ilog.rules.bres.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.IlrVersion;
import ilog.rules.bres.model.xml.IlrErrorHandlerImpl;
import ilog.rules.bres.model.xml.IlrResourceEntityResolver;
import ilog.rules.bres.model.xml.IlrXMLSerializer;
import ilog.rules.bres.util.xml.IlrDOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class IlrRuleAppArchiveDescriptor {
    public static final String SCHEMA_LOCATION = "http://schemas.ilog.com/JRules/1.2/RuleAppArchive";
    public static final String ELEMENT_RULEAPP_ARCHIVE = "ruleapp-archive";
    public static final String ELEMENT_RULEAPP = "ruleapp";
    public static final String ELEMENT_RULEAPP_NAME = "ruleapp-name";
    public static final String ELEMENT_RULEAPP_DISPLAY_NAME = "ruleapp-display-name";
    public static final String ELEMENT_RULEAPP_VERSION = "ruleapp-version";
    public static final String ELEMENT_RULEAPP_DESCRIPTION = "ruleapp-description";
    public static final String ELEMENT_RULEAPP_CREATION_DATE = "creation-date";
    public static final String ELEMENT_RULEAPP_PROPERTY = "ruleapp-property";
    public static final String ELEMENT_RULEAPP_PROPERTY_NAME = "ruleapp-property-name";
    public static final String ELEMENT_RULEAPP_PROPERTY_VALUE = "ruleapp-property-value";
    public static final String ELEMENT_RULESET = "ruleset";
    public static final String ELEMENT_RULESET_NAME = "ruleset-name";
    public static final String ELEMENT_RULESET_DISPLAY_NAME = "ruleset-display-name";
    public static final String ELEMENT_RULESET_CREATION_DATE = "creation-date";
    public static final String ELEMENT_RULESET_VERSION = "ruleset-version";
    public static final String ELEMENT_RULESET_DESCRIPTION = "ruleset-description";
    public static final String ELEMENT_RULESET_PROPERTY = "ruleset-property";
    public static final String ELEMENT_RULESET_PROPERTY_NAME = "ruleset-property-name";
    public static final String ELEMENT_RULESET_PROPERTY_VALUE = "ruleset-property-value";
    private DocumentBuilderFactory documentBuilderFactory;
    private boolean validating;

    public IlrRuleAppArchiveDescriptor() {
        this(true);
    }

    public IlrRuleAppArchiveDescriptor(boolean bl) {
        this.validating = bl;
    }

    public Set load(IlrRepositoryFactory ilrRepositoryFactory, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException, IlrAlreadyExistException, IlrFormatException, IlrIllegalArgumentRuntimeException {
        IlrErrorHandlerImpl ilrErrorHandlerImpl = new IlrErrorHandlerImpl();
        DocumentBuilder documentBuilder = this.createDocumentBuilder(ilrErrorHandlerImpl);
        Document document = documentBuilder.parse(inputStream);
        if (ilrErrorHandlerImpl.hasErrors() || ilrErrorHandlerImpl.hasFatalErrors()) {
            throw ilrErrorHandlerImpl.getFirstErrorException();
        }
        NodeList nodeList = IlrDOMUtil.getChildElementsByTagName(document.getDocumentElement(), ELEMENT_RULEAPP);
        HashSet<IlrMutableRuleAppInformation> hashSet = new HashSet<IlrMutableRuleAppInformation>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            IlrMutableRuleAppInformation ilrMutableRuleAppInformation = this.loadRuleApp(ilrRepositoryFactory, (Element)nodeList.item(i));
            hashSet.add(ilrMutableRuleAppInformation);
        }
        return hashSet;
    }

    public void save(Set set, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        IlrXMLSerializer ilrXMLSerializer = new IlrXMLSerializer(outputStreamWriter);
        ilrXMLSerializer.writeXMLDeclaration();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        hashMap.put("xsi:noNamespaceSchemaLocation", SCHEMA_LOCATION);
        ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP_ARCHIVE, hashMap, true);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IlrRuleAppInformation ilrRuleAppInformation = (IlrRuleAppInformation)iterator.next();
            this.save(ilrRuleAppInformation, ilrXMLSerializer);
        }
        ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP_ARCHIVE);
        outputStreamWriter.flush();
    }

    private synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setNamespaceAware(true);
            try {
                this.documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", this.validating ? Boolean.TRUE : Boolean.FALSE);
                this.documentBuilderFactory.setValidating(this.validating);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.documentBuilderFactory.setValidating(false);
            }
        }
        return this.documentBuilderFactory;
    }

    private DocumentBuilder createDocumentBuilder(ErrorHandler errorHandler) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        documentBuilder.setEntityResolver(new IlrResourceEntityResolver("ilog/rules/bres/model/xml"));
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder;
    }

    private void save(IlrRuleAppInformation ilrRuleAppInformation, IlrXMLSerializer ilrXMLSerializer) throws IOException {
        ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP, true);
        String string = ilrRuleAppInformation.getDisplayName();
        if (string != null) {
            ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP_DISPLAY_NAME, false);
            ilrXMLSerializer.writeBody(string);
            ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP_DISPLAY_NAME);
        }
        ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP_NAME, false);
        ilrXMLSerializer.writeBody(ilrRuleAppInformation.getName());
        ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP_NAME);
        ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP_VERSION, false);
        ilrXMLSerializer.writeBody(ilrRuleAppInformation.getVersion().toString());
        ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP_VERSION);
        ilrXMLSerializer.writeStartTag("creation-date", false);
        ilrXMLSerializer.writeBody(Long.toString(ilrRuleAppInformation.getCreationDate().getTime()));
        ilrXMLSerializer.writeEndTag("creation-date");
        String string2 = ilrRuleAppInformation.getDescription();
        if (string2 != null) {
            ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP_DESCRIPTION, false);
            ilrXMLSerializer.writeBody(string2);
            ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP_DESCRIPTION);
        }
        Properties properties = ilrRuleAppInformation.getProperties().toProperties();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP_PROPERTY, true);
            ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP_PROPERTY_NAME, false);
            ilrXMLSerializer.writeBody((String)entry.getKey());
            ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP_PROPERTY_NAME);
            ilrXMLSerializer.writeStartTag(ELEMENT_RULEAPP_PROPERTY_VALUE, false);
            ilrXMLSerializer.writeBody((String)entry.getValue());
            ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP_PROPERTY_VALUE);
            ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP_PROPERTY);
        }
        iterator = ilrRuleAppInformation.getRulesets().iterator();
        while (iterator.hasNext()) {
            this.save((IlrRulesetArchiveInformation)((Object)iterator.next()), ilrXMLSerializer);
        }
        ilrXMLSerializer.writeEndTag(ELEMENT_RULEAPP);
    }

    private void save(IlrRulesetArchiveInformation ilrRulesetArchiveInformation, IlrXMLSerializer ilrXMLSerializer) throws IOException {
        ilrXMLSerializer.writeStartTag(ELEMENT_RULESET, true);
        String string = ilrRulesetArchiveInformation.getDisplayName();
        if (string != null) {
            ilrXMLSerializer.writeStartTag(ELEMENT_RULESET_DISPLAY_NAME, false);
            ilrXMLSerializer.writeBody(string);
            ilrXMLSerializer.writeEndTag(ELEMENT_RULESET_DISPLAY_NAME);
        }
        ilrXMLSerializer.writeStartTag(ELEMENT_RULESET_NAME, false);
        ilrXMLSerializer.writeBody(ilrRulesetArchiveInformation.getName());
        ilrXMLSerializer.writeEndTag(ELEMENT_RULESET_NAME);
        ilrXMLSerializer.writeStartTag(ELEMENT_RULESET_VERSION, false);
        ilrXMLSerializer.writeBody(ilrRulesetArchiveInformation.getVersion().toString());
        ilrXMLSerializer.writeEndTag(ELEMENT_RULESET_VERSION);
        ilrXMLSerializer.writeStartTag("creation-date", false);
        ilrXMLSerializer.writeBody(Long.toString(ilrRulesetArchiveInformation.getCreationDate().getTime()));
        ilrXMLSerializer.writeEndTag("creation-date");
        String string2 = ilrRulesetArchiveInformation.getDescription();
        if (string2 != null) {
            ilrXMLSerializer.writeStartTag(ELEMENT_RULESET_DESCRIPTION, false);
            ilrXMLSerializer.writeBody(string2);
            ilrXMLSerializer.writeEndTag(ELEMENT_RULESET_DESCRIPTION);
        }
        Properties properties = ilrRulesetArchiveInformation.getProperties().toProperties();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            ilrXMLSerializer.writeStartTag(ELEMENT_RULESET_PROPERTY, true);
            ilrXMLSerializer.writeStartTag(ELEMENT_RULESET_PROPERTY_NAME, false);
            ilrXMLSerializer.writeBody((String)entry.getKey());
            ilrXMLSerializer.writeEndTag(ELEMENT_RULESET_PROPERTY_NAME);
            ilrXMLSerializer.writeStartTag(ELEMENT_RULESET_PROPERTY_VALUE, false);
            ilrXMLSerializer.writeBody((String)entry.getValue());
            ilrXMLSerializer.writeEndTag(ELEMENT_RULESET_PROPERTY_VALUE);
            ilrXMLSerializer.writeEndTag(ELEMENT_RULESET_PROPERTY);
        }
        ilrXMLSerializer.writeEndTag(ELEMENT_RULESET);
    }

    private IlrMutableRuleAppInformation loadRuleApp(IlrRepositoryFactory ilrRepositoryFactory, Element element) throws IlrAlreadyExistException, IlrFormatException, IlrIllegalArgumentRuntimeException {
        Element element2;
        Object object;
        Object object2;
        Element element3;
        String string = null;
        IlrVersion ilrVersion = null;
        Date date = null;
        Element element4 = IlrDOMUtil.getFirstElementByTagName(element, ELEMENT_RULEAPP_NAME);
        if (element4 != null) {
            string = IlrDOMUtil.textNodesToString(element4.getChildNodes());
        }
        if ((element3 = IlrDOMUtil.getFirstElementByTagName(element, ELEMENT_RULEAPP_VERSION)) != null) {
            object2 = IlrDOMUtil.textNodesToString(element3.getChildNodes());
            ilrVersion = ilrRepositoryFactory.getVersionParser().parse((String)object2);
        }
        if ((object2 = IlrDOMUtil.getFirstElementByTagName(element, "creation-date")) != null) {
            object = IlrDOMUtil.textNodesToString(object2.getChildNodes());
            date = new Date(Long.parseLong((String)object));
        }
        object = ilrRepositoryFactory.createRuleApp(string, ilrVersion, date);
        Element element5 = IlrDOMUtil.getFirstElementByTagName(element, ELEMENT_RULEAPP_DISPLAY_NAME);
        if (element5 != null) {
            object.setDisplayName(IlrDOMUtil.textNodesToString(element5.getChildNodes()));
        }
        if ((element2 = IlrDOMUtil.getFirstElementByTagName(element, ELEMENT_RULEAPP_DESCRIPTION)) != null) {
            object.setDescription(IlrDOMUtil.textNodesToString(element2.getChildNodes()));
        }
        this.loadRuleAppProperties(element, (IlrMutableRuleAppInformation)object);
        NodeList nodeList = IlrDOMUtil.getChildElementsByTagName(element, ELEMENT_RULESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element6 = (Element)nodeList.item(i);
            IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation = this.loadRuleset(ilrRepositoryFactory, element6);
            object.addRuleset(ilrMutableRulesetArchiveInformation);
        }
        return object;
    }

    private IlrMutableRulesetArchiveInformation loadRuleset(IlrRepositoryFactory ilrRepositoryFactory, Element element) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        Element element2;
        Object object;
        Object object2;
        Element element3;
        String string = null;
        IlrVersion ilrVersion = null;
        Date date = null;
        Element element4 = IlrDOMUtil.getFirstElementByTagName(element, ELEMENT_RULESET_NAME);
        if (element4 != null) {
            string = IlrDOMUtil.textNodesToString(element4.getChildNodes());
        }
        if ((element3 = IlrDOMUtil.getFirstElementByTagName(element, ELEMENT_RULESET_VERSION)) != null) {
            object2 = IlrDOMUtil.textNodesToString(element3.getChildNodes());
            ilrVersion = ilrRepositoryFactory.getVersionParser().parse((String)object2);
        }
        if ((object2 = IlrDOMUtil.getFirstElementByTagName(element, "creation-date")) != null) {
            object = IlrDOMUtil.textNodesToString(object2.getChildNodes());
            date = new Date(Long.parseLong((String)object));
        }
        object = ilrRepositoryFactory.createRuleset(string, ilrVersion, date);
        Element element5 = IlrDOMUtil.getFirstElementByTagName(element, ELEMENT_RULESET_DISPLAY_NAME);
        if (element5 != null) {
            object.setDisplayName(IlrDOMUtil.textNodesToString(element5.getChildNodes()));
        }
        if ((element2 = IlrDOMUtil.getFirstElementByTagName(element, ELEMENT_RULESET_DESCRIPTION)) != null) {
            object.setDescription(IlrDOMUtil.textNodesToString(element2.getChildNodes()));
        }
        this.loadRulesetProperties(element, (IlrMutableRulesetArchiveInformation)object);
        return object;
    }

    private void loadRuleAppProperties(Element element, IlrMutableRuleAppInformation ilrMutableRuleAppInformation) {
        NodeList nodeList = IlrDOMUtil.getChildElementsByTagName(element, ELEMENT_RULEAPP_PROPERTY);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            Element element3 = IlrDOMUtil.getFirstElementByTagName(element2, ELEMENT_RULEAPP_PROPERTY_NAME);
            Element element4 = IlrDOMUtil.getFirstElementByTagName(element2, ELEMENT_RULEAPP_PROPERTY_VALUE);
            String string = IlrDOMUtil.textNodesToString(element3.getChildNodes());
            String string2 = IlrDOMUtil.textNodesToString(element4.getChildNodes());
            ilrMutableRuleAppInformation.setProperty(string, string2);
        }
    }

    private void loadRulesetProperties(Element element, IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation) {
        NodeList nodeList = IlrDOMUtil.getChildElementsByTagName(element, ELEMENT_RULESET_PROPERTY);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            Element element3 = IlrDOMUtil.getFirstElementByTagName(element2, ELEMENT_RULESET_PROPERTY_NAME);
            Element element4 = IlrDOMUtil.getFirstElementByTagName(element2, ELEMENT_RULESET_PROPERTY_VALUE);
            String string = IlrDOMUtil.textNodesToString(element3.getChildNodes());
            String string2 = IlrDOMUtil.textNodesToString(element4.getChildNodes());
            ilrMutableRulesetArchiveInformation.setProperty(string, string2);
        }
    }
}

