/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class IlrXMLSerializer {
    public static final String ENCODING_CHARSET_NAME = "UTF-8";
    private Writer writer = null;
    private int depth = 0;
    private boolean beginingOfLine = true;
    private String whiteSpaces = "                             ";
    private int WHITESPACES_PER_TAB = 2;

    public IlrXMLSerializer(Writer writer) {
        this.writer = writer;
    }

    public void writeXMLDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public void writeStartTag(String string, Map map, boolean bl) throws IOException {
        this.writeWhiteSpaces(this.depth * this.WHITESPACES_PER_TAB);
        this.writer.write("<");
        this.writer.write(string);
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.writer.write(" ");
                this.writer.write(entry.getKey().toString());
                this.writer.write("=\"");
                this.writer.write(entry.getValue().toString());
                this.writer.write("\"");
            }
        }
        this.writer.write(">");
        if (bl) {
            this.writer.write("\n");
            this.beginingOfLine = true;
        }
        ++this.depth;
    }

    public void writeStartTag(String string, boolean bl) throws IOException {
        this.writeStartTag(string, null, bl);
    }

    public void writeEndTag(String string) throws IOException {
        if (this.beginingOfLine) {
            this.writeWhiteSpaces((this.depth - 1) * this.WHITESPACES_PER_TAB);
        }
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(">\n");
        this.beginingOfLine = true;
        --this.depth;
    }

    public void writeBody(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                this.writer.write("&amp;");
            } else if (c == '<') {
                this.writer.write("&lt;");
            } else {
                this.writer.write(c);
            }
            this.beginingOfLine = c == '\n';
        }
    }

    private void writeWhiteSpaces(int n) throws IOException {
        int n2 = n / this.whiteSpaces.length();
        int n3 = n % this.whiteSpaces.length();
        for (int i = 0; i < n2; ++i) {
            this.writer.write(this.whiteSpaces);
        }
        this.writer.write(this.whiteSpaces, 0, n3);
    }
}

