/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.persistence;

import ilog.rules.bres.model.IlrFormatException;
import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.IlrPathParser;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.impl.IlrRepositoryFactoryImpl;
import ilog.rules.bres.model.impl.IlrVersionImpl;
import ilog.rules.bres.persistence.IlrRulesetPathElement;

public class IlrRulesetPathElementImpl
implements IlrRulesetPathElement {
    private String ruleAppName = null;
    private String rulesetName = null;
    private int ruleAppMajorVersion = -1;
    private int ruleAppMinorVersion = -1;
    private int rulesetMajorVersion = -1;
    private int rulesetMinorVersion = -1;
    private boolean isRuleApp = false;
    private String rulesetPathAsString = null;
    private IlrPath rulesetPath = null;

    public IlrRulesetPathElementImpl() {
    }

    public IlrRulesetPathElementImpl(String string, int n, int n2) {
        this.ruleAppName = string;
        this.ruleAppMajorVersion = n;
        this.ruleAppMinorVersion = n2;
        this.isRuleApp = true;
    }

    public IlrRulesetPathElementImpl(String string, int n, int n2, String string2, int n3, int n4) {
        this.ruleAppName = string;
        this.ruleAppMajorVersion = n;
        this.ruleAppMinorVersion = n2;
        this.rulesetName = string2;
        this.rulesetMajorVersion = n3;
        this.rulesetMinorVersion = n4;
        this.isRuleApp = false;
    }

    public IlrRulesetPathElementImpl(IlrRuleAppInformation ilrRuleAppInformation) {
        this.ruleAppName = ilrRuleAppInformation.getName();
        this.ruleAppMajorVersion = ((IlrVersionImpl)ilrRuleAppInformation.getVersion()).getMajor();
        this.ruleAppMinorVersion = ((IlrVersionImpl)ilrRuleAppInformation.getVersion()).getMinor();
        this.isRuleApp = true;
        this.rulesetPathAsString = ilrRuleAppInformation.toString();
    }

    public IlrRulesetPathElementImpl(IlrPath ilrPath) {
        this.ruleAppName = ilrPath.getRuleAppName();
        this.ruleAppMajorVersion = ((IlrVersionImpl)ilrPath.getRuleAppVersion()).getMajor();
        this.ruleAppMinorVersion = ((IlrVersionImpl)ilrPath.getRuleAppVersion()).getMinor();
        if (ilrPath.isRulesetPath()) {
            this.rulesetName = ilrPath.getRulesetName();
            this.rulesetMajorVersion = ((IlrVersionImpl)ilrPath.getRulesetVersion()).getMajor();
            this.rulesetMinorVersion = ((IlrVersionImpl)ilrPath.getRulesetVersion()).getMinor();
        }
        this.isRuleApp = ilrPath.isRuleAppPath();
        this.rulesetPathAsString = ilrPath.toString();
        this.rulesetPath = ilrPath;
    }

    public IlrRulesetPathElementImpl(IlrRulesetArchiveInformation ilrRulesetArchiveInformation) throws IlrFormatException {
        this(new IlrRepositoryFactoryImpl().getPathParser().parse(ilrRulesetArchiveInformation.getCanonicalRulesetPath()));
    }

    public String getRuleAppName() {
        return this.ruleAppName;
    }

    public int getRuleAppMajorVersion() {
        return this.ruleAppMajorVersion;
    }

    public int getRuleAppMinorVersion() {
        return this.ruleAppMinorVersion;
    }

    public String getRulesetName() {
        return this.rulesetName;
    }

    public int getRulesetMajorVersion() {
        return this.rulesetMajorVersion;
    }

    public int getRulesetMinorVersion() {
        return this.rulesetMinorVersion;
    }

    public boolean isRuleApp() {
        return this.isRuleApp;
    }

    public IlrPath getPath() throws IlrFormatException {
        if (this.rulesetPath == null) {
            IlrRepositoryFactoryImpl ilrRepositoryFactoryImpl = new IlrRepositoryFactoryImpl();
            IlrPathParser ilrPathParser = ilrRepositoryFactoryImpl.getPathParser();
            this.rulesetPath = ilrPathParser.parse(this.toString());
        }
        return this.rulesetPath;
    }

    public void setRuleAppName(String string) {
        this.isRuleApp = true;
        this.ruleAppName = string;
    }

    public void setRuleAppMajorVersion(int n) {
        this.ruleAppMajorVersion = n;
    }

    public void setRuleAppMinorVersion(int n) {
        this.ruleAppMinorVersion = n;
    }

    public void setRulesetName(String string) {
        this.isRuleApp = string == null;
        this.rulesetName = string;
    }

    public void setRulesetMajorVersion(int n) {
        this.rulesetMajorVersion = n;
    }

    public void setRulesetMinorVersion(int n) {
        this.rulesetMinorVersion = n;
    }

    public String toString() {
        if (this.rulesetPathAsString != null) {
            return this.rulesetPathAsString;
        }
        if (this.ruleAppName != null) {
            if (this.ruleAppMajorVersion >= 1 && this.ruleAppMinorVersion >= 0 || this.ruleAppMajorVersion < 1 && this.ruleAppMinorVersion < 0) {
                StringBuffer stringBuffer = null;
                if (this.ruleAppMajorVersion >= 1 && this.ruleAppMinorVersion >= 0) {
                    stringBuffer = new StringBuffer("/");
                    stringBuffer.append(this.ruleAppName);
                    stringBuffer.append("/");
                    stringBuffer.append(this.ruleAppMajorVersion);
                    stringBuffer.append(".");
                    stringBuffer.append(this.ruleAppMinorVersion);
                }
                if (this.rulesetName != null) {
                    if (this.rulesetMajorVersion >= 1 && this.rulesetMinorVersion >= 0 || this.rulesetMajorVersion < 1 && this.rulesetMinorVersion < 0) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer("/");
                            stringBuffer.append(this.ruleAppName);
                        }
                        stringBuffer.append("/");
                        stringBuffer.append(this.rulesetName);
                        if (this.rulesetMajorVersion >= 1 && this.rulesetMinorVersion >= 0) {
                            stringBuffer.append("/");
                            stringBuffer.append(this.rulesetMajorVersion);
                            stringBuffer.append(".");
                            stringBuffer.append(this.rulesetMinorVersion);
                        }
                        return stringBuffer.toString();
                    }
                    return null;
                }
                if (stringBuffer != null) {
                    return stringBuffer.toString();
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

