/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.persistence.file;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.model.IlrFormatException;
import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.impl.IlrRepositoryFactoryImpl;
import ilog.rules.bres.model.impl.IlrVersionImpl;
import ilog.rules.bres.persistence.IlrDataGetter;
import ilog.rules.bres.persistence.IlrDataGetterException;
import ilog.rules.bres.persistence.IlrDataSource;
import ilog.rules.bres.persistence.IlrDataSourceException;
import ilog.rules.bres.persistence.IlrRulesetPathElement;
import ilog.rules.bres.persistence.IlrRulesetPathElementImpl;
import ilog.rules.bres.persistence.file.IlrFileDataSource;
import ilog.rules.bres.persistence.file.util.IlrExistDirectoryPrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrListDirectoryPrivilegedAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Properties;

public class IlrFileDataGetter
implements IlrDataGetter,
Serializable {
    protected IlrFileDataSource fileDS = null;

    public IlrFileDataGetter() throws IlrDataSourceException {
        this.fileDS = new IlrFileDataSource();
    }

    public IlrFileDataGetter(String string) throws IlrDataSourceException {
        this.fileDS = new IlrFileDataSource(string);
    }

    public IlrDataSource getDataSource() {
        return this.fileDS;
    }

    public boolean isResourceAvailable(IlrRulesetPathElement ilrRulesetPathElement, int n) {
        return this.fileDS.isResourceAvailable(ilrRulesetPathElement, n);
    }

    public ByteArrayOutputStream retrieveResource(String string, int n) throws IlrDataGetterException {
        IlrPath ilrPath;
        IlrRepositoryFactoryImpl ilrRepositoryFactoryImpl = new IlrRepositoryFactoryImpl();
        try {
            ilrPath = ilrRepositoryFactoryImpl.getPathParser().parse(string);
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1010", new Object[]{string});
        }
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        return this.retrieveResource(ilrRulesetPathElementImpl, n);
    }

    public ByteArrayOutputStream retrieveResource(IlrRulesetPathElement ilrRulesetPathElement, int n) throws IlrDataGetterException {
        return this.fileDS.select(ilrRulesetPathElement, n);
    }

    public String getCanonicalRulesetPath(IlrPath ilrPath) throws IlrDataGetterException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (ilrPath.getRuleAppVersion() != null) {
            n = ((IlrVersionImpl)ilrPath.getRuleAppVersion()).getMajor();
            n2 = ((IlrVersionImpl)ilrPath.getRuleAppVersion()).getMinor();
        }
        if (ilrPath.getRulesetVersion() != null) {
            n3 = ((IlrVersionImpl)ilrPath.getRulesetVersion()).getMajor();
            n4 = ((IlrVersionImpl)ilrPath.getRulesetVersion()).getMinor();
        }
        return this.getCanonicalRulesetPath(ilrPath.getRuleAppName(), n, n2, ilrPath.getRulesetName(), n3, n4);
    }

    public IlrRulesetArchive retrieveRulesetArchive(String string) throws IlrDataGetterException {
        IlrPath ilrPath;
        IlrRepositoryFactoryImpl ilrRepositoryFactoryImpl = new IlrRepositoryFactoryImpl();
        try {
            ilrPath = ilrRepositoryFactoryImpl.getPathParser().parse(string);
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1010", new Object[]{string});
        }
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        return this.retrieveRulesetArchive(ilrRulesetPathElementImpl);
    }

    public IlrRulesetArchive retrieveRulesetArchive(IlrRulesetPathElement ilrRulesetPathElement) throws IlrDataGetterException {
        return this.fileDS.selectRulesetArchive(ilrRulesetPathElement);
    }

    private String getCanonicalRulesetPath(String string, int n, int n2, String string2, int n3, int n4) throws IlrDataGetterException {
        if (string == null) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1008", new Object[]{"null/" + n + "." + n2});
        }
        if (string2 == null) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1009", new Object[]{string + "/" + n + "." + n2 + "/null/" + n3 + "." + n4});
        }
        try {
            ComplexVersion[] complexVersionArray = this.computeSortedRuleApps(string, n, n2);
            if (complexVersionArray != null) {
                for (int i = complexVersionArray.length - 1; i >= 0; --i) {
                    ComplexVersion[] complexVersionArray2 = this.computeSortedRuleSets(string, complexVersionArray[i], string2, n3, n4);
                    if (complexVersionArray2 == null) continue;
                    for (int j = complexVersionArray2.length - 1; j >= 0; --j) {
                        if (!this.rulesetEnabled(string, complexVersionArray[i], string2, complexVersionArray2[j])) continue;
                        return this.makeRulesetCanonicalName(string, complexVersionArray[i], string2, complexVersionArray2[j]);
                    }
                }
            }
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1011", new Object[]{this.formatErrorMessage(string, n, n2, string2, n3, n4)});
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1510", new Object[]{privilegedActionException.getException().getMessage()}, privilegedActionException.getException());
        }
    }

    private String formatErrorMessage(String string, int n, int n2, String string2, int n3, int n4) {
        String string3;
        String string4;
        String string5;
        String string6;
        if (n == -1) {
            string6 = "*";
            string5 = "*";
        } else if (n2 == -1) {
            string5 = Integer.toString(n);
            string6 = "*";
        } else {
            string5 = Integer.toString(n);
            string6 = Integer.toString(n2);
        }
        if (n3 == -1) {
            string4 = "*";
            string3 = "*";
        } else if (n4 == -1) {
            string3 = Integer.toString(n3);
            string4 = "*";
        } else {
            string3 = Integer.toString(n3);
            string4 = Integer.toString(n4);
        }
        return "{" + string + "," + string5 + "," + string6 + "," + string2 + "," + string3 + "," + string4 + "}";
    }

    private ComplexVersion[] computeSortedRuleApps(String string, final int n, int n2) throws PrivilegedActionException {
        File file = new File(this.fileDS.getWorkingDirectory() + File.separator + string);
        Boolean bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
        if (!bl.booleanValue()) {
            return null;
        }
        if (n == -1) {
            String[] stringArray = (String[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file, new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return IlrFileDataGetter.this.isMajorMinorName(string);
                }
            }));
            if (stringArray.length > 0) {
                return this.sortByVersion(stringArray);
            }
            return null;
        }
        if (n2 == -1) {
            String[] stringArray = (String[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file, new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return IlrFileDataGetter.this.isMajorMinorName(string) && string.startsWith(Integer.toString(n) + '.');
                }
            }));
            if (stringArray.length > 0) {
                return this.sortByVersion(stringArray);
            }
            return null;
        }
        file = new File(this.fileDS.getWorkingDirectory() + File.separator + string + File.separator + n + "." + n2);
        bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
        if (!bl.booleanValue()) {
            return null;
        }
        ComplexVersion[] complexVersionArray = new ComplexVersion[]{new ComplexVersion(n, n2)};
        return complexVersionArray;
    }

    private ComplexVersion[] computeSortedRuleSets(String string, ComplexVersion complexVersion, String string2, final int n, int n2) throws PrivilegedActionException {
        String string3 = this.fileDS.getWorkingDirectory() + File.separator + string + File.separator + complexVersion.name;
        File file = new File(string3 + File.separator + string2);
        Boolean bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
        if (!bl.booleanValue()) {
            return null;
        }
        if (n == -1) {
            String[] stringArray = (String[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file, new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return IlrFileDataGetter.this.isMajorMinorName(string);
                }
            }));
            if (stringArray.length > 0) {
                return this.sortByVersion(stringArray);
            }
            return null;
        }
        if (n2 == -1) {
            String[] stringArray = (String[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file, new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.startsWith(Integer.toString(n) + '.');
                }
            }));
            if (stringArray.length > 0) {
                return this.sortByVersion(stringArray);
            }
            return null;
        }
        file = new File(string3 + File.separator + string2 + File.separator + n + "." + n2);
        bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
        if (!bl.booleanValue()) {
            return null;
        }
        ComplexVersion[] complexVersionArray = new ComplexVersion[]{new ComplexVersion(n, n2)};
        return complexVersionArray;
    }

    private String makeRulesetCanonicalName(String string, ComplexVersion complexVersion, String string2, ComplexVersion complexVersion2) {
        return "/" + string + "/" + complexVersion.maj + '.' + complexVersion.min + "/" + string2 + "/" + complexVersion2.maj + '.' + complexVersion2.min;
    }

    private boolean rulesetEnabled(String string, ComplexVersion complexVersion, String string2, ComplexVersion complexVersion2) {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(string, complexVersion.maj, complexVersion.min, string2, complexVersion2.maj, complexVersion2.min);
        File file = new File(this.fileDS.getWorkingDirectory() + File.separator + ((Object)ilrRulesetPathElementImpl).toString() + File.separator + "properties" + ".txt");
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
            if (!bl.booleanValue()) {
                return true;
            }
            Properties properties = new Properties();
            ByteArrayOutputStream byteArrayOutputStream = this.retrieveResource(ilrRulesetPathElementImpl, 3);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            properties.load(byteArrayInputStream);
            return "enabled".equals(properties.getProperty("ruleset.status", "enabled"));
        }
        catch (IOException iOException) {
            return true;
        }
        catch (IlrDataGetterException ilrDataGetterException) {
            return true;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return true;
        }
    }

    private ComplexVersion[] sortByVersion(String[] stringArray) {
        int n;
        ComplexVersion[] complexVersionArray = new ComplexVersion[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            complexVersionArray[n] = new ComplexVersion(stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (complexVersionArray[n].higherVersion(complexVersionArray[i])) continue;
                ComplexVersion complexVersion = complexVersionArray[n];
                complexVersionArray[n] = complexVersionArray[i];
                complexVersionArray[i] = complexVersion;
            }
        }
        return complexVersionArray;
    }

    private boolean isMajorMinorName(String string) {
        int n = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (Character.isDigit(c)) {
                        n = 1;
                        continue block5;
                    }
                    return false;
                }
                case 1: {
                    if (Character.isDigit(c)) {
                        n = 1;
                        continue block5;
                    }
                    if (c == '.') {
                        n = 2;
                        continue block5;
                    }
                    return false;
                }
                case 2: {
                    if (Character.isDigit(c)) {
                        n = 1;
                        continue block5;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private class ComplexVersion {
        String name;
        int maj;
        int min;

        ComplexVersion(String string) {
            int n = string.indexOf(".irl");
            this.name = n == -1 ? string : string.substring(0, n);
            this.maj = Integer.parseInt(this.name.substring(0, string.indexOf(46)));
            this.min = Integer.parseInt(this.name.substring(string.indexOf(46) + 1));
        }

        ComplexVersion(int n, int n2) {
            this(n, n2, "");
        }

        ComplexVersion(int n, int n2, String string) {
            this.maj = n;
            this.min = n2;
            this.name = "" + n + "." + n2 + string;
        }

        boolean higherVersion(ComplexVersion complexVersion) {
            if (this.maj > complexVersion.maj) {
                return true;
            }
            return this.maj == complexVersion.maj && this.min > complexVersion.min;
        }
    }
}

