/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.persistence.file;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.persistence.IlrAbstractDataSource;
import ilog.rules.bres.persistence.IlrDataSourceException;
import ilog.rules.bres.persistence.IlrRulesetPathElement;
import ilog.rules.bres.persistence.IlrRulesetPathElementImpl;
import ilog.rules.bres.persistence.file.util.IlrDeleteFilePrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrExistDirectoryPrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrGetCanonicalPathPrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrIsDirectoryPrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrIsFilePrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrListDirectoryPrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrMkdirsPrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrNewFileInputStreamPrivilegedAction;
import ilog.rules.bres.persistence.file.util.IlrNewFileOutputStreamPrivilegedAction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IlrFileDataSource
extends IlrAbstractDataSource {
    public static final String DEFAULT_BRES_FILES_DIRECTORY = "res_data";
    private String workingDir;
    private String text_extention = "txt";
    private String http_pattern = "http://";
    private String http_pattern_replacement = "http_colon_slash_slash/";

    public IlrFileDataSource() throws IlrDataSourceException {
        this.initializeDirectory(null);
    }

    public IlrFileDataSource(String string) throws IlrDataSourceException {
        if (string != null) {
            this.initializeDirectory(string);
        }
    }

    public String getPersistenceType() {
        return "File";
    }

    public void setWorkingDirectory(String string) throws IlrDataSourceException {
        if (string != null && !string.equalsIgnoreCase(this.workingDir)) {
            this.initializeDirectory(string);
        }
    }

    public String getWorkingDirectory() {
        return this.workingDir;
    }

    public void insert(IlrRulesetPathElement ilrRulesetPathElement, IlrRulesetArchive ilrRulesetArchive, int n) throws IlrDataSourceException {
        StringBuffer stringBuffer = new StringBuffer().append(this.workingDir).append(ilrRulesetPathElement.toString()).append("/").append("archive");
        File file = new File(stringBuffer.toString());
        try {
            AccessController.doPrivileged(new IlrMkdirsPrivilegedAction(file));
            if (ilrRulesetArchive.getElements().isEmpty()) {
                throw new IlrDataSourceException("1016", new Object[]{ilrRulesetPathElement.toString()});
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            Iterator iterator = ilrRulesetArchive.getElements().iterator();
            while (iterator.hasNext()) {
                int n2;
                IlrRulesetArchive.Element element = (IlrRulesetArchive.Element)iterator.next();
                StringBuffer stringBuffer3 = new StringBuffer(element.getKey());
                int n3 = stringBuffer3.indexOf(this.http_pattern);
                if (n3 != -1) {
                    stringBuffer3.replace(n3, n3 + this.http_pattern.length(), this.http_pattern_replacement);
                }
                if ((n2 = stringBuffer3.lastIndexOf("/")) != -1) {
                    if (stringBuffer2.length() != 0) {
                        stringBuffer2.delete(0, stringBuffer2.length());
                    }
                    stringBuffer2.append(stringBuffer).append("/").append(stringBuffer3.substring(0, n2));
                    AccessController.doPrivileged(new IlrMkdirsPrivilegedAction(new File(stringBuffer2.toString())));
                }
                if (stringBuffer2.length() != 0) {
                    stringBuffer2.delete(0, stringBuffer2.length());
                }
                stringBuffer2.append(stringBuffer).append("/").append(stringBuffer3);
                FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new IlrNewFileOutputStreamPrivilegedAction(stringBuffer2.toString()));
                fileOutputStream.write(element.getContent());
                fileOutputStream.close();
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.cleanUpOnException(file);
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
        catch (IOException iOException) {
            this.cleanUpOnException(file);
            throw new IlrDataSourceException("1002", new Object[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    public void insert(IlrRulesetPathElement ilrRulesetPathElement, int n, String string, int n2) throws IlrDataSourceException {
        StringBuffer stringBuffer = new StringBuffer().append(this.workingDir).append(ilrRulesetPathElement.toString());
        File file = new File(stringBuffer.toString());
        try {
            AccessController.doPrivileged(new IlrMkdirsPrivilegedAction(file));
            this.appendDatatypeString(stringBuffer, n);
            FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new IlrNewFileOutputStreamPrivilegedAction(stringBuffer.toString()));
            fileOutputStream.write(string.getBytes(this.defaultEncoding));
            fileOutputStream.close();
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.cleanUpOnException(file);
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
        catch (IOException iOException) {
            this.cleanUpOnException(file);
            throw new IlrDataSourceException("1002", new Object[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    public void delete(IlrRulesetPathElement ilrRulesetPathElement, int n) throws IlrDataSourceException {
        try {
            StringBuffer stringBuffer = new StringBuffer().append(this.workingDir).append(ilrRulesetPathElement.toString());
            this.deleteDirectory(stringBuffer.toString());
            int n2 = stringBuffer.lastIndexOf("/");
            this.cleanEmptyDirs(stringBuffer.substring(0, n2));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
    }

    public void delete(IlrRulesetPathElement ilrRulesetPathElement, int n, int n2) throws IlrDataSourceException {
        try {
            StringBuffer stringBuffer = new StringBuffer().append(this.workingDir).append(ilrRulesetPathElement.toString());
            int n3 = stringBuffer.length();
            if (7 == n) {
                stringBuffer.append("/").append("archive");
                this.deleteDirectory(stringBuffer.toString());
                this.cleanEmptyDirs(stringBuffer.substring(0, n3));
            } else {
                this.appendDatatypeString(stringBuffer, n);
                AccessController.doPrivileged(new IlrDeleteFilePrivilegedAction(new File(stringBuffer.toString())));
                this.cleanEmptyDirs(stringBuffer.substring(0, n3));
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
    }

    public List selectAllEntities(IlrRulesetPathElement ilrRulesetPathElement) throws IlrDataSourceException {
        ArrayList<IlrRulesetPathElementImpl> arrayList = new ArrayList<IlrRulesetPathElementImpl>();
        File file = ilrRulesetPathElement == null ? new File(this.workingDir) : new File(this.workingDir + "/" + ilrRulesetPathElement.toString());
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
            if (!bl.booleanValue()) {
                throw new IlrDataSourceException("1501", new Object[]{this.workingDir});
            }
            File[] fileArray = (File[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file));
            for (int i = 0; i < fileArray.length; ++i) {
                Boolean bl2 = (Boolean)AccessController.doPrivileged(new IlrIsDirectoryPrivilegedAction(fileArray[i]));
                if (!bl2.booleanValue()) continue;
                String string = fileArray[i].getName();
                File[] fileArray2 = (File[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(fileArray[i]));
                for (int j = 0; j < fileArray2.length; ++j) {
                    String string2;
                    int n;
                    Boolean bl3 = (Boolean)AccessController.doPrivileged(new IlrIsDirectoryPrivilegedAction(fileArray2[j]));
                    if (!bl3.booleanValue() || (n = (string2 = fileArray2[j].getName()).indexOf(".")) == -1) continue;
                    try {
                        int n2 = Integer.parseInt(string2.substring(0, n));
                        int n3 = Integer.parseInt(string2.substring(n + 1));
                        if (ilrRulesetPathElement == null) {
                            arrayList.add(new IlrRulesetPathElementImpl(string, n2, n3));
                            continue;
                        }
                        arrayList.add(new IlrRulesetPathElementImpl(ilrRulesetPathElement.getRuleAppName(), ilrRulesetPathElement.getRuleAppMajorVersion(), ilrRulesetPathElement.getRuleAppMinorVersion(), string, n2, n3));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return arrayList;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
    }

    public ByteArrayOutputStream select(IlrRulesetPathElement ilrRulesetPathElement, int n) throws IlrDataSourceException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        StringBuffer stringBuffer = new StringBuffer().append(this.workingDir).append(ilrRulesetPathElement.toString());
        this.appendDatatypeString(stringBuffer, n);
        File file = new File(stringBuffer.toString());
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new IlrIsFilePrivilegedAction(file));
            if (bl.booleanValue() && bl2.booleanValue()) {
                byteArrayOutputStream = this.readFileContent(stringBuffer.toString());
            } else if (6 == n) {
                throw new IlrDataSourceException("1012", new Object[]{ilrRulesetPathElement.toString(), stringBuffer.toString()});
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                if (6 == n) {
                    throw new IlrDataSourceException("1012", new Object[]{ilrRulesetPathElement.toString(), stringBuffer}, (Throwable)privilegedActionException.getException());
                }
            }
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
        catch (IOException iOException) {
            throw new IlrDataSourceException("1002", new Object[]{iOException.getMessage()}, (Throwable)iOException);
        }
        return byteArrayOutputStream;
    }

    public IlrRulesetArchive selectRulesetArchive(IlrRulesetPathElement ilrRulesetPathElement) throws IlrDataSourceException {
        String string = ilrRulesetPathElement.toString();
        StringBuffer stringBuffer = new StringBuffer().append(this.workingDir).append(string).append("/").append("archive");
        try {
            File file = new File(stringBuffer.toString());
            Boolean bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new IlrIsDirectoryPrivilegedAction(file));
            if (!bl.booleanValue() || !bl2.booleanValue()) {
                throw new IlrDataSourceException("1511", new Object[]{string});
            }
            IlrRulesetArchive ilrRulesetArchive = this.readDirContent(string, file);
            if (ilrRulesetArchive == null) {
                throw new IlrDataSourceException("1512", new Object[]{ilrRulesetPathElement.toString(), ""});
            }
            return ilrRulesetArchive;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
        catch (IOException iOException) {
            throw new IlrDataSourceException("1002", new Object[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    public boolean isResourceAvailable(IlrRulesetPathElement ilrRulesetPathElement, int n) {
        try {
            this.select(ilrRulesetPathElement, n);
            return true;
        }
        catch (IlrDataSourceException ilrDataSourceException) {
            return false;
        }
    }

    private void initializeDirectory(String string) throws IlrDataSourceException {
        File file = string != null ? new File(string) : new File(DEFAULT_BRES_FILES_DIRECTORY);
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new IlrExistDirectoryPrivilegedAction(file));
            if (!bl.booleanValue()) {
                AccessController.doPrivileged(new IlrMkdirsPrivilegedAction(file));
            }
            this.workingDir = (String)AccessController.doPrivileged(new IlrGetCanonicalPathPrivilegedAction(file));
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.cleanUpOnException(file);
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
    }

    private void cleanEmptyDirs(String string) throws IlrDataSourceException {
        if (this.workingDir.equals(string)) {
            return;
        }
        File file = new File(string);
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new IlrIsDirectoryPrivilegedAction(file));
            File[] fileArray = (File[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file));
            if (bl.booleanValue() && fileArray.length == 0) {
                AccessController.doPrivileged(new IlrDeleteFilePrivilegedAction(file));
                int n = string.lastIndexOf("/");
                if (n == -1) {
                    return;
                }
                this.cleanEmptyDirs(string.substring(0, n));
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IlrDataSourceException("1510", new Object[]{privilegedActionException.getException().getMessage()}, (Throwable)privilegedActionException.getException());
        }
    }

    private void deleteDirectory(String string) throws PrivilegedActionException {
        File file = new File(string);
        Boolean bl = (Boolean)AccessController.doPrivileged(new IlrIsDirectoryPrivilegedAction(file));
        if (bl.booleanValue()) {
            this.deleteAllFiles(file);
        }
        AccessController.doPrivileged(new IlrDeleteFilePrivilegedAction(file));
    }

    private void cleanUpOnException(File file) {
        try {
            this.deleteAllFiles(file);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private void deleteAllFiles(File file) throws PrivilegedActionException {
        File[] fileArray;
        if (file != null && (fileArray = (File[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file))) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File[] fileArray2;
                Boolean bl = (Boolean)AccessController.doPrivileged(new IlrIsDirectoryPrivilegedAction(fileArray[i]));
                if (bl.booleanValue() && (fileArray2 = (File[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(fileArray[i]))).length != 0) {
                    this.deleteAllFiles(fileArray[i]);
                }
                AccessController.doPrivileged(new IlrDeleteFilePrivilegedAction(fileArray[i]));
            }
        }
    }

    private ByteArrayOutputStream readFileContent(String string) throws PrivilegedActionException, IOException {
        int n;
        FileInputStream fileInputStream = (FileInputStream)AccessController.doPrivileged(new IlrNewFileInputStreamPrivilegedAction(string));
        byte[] byArray = new byte[500];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        return byteArrayOutputStream;
    }

    private IlrRulesetArchive readDirContent(String string, File file) throws PrivilegedActionException, IOException, IlrDataSourceException {
        File[] fileArray = (File[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file));
        if (fileArray.length == 0) {
            throw new IlrDataSourceException("1511", new Object[]{string});
        }
        IlrRulesetArchive ilrRulesetArchive = new IlrRulesetArchive(this.defaultEncoding);
        this.readDirContent(ilrRulesetArchive, file, file.getPath() + File.separator);
        return ilrRulesetArchive;
    }

    private void readDirContent(IlrRulesetArchive ilrRulesetArchive, File file, String string) throws PrivilegedActionException, IOException {
        File[] fileArray = (File[])AccessController.doPrivileged(new IlrListDirectoryPrivilegedAction(file));
        for (int i = 0; i < fileArray.length; ++i) {
            Boolean bl = (Boolean)AccessController.doPrivileged(new IlrIsDirectoryPrivilegedAction(fileArray[i]));
            if (bl.booleanValue()) {
                this.readDirContent(ilrRulesetArchive, fileArray[i], string);
                continue;
            }
            String string2 = fileArray[i].getPath();
            String string3 = string2.substring(string.length());
            String string4 = string3.replace('\\', '/').replaceAll(this.http_pattern_replacement, this.http_pattern);
            IlrRulesetArchive ilrRulesetArchive2 = ilrRulesetArchive;
            ilrRulesetArchive2.getClass();
            IlrRulesetArchive.Element element = ilrRulesetArchive2.new IlrRulesetArchive.Element(string4);
            ByteArrayOutputStream byteArrayOutputStream = this.readFileContent(string2);
            element.setContent(byteArrayOutputStream.toByteArray());
            ilrRulesetArchive.addElement(element);
        }
    }

    private void appendDatatypeString(StringBuffer stringBuffer, int n) {
        stringBuffer.append("/");
        switch (n) {
            case 6: {
                stringBuffer.append("creation_date");
                break;
            }
            case 4: {
                stringBuffer.append("description");
                break;
            }
            case 5: {
                stringBuffer.append("display_name");
                break;
            }
            case 3: {
                stringBuffer.append("properties");
                break;
            }
            case 2: {
                stringBuffer.append("properties");
            }
        }
        stringBuffer.append(".").append(this.text_extention);
    }
}

