/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.persistence.file;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.model.IlrAlreadyExistException;
import ilog.rules.bres.model.IlrFormatException;
import ilog.rules.bres.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.bres.model.IlrMutableRuleAppInformation;
import ilog.rules.bres.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.impl.IlrVersionImpl;
import ilog.rules.bres.persistence.IlrAbstractTransactionalResourceProvider;
import ilog.rules.bres.persistence.IlrDataGetterException;
import ilog.rules.bres.persistence.IlrDataProvider;
import ilog.rules.bres.persistence.IlrDataProviderException;
import ilog.rules.bres.persistence.IlrDataSourceException;
import ilog.rules.bres.persistence.IlrResourceProvider;
import ilog.rules.bres.persistence.IlrResourceProviderException;
import ilog.rules.bres.persistence.IlrRulesetPathElement;
import ilog.rules.bres.persistence.IlrRulesetPathElementImpl;
import ilog.rules.bres.persistence.file.IlrFileDataProvider;
import ilog.rules.bres.persistence.file.IlrFileDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class IlrFileResourceProvider
extends IlrAbstractTransactionalResourceProvider {
    protected IlrFileDataProvider fileDataProvider = null;
    private IlrFileDiagnosticResultImpl fileDiagRes = new IlrFileDiagnosticResultImpl();

    public IlrFileResourceProvider() throws IlrDataSourceException {
        this.fileDataProvider = new IlrFileDataProvider();
    }

    public IlrFileResourceProvider(String string) throws IlrDataSourceException {
        this.fileDataProvider = new IlrFileDataProvider(string);
    }

    public IlrDataProvider getDataProvider() {
        return this.fileDataProvider;
    }

    public int startTransaction() throws IlrResourceProviderException {
        return 0;
    }

    public void endTransaction(int n) throws IlrResourceProviderException {
    }

    public Set load(IlrRepositoryFactory ilrRepositoryFactory) throws IlrResourceProviderException {
        HashSet<IlrMutableRuleAppInformation> hashSet = new HashSet<IlrMutableRuleAppInformation>();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = (ArrayList)this.fileDataProvider.retrieveEntities(null);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                IlrRulesetPathElement ilrRulesetPathElement = (IlrRulesetPathElement)iterator.next();
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(ilrRulesetPathElement.getRuleAppMajorVersion());
                stringBuffer.append(".");
                stringBuffer.append(ilrRulesetPathElement.getRuleAppMinorVersion());
                IlrVersionImpl ilrVersionImpl = (IlrVersionImpl)ilrRepositoryFactory.getVersionParser().parse(stringBuffer.toString());
                ByteArrayOutputStream byteArrayOutputStream = this.fileDataProvider.retrieveResource(ilrRulesetPathElement, 6);
                IlrMutableRuleAppInformation ilrMutableRuleAppInformation = ilrRepositoryFactory.createRuleApp(ilrRulesetPathElement.getRuleAppName(), ilrVersionImpl, new Date(Long.parseLong(byteArrayOutputStream.toString(this.encoding))));
                byteArrayOutputStream = this.fileDataProvider.retrieveResource(ilrRulesetPathElement, 4);
                if (byteArrayOutputStream != null) {
                    ilrMutableRuleAppInformation.setDescription(byteArrayOutputStream.toString(this.encoding));
                }
                if ((byteArrayOutputStream = this.fileDataProvider.retrieveResource(ilrRulesetPathElement, 5)) != null) {
                    ilrMutableRuleAppInformation.setDisplayName(byteArrayOutputStream.toString(this.encoding));
                }
                ArrayList arrayList2 = (ArrayList)this.fileDataProvider.retrieveEntities(ilrRulesetPathElement);
                Iterator iterator2 = arrayList2.iterator();
                while (iterator2.hasNext()) {
                    IlrRulesetPathElementImpl ilrRulesetPathElementImpl = (IlrRulesetPathElementImpl)iterator2.next();
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(ilrRulesetPathElementImpl.getRulesetMajorVersion());
                    stringBuffer.append(".");
                    stringBuffer.append(ilrRulesetPathElementImpl.getRulesetMinorVersion());
                    ilrVersionImpl = (IlrVersionImpl)ilrRepositoryFactory.getVersionParser().parse(stringBuffer.toString());
                    byteArrayOutputStream = this.fileDataProvider.retrieveResource(ilrRulesetPathElementImpl, 6);
                    IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation = ilrRepositoryFactory.createRuleset(ilrRulesetPathElementImpl.getRulesetName(), ilrVersionImpl, new Date(Long.parseLong(byteArrayOutputStream.toString(this.encoding))));
                    byteArrayOutputStream = this.fileDataProvider.retrieveResource(ilrRulesetPathElementImpl, 4);
                    if (byteArrayOutputStream != null) {
                        ilrMutableRulesetArchiveInformation.setDescription(byteArrayOutputStream.toString(this.encoding));
                    }
                    if ((byteArrayOutputStream = this.fileDataProvider.retrieveResource(ilrRulesetPathElementImpl, 5)) != null) {
                        ilrMutableRulesetArchiveInformation.setDisplayName(byteArrayOutputStream.toString(this.encoding));
                    }
                    ilrMutableRuleAppInformation.addRuleset(ilrMutableRulesetArchiveInformation);
                }
                hashSet.add(ilrMutableRuleAppInformation);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", unsupportedEncodingException);
            }
            catch (IlrFormatException ilrFormatException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrFormatException);
            }
            catch (IlrAlreadyExistException ilrAlreadyExistException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrAlreadyExistException);
            }
            catch (IlrIllegalArgumentRuntimeException ilrIllegalArgumentRuntimeException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrIllegalArgumentRuntimeException);
            }
            catch (IlrDataGetterException ilrDataGetterException) {
                if (ilrDataGetterException.getCause() != null) {
                    throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrDataGetterException.getCause());
                }
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrDataGetterException);
            }
        }
        return hashSet;
    }

    public void addRuleApp(IlrRuleAppInformation ilrRuleAppInformation, int n) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrRuleAppInformation);
        this.fileDataProvider.saveResource(ilrRulesetPathElementImpl, 6, String.valueOf(ilrRuleAppInformation.getCreationDate().getTime()), n);
        this.updateRuleApp(ilrRuleAppInformation, n);
        Set set = ilrRuleAppInformation.getRulesets();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IlrRulesetArchiveInformation ilrRulesetArchiveInformation = (IlrRulesetArchiveInformation)iterator.next();
            try {
                IlrRulesetPathElementImpl ilrRulesetPathElementImpl2 = new IlrRulesetPathElementImpl(ilrRulesetArchiveInformation);
                this.addRuleset(ilrRulesetPathElementImpl2.getPath(), ilrRulesetArchiveInformation, n);
            }
            catch (IlrFormatException ilrFormatException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrFormatException);
            }
        }
    }

    public void updateRuleApp(IlrRuleAppInformation ilrRuleAppInformation, int n) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrRuleAppInformation);
        try {
            IlrPath ilrPath = ilrRulesetPathElementImpl.getPath();
            this.setDisplayName(ilrPath, ilrRuleAppInformation.getDisplayName());
            this.setDescription(ilrPath, ilrRuleAppInformation.getDescription());
            this.setProperties(ilrPath, ilrRuleAppInformation.getProperties().toProperties());
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrFormatException);
        }
    }

    public void removeRuleApp(IlrPath ilrPath, int n) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        this.fileDataProvider.removeResource(ilrRulesetPathElementImpl, n);
    }

    public void addRuleset(IlrPath ilrPath, IlrRulesetArchiveInformation ilrRulesetArchiveInformation, int n) throws IlrResourceProviderException {
        try {
            IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
            IlrRulesetArchive ilrRulesetArchive = ilrRulesetArchiveInformation.getRulesetArchive();
            if (ilrRulesetArchive == null) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1015", new Object[]{ilrRulesetPathElementImpl.toString()});
            }
            this.fileDataProvider.saveResource(ilrRulesetPathElementImpl, 6, String.valueOf(ilrRulesetArchiveInformation.getCreationDate().getTime()), n);
            this.setDisplayName(ilrPath, ilrRulesetArchiveInformation.getDisplayName());
            this.setDescription(ilrPath, ilrRulesetArchiveInformation.getDescription());
            this.setProperties(ilrPath, ilrRulesetArchiveInformation.getProperties().toProperties());
            this.setRulesetArchive(ilrPath, ilrRulesetArchive);
        }
        catch (IlrDataProviderException ilrDataProviderException) {
            throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrDataProviderException.getCause());
        }
    }

    public void removeRuleset(IlrPath ilrPath, int n) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        this.fileDataProvider.removeResource(ilrRulesetPathElementImpl, n);
    }

    public IlrRulesetArchive getRulesetArchive(IlrPath ilrPath) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        return this.fileDataProvider.retrieveRulesetArchive(ilrRulesetPathElementImpl);
    }

    public void setRulesetArchive(IlrPath ilrPath, IlrRulesetArchive ilrRulesetArchive) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        if (ilrRulesetArchive == null) {
            throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1015", new Object[]{ilrRulesetPathElementImpl.toString()});
        }
        this.fileDataProvider.removeResource(ilrRulesetPathElementImpl, 7, -1);
        this.fileDataProvider.saveResource(ilrRulesetPathElementImpl, ilrRulesetArchive, -1);
    }

    public Properties getProperties(IlrPath ilrPath) throws IlrResourceProviderException {
        Properties properties;
        block4: {
            properties = new Properties();
            try {
                IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
                ByteArrayOutputStream byteArrayOutputStream = this.fileDataProvider.retrieveResource(ilrRulesetPathElementImpl, 3);
                if (byteArrayOutputStream != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    properties.load(byteArrayInputStream);
                }
            }
            catch (IOException iOException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1002", new Object[]{iOException.getMessage()}, iOException);
            }
            catch (IlrDataGetterException ilrDataGetterException) {
                if (ilrDataGetterException.getCause() == null || ilrDataGetterException.getCause() instanceof FileNotFoundException) break block4;
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrDataGetterException.getCause());
            }
        }
        return properties;
    }

    public void setProperty(IlrPath ilrPath, String string, String string2) throws IlrResourceProviderException {
        if (string == null) {
            return;
        }
        Properties properties = this.getProperties(ilrPath);
        if (string2 != null) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
        this.setProperties(ilrPath, properties);
    }

    public void setProperties(IlrPath ilrPath, Properties properties) throws IlrResourceProviderException {
        if (properties != null) {
            try {
                IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                properties.store(byteArrayOutputStream, null);
                this.fileDataProvider.saveResource(ilrRulesetPathElementImpl, 3, byteArrayOutputStream.toString(this.encoding), -1);
            }
            catch (IOException iOException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1002", new Object[]{iOException.getMessage()}, iOException);
            }
        }
    }

    public void setDisplayName(IlrPath ilrPath, String string) throws IlrResourceProviderException {
        if (string != null) {
            IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
            this.fileDataProvider.removeResource(ilrRulesetPathElementImpl, 5, -1);
            this.fileDataProvider.saveResource(ilrRulesetPathElementImpl, 5, string, -1);
        }
    }

    public void setDescription(IlrPath ilrPath, String string) throws IlrResourceProviderException {
        if (string != null) {
            IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
            this.fileDataProvider.removeResource(ilrRulesetPathElementImpl, 4, -1);
            this.fileDataProvider.saveResource(ilrRulesetPathElementImpl, 4, string, -1);
        }
    }

    public String getDetails() {
        try {
            IlrFileDataSource ilrFileDataSource = (IlrFileDataSource)this.fileDataProvider.getDataSource();
            File file = new File(ilrFileDataSource.getWorkingDirectory());
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public IlrResourceProvider.IlrDiagnosticResult executeDiagnostic() {
        this.fileDiagRes.setInfos(this.fileDataProvider);
        return this.fileDiagRes;
    }

    public class IlrFileDiagnosticResultImpl
    implements IlrResourceProvider.IlrDiagnosticResult {
        boolean isPassed = false;
        Exception e;
        Properties props = new Properties();

        public boolean isPassed() {
            return this.isPassed;
        }

        public Exception getError() {
            return this.e;
        }

        public Properties getInfos() {
            return this.props;
        }

        public void setPassed(boolean bl) {
            this.isPassed = bl;
        }

        public void setError(Exception exception) {
            this.e = exception;
        }

        public void setInfos(IlrFileDataProvider ilrFileDataProvider) {
            IlrFileDataSource ilrFileDataSource = (IlrFileDataSource)ilrFileDataProvider.getDataSource();
            File file = new File(ilrFileDataSource.getWorkingDirectory());
            try {
                this.props.put("Working Directory", file.getCanonicalPath());
                this.performCheck(ilrFileDataSource);
                this.setPassed(true);
            }
            catch (IOException iOException) {
                this.setError(iOException);
                this.setPassed(false);
            }
            catch (IlrDataSourceException ilrDataSourceException) {
                this.setError(ilrDataSourceException);
                this.setPassed(false);
            }
        }

        private void performCheck(IlrFileDataSource ilrFileDataSource) throws IlrDataSourceException {
            boolean bl = true;
            while (bl) {
                IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl("IlogRuleAppForDiagnostic", 98765, 12345);
                bl = ilrFileDataSource.isResourceAvailable(ilrRulesetPathElementImpl, 6);
                if (bl) continue;
                ilrFileDataSource.insert(ilrRulesetPathElementImpl, 6, String.valueOf(System.currentTimeMillis()), -1);
                ilrFileDataSource.delete(ilrRulesetPathElementImpl, 6, -1);
            }
        }
    }
}

