/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.persistence.jdbc;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.model.IlrFormatException;
import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.impl.IlrRepositoryFactoryImpl;
import ilog.rules.bres.model.impl.IlrVersionImpl;
import ilog.rules.bres.persistence.IlrDataGetter;
import ilog.rules.bres.persistence.IlrDataGetterException;
import ilog.rules.bres.persistence.IlrDataSource;
import ilog.rules.bres.persistence.IlrRulesetPathElement;
import ilog.rules.bres.persistence.IlrRulesetPathElementImpl;
import ilog.rules.bres.persistence.jdbc.IlrDbDataSource;
import ilog.rules.bres.persistence.jdbc.IlrDbDataSourceFactory;
import ilog.rules.bres.persistence.jdbc.IlrDbDataSourceFactoryException;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;

public class IlrDbDataGetter
implements IlrDataGetter {
    protected IlrDbDataSource dbDS = null;

    public IlrDbDataGetter() {
    }

    public IlrDbDataGetter(String string) throws IlrDataGetterException {
        String string2 = string == null ? "jdbc/bresdatasource" : string;
        try {
            this.dbDS = IlrDbDataSourceFactory.getInstance("java:comp/env/" + string2);
        }
        catch (NamingException namingException) {
            try {
                this.dbDS = IlrDbDataSourceFactory.getInstance(string2);
            }
            catch (NamingException namingException2) {
                throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{namingException.getMessage()}, namingException);
            }
            catch (SQLException sQLException) {
                throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{sQLException.getMessage()}, sQLException);
            }
            catch (IlrDbDataSourceFactoryException ilrDbDataSourceFactoryException) {
                if (ilrDbDataSourceFactoryException.getCause() != null) {
                    throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{ilrDbDataSourceFactoryException.getCause().getMessage()}, ilrDbDataSourceFactoryException.getCause());
                }
                throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{ilrDbDataSourceFactoryException.getMessage()});
            }
        }
        catch (SQLException sQLException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{sQLException.getMessage()}, sQLException);
        }
        catch (IlrDbDataSourceFactoryException ilrDbDataSourceFactoryException) {
            if (ilrDbDataSourceFactoryException.getCause() != null) {
                throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{ilrDbDataSourceFactoryException.getCause().getMessage()}, ilrDbDataSourceFactoryException.getCause());
            }
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{ilrDbDataSourceFactoryException.getMessage()});
        }
    }

    public IlrDbDataGetter(ClassLoader classLoader, String string, String string2, Properties properties) throws IlrDataGetterException {
        try {
            this.dbDS = IlrDbDataSourceFactory.getInstance(classLoader, string, string2, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{classNotFoundException.getMessage()}, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{instantiationException.getMessage()}, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{illegalAccessException.getMessage()}, illegalAccessException);
        }
        catch (SQLException sQLException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{sQLException.getMessage()}, sQLException);
        }
        catch (IlrDbDataSourceFactoryException ilrDbDataSourceFactoryException) {
            if (ilrDbDataSourceFactoryException.getCause() != null) {
                throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{ilrDbDataSourceFactoryException.getCause().getMessage()}, ilrDbDataSourceFactoryException.getCause());
            }
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1001", new Object[]{ilrDbDataSourceFactoryException.getCause().getMessage()});
        }
    }

    public IlrDbDataGetter(IlrDbDataSource ilrDbDataSource) {
        this.dbDS = ilrDbDataSource;
    }

    public IlrDataSource getDataSource() {
        return this.dbDS;
    }

    public boolean isResourceAvailable(IlrRulesetPathElement ilrRulesetPathElement, int n) {
        if (this.dbDS != null) {
            return this.dbDS.isResourceAvailable(ilrRulesetPathElement, n);
        }
        return false;
    }

    public ByteArrayOutputStream retrieveResource(String string, int n) throws IlrDataGetterException {
        IlrPath ilrPath;
        IlrRepositoryFactoryImpl ilrRepositoryFactoryImpl = new IlrRepositoryFactoryImpl();
        try {
            ilrPath = ilrRepositoryFactoryImpl.getPathParser().parse(string);
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1010", new Object[]{string});
        }
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        return this.retrieveResource(ilrRulesetPathElementImpl, n);
    }

    public ByteArrayOutputStream retrieveResource(IlrRulesetPathElement ilrRulesetPathElement, int n) throws IlrDataGetterException {
        return this.dbDS.select(ilrRulesetPathElement, n);
    }

    public String retrieveResourceAsString(IlrRulesetPathElement ilrRulesetPathElement, int n) throws IlrDataGetterException {
        return this.dbDS.selectAsString(ilrRulesetPathElement, n);
    }

    public Properties retrieveResourceAsProperties(IlrRulesetPathElement ilrRulesetPathElement) throws IlrDataGetterException {
        return this.dbDS.selectAsProperties(ilrRulesetPathElement);
    }

    public String getCanonicalRulesetPath(IlrPath ilrPath) throws IlrDataGetterException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (ilrPath.getRuleAppVersion() != null) {
            n = ((IlrVersionImpl)ilrPath.getRuleAppVersion()).getMajor();
            n2 = ((IlrVersionImpl)ilrPath.getRuleAppVersion()).getMinor();
        }
        if (ilrPath.getRulesetVersion() != null) {
            n3 = ((IlrVersionImpl)ilrPath.getRulesetVersion()).getMajor();
            n4 = ((IlrVersionImpl)ilrPath.getRulesetVersion()).getMinor();
        }
        return this.getCanonicalRulesetPath(ilrPath.getRuleAppName(), n, n2, ilrPath.getRulesetName(), n3, n4);
    }

    public IlrRulesetArchive retrieveRulesetArchive(String string) throws IlrDataGetterException {
        IlrPath ilrPath;
        IlrRepositoryFactoryImpl ilrRepositoryFactoryImpl = new IlrRepositoryFactoryImpl();
        try {
            ilrPath = ilrRepositoryFactoryImpl.getPathParser().parse(string);
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1010", new Object[]{string});
        }
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        return this.retrieveRulesetArchive(ilrRulesetPathElementImpl);
    }

    public IlrRulesetArchive retrieveRulesetArchive(IlrRulesetPathElement ilrRulesetPathElement) throws IlrDataGetterException {
        return this.dbDS.selectRulesetArchive(ilrRulesetPathElement);
    }

    public String getCanonicalRulesetPath(String string, int n, int n2, String string2, int n3, int n4) throws IlrDataGetterException {
        int n5 = -1;
        if (string == null || string2 == null) {
            if (string == null) {
                throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1008", new Object[]{"IlrDataGetter::getCanonicalRulesetPath"});
            }
            if (string2 == null) {
                throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1009", new Object[]{"IlrDataGetter::getCanonicalRulesetPath"});
            }
        }
        if (n == n5 && n3 == n5) {
            return "/" + this.dbDS.getLatestRaVersionAndLatestRsVersion(string, string2);
        }
        if (n == n5 && n3 != n5 && n4 != n5) {
            return "/" + this.dbDS.getLatestRaAndGivenRsVersion(string, string2, n3, n4);
        }
        if (n != n5 && n2 != n5 && n3 == n5) {
            return "/" + this.dbDS.getGivenRaVersionAndLatestRsVersion(string, n, n2, string2);
        }
        if (n != n5 && n2 != n5 && n3 != n5 && n4 != n5) {
            return "/" + this.dbDS.getGivenRaVersionAndGivenRsVersion(string, n, n2, string2, n3, n4);
        }
        throw new IlrDataGetterException("ilog.rules.bres.persistence.messages", "1010", new Object[]{"IlrDataGetter::getCanonicalRulesetPath"});
    }
}

