/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.persistence.jdbc;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.persistence.IlrAbstractDataSource;
import ilog.rules.bres.persistence.IlrDataGetterException;
import ilog.rules.bres.persistence.IlrDataSourceException;
import ilog.rules.bres.persistence.IlrPersistenceUtil;
import ilog.rules.bres.persistence.IlrRulesetPathElement;
import ilog.rules.bres.persistence.IlrRulesetPathElementImpl;
import ilog.rules.bres.persistence.IlrTransactionImpl;
import ilog.rules.bres.persistence.xml.IlrXmlSqlHelper;
import ilog.rules.bres.persistence.xml.IlrXmlSqlHelperException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class IlrDbDataSource
extends IlrAbstractDataSource {
    protected IlrXmlSqlHelper xmlSqlHelper;
    private DataSource asDatasource = null;
    private String driverClassName = null;
    private Driver driverInstance = null;
    private DatabaseMetaData dbMetaData = null;
    private String dbNameFromDriver = null;
    private String dbVersionFromDriver = null;
    private String dbUrl = null;
    private Connection connection = null;
    private Properties connProps = null;
    private boolean keepConnected = false;
    private ClassLoader classLoader = null;
    private IlrTransactionImpl transaction = null;

    public IlrDbDataSource(Connection connection, Properties properties) throws SQLException {
        this.connection = connection;
        this.connProps = properties;
        this.getConnectionMetaDataInformation(this.connection);
    }

    public IlrDbDataSource(ClassLoader classLoader, Driver driver, String string, Properties properties) throws SQLException {
        this.classLoader = classLoader;
        this.driverInstance = driver;
        this.driverClassName = this.driverInstance.getClass().getName();
        this.dbUrl = string;
        this.connProps = properties;
        this.connection = this.getConnection();
        this.getConnectionMetaDataInformation(this.connection);
    }

    public IlrDbDataSource(ClassLoader classLoader, String string, String string2, Properties properties) throws SQLException {
        this.classLoader = classLoader;
        this.driverClassName = string;
        this.dbUrl = string2;
        this.connProps = properties;
        this.connection = this.getConnection();
        this.getConnectionMetaDataInformation(this.connection);
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrDbDataSource(String string) throws NamingException, SQLException {
        IlrPersistenceUtil.log(1, "[IlrDbDataSource(" + string + ")]", null);
        try {
            this.connection = this.getDataSourceConnection(string);
            this.getConnectionMetaDataInformation(this.connection);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                IlrPersistenceUtil.log(1, "[IlrDbDataSource(" + string + ")]Connection closed", null);
            }
            throw throwable;
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            IlrPersistenceUtil.log(1, "[IlrDbDataSource(" + string + ")]Connection closed", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrDbDataSource(DataSource dataSource, IlrXmlSqlHelper ilrXmlSqlHelper) throws SQLException {
        IlrPersistenceUtil.log(1, "[IlrDbDataSource(DataSource, IlrXmlSqlHelper)]", null);
        this.asDatasource = dataSource;
        this.xmlSqlHelper = ilrXmlSqlHelper;
        try {
            this.connection = dataSource.getConnection();
            this.getConnectionMetaDataInformation(this.connection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                IlrPersistenceUtil.log(1, "[IlrDbDataSource(DataSource, IlrXmlSqlHelper)]Connection closed", null);
            }
            throw throwable;
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            IlrPersistenceUtil.log(1, "[IlrDbDataSource(DataSource, IlrXmlSqlHelper)]Connection closed", null);
        }
    }

    public IlrDbDataSource(DataSource dataSource) throws SQLException, IlrXmlSqlHelperException {
        this(dataSource, new IlrXmlSqlHelper());
    }

    public DataSource getDataSource() {
        return this.asDatasource;
    }

    public Connection getConnection() throws SQLException {
        if (this.asDatasource != null) {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = this.asDatasource.getConnection();
            }
            return this.connection;
        }
        if (this.connection == null || this.connection.isClosed()) {
            if (this.driverInstance == null) {
                try {
                    Class<?> clazz = this.classLoader != null ? Class.forName(this.driverClassName, true, this.classLoader) : Class.forName(this.driverClassName);
                    this.driverInstance = (Driver)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SQLException(classNotFoundException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    throw new SQLException(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SQLException(illegalAccessException.getMessage());
                }
            }
            this.connection = this.driverInstance.connect(this.dbUrl, this.connProps);
        }
        return this.connection;
    }

    public void closeConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    public boolean isKeepConnected() {
        return this.keepConnected;
    }

    public void setKeepConnected(boolean bl) {
        this.keepConnected = bl;
    }

    public String getDatabaseName() {
        return this.dbNameFromDriver;
    }

    public String getDatabaseVersion() {
        return this.dbVersionFromDriver;
    }

    public String getConnectionUrl() {
        return this.dbUrl;
    }

    public void setConnectionUrl(String string) {
        this.dbUrl = string;
    }

    public Properties getConnectionProperties() {
        return this.connProps;
    }

    public void setConnectionProperties(Properties properties) {
        if (this.connProps == null) {
            this.connProps = properties;
        } else {
            this.connProps.putAll((Map<?, ?>)properties);
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public IlrXmlSqlHelper getXmlSqlHelper() {
        return this.xmlSqlHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getDataSourceConnection(String string) throws NamingException, SQLException {
        InitialContext initialContext = null;
        Connection connection = null;
        try {
            initialContext = new InitialContext();
            this.asDatasource = (DataSource)initialContext.lookup(string);
            connection = this.asDatasource.getConnection();
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
        }
        return connection;
    }

    private void getConnectionMetaDataInformation(Connection connection) throws SQLException {
        this.dbMetaData = connection.getMetaData();
        this.dbUrl = this.dbMetaData.getURL();
        this.dbNameFromDriver = this.dbMetaData.getDatabaseProductName();
        this.dbVersionFromDriver = this.dbMetaData.getDatabaseProductVersion();
    }

    public String getPersistenceType() {
        return "Database";
    }

    public synchronized int startTransaction() throws IlrDataSourceException {
        return -1;
    }

    public synchronized void endTransaction(int n) throws IlrDataSourceException {
    }

    public boolean isInTransaction() {
        return this.transaction != null && this.transaction.getStatus() != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertProperty(IlrRulesetPathElement ilrRulesetPathElement, String string, String string2, int n) throws IlrDataSourceException {
        if (string == null) {
            return;
        }
        try {
            Connection connection;
            block20: {
                connection = null;
                Statement statement = null;
                try {
                    connection = this.getConnection();
                    if (ilrRulesetPathElement.isRuleApp()) {
                        int n2 = this.getId(ilrRulesetPathElement, connection);
                        statement = connection.prepareStatement("update RULEAPP_PROPERTIES set VALUE = ?, IS_AVAILABLE = 1 where RULEAPP_ID = ? and NAME = ?");
                        statement.setString(1, string2);
                        statement.setInt(2, n2);
                        statement.setString(3, string);
                        int n3 = statement.executeUpdate();
                        if (n3 == 1) {
                            if (!connection.getAutoCommit()) {
                                connection.commit();
                            }
                        } else {
                            if (statement != null) {
                                statement.close();
                            }
                            statement = connection.prepareStatement("insert into RULEAPP_PROPERTIES (RULEAPP_ID, NAME, VALUE) values (?, ?, ?)");
                            statement.setInt(1, n2);
                            statement.setString(2, string);
                            statement.setString(3, string2);
                            n3 = statement.executeUpdate();
                            if (n3 == 1 && !connection.getAutoCommit()) {
                                connection.commit();
                            }
                        }
                    } else {
                        int n4 = this.getId(ilrRulesetPathElement, connection);
                        statement = connection.prepareStatement("update RULESET_PROPERTIES set VALUE = ?, IS_AVAILABLE = 1 where RULESET_ID = ? and NAME = ?");
                        statement.setString(1, string2);
                        statement.setInt(2, n4);
                        statement.setString(3, string);
                        int n5 = statement.executeUpdate();
                        if (n5 == 1) {
                            if (!connection.getAutoCommit()) {
                                connection.commit();
                            }
                        } else {
                            if (statement != null) {
                                statement.close();
                            }
                            statement = connection.prepareStatement("insert into RULESET_PROPERTIES (RULESET_ID, NAME, VALUE) values (?, ?, ?)");
                            statement.setInt(1, n4);
                            statement.setString(2, string);
                            statement.setString(3, string2);
                            n5 = statement.executeUpdate();
                            if (n5 == 1 && !connection.getAutoCommit()) {
                                connection.commit();
                            }
                        }
                    }
                    Object var10_12 = null;
                    if (statement == null) break block20;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (statement != null) {
                        statement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                statement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(IlrRulesetPathElement ilrRulesetPathElement, boolean bl, Map map, int n) throws IlrDataSourceException {
        if (map == null) {
            return;
        }
        try {
            Connection connection = null;
            try {
                connection = this.getConnection();
                if (!bl) {
                    if (ilrRulesetPathElement.isRuleApp()) {
                        this.insertRuleApp(ilrRulesetPathElement, map, connection, n);
                    } else {
                        this.insertRuleset(ilrRulesetPathElement, map, connection, n);
                    }
                } else {
                    this.insertRulesetProperties(ilrRulesetPathElement, (Properties)map, connection, n);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                    connection.close();
                }
                throw throwable;
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(IlrRulesetPathElement ilrRulesetPathElement, int n, String string, int n2) throws IlrDataSourceException {
        if (string == null) {
            return;
        }
        try {
            Connection connection = null;
            try {
                connection = this.getConnection();
                if (ilrRulesetPathElement.isRuleApp()) {
                    if (6 == n) {
                        this.insertRuleApp(ilrRulesetPathElement, string, connection, n2);
                    } else {
                        this.updateRuleApp(ilrRulesetPathElement, n, string, connection, n2);
                    }
                } else if (6 == n) {
                    this.insertRuleset(ilrRulesetPathElement, string, connection, n2);
                } else {
                    this.updateRuleset(ilrRulesetPathElement, n, string, connection, n2);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                    connection.close();
                }
                throw throwable;
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(IlrRulesetPathElement ilrRulesetPathElement, IlrRulesetArchive ilrRulesetArchive, int n) throws IlrDataSourceException {
        if (ilrRulesetArchive == null) {
            return;
        }
        try {
            Connection connection;
            block18: {
                connection = null;
                Statement statement = null;
                try {
                    connection = this.getConnection();
                    connection.setAutoCommit(false);
                    if (ilrRulesetArchive.getElements().isEmpty()) {
                        throw new IlrDataSourceException("1016", new Object[]{ilrRulesetPathElement.toString()});
                    }
                    int n2 = this.getId(ilrRulesetPathElement, connection);
                    boolean bl = true;
                    statement = connection.prepareStatement("insert into RULESET_RESOURCES (RULESET_ID, NAME, DATA, PART) values (?, ?, ?, ?)");
                    boolean bl2 = false;
                    Iterator iterator = ilrRulesetArchive.getElements().iterator();
                    while (iterator.hasNext()) {
                        IlrRulesetArchive.Element element = (IlrRulesetArchive.Element)iterator.next();
                        if (element.toString().length() > 998) {
                            String[] stringArray = this.splitString(element.toString(), 998);
                            for (int i = 0; i < stringArray.length; ++i) {
                                statement.setInt(1, n2);
                                statement.setString(2, element.getKey());
                                statement.setString(3, stringArray[i]);
                                if (stringArray.length == 1 || i == stringArray.length - 1) {
                                    statement.setInt(4, Integer.MAX_VALUE);
                                } else {
                                    statement.setInt(4, i + 1);
                                }
                                statement.addBatch();
                            }
                        } else {
                            statement.setInt(1, n2);
                            statement.setString(2, element.getKey());
                            statement.setString(3, element.toString());
                            statement.setInt(4, Integer.MAX_VALUE);
                            statement.addBatch();
                        }
                        bl2 = true;
                    }
                    if (bl2) {
                        statement.executeBatch();
                    }
                    if (bl && !connection.getAutoCommit()) {
                        connection.commit();
                    }
                    Object var14_15 = null;
                    if (statement == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    if (statement != null) {
                        statement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                statement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (BatchUpdateException batchUpdateException) {
            throw new IlrDataSourceException("1301", new Object[]{batchUpdateException.getSQLState(), batchUpdateException.getMessage()}, (Throwable)batchUpdateException);
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized IlrRulesetArchive selectRulesetArchive(IlrRulesetPathElement ilrRulesetPathElement) throws IlrDataSourceException {
        try {
            Object object;
            PreparedStatement preparedStatement;
            Connection connection;
            block16: {
                connection = null;
                preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    connection = this.getConnection();
                    preparedStatement = connection.prepareStatement("select NAME, DATA, PART from RULESET_RESOURCES where RULESET_ID = ? order by NAME, PART");
                    int n = this.getId(ilrRulesetPathElement, connection);
                    preparedStatement.setInt(1, n);
                    resultSet = preparedStatement.executeQuery();
                    String string = "";
                    StringBuffer stringBuffer = new StringBuffer();
                    Object object2 = null;
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("NAME");
                        int n2 = resultSet.getInt("PART");
                        if (string.equals(string2)) {
                            stringBuffer.append(resultSet.getString("DATA"));
                        } else {
                            stringBuffer.setLength(0);
                            stringBuffer.append(resultSet.getString("DATA"));
                        }
                        if (n2 == Integer.MAX_VALUE) {
                            if (object2 == null) {
                                object2 = new IlrRulesetArchive(this.defaultEncoding);
                            }
                            Object object3 = object2;
                            object3.getClass();
                            IlrRulesetArchive.Element element = (IlrRulesetArchive)object3.new IlrRulesetArchive.Element(string2);
                            element.setContent(stringBuffer.toString().getBytes(this.defaultEncoding));
                            ((IlrRulesetArchive)object2).addElement(element);
                        }
                        string = string2;
                    }
                    if (object2 == null) {
                        throw new IlrDataSourceException("1303", new Object[]{ilrRulesetPathElement.toString(), ""});
                    }
                    object = object2;
                    Object var13_15 = null;
                    if (resultSet == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return object;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IlrDataSourceException("1002", new Object[]{unsupportedEncodingException.getMessage()}, (Throwable)unsupportedEncodingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized List selectAllEntities(IlrRulesetPathElement ilrRulesetPathElement) throws IlrDataSourceException {
        ArrayList<IlrRulesetPathElementImpl> arrayList = new ArrayList<IlrRulesetPathElementImpl>();
        try {
            ArrayList<IlrRulesetPathElementImpl> arrayList2;
            PreparedStatement preparedStatement;
            Connection connection;
            block13: {
                String string = ilrRulesetPathElement != null ? "select NAME, MAJOR_VERSION, MINOR_VERSION from RULESETS where RULEAPP_ID = ?" : "select NAME, MAJOR_VERSION, MINOR_VERSION from RULEAPPS";
                connection = null;
                preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    connection = this.getConnection();
                    if (ilrRulesetPathElement != null) {
                        int n = this.getId(ilrRulesetPathElement, connection);
                        preparedStatement = connection.prepareStatement(string);
                        preparedStatement.setInt(1, n);
                    } else {
                        preparedStatement = connection.prepareStatement(string);
                    }
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        if (ilrRulesetPathElement == null) {
                            arrayList.add(new IlrRulesetPathElementImpl(resultSet.getString("NAME"), resultSet.getInt("MAJOR_VERSION"), resultSet.getInt("MINOR_VERSION")));
                            continue;
                        }
                        arrayList.add(new IlrRulesetPathElementImpl(ilrRulesetPathElement.getRuleAppName(), ilrRulesetPathElement.getRuleAppMajorVersion(), ilrRulesetPathElement.getRuleAppMinorVersion(), resultSet.getString("NAME"), resultSet.getInt("MAJOR_VERSION"), resultSet.getInt("MINOR_VERSION")));
                    }
                    arrayList2 = arrayList;
                    Object var9_10 = null;
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return arrayList2;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ByteArrayOutputStream select(IlrRulesetPathElement ilrRulesetPathElement, int n) throws IlrDataSourceException {
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block50: {
                ByteArrayOutputStream byteArrayOutputStream2;
                block49: {
                    ByteArrayOutputStream byteArrayOutputStream3;
                    block48: {
                        ByteArrayOutputStream byteArrayOutputStream4;
                        block47: {
                            ByteArrayOutputStream byteArrayOutputStream5;
                            block45: {
                                block46: {
                                    connection = null;
                                    statement = null;
                                    resultSet = null;
                                    try {
                                        int n2;
                                        String string;
                                        String string2;
                                        connection = this.getConnection();
                                        if (ilrRulesetPathElement.isRuleApp()) {
                                            switch (n) {
                                                case 6: {
                                                    string2 = "select CREATION_DATE from RULEAPPS where ID = ?";
                                                    string = "creation_date";
                                                    break;
                                                }
                                                case 4: {
                                                    string2 = "select DESCRIPTION from RULEAPPS where ID = ?";
                                                    string = "description";
                                                    break;
                                                }
                                                case 5: {
                                                    string2 = "select DISPLAY_NAME from RULEAPPS where ID = ?";
                                                    string = "display_name";
                                                    break;
                                                }
                                                case 3: {
                                                    string2 = "select NAME, VALUE from RULEAPP_PROPERTIES where RULEAPP_ID = ? and IS_AVAILABLE = 1";
                                                    string = "properties";
                                                    break;
                                                }
                                                default: {
                                                    byteArrayOutputStream5 = null;
                                                    Object var13_14 = null;
                                                    if (resultSet == null) break block45;
                                                    break block46;
                                                }
                                            }
                                            n2 = this.getId(ilrRulesetPathElement, connection);
                                        } else {
                                            switch (n) {
                                                case 6: {
                                                    string2 = "select CREATION_DATE from RULESETS where ID = ?";
                                                    string = "creation_date";
                                                    break;
                                                }
                                                case 4: {
                                                    string2 = "select DESCRIPTION from RULESETS where ID = ?";
                                                    string = "description";
                                                    break;
                                                }
                                                case 5: {
                                                    string2 = "select DISPLAY_NAME from RULESETS where ID = ?";
                                                    string = "display_name";
                                                    break;
                                                }
                                                case 3: {
                                                    string2 = "select NAME, VALUE from RULESET_PROPERTIES where RULESET_ID = ? and IS_AVAILABLE = 1";
                                                    string = "properties";
                                                    break;
                                                }
                                                default: {
                                                    byteArrayOutputStream4 = null;
                                                    break block47;
                                                }
                                            }
                                            n2 = this.getId(ilrRulesetPathElement, connection);
                                        }
                                        statement = connection.prepareStatement(string2);
                                        statement.setInt(1, n2);
                                        resultSet = statement.executeQuery();
                                        if (3 == n) {
                                            Properties properties = new Properties();
                                            while (resultSet.next()) {
                                                properties.put(resultSet.getString("NAME"), resultSet.getString("VALUE"));
                                            }
                                            ByteArrayOutputStream byteArrayOutputStream6 = new ByteArrayOutputStream();
                                            properties.store(byteArrayOutputStream6, null);
                                            byteArrayOutputStream3 = byteArrayOutputStream6;
                                            break block48;
                                        }
                                        if (!resultSet.next()) {
                                            throw new IlrDataSourceException("1012", new Object[]{ilrRulesetPathElement.toString(), string});
                                        }
                                        String string3 = null;
                                        switch (n) {
                                            case 6: {
                                                string3 = resultSet.getString("CREATION_DATE");
                                                break;
                                            }
                                            case 4: {
                                                string3 = resultSet.getString("DESCRIPTION");
                                                break;
                                            }
                                            case 5: {
                                                string3 = resultSet.getString("DISPLAY_NAME");
                                                break;
                                            }
                                        }
                                        if (string3 != null) {
                                            ByteArrayOutputStream byteArrayOutputStream7 = new ByteArrayOutputStream();
                                            byteArrayOutputStream7.write(string3.getBytes(this.defaultEncoding));
                                            byteArrayOutputStream2 = byteArrayOutputStream7;
                                            break block49;
                                        }
                                        byteArrayOutputStream = null;
                                        break block50;
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_19 = null;
                                        if (resultSet != null) {
                                            resultSet.close();
                                        }
                                        if (statement != null) {
                                            statement.close();
                                        }
                                        if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                                            connection.close();
                                        }
                                        throw throwable;
                                    }
                                }
                                resultSet.close();
                            }
                            if (statement != null) {
                                statement.close();
                            }
                            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                            return byteArrayOutputStream5;
                        }
                        Object var13_15 = null;
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                            connection.close();
                        }
                        return byteArrayOutputStream4;
                    }
                    Object var13_16 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    return byteArrayOutputStream3;
                }
                Object var13_17 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                    connection.close();
                }
                return byteArrayOutputStream2;
            }
            Object var13_18 = null;
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return byteArrayOutputStream;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new IlrDataSourceException("1002", new Object[]{iOException.getMessage()}, (Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String selectAsString(IlrRulesetPathElement ilrRulesetPathElement, int n) throws IlrDataSourceException {
        try {
            String string;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block48: {
                String string2;
                block47: {
                    String string3;
                    block46: {
                        String string4;
                        block45: {
                            String string5;
                            block44: {
                                String string6;
                                block42: {
                                    block43: {
                                        connection = null;
                                        statement = null;
                                        resultSet = null;
                                        try {
                                            int n2;
                                            String string7;
                                            String string8;
                                            connection = this.getConnection();
                                            if (ilrRulesetPathElement.isRuleApp()) {
                                                switch (n) {
                                                    case 6: {
                                                        string8 = "select CREATION_DATE from RULEAPPS where ID = ?";
                                                        string7 = "creation_date";
                                                        break;
                                                    }
                                                    case 4: {
                                                        string8 = "select DESCRIPTION from RULEAPPS where ID = ?";
                                                        string7 = "description";
                                                        break;
                                                    }
                                                    case 5: {
                                                        string8 = "select DISPLAY_NAME from RULEAPPS where ID = ?";
                                                        string7 = "display_name";
                                                        break;
                                                    }
                                                    default: {
                                                        string6 = null;
                                                        Object var11_15 = null;
                                                        if (resultSet == null) break block42;
                                                        break block43;
                                                    }
                                                }
                                                n2 = this.getId(ilrRulesetPathElement, connection);
                                            } else {
                                                switch (n) {
                                                    case 6: {
                                                        string8 = "select CREATION_DATE from RULESETS where ID = ?";
                                                        string7 = "creation_date";
                                                        break;
                                                    }
                                                    case 4: {
                                                        string8 = "select DESCRIPTION from RULESETS where ID = ?";
                                                        string7 = "description";
                                                        break;
                                                    }
                                                    case 5: {
                                                        string8 = "select DISPLAY_NAME from RULESETS where ID = ?";
                                                        string7 = "display_name";
                                                        break;
                                                    }
                                                    default: {
                                                        string5 = null;
                                                        break block44;
                                                    }
                                                }
                                                n2 = this.getId(ilrRulesetPathElement, connection);
                                            }
                                            statement = connection.prepareStatement(string8);
                                            statement.setInt(1, n2);
                                            resultSet = statement.executeQuery();
                                            if (!resultSet.next()) {
                                                throw new IlrDataSourceException("1012", new Object[]{ilrRulesetPathElement.toString(), string7});
                                            }
                                            switch (n) {
                                                case 6: {
                                                    string4 = resultSet.getString("CREATION_DATE");
                                                    break block45;
                                                }
                                                case 4: {
                                                    string3 = resultSet.getString("DESCRIPTION");
                                                    break block46;
                                                }
                                                case 5: {
                                                    string2 = resultSet.getString("DISPLAY_NAME");
                                                    break block47;
                                                }
                                                default: {
                                                    string = null;
                                                    break;
                                                }
                                            }
                                            break block48;
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_21 = null;
                                            if (resultSet != null) {
                                                resultSet.close();
                                            }
                                            if (statement != null) {
                                                statement.close();
                                            }
                                            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                                                connection.close();
                                            }
                                            throw throwable;
                                        }
                                    }
                                    resultSet.close();
                                }
                                if (statement != null) {
                                    statement.close();
                                }
                                if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                                    connection.close();
                                }
                                return string6;
                            }
                            Object var11_16 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (statement != null) {
                                statement.close();
                            }
                            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                            return string5;
                        }
                        Object var11_17 = null;
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                            connection.close();
                        }
                        return string4;
                    }
                    Object var11_18 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    return string3;
                }
                Object var11_19 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                    connection.close();
                }
                return string2;
            }
            Object var11_20 = null;
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return string;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Properties selectAsProperties(IlrRulesetPathElement ilrRulesetPathElement) throws IlrDataGetterException {
        try {
            Properties properties;
            Statement statement;
            Connection connection;
            block10: {
                connection = null;
                statement = null;
                ResultSet resultSet = null;
                try {
                    connection = this.getConnection();
                    String string = ilrRulesetPathElement.isRuleApp() ? "select NAME, VALUE from RULEAPP_PROPERTIES where RULEAPP_ID = ? and IS_AVAILABLE = 1" : "select NAME, VALUE from RULESET_PROPERTIES where RULESET_ID = ? and IS_AVAILABLE = 1";
                    statement = connection.prepareStatement(string);
                    statement.setInt(1, this.getId(ilrRulesetPathElement, connection));
                    resultSet = statement.executeQuery();
                    Properties properties2 = new Properties();
                    while (resultSet.next()) {
                        properties2.put(resultSet.getString("NAME"), resultSet.getString("VALUE"));
                    }
                    properties = properties2;
                    Object var9_9 = null;
                    if (resultSet == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return properties;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(IlrRulesetPathElement ilrRulesetPathElement, int n) throws IlrDataSourceException {
        try {
            Connection connection = null;
            try {
                connection = this.getConnection();
                this.delete(ilrRulesetPathElement, connection, n);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                    connection.close();
                }
                throw throwable;
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(IlrRulesetPathElement ilrRulesetPathElement, int n, int n2) throws IlrDataSourceException {
        try {
            Connection connection = null;
            try {
                connection = this.getConnection();
                if (n == 3) {
                    this.setAllPropertiesUnAvailable(ilrRulesetPathElement, connection, n2);
                }
                if (n == 7 && !ilrRulesetPathElement.isRuleApp()) {
                    int n3 = this.getId(ilrRulesetPathElement, connection);
                    this.deleteRulesetResources(n3, connection);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                    connection.close();
                }
                throw throwable;
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyUnAvailable(IlrRulesetPathElement ilrRulesetPathElement, String string, int n) throws IlrDataSourceException {
        try {
            Connection connection = null;
            try {
                connection = this.getConnection();
                this.setPropertyUnAvailable(ilrRulesetPathElement, string, connection, n);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                    connection.close();
                }
                throw throwable;
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    public synchronized boolean isResourceAvailable(IlrRulesetPathElement ilrRulesetPathElement, int n) {
        try {
            this.select(ilrRulesetPathElement, n);
            return true;
        }
        catch (IlrDataSourceException ilrDataSourceException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getLatestRaVersionAndLatestRsVersion(String string, String string2) throws IlrDataSourceException {
        try {
            String string3;
            PreparedStatement preparedStatement;
            Connection connection;
            block10: {
                connection = null;
                ResultSet resultSet = null;
                preparedStatement = null;
                try {
                    connection = this.getConnection();
                    preparedStatement = connection.prepareStatement("select RA_NAME, RA_MAJVERS, RA_MINVERS, RS_NAME, RS_MAJVERS, RS_MINVERS from RS_ENABLED_VIEW where RA_NAME = ? and RS_NAME = ? order by RA_MAJVERS desc, RA_MINVERS desc, RS_MAJVERS desc, RS_MINVERS desc");
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new IlrDataSourceException("1011", new Object[]{"{" + string + "," + string2 + "}"});
                    }
                    string3 = resultSet.getString("RA_NAME") + "/" + resultSet.getInt("RA_MAJVERS") + "." + resultSet.getInt("RA_MINVERS") + "/" + resultSet.getString("RS_NAME") + "/" + resultSet.getInt("RS_MAJVERS") + "." + resultSet.getInt("RS_MINVERS");
                    Object var8_8 = null;
                    if (resultSet == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return string3;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getLatestRaAndGivenRsVersion(String string, String string2, int n, int n2) throws IlrDataSourceException {
        try {
            String string3;
            PreparedStatement preparedStatement;
            Connection connection;
            block10: {
                connection = null;
                ResultSet resultSet = null;
                preparedStatement = null;
                try {
                    connection = this.getConnection();
                    preparedStatement = connection.prepareStatement("select RA_NAME, RA_MAJVERS, RA_MINVERS, RS_NAME, RS_MAJVERS, RS_MINVERS from RS_ENABLED_VIEW where RA_NAME = ? and RS_NAME = ? and RS_MAJVERS = ? and RS_MINVERS = ? order by RA_MAJVERS desc, RA_MINVERS desc, RS_MAJVERS desc, RS_MINVERS desc");
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    preparedStatement.setInt(3, n);
                    preparedStatement.setInt(4, n2);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new IlrDataSourceException("1011", new Object[]{"{" + string + ", " + string2 + ", " + n + ", " + n2 + "}"});
                    }
                    string3 = resultSet.getString("RA_NAME") + "/" + resultSet.getInt("RA_MAJVERS") + "." + resultSet.getInt("RA_MINVERS") + "/" + resultSet.getString("RS_NAME") + "/" + resultSet.getInt("RS_MAJVERS") + "." + resultSet.getInt("RS_MINVERS");
                    Object var10_10 = null;
                    if (resultSet == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return string3;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getGivenRaVersionAndLatestRsVersion(String string, int n, int n2, String string2) throws IlrDataSourceException {
        try {
            String string3;
            PreparedStatement preparedStatement;
            Connection connection;
            block10: {
                connection = null;
                ResultSet resultSet = null;
                preparedStatement = null;
                try {
                    connection = this.getConnection();
                    preparedStatement = connection.prepareStatement("select RA_NAME, RA_MAJVERS, RA_MINVERS, RS_NAME, RS_MAJVERS, RS_MINVERS from RS_ENABLED_VIEW where RA_NAME = ? and RA_MAJVERS = ? and RA_MINVERS = ? and RS_NAME = ? order by RA_MAJVERS desc, RA_MINVERS desc, RS_MAJVERS desc, RS_MINVERS desc");
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                    preparedStatement.setInt(3, n2);
                    preparedStatement.setString(4, string2);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new IlrDataSourceException("1011", new Object[]{"{" + string + ", " + n + ", " + n2 + ", " + string2 + "}"});
                    }
                    string3 = resultSet.getString("RA_NAME") + "/" + resultSet.getInt("RA_MAJVERS") + "." + resultSet.getInt("RA_MINVERS") + "/" + resultSet.getString("RS_NAME") + "/" + resultSet.getInt("RS_MAJVERS") + "." + resultSet.getInt("RS_MINVERS");
                    Object var10_10 = null;
                    if (resultSet == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return string3;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getGivenRaVersionAndGivenRsVersion(String string, int n, int n2, String string2, int n3, int n4) throws IlrDataSourceException {
        try {
            String string3;
            PreparedStatement preparedStatement;
            Connection connection;
            block10: {
                connection = null;
                ResultSet resultSet = null;
                preparedStatement = null;
                try {
                    connection = this.getConnection();
                    preparedStatement = connection.prepareStatement("select RA_NAME, RA_MAJVERS, RA_MINVERS, RS_NAME, RS_MAJVERS, RS_MINVERS from RS_ENABLED_VIEW where RA_NAME = ? and RA_MAJVERS = ? and RA_MINVERS = ? and RS_NAME = ? and RS_MAJVERS = ? and RS_MINVERS = ? order by RA_MAJVERS desc, RA_MINVERS desc, RS_MAJVERS desc, RS_MINVERS desc");
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                    preparedStatement.setInt(3, n2);
                    preparedStatement.setString(4, string2);
                    preparedStatement.setInt(5, n3);
                    preparedStatement.setInt(6, n4);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new IlrDataSourceException("1011", new Object[]{"{" + string + ", " + n + ", " + n2 + ", " + string2 + ", " + n3 + ", " + n4 + "}"});
                    }
                    string3 = resultSet.getString("RA_NAME") + "/" + resultSet.getInt("RA_MAJVERS") + "." + resultSet.getInt("RA_MINVERS") + "/" + resultSet.getString("RS_NAME") + "/" + resultSet.getInt("RS_MAJVERS") + "." + resultSet.getInt("RS_MINVERS");
                    Object var12_12 = null;
                    if (resultSet == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (!this.isKeepConnected() && connection != null && !connection.isClosed()) {
                connection.close();
            }
            return string3;
        }
        catch (SQLException sQLException) {
            throw new IlrDataSourceException("1301", new Object[]{sQLException.getSQLState(), sQLException.getMessage()}, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRuleApp(IlrRulesetPathElement ilrRulesetPathElement, String string, Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("insert into RULEAPPS (NAME, MAJOR_VERSION, MINOR_VERSION, CREATION_DATE, DESCRIPTION, DISPLAY_NAME) values ( ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, ilrRulesetPathElement.getRuleAppName());
            preparedStatement.setInt(2, ilrRulesetPathElement.getRuleAppMajorVersion());
            preparedStatement.setInt(3, ilrRulesetPathElement.getRuleAppMinorVersion());
            Long l = new Long(string);
            preparedStatement.setLong(4, l);
            preparedStatement.setString(5, null);
            preparedStatement.setString(6, null);
            int n2 = preparedStatement.executeUpdate();
            if (n2 == 1 && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRuleApp(IlrRulesetPathElement ilrRulesetPathElement, Map map, Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("insert into RULEAPPS (NAME, MAJOR_VERSION, MINOR_VERSION, CREATION_DATE, DESCRIPTION, DISPLAY_NAME) values ( ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, ilrRulesetPathElement.getRuleAppName());
            preparedStatement.setInt(2, ilrRulesetPathElement.getRuleAppMajorVersion());
            preparedStatement.setInt(3, ilrRulesetPathElement.getRuleAppMinorVersion());
            Long l = new Long((String)map.get("creation_date"));
            preparedStatement.setLong(4, l);
            preparedStatement.setString(5, (String)map.get("description"));
            preparedStatement.setString(6, (String)map.get("display_name"));
            int n2 = preparedStatement.executeUpdate();
            if (n2 == 1 && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRuleset(IlrRulesetPathElement ilrRulesetPathElement, String string, Connection connection, int n) throws SQLException {
        Statement statement = null;
        try {
            int n2 = this.getId(new IlrRulesetPathElementImpl(ilrRulesetPathElement.getRuleAppName(), ilrRulesetPathElement.getRuleAppMajorVersion(), ilrRulesetPathElement.getRuleAppMinorVersion()), connection);
            statement = connection.prepareStatement("insert into RULESETS (NAME, MAJOR_VERSION, MINOR_VERSION, CREATION_DATE, DESCRIPTION, DISPLAY_NAME, RULEAPP_ID) values (?, ?, ?, ?, ?, ?, ?)");
            statement.setString(1, ilrRulesetPathElement.getRulesetName());
            statement.setInt(2, ilrRulesetPathElement.getRulesetMajorVersion());
            statement.setInt(3, ilrRulesetPathElement.getRulesetMinorVersion());
            Long l = new Long(string);
            statement.setLong(4, l);
            statement.setString(5, null);
            statement.setString(6, null);
            statement.setInt(7, n2);
            int n3 = statement.executeUpdate();
            if (n3 == 1 && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRuleset(IlrRulesetPathElement ilrRulesetPathElement, Map map, Connection connection, int n) throws SQLException {
        Statement statement = null;
        try {
            int n2 = this.getId(new IlrRulesetPathElementImpl(ilrRulesetPathElement.getRuleAppName(), ilrRulesetPathElement.getRuleAppMajorVersion(), ilrRulesetPathElement.getRuleAppMinorVersion()), connection);
            statement = connection.prepareStatement("insert into RULESETS (NAME, MAJOR_VERSION, MINOR_VERSION, CREATION_DATE, DESCRIPTION, DISPLAY_NAME, RULEAPP_ID) values (?, ?, ?, ?, ?, ?, ?)");
            statement.setString(1, ilrRulesetPathElement.getRulesetName());
            statement.setInt(2, ilrRulesetPathElement.getRulesetMajorVersion());
            statement.setInt(3, ilrRulesetPathElement.getRulesetMinorVersion());
            Long l = new Long((String)map.get("creation_date"));
            statement.setLong(4, l);
            statement.setString(5, (String)map.get("description"));
            statement.setString(6, (String)map.get("display_name"));
            statement.setInt(7, n2);
            int n3 = statement.executeUpdate();
            if (n3 == 1 && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertRulesetProperties(IlrRulesetPathElement ilrRulesetPathElement, Properties properties, Connection connection, int n) throws SQLException {
        Statement statement = null;
        Properties properties2 = null;
        boolean bl = true;
        try {
            if (ilrRulesetPathElement.isRuleApp()) {
                int n2;
                String string;
                int n3;
                int n4 = this.getId(ilrRulesetPathElement, connection);
                statement = connection.prepareStatement("update RULEAPP_PROPERTIES set VALUE = ?, IS_AVAILABLE = 1 where RULEAPP_ID = ? and NAME = ?");
                Object[] objectArray = properties.keySet().toArray();
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    string = (String)objectArray[n3];
                    statement.setString(1, properties.getProperty(string));
                    statement.setInt(2, n4);
                    statement.setString(3, string);
                    n2 = statement.executeUpdate();
                    if (n2 == 1) continue;
                    if (properties2 == null) {
                        properties2 = new Properties();
                    }
                    properties2.put(string, properties.getProperty(string));
                }
                if (properties2 != null && properties2.size() != 0) {
                    objectArray = properties2.keySet().toArray();
                    if (statement != null) {
                        statement.close();
                    }
                    statement = connection.prepareStatement("insert into RULEAPP_PROPERTIES (RULEAPP_ID, NAME, VALUE) values (?, ?, ?)");
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        statement.setInt(1, n4);
                        string = (String)objectArray[n3];
                        statement.setString(2, string);
                        statement.setString(3, properties.getProperty(string));
                        n2 = statement.executeUpdate();
                        if (n2 == 1) continue;
                        bl = false;
                    }
                }
            } else {
                int n5;
                String string;
                int n6;
                int n7 = this.getId(ilrRulesetPathElement, connection);
                statement = connection.prepareStatement("update RULESET_PROPERTIES set VALUE = ?, IS_AVAILABLE = 1 where RULESET_ID = ? and NAME = ?");
                Object[] objectArray = properties.keySet().toArray();
                for (n6 = 0; n6 < objectArray.length; ++n6) {
                    string = (String)objectArray[n6];
                    statement.setString(1, properties.getProperty(string));
                    statement.setInt(2, n7);
                    statement.setString(3, string);
                    n5 = statement.executeUpdate();
                    if (n5 == 1) continue;
                    if (properties2 == null) {
                        properties2 = new Properties();
                    }
                    properties2.put(string, properties.getProperty(string));
                }
                if (properties2 != null && properties2.size() != 0) {
                    objectArray = properties2.keySet().toArray();
                    if (statement != null) {
                        statement.close();
                    }
                    statement = connection.prepareStatement("insert into RULESET_PROPERTIES (RULESET_ID, NAME, VALUE) values (?, ?, ?)");
                    for (n6 = 0; n6 < objectArray.length; ++n6) {
                        statement.setInt(1, n7);
                        string = (String)objectArray[n6];
                        statement.setString(2, string);
                        statement.setString(3, properties.getProperty(string));
                        n5 = statement.executeUpdate();
                        if (n5 == 1) continue;
                        bl = false;
                    }
                }
            }
            if (bl && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRuleApp(IlrRulesetPathElement ilrRulesetPathElement, int n, String string, Connection connection, int n2) throws SQLException {
        Statement statement = null;
        try {
            String string2;
            int n3 = this.getId(ilrRulesetPathElement, connection);
            switch (n) {
                case 4: {
                    string2 = "update RULEAPPS set DESCRIPTION = ? where ID = ?";
                    break;
                }
                case 5: {
                    string2 = "update RULEAPPS set DISPLAY_NAME = ? where ID = ?";
                    break;
                }
                default: {
                    return;
                }
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            statement.setInt(2, n3);
            int n4 = statement.executeUpdate();
            if (n4 == 1 && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRuleset(IlrRulesetPathElement ilrRulesetPathElement, int n, String string, Connection connection, int n2) throws SQLException {
        Statement statement = null;
        try {
            int n3 = this.getId(ilrRulesetPathElement, connection);
            switch (n) {
                case 4: {
                    statement = connection.prepareStatement("update RULESETS set DESCRIPTION = ? where ID = ?");
                    break;
                }
                case 5: {
                    statement = connection.prepareStatement("update RULESETS set DISPLAY_NAME = ? where ID = ?");
                    break;
                }
                default: {
                    return;
                }
            }
            statement.setString(1, string);
            statement.setInt(2, n3);
            int n4 = statement.executeUpdate();
            if (n4 == 1 && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(IlrRulesetPathElement ilrRulesetPathElement, Connection connection, int n) throws SQLException {
        Statement statement = null;
        try {
            int n2;
            if (ilrRulesetPathElement.isRuleApp()) {
                n2 = this.getId(ilrRulesetPathElement, connection);
                this.deleteLinkedResources(n2, true, connection);
                statement = connection.prepareStatement("delete from RULEAPPS where ID = ?");
            } else {
                n2 = this.getId(ilrRulesetPathElement, connection);
                this.deleteLinkedResources(n2, false, connection);
                statement = connection.prepareStatement("delete from RULESETS where ID = ?");
            }
            statement.setInt(1, n2);
            int n3 = statement.executeUpdate();
            if (n3 == 1 && !connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    protected void deleteLinkedResources(int n, boolean bl, Connection connection) throws SQLException {
        if (bl) {
            this.deleteRuleappProperties(n, connection);
            ArrayList arrayList = this.select_all_rulesets_id(n, connection);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                this.deleteLinkedResources(n2, false, connection);
                PreparedStatement preparedStatement = connection.prepareStatement("delete from RULESETS where ID = ?");
                preparedStatement.setInt(1, n2);
                preparedStatement.executeUpdate();
                if (connection.getAutoCommit()) continue;
                connection.commit();
            }
        } else {
            this.deleteRulesetResources(n, connection);
            this.deleteRulesetProperties(n, connection);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRulesetResources(int n, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("delete from RULESET_RESOURCES where RULESET_ID = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRulesetProperties(int n, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("delete from RULESET_PROPERTIES where RULESET_ID = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRuleappProperties(int n, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("delete from RULEAPP_PROPERTIES where RULEAPP_ID = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAllPropertiesUnAvailable(IlrRulesetPathElement ilrRulesetPathElement, Connection connection, int n) throws SQLException {
        Statement statement = null;
        try {
            int n2 = this.getId(ilrRulesetPathElement, connection);
            statement = connection.prepareStatement("update RULESET_PROPERTIES set IS_AVAILABLE = 0 where RULESET_ID = ?");
            statement.setInt(1, n2);
            statement.executeUpdate();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertyUnAvailable(IlrRulesetPathElement ilrRulesetPathElement, String string, Connection connection, int n) throws SQLException {
        Statement statement = null;
        try {
            if (ilrRulesetPathElement.isRuleApp()) {
                int n2 = this.getId(ilrRulesetPathElement, connection);
                statement = connection.prepareStatement("update RULEAPP_PROPERTIES set IS_AVAILABLE = 0 where RULEAPP_ID = ? and NAME = ?");
                statement.setInt(1, n2);
                statement.setString(2, string);
            } else {
                int n3 = this.getId(ilrRulesetPathElement, connection);
                statement = connection.prepareStatement("update RULESET_PROPERTIES set IS_AVAILABLE = 0 where RULESET_ID = ? and NAME = ?");
                statement.setInt(1, n3);
                statement.setString(2, string);
            }
            statement.executeUpdate();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    protected int getId(IlrRulesetPathElement ilrRulesetPathElement, Connection connection) throws SQLException {
        return this.getIdFromDatabase(ilrRulesetPathElement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIdFromDatabase(IlrRulesetPathElement ilrRulesetPathElement, Connection connection) throws SQLException {
        int n;
        Statement statement;
        block11: {
            ResultSet resultSet;
            block9: {
                int n2;
                block10: {
                    statement = null;
                    resultSet = null;
                    try {
                        int n3;
                        int n4;
                        String string;
                        int n5 = -1;
                        if (ilrRulesetPathElement.isRuleApp()) {
                            string = ilrRulesetPathElement.getRuleAppName();
                            n4 = ilrRulesetPathElement.getRuleAppMajorVersion();
                            n3 = ilrRulesetPathElement.getRuleAppMinorVersion();
                            statement = connection.prepareStatement("select ID from RULEAPPS where NAME = ? and MAJOR_VERSION = ? and MINOR_VERSION = ?");
                        } else {
                            string = ilrRulesetPathElement.getRulesetName();
                            n4 = ilrRulesetPathElement.getRulesetMajorVersion();
                            n3 = ilrRulesetPathElement.getRulesetMinorVersion();
                            n5 = this.getId(new IlrRulesetPathElementImpl(ilrRulesetPathElement.getRuleAppName(), ilrRulesetPathElement.getRuleAppMajorVersion(), ilrRulesetPathElement.getRuleAppMinorVersion()), connection);
                            statement = connection.prepareStatement("select ID from RULESETS where NAME = ? and MAJOR_VERSION = ? and MINOR_VERSION = ? and RULEAPP_ID = ?");
                        }
                        statement.setString(1, string);
                        statement.setInt(2, n4);
                        statement.setInt(3, n3);
                        if (!ilrRulesetPathElement.isRuleApp()) {
                            statement.setInt(4, n5);
                        }
                        if (!(resultSet = statement.executeQuery()).next()) break block9;
                        n2 = resultSet.getInt("ID");
                        Object var11_11 = null;
                        if (resultSet == null) break block10;
                    }
                    catch (Throwable throwable) {
                        block12: {
                            Object var11_13 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (statement == null) break block12;
                            statement.close();
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                return n2;
            }
            n = -1;
            Object var11_12 = null;
            if (resultSet == null) break block11;
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList select_all_rulesets_id(int n, Connection connection) throws SQLException {
        ArrayList<Integer> arrayList;
        PreparedStatement preparedStatement;
        block5: {
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement("select ID from RULESETS where RULEAPP_ID = ?");
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                while (resultSet.next()) {
                    arrayList2.add(new Integer(resultSet.getInt("ID")));
                }
                arrayList = arrayList2;
                Object var8_7 = null;
                if (resultSet == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement == null) break block6;
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        return arrayList;
    }

    protected String[] splitString(String string, int n) {
        String[] stringArray;
        block4: {
            stringArray = null;
            if (string.length() <= n) break block4;
            int n2 = string.length() / n;
            int n3 = string.length() % n;
            if (n3 != 0) {
                stringArray = new String[n2 + 1];
                int n4 = 0;
                int n5 = 0;
                while (n4 <= n2) {
                    stringArray[n4] = n4 == n2 ? string.substring(n5, string.length()) : string.substring(n5, n5 + n);
                    ++n4;
                    n5 += n;
                }
            } else {
                stringArray = new String[n2];
                int n6 = 0;
                int n7 = 0;
                while (n6 < n2) {
                    stringArray[n6] = string.substring(n7, n7 + n);
                    ++n6;
                    n7 += n;
                }
            }
        }
        return stringArray;
    }
}

