/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.persistence.jdbc;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.model.IlrAlreadyExistException;
import ilog.rules.bres.model.IlrFormatException;
import ilog.rules.bres.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.bres.model.IlrMutableRuleAppInformation;
import ilog.rules.bres.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.impl.IlrVersionImpl;
import ilog.rules.bres.persistence.IlrAbstractTransactionalResourceProvider;
import ilog.rules.bres.persistence.IlrDataProvider;
import ilog.rules.bres.persistence.IlrDataProviderException;
import ilog.rules.bres.persistence.IlrResourceProvider;
import ilog.rules.bres.persistence.IlrResourceProviderException;
import ilog.rules.bres.persistence.IlrRulesetPathElement;
import ilog.rules.bres.persistence.IlrRulesetPathElementImpl;
import ilog.rules.bres.persistence.jdbc.IlrDbDataProvider;
import ilog.rules.bres.persistence.jdbc.IlrDbDataSource;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class IlrDbResourceProvider
extends IlrAbstractTransactionalResourceProvider {
    protected IlrDbDataProvider dbDataProvider = null;
    private IlrDbDiagnosticResultImpl dbDiagRes = new IlrDbDiagnosticResultImpl();

    public IlrDbResourceProvider() {
        this.dbDataProvider = new IlrDbDataProvider();
    }

    public IlrDbResourceProvider(String string) throws IlrResourceProviderException {
        this.dbDataProvider = new IlrDbDataProvider(string);
    }

    public IlrDbResourceProvider(IlrDbDataSource ilrDbDataSource) throws IlrResourceProviderException {
        this.dbDataProvider = new IlrDbDataProvider(ilrDbDataSource);
    }

    public IlrDbResourceProvider(ClassLoader classLoader, String string, String string2, String string3, String string4) throws IlrResourceProviderException {
        Properties properties = new Properties();
        if (string3 != null) {
            properties.put("user", string3);
        } else {
            properties.put("user", "");
        }
        if (string4 != null) {
            properties.put("password", string4);
        } else {
            properties.put("password", "");
        }
        this.dbDataProvider = new IlrDbDataProvider(classLoader, string, string2, properties);
    }

    public IlrDataProvider getDataProvider() {
        return this.dbDataProvider;
    }

    public int startTransaction() throws IlrResourceProviderException {
        if (this.dbDataProvider != null) {
            return this.dbDataProvider.startTransaction();
        }
        return 0;
    }

    public void endTransaction(int n) throws IlrResourceProviderException {
        if (this.dbDataProvider != null) {
            this.dbDataProvider.endTransaction(n);
        }
    }

    public Set load(IlrRepositoryFactory ilrRepositoryFactory) throws IlrResourceProviderException {
        HashSet<IlrMutableRuleAppInformation> hashSet = new HashSet<IlrMutableRuleAppInformation>();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = (ArrayList)this.dbDataProvider.retrieveEntities(null);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                IlrRulesetPathElement ilrRulesetPathElement = (IlrRulesetPathElement)iterator.next();
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(ilrRulesetPathElement.getRuleAppMajorVersion());
                stringBuffer.append(".");
                stringBuffer.append(ilrRulesetPathElement.getRuleAppMinorVersion());
                IlrVersionImpl ilrVersionImpl = (IlrVersionImpl)ilrRepositoryFactory.getVersionParser().parse(stringBuffer.toString());
                ByteArrayOutputStream byteArrayOutputStream = this.dbDataProvider.retrieveResource(ilrRulesetPathElement, 6);
                IlrMutableRuleAppInformation ilrMutableRuleAppInformation = ilrRepositoryFactory.createRuleApp(ilrRulesetPathElement.getRuleAppName(), ilrVersionImpl, new Date(Long.parseLong(byteArrayOutputStream.toString(this.encoding))));
                byteArrayOutputStream = this.dbDataProvider.retrieveResource(ilrRulesetPathElement, 4);
                if (byteArrayOutputStream != null) {
                    ilrMutableRuleAppInformation.setDescription(byteArrayOutputStream.toString(this.encoding));
                }
                if ((byteArrayOutputStream = this.dbDataProvider.retrieveResource(ilrRulesetPathElement, 5)) != null) {
                    ilrMutableRuleAppInformation.setDisplayName(byteArrayOutputStream.toString(this.encoding));
                }
                ArrayList arrayList2 = (ArrayList)this.dbDataProvider.retrieveEntities(ilrRulesetPathElement);
                Iterator iterator2 = arrayList2.iterator();
                while (iterator2.hasNext()) {
                    IlrRulesetPathElementImpl ilrRulesetPathElementImpl = (IlrRulesetPathElementImpl)iterator2.next();
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(ilrRulesetPathElementImpl.getRulesetMajorVersion());
                    stringBuffer.append(".");
                    stringBuffer.append(ilrRulesetPathElementImpl.getRulesetMinorVersion());
                    ilrVersionImpl = (IlrVersionImpl)ilrRepositoryFactory.getVersionParser().parse(stringBuffer.toString());
                    byteArrayOutputStream = this.dbDataProvider.retrieveResource(ilrRulesetPathElementImpl, 6);
                    IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation = ilrRepositoryFactory.createRuleset(ilrRulesetPathElementImpl.getRulesetName(), ilrVersionImpl, new Date(Long.parseLong(byteArrayOutputStream.toString(this.encoding))));
                    byteArrayOutputStream = this.dbDataProvider.retrieveResource(ilrRulesetPathElementImpl, 4);
                    if (byteArrayOutputStream != null) {
                        ilrMutableRulesetArchiveInformation.setDescription(byteArrayOutputStream.toString(this.encoding));
                    }
                    if ((byteArrayOutputStream = this.dbDataProvider.retrieveResource(ilrRulesetPathElementImpl, 5)) != null) {
                        ilrMutableRulesetArchiveInformation.setDisplayName(byteArrayOutputStream.toString(this.encoding));
                    }
                    ilrMutableRuleAppInformation.addRuleset(ilrMutableRulesetArchiveInformation);
                }
                hashSet.add(ilrMutableRuleAppInformation);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", unsupportedEncodingException);
            }
            catch (IlrFormatException ilrFormatException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrFormatException);
            }
            catch (IlrAlreadyExistException ilrAlreadyExistException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrAlreadyExistException);
            }
            catch (IlrIllegalArgumentRuntimeException ilrIllegalArgumentRuntimeException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrIllegalArgumentRuntimeException);
            }
        }
        return hashSet;
    }

    public void addRuleApp(IlrRuleAppInformation ilrRuleAppInformation, int n) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrRuleAppInformation);
        this.dbDataProvider.saveResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, 6, String.valueOf(ilrRuleAppInformation.getCreationDate().getTime()), n);
        this.updateRuleApp(ilrRuleAppInformation, n);
        Set set = ilrRuleAppInformation.getRulesets();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IlrRulesetArchiveInformation ilrRulesetArchiveInformation = (IlrRulesetArchiveInformation)iterator.next();
            try {
                IlrRulesetPathElementImpl ilrRulesetPathElementImpl2 = new IlrRulesetPathElementImpl(ilrRulesetArchiveInformation);
                this.addRuleset(ilrRulesetPathElementImpl2.getPath(), ilrRulesetArchiveInformation, n);
            }
            catch (IlrFormatException ilrFormatException) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrFormatException);
            }
        }
    }

    public void updateRuleApp(IlrRuleAppInformation ilrRuleAppInformation, int n) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrRuleAppInformation);
        try {
            IlrPath ilrPath = ilrRulesetPathElementImpl.getPath();
            this.setDisplayName(ilrPath, ilrRuleAppInformation.getDisplayName());
            this.setDescription(ilrPath, ilrRuleAppInformation.getDescription());
            this.setProperties(ilrPath, ilrRuleAppInformation.getProperties().toProperties());
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrFormatException);
        }
    }

    public void removeRuleApp(IlrPath ilrPath, int n) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        this.dbDataProvider.removeResource(ilrRulesetPathElementImpl, n);
    }

    public void addRuleset(IlrPath ilrPath, IlrRulesetArchiveInformation ilrRulesetArchiveInformation, int n) throws IlrResourceProviderException {
        try {
            IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
            IlrRulesetArchive ilrRulesetArchive = ilrRulesetArchiveInformation.getRulesetArchive();
            if (ilrRulesetArchive == null) {
                throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1015", new Object[]{ilrRulesetPathElementImpl.toString()});
            }
            this.dbDataProvider.saveResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, 6, String.valueOf(ilrRulesetArchiveInformation.getCreationDate().getTime()), n);
            this.setProperty(ilrPath, "ruleset.status", "enabled");
            this.setDisplayName(ilrPath, ilrRulesetArchiveInformation.getDisplayName());
            this.setDescription(ilrPath, ilrRulesetArchiveInformation.getDescription());
            this.setProperties(ilrPath, ilrRulesetArchiveInformation.getProperties().toProperties());
            this.setRulesetArchive(ilrPath, ilrRulesetArchive);
        }
        catch (IlrDataProviderException ilrDataProviderException) {
            throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1006", ilrDataProviderException.getCause());
        }
    }

    public void removeRuleset(IlrPath ilrPath, int n) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        this.dbDataProvider.removeResource(ilrRulesetPathElementImpl, n);
    }

    public IlrRulesetArchive getRulesetArchive(IlrPath ilrPath) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        return this.dbDataProvider.retrieveRulesetArchive(ilrRulesetPathElementImpl);
    }

    public void setRulesetArchive(IlrPath ilrPath, IlrRulesetArchive ilrRulesetArchive) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        if (ilrRulesetArchive == null) {
            throw new IlrResourceProviderException("ilog.rules.bres.persistence.messages", "1015", new Object[]{ilrRulesetPathElementImpl.toString()});
        }
        this.dbDataProvider.removeResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, 7, -1);
        this.dbDataProvider.saveResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, ilrRulesetArchive, -1);
    }

    public Properties getProperties(IlrPath ilrPath) throws IlrResourceProviderException {
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        return this.dbDataProvider.retrieveResourceAsProperties(ilrRulesetPathElementImpl);
    }

    public void setProperty(IlrPath ilrPath, String string, String string2) throws IlrResourceProviderException {
        if (string == null) {
            return;
        }
        IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
        if (string2 != null) {
            this.dbDataProvider.saveResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, string, string2, -1);
        } else {
            this.dbDataProvider.removeResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, string, -1);
        }
    }

    public void setProperties(IlrPath ilrPath, Properties properties) throws IlrResourceProviderException {
        if (properties != null) {
            IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
            this.dbDataProvider.saveResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, properties, -1);
        }
    }

    public void setDisplayName(IlrPath ilrPath, String string) throws IlrResourceProviderException {
        if (string != null) {
            IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
            this.dbDataProvider.saveResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, 5, string, -1);
        }
    }

    public void setDescription(IlrPath ilrPath, String string) throws IlrResourceProviderException {
        if (string != null) {
            IlrRulesetPathElementImpl ilrRulesetPathElementImpl = new IlrRulesetPathElementImpl(ilrPath);
            this.dbDataProvider.saveResource((IlrRulesetPathElement)ilrRulesetPathElementImpl, 4, string, -1);
        }
    }

    public String getDetails() {
        IlrDbDataSource ilrDbDataSource = (IlrDbDataSource)this.dbDataProvider.getDataSource();
        if ("DBMS:db2j".equalsIgnoreCase(ilrDbDataSource.getDatabaseName())) {
            return "Cloudscape " + ilrDbDataSource.getDatabaseVersion();
        }
        return ilrDbDataSource.getDatabaseName() + " " + ilrDbDataSource.getDatabaseVersion();
    }

    public IlrResourceProvider.IlrDiagnosticResult executeDiagnostic() {
        this.dbDiagRes.setInfos();
        return this.dbDiagRes;
    }

    public class IlrDbDiagnosticResultImpl
    implements IlrResourceProvider.IlrDiagnosticResult {
        boolean isPassed = false;
        Exception e;
        Properties props = new Properties();
        String dsName = "jdbc/bresdatasource";
        String dbProductNameKey = "Database Product Name";
        String dbProductVersionKey = "Database Product Version";
        String dbDriverNameKey = "Driver Name";
        String dbDriverVersionKey = "Driver Version";
        String dbUrlKey = "JDBC URL";
        String dbUsernameKey = "Username";
        String isTransactionSupportedKey = "Is Transaction Supported";
        String trueValue = "True";
        String falseValue = "False";
        String isTableRuleappsCreatedKey = "Table RULEAPPS created";
        String isTableRulesetsCreatedKey = "Table RULESETS created";
        String isTableRuleappPropertiesCreatedKey = "Table RULEAPP_PROPERTIES created";
        String isTableRulesetPropertiesCreatedKey = "Table RULESET_PROPERTIES created";
        String isTableRulesetResourcesCreatedKey = "Table RULESET_RESOURCES created";
        String isViewRsEnabledCreatedKey = "View RS_ENABLED_VIEW created";
        String viewObjectNotSupported = "Database does not support VIEW object";
        String informationUnknown = "Cannot get information from database";

        public void setPassed(boolean bl) {
            this.isPassed = bl;
        }

        public void setError(Exception exception) {
            this.e = exception;
        }

        public boolean isPassed() {
            return this.isPassed;
        }

        public Exception getError() {
            return this.e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInfos() {
            InitialContext initialContext = null;
            Connection connection = null;
            try {
                try {
                    initialContext = new InitialContext();
                    DataSource dataSource = this.lookupDataSource(initialContext, this.dsName);
                    connection = dataSource.getConnection();
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    this.getConnectionMetadata(databaseMetaData);
                    this.getTable(databaseMetaData, this.isTableRuleappsCreatedKey);
                    this.getTable(databaseMetaData, this.isTableRulesetsCreatedKey);
                    this.getTable(databaseMetaData, this.isTableRuleappPropertiesCreatedKey);
                    this.getTable(databaseMetaData, this.isTableRulesetPropertiesCreatedKey);
                    this.getTable(databaseMetaData, this.isTableRulesetResourcesCreatedKey);
                    this.getView(databaseMetaData);
                    if (this.props.getProperty(this.isTableRuleappsCreatedKey).equals(this.trueValue) && this.props.getProperty(this.isTableRulesetsCreatedKey).equals(this.trueValue) && this.props.getProperty(this.isTableRuleappPropertiesCreatedKey).equals(this.trueValue) && this.props.getProperty(this.isTableRulesetPropertiesCreatedKey).equals(this.trueValue) && this.props.getProperty(this.isTableRulesetResourcesCreatedKey).equals(this.trueValue) && (this.props.getProperty(this.isViewRsEnabledCreatedKey).equals(this.trueValue) || this.props.getProperty(this.isViewRsEnabledCreatedKey).equals(this.viewObjectNotSupported))) {
                        this.manageData(connection);
                        this.setPassed(true);
                    } else {
                        this.setPassed(false);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    if (initialContext != null) {
                        initialContext.close();
                    }
                    throw throwable;
                }
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
                if (initialContext != null) {
                    initialContext.close();
                }
            }
            catch (NamingException namingException) {
                this.setPassed(false);
                this.setError(namingException);
            }
            catch (SQLException sQLException) {
                this.setPassed(false);
                this.setError(sQLException);
            }
        }

        public Properties getInfos() {
            return this.props;
        }

        private DataSource lookupDataSource(InitialContext initialContext, String string) throws NamingException {
            DataSource dataSource;
            try {
                dataSource = (DataSource)initialContext.lookup("java:comp/env/" + string);
            }
            catch (NamingException namingException) {
                try {
                    dataSource = (DataSource)initialContext.lookup(string);
                }
                catch (NamingException namingException2) {
                    throw namingException;
                }
            }
            return dataSource;
        }

        private void getConnectionMetadata(DatabaseMetaData databaseMetaData) throws SQLException {
            if (databaseMetaData != null) {
                if (databaseMetaData.getDatabaseProductName() != null) {
                    this.props.put(this.dbProductNameKey, databaseMetaData.getDatabaseProductName());
                } else {
                    this.props.put(this.dbProductNameKey, this.informationUnknown);
                }
                if (databaseMetaData.getDatabaseProductVersion() != null) {
                    this.props.put(this.dbProductVersionKey, databaseMetaData.getDatabaseProductVersion());
                } else {
                    this.props.put(this.dbProductVersionKey, this.informationUnknown);
                }
                if (databaseMetaData.getDriverName() != null) {
                    this.props.put(this.dbDriverNameKey, databaseMetaData.getDriverName());
                } else {
                    this.props.put(this.dbDriverNameKey, this.informationUnknown);
                }
                if (databaseMetaData.getDriverVersion() != null) {
                    this.props.put(this.dbDriverVersionKey, databaseMetaData.getDriverVersion());
                } else {
                    this.props.put(this.dbDriverVersionKey, this.informationUnknown);
                }
                if (databaseMetaData.getURL() != null) {
                    this.props.put(this.dbUrlKey, databaseMetaData.getURL());
                } else {
                    this.props.put(this.dbUrlKey, this.informationUnknown);
                }
                if (databaseMetaData.getUserName() != null) {
                    this.props.put(this.dbUsernameKey, databaseMetaData.getUserName());
                } else {
                    this.props.put(this.dbUsernameKey, this.informationUnknown);
                }
                if (databaseMetaData.supportsTransactions()) {
                    this.props.put(this.isTransactionSupportedKey, this.trueValue);
                } else {
                    this.props.put(this.isTransactionSupportedKey, this.falseValue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getTable(DatabaseMetaData databaseMetaData, String string) throws SQLException {
            if (databaseMetaData != null) {
                String[] stringArray = new String[]{"TABLE"};
                String string2 = null;
                ResultSet resultSet = null;
                try {
                    if (string.equals(this.isTableRuleappsCreatedKey)) {
                        string2 = "RULEAPPS";
                    } else if (string.equals(this.isTableRulesetsCreatedKey)) {
                        string2 = "RULESETS";
                    } else if (string.equals(this.isTableRuleappPropertiesCreatedKey)) {
                        string2 = "RULEAPP_PROPERTIES";
                    } else if (string.equals(this.isTableRulesetPropertiesCreatedKey)) {
                        string2 = "RULESET_PROPERTIES";
                    } else if (string.equals(this.isTableRulesetResourcesCreatedKey)) {
                        string2 = "RULESET_RESOURCES";
                    }
                    resultSet = databaseMetaData.getTables(null, this.props.getProperty(this.dbUsernameKey), string2, stringArray);
                    if (!(resultSet.next() || (resultSet = databaseMetaData.getTables(null, this.props.getProperty(this.dbUsernameKey).toUpperCase(), string2, stringArray)).next() || (resultSet = databaseMetaData.getTables(null, null, string2, stringArray)).next())) {
                        this.props.put(string, this.falseValue);
                        return;
                    }
                    String string3 = resultSet.getString("TABLE_NAME");
                    if (string2 != null && string2.equalsIgnoreCase(string3)) {
                        this.props.put(string, this.trueValue);
                    } else {
                        this.props.put(string, this.falseValue);
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getView(DatabaseMetaData databaseMetaData) throws SQLException {
            if (databaseMetaData != null) {
                if ("MySQL".equalsIgnoreCase((String)this.props.get(this.dbProductNameKey)) && databaseMetaData.getDatabaseMajorVersion() < 5) {
                    this.props.put(this.isViewRsEnabledCreatedKey, this.viewObjectNotSupported);
                    return;
                }
                String[] stringArray = new String[]{"VIEW"};
                String string = "RS_ENABLED_VIEW";
                ResultSet resultSet = null;
                try {
                    resultSet = databaseMetaData.getTables(null, this.props.getProperty(this.dbUsernameKey), string, stringArray);
                    if (!(resultSet.next() || (resultSet = databaseMetaData.getTables(null, this.props.getProperty(this.dbUsernameKey).toUpperCase(), string, stringArray)).next() || (resultSet = databaseMetaData.getTables(null, null, string, stringArray)).next())) {
                        this.props.put(this.isViewRsEnabledCreatedKey, this.falseValue);
                        return;
                    }
                    String string2 = resultSet.getString("TABLE_NAME");
                    if (string.equalsIgnoreCase(string2)) {
                        this.props.put(this.isViewRsEnabledCreatedKey, this.trueValue);
                    } else {
                        this.props.put(this.isViewRsEnabledCreatedKey, this.falseValue);
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertRuleApp(Connection connection) throws SQLException {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("insert into RULEAPPS (NAME, MAJOR_VERSION, MINOR_VERSION, CREATION_DATE, DESCRIPTION, DISPLAY_NAME) values ( ?, ?, ?, ?, ?, ?)");
                preparedStatement.setString(1, "IlogRuleAppForDiagnostic");
                preparedStatement.setInt(2, 98765);
                preparedStatement.setInt(3, 12345);
                Long l = new Long(String.valueOf(System.currentTimeMillis()));
                preparedStatement.setLong(4, l);
                preparedStatement.setString(5, "This is an ILOG RuleApp for Diagnostic purpose");
                preparedStatement.setString(6, "ILOG RuleApp for Diagnostic purpose");
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getRuleAppId(Connection connection) throws SQLException {
            int n;
            PreparedStatement preparedStatement;
            block4: {
                preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement("select ID from RULEAPPS where NAME = ? and MAJOR_VERSION = ? and MINOR_VERSION = ?");
                    preparedStatement.setString(1, "IlogRuleAppForDiagnostic");
                    preparedStatement.setInt(2, 98765);
                    preparedStatement.setInt(3, 12345);
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    n = resultSet.getInt("ID");
                    Object var6_5 = null;
                    if (resultSet == null) break block4;
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var6_6 = null;
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement == null) break block5;
                        preparedStatement.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertRuleset(Connection connection, int n) throws SQLException {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("insert into RULESETS (NAME, MAJOR_VERSION, MINOR_VERSION, CREATION_DATE, DESCRIPTION, DISPLAY_NAME, RULEAPP_ID) values (?, ?, ?, ?, ?, ?, ?)");
                preparedStatement.setString(1, "IlogRulesetForDiagnostic");
                preparedStatement.setInt(2, 12345);
                preparedStatement.setInt(3, 98765);
                Long l = new Long(String.valueOf(System.currentTimeMillis()));
                preparedStatement.setLong(4, l);
                preparedStatement.setString(5, "This is an ILOG Ruleset for Diagnostic purpose");
                preparedStatement.setString(6, "ILOG Ruleset for Diagnostic purpose");
                preparedStatement.setInt(7, n);
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getRulesetId(Connection connection, int n) throws SQLException {
            int n2;
            PreparedStatement preparedStatement;
            block4: {
                preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement("select ID from RULESETS where NAME = ? and MAJOR_VERSION = ? and MINOR_VERSION = ? and RULEAPP_ID = ?");
                    preparedStatement.setString(1, "IlogRulesetForDiagnostic");
                    preparedStatement.setInt(2, 12345);
                    preparedStatement.setInt(3, 98765);
                    preparedStatement.setInt(4, n);
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    n2 = resultSet.getInt("ID");
                    Object var7_6 = null;
                    if (resultSet == null) break block4;
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var7_7 = null;
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement == null) break block5;
                        preparedStatement.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertRulesetProperties(Connection connection, int n) throws SQLException {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("insert into RULESET_PROPERTIES (RULESET_ID, NAME, VALUE) values (?, ?, ?)");
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, "Dummy Property");
                preparedStatement.setString(3, "Dummy Value for Dummy Property");
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertRulesetResources(Connection connection, int n) throws SQLException {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("insert into RULESET_RESOURCES (RULESET_ID, NAME, DATA, PART) values (?, ?, ?, ?)");
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, "Dummy Entry");
                preparedStatement.setString(3, "Dummy Value for Dummy Entry");
                preparedStatement.setInt(4, Integer.MAX_VALUE);
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteData(Connection connection, int n, int n2) throws SQLException {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("delete from RULESET_RESOURCES where RULESET_ID = ?");
                preparedStatement.setInt(1, n2);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("delete from RULESET_PROPERTIES where RULESET_ID = ?");
                preparedStatement.setInt(1, n2);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("delete from RULESETS where ID = ?");
                preparedStatement.setInt(1, n2);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("delete from RULEAPPS where ID = ?");
                preparedStatement.setInt(1, n);
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }

        private void manageData(Connection connection) throws SQLException {
            this.insertRuleApp(connection);
            int n = this.getRuleAppId(connection);
            this.insertRuleset(connection, n);
            int n2 = this.getRulesetId(connection, n);
            this.insertRulesetProperties(connection, n2);
            this.insertRulesetResources(connection, n2);
            this.deleteData(connection, n, n2);
        }
    }
}

