/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.ras.model.impl;

import ilog.rules.bres.ras.model.IlrExecutionTrace;
import ilog.rules.bres.ras.model.IlrExecutionTraceSerializationException;
import ilog.rules.bres.ras.model.IlrExecutionTraceSerializerHandler;
import ilog.rules.bres.ras.model.impl.IlrExecutionTraceAdapterImpl;
import ilog.rules.bres.ras.model.impl.IlrExecutionTraceFilterImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IlrExecutionTraceImpl
extends IlrExecutionTraceFilterImpl
implements IlrExecutionTrace {
    static final long serialVersionUID = 1L;
    static final Object[] emptyWorkingMemory = new Object[0];
    protected static transient IlrExecutionTraceSerializerHandler Serializer = null;
    protected String executionTraceId;
    protected Serializable userData = null;
    protected Properties executionTraceProperties = new Properties();
    protected Properties filterProperties = new Properties();
    protected ArrayList rulesFired = new ArrayList();
    protected ArrayList tasksExecuted = new ArrayList();
    protected ArrayList allRules = new ArrayList();
    protected ArrayList allTasks = new ArrayList();
    protected String canonicalRulesetPath;
    protected String rulesetPath;
    protected Serializable connectionId;
    protected long executionDuration = -1L;
    protected long numRulesFired = -1L;
    protected long numRulesNotFired = -1L;
    protected long numTasksExecuted = -1L;
    protected long numTasksNotExecuted = -1L;
    protected transient Object[] workingMemory = emptyWorkingMemory;
    protected String outputString;
    protected HashMap inputParameters = new HashMap();
    protected HashMap outputParameters = new HashMap();
    protected ArrayList warningMessages = new ArrayList();
    protected ArrayList errorMessages = new ArrayList();
    protected boolean enableInterceptor = false;
    protected String taskName = null;
    protected String interceptorClassNameUsed = null;
    protected boolean onBomExecution = false;

    public IlrExecutionTraceImpl(String string) {
        this.executionTraceId = string;
        this.enableInterceptor = false;
        this.taskName = null;
        this.interceptorClassNameUsed = null;
    }

    public Serializable getUserData() {
        return this.userData;
    }

    public void setUserData(Serializable serializable) {
        this.userData = serializable;
    }

    public String getExecutionTraceId() {
        return this.executionTraceId;
    }

    public void addExecutionTraceProperty(String string, String string2) {
        if (string != null) {
            this.executionTraceProperties.setProperty(string, string2);
        }
    }

    public void addFilterProperty(String string, String string2) {
        if (string != null) {
            this.filterProperties.setProperty(string, string2);
        }
    }

    public Properties getExecutionTraceProperties() {
        return this.executionTraceProperties;
    }

    public Map getInputParameters() throws IlrExecutionTraceSerializationException {
        return this.inputParameters;
    }

    public String getCanonicalRulesetPath() {
        return this.canonicalRulesetPath;
    }

    public void setCanonicalRulesetPath(String string) {
        this.canonicalRulesetPath = string;
    }

    public void setConnectionId(Serializable serializable) {
        this.connectionId = serializable;
    }

    public Serializable getConnectionId() {
        return this.connectionId;
    }

    public void setExecutionDuration(long l) {
        if (this.infoExecutionDuration()) {
            this.executionDuration = l;
        }
    }

    public long getExecutionDuration() {
        return this.executionDuration;
    }

    public void addRuleFired(String string) {
        if (string != null && this.infoRulesFired()) {
            this.rulesFired.add(string);
        }
    }

    public ArrayList getRulesFired() {
        return this.rulesFired;
    }

    public void addTaskExecuted(String string) {
        if (string != null && this.infoTasksExecuted()) {
            this.tasksExecuted.add(string);
        }
    }

    public ArrayList getTasksExecuted() {
        return this.tasksExecuted;
    }

    public void setWorkingMemory(Object[] objectArray) {
        if (this.infoWorkingMemory()) {
            this.workingMemory = objectArray;
        }
    }

    public Object[] getWorkingMemory() throws IlrExecutionTraceSerializationException {
        return this.workingMemory;
    }

    public void setOutputParameters(Map map) {
        if (this.infoOutputParameters()) {
            this.outputParameters.putAll(map);
        }
    }

    public void setInputParameters(Map map) {
        this.inputParameters.putAll(map);
    }

    public Map getOutputParameters() throws IlrExecutionTraceSerializationException {
        return this.outputParameters;
    }

    public void setOutputString(String string) {
        if (this.infoOutputString()) {
            this.outputString = string;
        }
    }

    public String getOutputString() {
        return this.outputString;
    }

    public void addWarningMessage(String string) {
        if (string != null) {
            this.warningMessages.add(string);
        }
    }

    public ArrayList getWarningMessages() {
        return this.warningMessages;
    }

    public void addErrorMessage(String string) {
        if (string != null) {
            this.errorMessages.add(string);
        }
    }

    public ArrayList getErrorMessages() {
        return this.errorMessages;
    }

    public static void SetSerializerHandler(IlrExecutionTraceSerializerHandler ilrExecutionTraceSerializerHandler) {
        Serializer = ilrExecutionTraceSerializerHandler;
    }

    public static IlrExecutionTraceSerializerHandler GetSerializerHandler() {
        return Serializer;
    }

    public Properties getFilterProperties() {
        return this.filterProperties;
    }

    public Map toMap() throws IlrExecutionTraceSerializationException {
        Object object;
        Object object2;
        Map.Entry<Object, Object> entry;
        IlrExecutionTraceAdapterImpl ilrExecutionTraceAdapterImpl = new IlrExecutionTraceAdapterImpl(new HashMap());
        ilrExecutionTraceAdapterImpl.setConnectionId(this.connectionId);
        ilrExecutionTraceAdapterImpl.setExecutionTraceId(this.executionTraceId);
        ilrExecutionTraceAdapterImpl.setExecutionDuration(this.executionDuration);
        ilrExecutionTraceAdapterImpl.setNumRulesFired(this.numRulesFired);
        ilrExecutionTraceAdapterImpl.setNumRulesNotFired(this.numRulesNotFired);
        ilrExecutionTraceAdapterImpl.setNumTasksExecuted(this.numTasksExecuted);
        ilrExecutionTraceAdapterImpl.setNumTasksNotExecuted(this.numTasksNotExecuted);
        ilrExecutionTraceAdapterImpl.setOutputString(this.outputString);
        ilrExecutionTraceAdapterImpl.setUserData(this.userData);
        ilrExecutionTraceAdapterImpl.setWorkingMemory(this.workingMemory);
        ilrExecutionTraceAdapterImpl.setInputParameters(this.inputParameters);
        ilrExecutionTraceAdapterImpl.setOutputParameters(this.outputParameters);
        Set<Map.Entry<Object, Object>> set = this.executionTraceProperties.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!(entry instanceof Map.Entry)) continue;
            object2 = entry.getKey();
            object = entry.getValue();
            ilrExecutionTraceAdapterImpl.addExecutionTraceProperty((String)object2, (String)object);
        }
        set = this.filterProperties.entrySet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!(entry instanceof Map.Entry)) continue;
            object2 = entry.getKey();
            object = entry.getValue();
            ilrExecutionTraceAdapterImpl.addFilterProperty((String)object2, (String)object);
        }
        iterator = this.errorMessages.iterator();
        while (iterator.hasNext()) {
            ilrExecutionTraceAdapterImpl.addErrorMessage((String)((Object)iterator.next()));
        }
        iterator = this.warningMessages.iterator();
        while (iterator.hasNext()) {
            ilrExecutionTraceAdapterImpl.addWarningMessage((String)((Object)iterator.next()));
        }
        iterator = this.rulesFired.iterator();
        while (iterator.hasNext()) {
            ilrExecutionTraceAdapterImpl.addRuleFired((String)((Object)iterator.next()));
        }
        iterator = this.tasksExecuted.iterator();
        while (iterator.hasNext()) {
            ilrExecutionTraceAdapterImpl.addTaskExecuted((String)((Object)iterator.next()));
        }
        ilrExecutionTraceAdapterImpl.setRulesetPath(this.getRulesetPath());
        ilrExecutionTraceAdapterImpl.setCanonicalRulesetPath(this.getCanonicalRulesetPath());
        ilrExecutionTraceAdapterImpl.setEnableInterceptor(this.enableInterceptor);
        ilrExecutionTraceAdapterImpl.setOnBomExecution(this.onBomExecution);
        ilrExecutionTraceAdapterImpl.setTaskName(this.taskName);
        ilrExecutionTraceAdapterImpl.setInterceptorClassNameUsed(this.interceptorClassNameUsed);
        return ilrExecutionTraceAdapterImpl.toMap();
    }

    public void fromMap(Map map) throws IlrExecutionTraceSerializationException {
        IlrExecutionTraceAdapterImpl ilrExecutionTraceAdapterImpl = new IlrExecutionTraceAdapterImpl(map);
        this.connectionId = ilrExecutionTraceAdapterImpl.getConnectionId();
        this.executionTraceId = ilrExecutionTraceAdapterImpl.getExecutionTraceId();
        this.executionDuration = ilrExecutionTraceAdapterImpl.getExecutionDuration();
        this.outputString = ilrExecutionTraceAdapterImpl.getOutputString();
        this.userData = ilrExecutionTraceAdapterImpl.getUserData();
        this.workingMemory = ilrExecutionTraceAdapterImpl.getWorkingMemory();
        this.executionTraceProperties = ilrExecutionTraceAdapterImpl.getExecutionTraceProperties();
        this.filterProperties = ilrExecutionTraceAdapterImpl.getFilterProperties();
        this.inputParameters.putAll(ilrExecutionTraceAdapterImpl.getInputParameters());
        this.outputParameters.putAll(ilrExecutionTraceAdapterImpl.getOutputParameters());
        this.errorMessages = ilrExecutionTraceAdapterImpl.getErrorMessages();
        this.warningMessages = ilrExecutionTraceAdapterImpl.getWarningMessages();
        this.rulesFired = ilrExecutionTraceAdapterImpl.getRulesFired();
        this.tasksExecuted = ilrExecutionTraceAdapterImpl.getTasksExecuted();
        this.allRules = ilrExecutionTraceAdapterImpl.getAllRules();
        this.allTasks = ilrExecutionTraceAdapterImpl.getAllTasks();
        this.rulesetPath = ilrExecutionTraceAdapterImpl.getRulesetPath();
        this.canonicalRulesetPath = ilrExecutionTraceAdapterImpl.getCanonicalRulesetPath();
        this.numRulesFired = ilrExecutionTraceAdapterImpl.getNumRulesFired();
        this.numRulesNotFired = ilrExecutionTraceAdapterImpl.getNumRulesNotFired();
        this.numTasksExecuted = ilrExecutionTraceAdapterImpl.getNumTasksExecuted();
        this.numTasksNotExecuted = ilrExecutionTraceAdapterImpl.getNumTasksNotExecuted();
        this.enableInterceptor = ilrExecutionTraceAdapterImpl.getEnableInterceptor();
        this.onBomExecution = ilrExecutionTraceAdapterImpl.isOnBomExecution();
        this.taskName = ilrExecutionTraceAdapterImpl.getTaskName();
        this.interceptorClassNameUsed = ilrExecutionTraceAdapterImpl.getInterceptorClassNameUsed();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (Serializer != null) {
            Serializer.serialize(this);
        }
        objectOutputStream.writeObject(this.executionTraceId);
        objectOutputStream.writeObject(this.connectionId != null ? this.connectionId.toString() : (String)null);
        objectOutputStream.writeObject(this.rulesetPath);
        objectOutputStream.writeObject(this.canonicalRulesetPath);
        objectOutputStream.writeObject(new Long(this.numRulesFired));
        objectOutputStream.writeObject(new Long(this.numRulesNotFired));
        objectOutputStream.writeObject(new Long(this.numTasksExecuted));
        objectOutputStream.writeObject(new Long(this.numTasksNotExecuted));
        objectOutputStream.writeObject(new Long(this.executionDuration));
        objectOutputStream.writeObject(this.outputString);
        objectOutputStream.writeObject(this.warningMessages);
        objectOutputStream.writeObject(this.errorMessages);
        objectOutputStream.writeObject(this.userData);
        objectOutputStream.writeObject(this.executionTraceProperties);
        objectOutputStream.writeObject(this.filterProperties);
        objectOutputStream.writeObject(this.inputParameters);
        objectOutputStream.writeObject(this.outputParameters);
        objectOutputStream.writeObject(this.rulesFired);
        objectOutputStream.writeObject(this.tasksExecuted);
        objectOutputStream.writeObject(this.allRules);
        objectOutputStream.writeObject(this.allTasks);
        objectOutputStream.writeObject(new Boolean(this.enableInterceptor));
        objectOutputStream.writeObject(new Boolean(this.onBomExecution));
        objectOutputStream.writeObject(this.taskName);
        objectOutputStream.writeObject(this.interceptorClassNameUsed);
        if (this.workingMemory == null) {
            objectOutputStream.writeInt(0);
            objectOutputStream.writeObject(new Object[0]);
        } else {
            objectOutputStream.writeInt(this.workingMemory.length);
            for (int i = 0; i < this.workingMemory.length; ++i) {
                objectOutputStream.writeObject(this.workingMemory[i]);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.executionTraceId = (String)objectInputStream.readObject();
        this.connectionId = (String)objectInputStream.readObject();
        this.rulesetPath = (String)objectInputStream.readObject();
        this.canonicalRulesetPath = (String)objectInputStream.readObject();
        this.numRulesFired = (Long)objectInputStream.readObject();
        this.numRulesNotFired = (Long)objectInputStream.readObject();
        this.numTasksExecuted = (Long)objectInputStream.readObject();
        this.numTasksNotExecuted = (Long)objectInputStream.readObject();
        this.executionDuration = (Long)objectInputStream.readObject();
        this.outputString = (String)objectInputStream.readObject();
        this.warningMessages = (ArrayList)objectInputStream.readObject();
        this.errorMessages = (ArrayList)objectInputStream.readObject();
        this.userData = (String)objectInputStream.readObject();
        this.executionTraceProperties = (Properties)objectInputStream.readObject();
        this.filterProperties = (Properties)objectInputStream.readObject();
        this.inputParameters = (HashMap)objectInputStream.readObject();
        this.outputParameters = (HashMap)objectInputStream.readObject();
        this.rulesFired = (ArrayList)objectInputStream.readObject();
        this.tasksExecuted = (ArrayList)objectInputStream.readObject();
        this.allRules = (ArrayList)objectInputStream.readObject();
        this.allTasks = (ArrayList)objectInputStream.readObject();
        this.enableInterceptor = (Boolean)objectInputStream.readObject();
        this.onBomExecution = (Boolean)objectInputStream.readObject();
        this.taskName = (String)objectInputStream.readObject();
        this.interceptorClassNameUsed = (String)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            this.workingMemory = null;
        } else {
            this.workingMemory = new Object[n];
            for (int i = 0; i < n; ++i) {
                this.workingMemory[i] = objectInputStream.readObject();
            }
        }
        if (Serializer != null) {
            this.inputParameters.clear();
            this.inputParameters.putAll(Serializer.readInputParameter(this));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-------------- :    ----------------------------------------------\n");
        stringBuffer.append("# SIMPLE    DATA                                                  \n");
        stringBuffer.append("-------------- :    ----------------------------------------------\n");
        stringBuffer.append("XR-ID          : " + this.executionTraceId + "\n");
        stringBuffer.append("Connection ID  : " + this.connectionId + "\n");
        stringBuffer.append("Ruleset Path   : " + this.rulesetPath + "\n");
        stringBuffer.append("Canonical Ruleset Path   : " + this.canonicalRulesetPath + "\n");
        stringBuffer.append("Task Name   : " + this.taskName + "\n");
        stringBuffer.append("EnableInterceptor   : " + this.enableInterceptor + "\n");
        stringBuffer.append("Interceptor Classname used   : " + this.interceptorClassNameUsed + "\n");
        stringBuffer.append("Num Rules Fired : " + this.numRulesFired + "\n");
        stringBuffer.append("Num Rules not Fired : " + this.numRulesNotFired + "\n");
        stringBuffer.append("Num Tasks executed : " + this.numTasksExecuted + "\n");
        stringBuffer.append("Num tasks not executed : " + this.numTasksNotExecuted + "\n");
        stringBuffer.append("Exec duration      : " + this.executionDuration + "\n");
        stringBuffer.append("Output String  : " + this.outputString + "\n");
        stringBuffer.append("-------------- :    ----------------------------------------------\n");
        stringBuffer.append("# LIST    DATA                                                    \n");
        stringBuffer.append("-------------- :    ----------------------------------------------\n");
        String string = this.warningMessages.size() == 0 ? "NO    WARNINGS REPORTED!" : this.warningMessages.toString();
        String string2 = this.errorMessages.size() == 0 ? "NO    ERRORS REPORTED!" : this.errorMessages.toString();
        String string3 = this.executionTraceProperties.size() == 0 ? "NO PROPERTIES DEFINED!" : this.executionTraceProperties.toString();
        String string4 = this.filterProperties.size() == 0 ? "NO    FILTERS DEFINED!" : this.filterProperties.toString();
        String string5 = this.inputParameters.size() == 0 ? "NO    INPUT PARAMS!" : this.inputParameters.toString();
        String string6 = this.outputParameters.size() == 0 ? "NO    OUTPUT PARAMS!" : this.outputParameters.toString();
        String string7 = this.rulesFired.size() == 0 ? "NO RULES    FIRED!" : this.rulesFired.toString();
        String string8 = this.tasksExecuted.size() == 0 ? "NO TASKS    EXECUTED!" : this.tasksExecuted.toString();
        String string9 = this.userData == null ? "NO USER DATA!" : this.userData.toString();
        stringBuffer.append("Warnings       : " + string + "\n");
        stringBuffer.append("Errors         : " + string2 + "\n");
        stringBuffer.append("User Data      : " + string9 + "\n");
        stringBuffer.append("Properties     : " + string3 + "\n");
        stringBuffer.append("Filters        : " + string4 + "\n");
        stringBuffer.append("Input Params   : " + string5 + "\n");
        stringBuffer.append("Output Params  : " + string6 + "\n");
        stringBuffer.append("Rules Fired    : " + string7 + "\n");
        stringBuffer.append("Tasks Fired    : " + string8 + "\n");
        stringBuffer.append("-------------- :    ----------------------------------------------\n");
        stringBuffer.append("# WORKING    MEM                                                  \n");
        stringBuffer.append("-------------- :    ----------------------------------------------\n");
        String string10 = "         ";
        if (this.workingMemory != null) {
            stringBuffer.append("Size           : " + this.workingMemory.length + "\n");
            for (int i = 0; i < this.workingMemory.length; ++i) {
                int n = String.valueOf(i).length();
                String string11 = "Elem[" + i + "]" + string10.substring(n, 9);
                stringBuffer.append(string11 + ":" + " " + this.workingMemory[i].toString() + "\n");
            }
        } else {
            stringBuffer.append("Working Memory : THE WORKING MEMORY IS NULL!\n");
        }
        return stringBuffer.toString();
    }

    public void addToAllRules(String string) {
        if (this.infoRulesNotFired()) {
            this.allRules.add(string);
        }
    }

    public void addToAllTasks(String string) {
        if (this.infoTasksNotExecuted()) {
            this.allTasks.add(string);
        }
    }

    public ArrayList getAllRules() {
        return this.allRules;
    }

    public ArrayList getAllTasks() {
        return this.allTasks;
    }

    public long getNumRulesFired() {
        return this.numRulesFired;
    }

    public long getNumRulesNotFired() {
        return this.numRulesNotFired;
    }

    public long getNumTasksExecuted() {
        return this.numTasksExecuted;
    }

    public long getNumTasksNotExecuted() {
        return this.numTasksNotExecuted;
    }

    public String getRulesetPath() throws IlrExecutionTraceSerializationException {
        return this.rulesetPath;
    }

    public void setRulesetPath(String string) {
        this.rulesetPath = string;
    }

    public void setNumRulesFired(long l) {
        if (this.infoNumRulesFired()) {
            this.numRulesFired = l;
        }
    }

    public void setNumRulesNotFired(long l) {
        if (this.infoNumRulesNotFired()) {
            this.numRulesNotFired = l;
        }
    }

    public void setNumTasksExecuted(long l) {
        if (this.infoNumTasksExecuted()) {
            this.numTasksExecuted = l;
        }
    }

    public void setNumTasksNotExecuted(long l) {
        if (this.infoNumTasksNotExecuted()) {
            this.numTasksNotExecuted = l;
        }
    }

    public boolean getEnableInterceptor() {
        return this.enableInterceptor;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setEnableInterceptor(boolean bl) {
        this.enableInterceptor = bl;
    }

    public void setTaskName(String string) {
        this.taskName = string;
    }

    public String getInterceptorClassNameUsed() {
        return this.interceptorClassNameUsed;
    }

    public void setInterceptorClassNameUsed(String string) {
        this.interceptorClassNameUsed = string;
    }

    public boolean isOnBomExecution() {
        return this.onBomExecution;
    }

    public void setOnBomExecution(boolean bl) {
        this.onBomExecution = bl;
    }
}

