/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.model.IlrFormatException;
import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.IlrPathParser;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.xu.cci.IlrXUConnectionSpec;
import ilog.rules.bres.xu.cci.IlrXUManagementInteractionSpec;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;

public abstract class IlrManagementSessionImpl {
    protected IlrXUManagementInteractionSpec interactionSpec = new IlrXUManagementInteractionSpec();
    protected ConnectionFactory connectionFactory;

    public abstract IlrRepositoryFactory getRepositoryFactory();

    protected IlrPathParser getRulesetPathParser() {
        return this.getRepositoryFactory().getPathParser();
    }

    protected String[] solveRulesetPath(Connection connection, String[] stringArray) throws ResourceException {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.interactionSpec.setRulesetPath(string);
            this.interactionSpec.setFunctionName(IlrXUManagementInteractionSpec.FUNCTION_NAME_SOLVE_RULESET_PATH);
            IndexedRecord indexedRecord = (IndexedRecord)this.createAndExecuteInteraction(connection);
            stringArray2[i] = (String)indexedRecord.get(0);
        }
        return stringArray2;
    }

    protected void invalidate(Connection connection, String[] stringArray) throws ResourceException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.checkRulesetPath(string);
            this.interactionSpec.setCanonicalRulesetPath(string);
            this.interactionSpec.setFunctionName(IlrXUManagementInteractionSpec.FUNCTION_NAME_RULESET_ARCHIVE_CHANGED);
            this.createAndExecuteInteraction(connection);
        }
    }

    protected void checkRulesetPath(String string) {
        try {
            IlrPath ilrPath = this.getRulesetPathParser().parse(string);
            if (!ilrPath.isCanonical()) {
                throw new IllegalArgumentException(string);
            }
        }
        catch (IlrFormatException ilrFormatException) {
            throw new IllegalArgumentException(ilrFormatException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Record createAndExecuteInteraction(Connection connection) throws ResourceException {
        Interaction interaction = null;
        Record record = null;
        try {
            interaction = connection.createInteraction();
            record = interaction.execute((InteractionSpec)this.interactionSpec, null);
        }
        finally {
            if (interaction != null) {
                interaction.close();
            }
        }
        return record;
    }

    protected Connection getConnection() throws ResourceException {
        IlrXUConnectionSpec ilrXUConnectionSpec = new IlrXUConnectionSpec();
        ilrXUConnectionSpec.setClientJRulesImplementationVersion("6.5.3.22");
        ilrXUConnectionSpec.setType((byte)1);
        return this.connectionFactory.getConnection((ConnectionSpec)ilrXUConnectionSpec);
    }
}

