/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.ras.model.IlrExecutionTrace;
import ilog.rules.bres.ras.model.IlrExecutionTraceSerializationException;
import ilog.rules.bres.ras.plugin.IlrExecutionTraceInteractionSpec;
import ilog.rules.bres.session.IlrRuleSessionException;
import ilog.rules.bres.session.IlrRuleSessionMetaData;
import ilog.rules.bres.session.IlrRuleSessionMetaDataImpl;
import ilog.rules.bres.session.IlrRulesetExecutionRequest;
import ilog.rules.bres.session.IlrRulesetExecutionResponse;
import ilog.rules.bres.session.IlrSessionDescriptor;
import ilog.rules.bres.session.IlrSessionExecutionProperties;
import ilog.rules.bres.session.IlrSessionExecutionResult;
import ilog.rules.bres.session.IlrSessionExecutionSettings;
import ilog.rules.bres.session.IlrSessionFilter;
import ilog.rules.bres.session.IlrSessionMappingUtilities;
import ilog.rules.bres.session.IlrSessionParameters;
import ilog.rules.bres.session.IlrSessionRequest;
import ilog.rules.bres.session.IlrSessionResponse;
import ilog.rules.bres.session.dispatch.IlrDispatcher;
import ilog.rules.bres.session.util.IlrClassLoaderBuilder;
import ilog.rules.bres.session.util.IlrJavaClassResolver;
import ilog.rules.bres.session.util.IlrMessages;
import ilog.rules.bres.xu.cci.IlrConnectionId;
import ilog.rules.bres.xu.cci.IlrRuleEngineInteractionSpec;
import ilog.rules.bres.xu.cci.IlrXUConnectionSpec;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceWarning;

public abstract class IlrRuleSessionExecuteImpl {
    protected final String engineNumRulesFired = "ilog.rules.firedRulesCount";
    protected IlrRuleEngineInteractionSpec interactionSpec = new IlrRuleEngineInteractionSpec();
    protected transient IlrJavaClassResolver javaClassResolver = null;
    protected static int DEFAULT_RESOURCE_EXCEPTION_MAX_DEPTH = 10;

    protected IlrRulesetExecutionResponse executeStateless(ConnectionFactory connectionFactory, Interaction interaction, IlrRulesetExecutionRequest ilrRulesetExecutionRequest, Warnings warnings) throws ResourceException {
        IlrRulesetExecutionResponse ilrRulesetExecutionResponse = null;
        HashMap hashMap = this.execute(connectionFactory, ilrRulesetExecutionRequest.getTaskName(), ilrRulesetExecutionRequest.getParameters(), warnings, false, true, interaction);
        String string = this.getIlrContextOutput(interaction, warnings);
        ilrRulesetExecutionResponse = new IlrRulesetExecutionResponse();
        ilrRulesetExecutionResponse.setOutputParameters(hashMap);
        ilrRulesetExecutionResponse.setOutputString(string);
        ilrRulesetExecutionResponse.setMetaData(this.calculateMetaData(interaction, warnings, ilrRulesetExecutionRequest.getUserData()));
        return ilrRulesetExecutionResponse;
    }

    protected IlrExecutionTrace executeStateless(ConnectionFactory connectionFactory, Connection connection, Interaction interaction, IlrExecutionTrace ilrExecutionTrace, Warnings warnings) throws ResourceException, IlrExecutionTraceSerializationException {
        MappedRecord mappedRecord = this.createMappedRecord("input", connectionFactory);
        MappedRecord mappedRecord2 = this.createMappedRecord("output", connectionFactory);
        mappedRecord.putAll(ilrExecutionTrace.toMap());
        this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_ENABLE_RULESET_EXECUTION_INFORMATION);
        this.executeInteraction(interaction, (Record)mappedRecord, warnings);
        long l = System.currentTimeMillis();
        HashMap hashMap = null;
        Object var11_10 = null;
        try {
            hashMap = this.execute(connectionFactory, ilrExecutionTrace.getTaskName(), ilrExecutionTrace.getInputParameters(), warnings, ilrExecutionTrace.isOnBomExecution(), false, interaction);
        }
        catch (Throwable throwable) {
            String string = this.format(throwable);
            ilrExecutionTrace.addErrorMessage(string);
            return ilrExecutionTrace;
        }
        long l2 = System.currentTimeMillis();
        String string = this.getIlrContextOutput(interaction, warnings);
        IlrExecutionTraceInteractionSpec ilrExecutionTraceInteractionSpec = new IlrExecutionTraceInteractionSpec();
        ilrExecutionTraceInteractionSpec.setFunctionName(IlrExecutionTraceInteractionSpec.FUNCTION_NAME_EXECUTION_TRACE);
        this.executeRasInteraction(ilrExecutionTraceInteractionSpec, interaction, (Record)mappedRecord, (Record)mappedRecord2, warnings);
        ilrExecutionTrace.fromMap((Map)mappedRecord2);
        ilrExecutionTrace.setOutputParameters(hashMap);
        ilrExecutionTrace.setOutputString(string);
        ilrExecutionTrace.setExecutionDuration(l2 - l);
        return ilrExecutionTrace;
    }

    protected String format(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        for (int i = 0; i < 10 && throwable instanceof ResourceException; ++i) {
            if ((throwable = ((ResourceException)throwable).getLinkedException()) == null) continue;
            IlrMessages.getMessages();
            String string = IlrMessages.getMessage("10032");
            printWriter.write(string + ": ");
            throwable.printStackTrace(printWriter);
        }
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    protected HashMap execute(ConnectionFactory connectionFactory, String string, Map map, Warnings warnings, boolean bl, boolean bl2, Interaction interaction) throws ResourceException {
        MappedRecord mappedRecord;
        if (map != null) {
            if (!bl) {
                this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_SET_PARAMETERS);
            } else {
                this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_SET_BOM_PARAMETERS);
            }
            mappedRecord = this.createMappedRecord("input", connectionFactory);
            mappedRecord.putAll(map);
            this.executeInteraction(interaction, (Record)mappedRecord, warnings);
        }
        IndexedRecord indexedRecord = null;
        if (string != null) {
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE_TASK);
            indexedRecord = this.createIndexedRecord("input", connectionFactory);
            indexedRecord.add((Object)string);
        } else {
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE);
        }
        mappedRecord = (MappedRecord)this.executeInteraction(interaction, (Record)indexedRecord, warnings);
        if (bl) {
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_BOM_PARAMETERS);
            mappedRecord = (MappedRecord)this.executeInteraction(interaction, (Record)indexedRecord, warnings);
        }
        HashMap<String, Object> hashMap = null;
        if (mappedRecord != null) {
            hashMap = new HashMap<String, Object>((Map<String, Object>)mappedRecord);
        }
        if (bl2) {
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_INFORMATION);
            mappedRecord = (MappedRecord)this.executeInteraction(interaction, (Record)indexedRecord, warnings);
            if (mappedRecord != null) {
                hashMap.put("ilog.rules.firedRulesCount", mappedRecord.get((Object)"ilog.rules.firedRulesCount"));
            }
        }
        return hashMap;
    }

    protected String getIlrContextOutput(Interaction interaction, Warnings warnings) throws ResourceException {
        this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_OUTPUT);
        IndexedRecord indexedRecord = (IndexedRecord)this.executeInteraction(interaction, null, warnings);
        return (String)indexedRecord.get(0);
    }

    protected IlrRuleSessionMetaData calculateMetaData(Interaction interaction, Warnings warnings, Serializable serializable) throws ResourceException {
        IlrRuleSessionMetaDataImpl ilrRuleSessionMetaDataImpl = null;
        this.interactionSpec.setFunctionName("ruleset.getInformation");
        MappedRecord mappedRecord = (MappedRecord)this.executeInteraction(interaction, null, warnings);
        ilrRuleSessionMetaDataImpl = new IlrRuleSessionMetaDataImpl();
        ilrRuleSessionMetaDataImpl.setCanonicalRulesetPath((String)mappedRecord.get((Object)"path.canonical"));
        ilrRuleSessionMetaDataImpl.setRulesetProperties((Properties)mappedRecord.get((Object)"properties"));
        ilrRuleSessionMetaDataImpl.setConnectionId(this.getConnectionId(interaction, warnings));
        ilrRuleSessionMetaDataImpl.setUserData(serializable);
        return ilrRuleSessionMetaDataImpl;
    }

    protected void calculateMetaData(Interaction interaction, IlrSessionExecutionProperties ilrSessionExecutionProperties, Warnings warnings, Serializable serializable) throws ResourceException {
        this.interactionSpec.setFunctionName("ruleset.getInformation");
        MappedRecord mappedRecord = (MappedRecord)this.executeInteraction(interaction, null, warnings);
        ilrSessionExecutionProperties.setCanonicalRulesetPath((String)mappedRecord.get((Object)"path.canonical"));
        ilrSessionExecutionProperties.setRulesetProperties((Properties)mappedRecord.get((Object)"properties"));
        ilrSessionExecutionProperties.setConnectionId(this.getConnectionId(interaction, warnings));
        ilrSessionExecutionProperties.setUserData(serializable);
    }

    protected Serializable getConnectionId(Interaction interaction, Warnings warnings) throws ResourceException {
        IndexedRecord indexedRecord = null;
        this.interactionSpec.setFunctionName("connectionId");
        indexedRecord = (IndexedRecord)this.executeInteraction(interaction, null, warnings);
        if (indexedRecord != null) {
            return (Serializable)indexedRecord.get(0);
        }
        return null;
    }

    protected void cleanContext(ConnectionFactory connectionFactory, Connection connection, Warnings warnings) throws ResourceException {
        this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RESET);
        this.createAndExecuteInteraction(connection, null, warnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Record createAndExecuteInteraction(Connection connection, Record record, Warnings warnings) throws ResourceException {
        Record record2;
        block3: {
            Interaction interaction = null;
            record2 = null;
            try {
                interaction = connection.createInteraction();
                record2 = interaction.execute((InteractionSpec)this.interactionSpec, record);
                Object var7_6 = null;
                if (interaction == null) break block3;
                warnings.addWarning(interaction.getWarnings());
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (interaction != null) {
                    warnings.addWarning(interaction.getWarnings());
                    interaction.clearWarnings();
                    interaction.close();
                }
                throw throwable;
            }
            interaction.clearWarnings();
            interaction.close();
            {
            }
        }
        return record2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Record executeInteraction(Interaction interaction, Record record, Warnings warnings) throws ResourceException {
        Record record2 = null;
        try {
            record2 = interaction.execute((InteractionSpec)this.interactionSpec, record);
        }
        finally {
            warnings.addWarning(interaction.getWarnings());
            interaction.clearWarnings();
        }
        return record2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createAndExecuteRasInteraction(IlrExecutionTraceInteractionSpec ilrExecutionTraceInteractionSpec, Connection connection, Record record, Record record2, Warnings warnings) throws ResourceException {
        boolean bl;
        block3: {
            bl = false;
            Interaction interaction = null;
            try {
                interaction = connection.createInteraction();
                bl = interaction.execute((InteractionSpec)ilrExecutionTraceInteractionSpec, record, record2);
                Object var9_8 = null;
                if (interaction == null) break block3;
                warnings.addWarning(interaction.getWarnings());
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (interaction != null) {
                    warnings.addWarning(interaction.getWarnings());
                    interaction.clearWarnings();
                    interaction.close();
                }
                throw throwable;
            }
            interaction.clearWarnings();
            interaction.close();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeRasInteraction(IlrExecutionTraceInteractionSpec ilrExecutionTraceInteractionSpec, Interaction interaction, Record record, Record record2, Warnings warnings) throws ResourceException {
        boolean bl = false;
        try {
            bl = interaction.execute((InteractionSpec)ilrExecutionTraceInteractionSpec, record, record2);
        }
        finally {
            warnings.addWarning(interaction.getWarnings());
            interaction.clearWarnings();
        }
        return bl;
    }

    protected IndexedRecord createIndexedRecord(String string, ConnectionFactory connectionFactory) throws ResourceException {
        RecordFactory recordFactory = connectionFactory.getRecordFactory();
        return recordFactory.createIndexedRecord(string);
    }

    protected MappedRecord createMappedRecord(String string, ConnectionFactory connectionFactory) throws ResourceException {
        RecordFactory recordFactory = connectionFactory.getRecordFactory();
        return recordFactory.createMappedRecord(string);
    }

    protected ClassLoader buildClassLoader(IlrJavaClassResolver ilrJavaClassResolver) throws MalformedURLException, IOException, ClassNotFoundException {
        IlrClassLoaderBuilder ilrClassLoaderBuilder = new IlrClassLoaderBuilder();
        ilrClassLoaderBuilder.loadJavaClass(ilrJavaClassResolver);
        return ilrClassLoaderBuilder.getClassLoader();
    }

    protected IlrRulesetExecutionRequest callInterceptor(IlrRulesetExecutionRequest ilrRulesetExecutionRequest, IlrJavaClassResolver ilrJavaClassResolver, Object object, StringBuffer stringBuffer) throws Exception {
        IlrDispatcher ilrDispatcher = new IlrDispatcher();
        ClassLoader classLoader = this.buildClassLoader(ilrJavaClassResolver);
        return ilrDispatcher.dispatch(ilrRulesetExecutionRequest, object, classLoader, stringBuffer);
    }

    protected Connection createConnection(ConnectionFactory connectionFactory, String string, Serializable serializable, IlrJavaClassResolver ilrJavaClassResolver, boolean bl) throws ResourceException, MalformedURLException, IOException, ClassNotFoundException {
        IlrXUConnectionSpec ilrXUConnectionSpec = new IlrXUConnectionSpec();
        ilrXUConnectionSpec.setReconnectSupportEnabled(bl);
        ilrXUConnectionSpec.setClientJRulesImplementationVersion("6.5.3.22");
        ilrXUConnectionSpec.setType((byte)0);
        ilrXUConnectionSpec.setRulesetPath(string);
        ilrXUConnectionSpec.setUserData(serializable);
        ilrXUConnectionSpec.setXOMClassLoader(this.buildClassLoader(ilrJavaClassResolver));
        return connectionFactory.getConnection((ConnectionSpec)ilrXUConnectionSpec);
    }

    protected Connection reopenConnection(ConnectionFactory connectionFactory, Object object) throws ResourceException {
        IlrXUConnectionSpec ilrXUConnectionSpec = new IlrXUConnectionSpec();
        ilrXUConnectionSpec.setReconnectSupportEnabled(true);
        ilrXUConnectionSpec.setClientJRulesImplementationVersion("6.5.3.22");
        ilrXUConnectionSpec.setType((byte)2);
        ilrXUConnectionSpec.setConnectionId((IlrConnectionId)object);
        return connectionFactory.getConnection((ConnectionSpec)ilrXUConnectionSpec);
    }

    protected void finalizeConnection(Connection connection) {
        this.javaClassResolver = null;
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    protected IlrSessionRequest callInterceptor(IlrSessionRequest ilrSessionRequest, IlrJavaClassResolver ilrJavaClassResolver, Object object, StringBuffer stringBuffer) throws Exception {
        IlrDispatcher ilrDispatcher = new IlrDispatcher();
        ClassLoader classLoader = this.buildClassLoader(ilrJavaClassResolver);
        return ilrDispatcher.dispatch(ilrSessionRequest, object, classLoader, stringBuffer);
    }

    protected IlrSessionResponse executeStateless(ConnectionFactory connectionFactory, Connection connection, Interaction interaction, IlrSessionRequest ilrSessionRequest, Warnings warnings) throws ResourceException, IlrRuleSessionException {
        IlrSessionDescriptor ilrSessionDescriptor = ilrSessionRequest.getSessionDescriptor();
        IlrSessionFilter ilrSessionFilter = ilrSessionDescriptor.getFilters();
        IlrSessionExecutionSettings ilrSessionExecutionSettings = ilrSessionRequest.getExecutionSettings();
        IlrSessionResponse ilrSessionResponse = new IlrSessionResponse();
        IlrSessionParameters ilrSessionParameters = ilrSessionExecutionSettings.getInputParameters();
        Map map = ilrSessionParameters.getParameters();
        String string = ilrSessionExecutionSettings.getTaskName();
        HashMap hashMap = null;
        boolean bl = ilrSessionExecutionSettings.isBOMAccess();
        IlrSessionExecutionResult ilrSessionExecutionResult = new IlrSessionExecutionResult();
        IlrSessionExecutionProperties ilrSessionExecutionProperties = new IlrSessionExecutionProperties();
        ilrSessionResponse.setExecutionProperties(ilrSessionExecutionProperties);
        ilrSessionResponse.setExecutionResult(ilrSessionExecutionResult);
        long l = 0L;
        MappedRecord mappedRecord = null;
        MappedRecord mappedRecord2 = null;
        if (ilrSessionDescriptor.isTraceEnabled()) {
            ilrSessionExecutionProperties.updateExecutionPropertiesWithEnvElements();
            mappedRecord = this.createMappedRecord("input", connectionFactory);
            mappedRecord2 = this.createMappedRecord("output", connectionFactory);
            mappedRecord.putAll(IlrSessionMappingUtilities.toMap(ilrSessionRequest));
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_ENABLE_RULESET_EXECUTION_INFORMATION);
            this.executeInteraction(interaction, (Record)mappedRecord, warnings);
            if (ilrSessionFilter.infoBoundObjectsByRulesFired()) {
                this.interactionSpec.setRulesetExecutionInformationFilter(1);
            }
            l = System.currentTimeMillis();
        }
        boolean bl2 = ilrSessionFilter == null;
        try {
            hashMap = this.execute(connectionFactory, string, map, warnings, bl, bl2, interaction);
        }
        catch (ResourceException resourceException) {
            if (ilrSessionDescriptor.isTraceEnabled()) {
                String string2 = this.format(resourceException);
                ilrSessionExecutionResult.addError(string2);
                return ilrSessionResponse;
            }
            throw resourceException;
        }
        if (ilrSessionDescriptor.isTraceEnabled()) {
            long l2 = System.currentTimeMillis();
            IlrExecutionTraceInteractionSpec ilrExecutionTraceInteractionSpec = new IlrExecutionTraceInteractionSpec();
            ilrExecutionTraceInteractionSpec.setFunctionName(IlrExecutionTraceInteractionSpec.FUNCTION_NAME_EXECUTION_TRACE);
            this.executeRasInteraction(ilrExecutionTraceInteractionSpec, interaction, (Record)mappedRecord, (Record)mappedRecord2, warnings);
            IlrSessionMappingUtilities.fromMap((Map)mappedRecord2, ilrSessionResponse, ilrSessionFilter);
            if (ilrSessionFilter.infoExecutionDuration()) {
                ilrSessionExecutionResult.setExecutionDuration(l2 - l);
            }
        } else if (bl2) {
            Integer n = (Integer)hashMap.get("ilog.rules.firedRulesCount");
            long l3 = n.intValue();
            ilrSessionExecutionResult.setNumRulesFired(l3);
        }
        if (ilrSessionFilter == null || ilrSessionFilter.infoOutputParameters()) {
            IlrSessionParameters ilrSessionParameters2 = new IlrSessionParameters(hashMap);
            ilrSessionExecutionResult.setOutputParameters(ilrSessionParameters2);
        } else {
            ilrSessionExecutionResult.setOutputParameters(new IlrSessionParameters());
        }
        if (ilrSessionFilter == null || ilrSessionFilter.infoOutputString()) {
            String string3 = this.getIlrContextOutput(interaction, warnings);
            ilrSessionExecutionResult.setOutputString(string3);
        }
        this.calculateMetaData(interaction, ilrSessionExecutionProperties, warnings, ilrSessionDescriptor.getUserData());
        return ilrSessionResponse;
    }

    protected class Warnings
    extends ArrayList {
        public boolean addWarning(ResourceWarning resourceWarning) {
            if (resourceWarning != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(resourceWarning.getErrorCode());
                stringBuffer.append(' ');
                stringBuffer.append(resourceWarning.getLocalizedMessage());
                return this.add(stringBuffer.toString());
            }
            return false;
        }

        boolean addWarning(String string, String string2) {
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                return this.add(stringBuffer.toString());
            }
            return false;
        }

        public String[] getWarnings() {
            if (this.size() > 0) {
                String[] stringArray = new String[this.size()];
                stringArray = this.toArray(stringArray);
                return stringArray;
            }
            return null;
        }

        public ArrayList getWarningsAsList() {
            if (this.size() > 0) {
                return new ArrayList(this);
            }
            return null;
        }
    }
}

