/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.session.IlrRuleSessionCreationException;
import ilog.rules.bres.session.IlrRuleSessionProvider;
import ilog.rules.bres.session.ejb.IlrManagedRuleSessionProvider;
import ilog.rules.bres.session.ejb.IlrRemoteRuleSessionProvider;
import ilog.rules.bres.session.j2se.IlrJ2SERuleSessionProvider;
import ilog.rules.bres.session.java.IlrSimpleRuleSessionProvider;
import java.io.PrintWriter;
import java.util.Properties;

public class IlrRuleSessionProviderFactory {
    public static String J2SE_RULESESSION_PROVIDER = "IlrJ2SERuleSessionProvider";
    public static String MANAGED_RULESESSION_PROVIDER = "IlrManagedRuleSessionProvider";
    public static String REMOTE_RULESESSION_PROVIDER = "IlrRemoteRuleSessionProvider";
    public static String SIMPLE_RULESESSION_PROVIDER = "IlrSimpleRuleSessionProvider";

    public static class Builder {
        private String providerType;
        private PrintWriter logger;
        private Properties jndiContextProperties;
        private boolean loadBalancingEnabled;
        private String jndiNameOfRemoteRuleSessionStateless = "ejb/IlrStatelessRuleSessionEJB";
        private String jndiNameOfRemoteRuleSessionStatefull = "ejb/IlrStatefulRuleSessionEJB";
        private String jndiNameOfLocalRuleSessionStateless = "java:comp/env/ejb/IlrStatelessRuleSessionEJB";
        private String jndiNameOfLocalRuleSessionStatefull = "java:comp/env/ejb/IlrStatefulRuleSessionEJB";
        private String jndiXuConnectorName = "java:comp/env/eis/XUConnectionFactory";

        protected Builder(String string, Properties properties) {
            this.providerType = string;
            this.jndiContextProperties = properties;
        }

        public Builder(Properties properties) {
            this(REMOTE_RULESESSION_PROVIDER, properties);
        }

        public Builder(String string) {
            this(string, null);
        }

        public Builder setLogger(PrintWriter printWriter) {
            this.logger = printWriter;
            return this;
        }

        public Builder setLoadBalancingEnabled(boolean bl) {
            this.loadBalancingEnabled = bl;
            return this;
        }

        public Builder setJNDINameOfRuleSessionStateless(String string) {
            if (this.providerType.equals(REMOTE_RULESESSION_PROVIDER)) {
                this.jndiNameOfRemoteRuleSessionStateless = string;
            } else {
                this.jndiNameOfLocalRuleSessionStateless = string;
            }
            return this;
        }

        public Builder setJNDINameOfRuleSessionStatefull(String string) {
            if (this.providerType.equals(REMOTE_RULESESSION_PROVIDER)) {
                this.jndiNameOfRemoteRuleSessionStatefull = string;
            } else {
                this.jndiNameOfLocalRuleSessionStatefull = string;
            }
            return this;
        }

        public Builder setJNDIXuConnectorName(String string) {
            this.jndiXuConnectorName = string;
            return this;
        }

        private IlrRuleSessionProvider createManagedRuleSessionProvider(String string, String string2) throws IlrRuleSessionCreationException {
            IlrManagedRuleSessionProvider ilrManagedRuleSessionProvider = new IlrManagedRuleSessionProvider();
            ilrManagedRuleSessionProvider.setJndiName(string, string2);
            return ilrManagedRuleSessionProvider;
        }

        private IlrRuleSessionProvider createJ2SERuleSessionProvider(PrintWriter printWriter) throws IlrRuleSessionCreationException {
            return new IlrJ2SERuleSessionProvider(printWriter);
        }

        private IlrRuleSessionProvider createSimpleRuleSessionProvider(String string) throws IlrRuleSessionCreationException {
            return new IlrSimpleRuleSessionProvider(string);
        }

        private IlrRuleSessionProvider createRemoteRuleSessionProvider(Properties properties, boolean bl, String string, String string2) throws IlrRuleSessionCreationException {
            try {
                IlrRemoteRuleSessionProvider ilrRemoteRuleSessionProvider = new IlrRemoteRuleSessionProvider(properties, bl);
                ilrRemoteRuleSessionProvider.setJndiNameOfRuleSessionStateless(string);
                ilrRemoteRuleSessionProvider.setJndiNameOfRuleSessionStatefull(string2);
                return ilrRemoteRuleSessionProvider;
            }
            catch (Throwable throwable) {
                throw new IlrRuleSessionCreationException(throwable);
            }
        }

        public IlrRuleSessionProvider build() throws IlrRuleSessionCreationException {
            Object var1_1 = null;
            if (this.providerType.equals(J2SE_RULESESSION_PROVIDER)) {
                return this.createJ2SERuleSessionProvider(this.logger);
            }
            if (this.providerType.equals(MANAGED_RULESESSION_PROVIDER)) {
                return this.createManagedRuleSessionProvider(this.jndiNameOfLocalRuleSessionStateless, this.jndiNameOfLocalRuleSessionStatefull);
            }
            if (this.providerType.equals(REMOTE_RULESESSION_PROVIDER)) {
                return this.createRemoteRuleSessionProvider(this.jndiContextProperties, this.loadBalancingEnabled, this.jndiNameOfRemoteRuleSessionStateless, this.jndiNameOfRemoteRuleSessionStatefull);
            }
            if (this.providerType.equals(SIMPLE_RULESESSION_PROVIDER)) {
                return this.createSimpleRuleSessionProvider(this.jndiXuConnectorName);
            }
            return null;
        }
    }
}

