/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.ras.model.IlrExecutionTrace;
import ilog.rules.bres.session.IlrSessionFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public class IlrSessionDescriptor
implements Serializable {
    protected IlrSessionFilter filters;
    protected Serializable userData;
    protected boolean interceptorEnabled = false;
    protected String rulesetPath;
    protected String executionTraceId;

    public IlrSessionDescriptor(String string) {
        this.rulesetPath = string;
    }

    public String getRulesetPath() {
        return this.rulesetPath;
    }

    public void setFilters(IlrSessionFilter ilrSessionFilter) {
        this.filters = ilrSessionFilter;
    }

    public void setFilters(InputStream inputStream) throws IOException {
        if (this.filters == null) {
            this.enableTrace();
        }
        this.filters.setFilters(inputStream);
    }

    public IlrSessionFilter getFilters() {
        return this.filters;
    }

    public void addFilterProperty(String string, String string2) {
        if (this.filters != null && string != null) {
            this.filters.setProperty(string, string2);
        }
    }

    public void enableTrace() {
        this.filters = new IlrSessionFilter();
    }

    public boolean isTraceEnabled() {
        return this.filters != null;
    }

    public Properties getFilterProperties() {
        if (this.filters != null) {
            return this.filters.getFilterProperties();
        }
        return null;
    }

    public void setInterceptorEnabled(boolean bl) {
        this.interceptorEnabled = bl;
    }

    public boolean isInterceptorEnabled() {
        return this.interceptorEnabled;
    }

    public void setUserData(Serializable serializable) {
        this.userData = serializable;
    }

    public Serializable getUserData() {
        return this.userData;
    }

    public String getExecutionTraceId() {
        return this.executionTraceId;
    }

    public void setExecutionTraceId(String string) {
        this.executionTraceId = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[execution id=");
        stringBuffer.append(this.executionTraceId);
        stringBuffer.append("]");
        if (this.filters != null) {
            stringBuffer.append("[filters=");
            stringBuffer.append(this.filters.toString());
            stringBuffer.append("]");
        }
        stringBuffer.append("][userData=");
        stringBuffer.append(this.userData);
        stringBuffer.append("][interceptorEnabled=");
        stringBuffer.append(this.interceptorEnabled);
        stringBuffer.append("][rulesetPath=");
        stringBuffer.append(this.rulesetPath);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void copyFrom(IlrExecutionTrace ilrExecutionTrace) {
        this.setUserData(ilrExecutionTrace.getUserData());
        this.setExecutionTraceId(ilrExecutionTrace.getExecutionTraceId());
        this.setInterceptorEnabled(ilrExecutionTrace.getEnableInterceptor());
        Properties properties = ilrExecutionTrace.getFilterProperties();
        this.setFilters(new IlrSessionFilter(properties));
    }
}

