/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.ras.model.IlrExecutionTrace;
import ilog.rules.bres.session.util.IlrDateTime;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;

public class IlrSessionExecutionProperties
implements Serializable {
    protected String canonicalRulesetPath;
    protected Serializable connectionId;
    protected String rulesetPath;
    protected Properties rulesetArchiveProperties;
    protected Properties executionTraceProperties = new Properties();
    protected Serializable userData;
    protected String executionTraceId;

    public void setCanonicalRulesetPath(String string) {
        this.canonicalRulesetPath = string;
    }

    public String getCanonicalRulesetPath() {
        return this.canonicalRulesetPath;
    }

    public void setConnectionId(Serializable serializable) {
        this.connectionId = serializable;
    }

    public Serializable getConnectionId() {
        return this.connectionId;
    }

    public void setRulesetPath(String string) {
        this.rulesetPath = string;
    }

    public String getRulesetPath() {
        return this.rulesetPath;
    }

    public void setRulesetProperties(Properties properties) {
        this.rulesetArchiveProperties = properties;
    }

    public Properties getRulesetProperties() {
        return this.rulesetArchiveProperties;
    }

    String getRulesetArchiveProperty(String string) {
        if (this.rulesetArchiveProperties == null) {
            return null;
        }
        return this.rulesetArchiveProperties.getProperty(string);
    }

    public Enumeration getRulesetArchivePropertiesNames() {
        return this.rulesetArchiveProperties.propertyNames();
    }

    public Properties getExecutionTraceProperties() {
        return this.executionTraceProperties;
    }

    public void setExecutionTraceProperties(Properties properties) {
        this.executionTraceProperties = properties;
    }

    public void addExecutionTraceProperty(String string, String string2) {
        if (string != null) {
            this.executionTraceProperties.setProperty(string, string2);
        }
    }

    public void setUserData(Serializable serializable) {
        this.userData = serializable;
    }

    public Serializable getUserData() {
        return this.userData;
    }

    public String getExecutionTraceId() {
        return this.executionTraceId;
    }

    public void setExecutionTraceId(String string) {
        this.executionTraceId = string;
    }

    private String dateToString(long l) {
        IlrDateTime ilrDateTime = new IlrDateTime(new Date(l), TimeZone.getDefault());
        return ilrDateTime.toString();
    }

    public void updateExecutionPropertiesWithEnvElements() {
        long l = System.currentTimeMillis();
        String string = this.dateToString(l);
        this.addExecutionTraceProperty("execution-date", string);
        try {
            this.addExecutionTraceProperty("ip-address", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            this.addExecutionTraceProperty("ip-address", unknownHostException.getMessage());
        }
        try {
            this.addExecutionTraceProperty("hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            this.addExecutionTraceProperty("hostname", unknownHostException.getMessage());
        }
        this.addExecutionTraceProperty("username", System.getProperty("user.name"));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[ruleset path=");
        stringBuffer.append(this.rulesetPath);
        stringBuffer.append("][canonical ruleset path=");
        stringBuffer.append(this.canonicalRulesetPath);
        stringBuffer.append("][connection id=");
        stringBuffer.append(this.connectionId);
        stringBuffer.append("][userData=");
        stringBuffer.append(this.userData);
        stringBuffer.append("][ruleset archive properties=");
        stringBuffer.append(this.rulesetArchiveProperties);
        stringBuffer.append("][execution trace properties=");
        stringBuffer.append(this.executionTraceProperties);
        stringBuffer.append("][execution trace id=");
        stringBuffer.append(this.executionTraceId);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void copyTo(IlrExecutionTrace ilrExecutionTrace) {
        String string;
        String string2;
        String string3;
        String string4 = this.executionTraceProperties.getProperty("hostname");
        if (string4 != null) {
            ilrExecutionTrace.addExecutionTraceProperty("hostname", string4);
        }
        if ((string3 = this.executionTraceProperties.getProperty("ip-address")) != null) {
            ilrExecutionTrace.addExecutionTraceProperty("ip-address", string3);
        }
        if ((string2 = this.executionTraceProperties.getProperty("username")) != null) {
            ilrExecutionTrace.addExecutionTraceProperty("username", string2);
        }
        if ((string = this.executionTraceProperties.getProperty("execution-date")) != null) {
            ilrExecutionTrace.addExecutionTraceProperty("execution-date", string);
        }
        ilrExecutionTrace.setConnectionId(this.connectionId);
        ilrExecutionTrace.setCanonicalRulesetPath(this.canonicalRulesetPath);
    }
}

