/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.ras.model.IlrExecutionTrace;
import ilog.rules.bres.session.IlrSessionFilter;
import ilog.rules.bres.session.IlrSessionParameters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class IlrSessionExecutionResult
implements Serializable {
    protected IlrSessionParameters outputParameters;
    protected long numRulesFired = -1L;
    protected ArrayList rulesFired;
    protected ArrayList rulesNotFired;
    protected ArrayList allRules;
    protected long numRulesNotFired = -1L;
    protected long numTasksExecuted = -1L;
    protected ArrayList tasksExecuted;
    protected ArrayList tasksNotExecuted;
    protected ArrayList allTasks;
    protected long numTasksNotExecuted = -1L;
    protected Object[] workingMemory;
    protected long executionDuration = -1L;
    protected String interceptorClassNameUsed = null;
    protected ArrayList warnings;
    protected ArrayList errors;
    protected String outputString;
    public static final String NUM_RULES_FIRED = "ilog_rules_bres_mdb_num_rules_fired";
    public static final String RULES_FIRED = "ilog_rules_bres_mdb_rules_fired";
    public static final String ALL_RULES = "ilog_rules_bres_mdb_all_rules";
    public static final String NUM_RULES_NOT_FIRED = "ilog_rules_bres_mdb_num_rules_not_fired";
    public static final String NUM_TASKS_EXECUTED = "ilog_rules_bres_mdb_num_tasks_executed";
    public static final String NUM_TASKS_NOT_EXECUTED = "ilog_rules_bres_mdb_num_tasks_not_executed";
    public static final String TASKS_EXECUTED = "ilog_rules_bres_mdb_tasks_executed";
    public static final String ALL_TASKS = "ilog_rules_bres_mdb_all_tasks";
    public static final String EXECUTION_DURATION = "ilog_rules_bres_mdb_execution_duration";
    public static final String CONTEXT_OUT = "ilog_rules_bres_mdb_contextOut";

    public void setOutputParameters(IlrSessionParameters ilrSessionParameters) {
        this.outputParameters = ilrSessionParameters;
    }

    public IlrSessionParameters getOutputParameters() {
        return this.outputParameters;
    }

    public void setNumRulesFired(long l) {
        this.numRulesFired = l;
    }

    public long getNumRulesFired() {
        return this.numRulesFired;
    }

    public void setRulesFired(ArrayList arrayList) {
        this.rulesFired = arrayList;
    }

    public void setRulesNotFired(ArrayList arrayList) {
        this.rulesNotFired = arrayList;
    }

    public ArrayList getRulesFired() {
        return this.rulesFired;
    }

    public ArrayList getRulesNotFired() {
        return this.rulesNotFired;
    }

    public void setAllRules(ArrayList arrayList) {
        this.allRules = arrayList;
    }

    public ArrayList getAllRules() {
        return this.allRules;
    }

    public void setNumRulesNotFired(long l) {
        this.numRulesNotFired = l;
    }

    public long getNumRulesNotFired() {
        return this.numRulesNotFired;
    }

    public void setNumTasksExecuted(long l) {
        this.numTasksExecuted = l;
    }

    public long getNumTasksExecuted() {
        return this.numTasksExecuted;
    }

    public void setTasksExecuted(ArrayList arrayList) {
        this.tasksExecuted = arrayList;
    }

    public void setTasksNotExecuted(ArrayList arrayList) {
        this.tasksNotExecuted = arrayList;
    }

    public ArrayList getTasksExecuted() {
        return this.tasksExecuted;
    }

    public ArrayList getTasksNotExecuted() {
        return this.tasksNotExecuted;
    }

    public void setAllTasks(ArrayList arrayList) {
        this.allTasks = arrayList;
    }

    public ArrayList getAllTasks() {
        return this.allTasks;
    }

    public void setNumTasksNotExecuted(long l) {
        this.numTasksNotExecuted = l;
    }

    public long getNumTasksNotExecuted() {
        return this.numTasksNotExecuted;
    }

    public void setExecutionDuration(long l) {
        this.executionDuration = l;
    }

    public long getExecutionDuration() {
        return this.executionDuration;
    }

    public void setWorkingMemory(Object[] objectArray) {
        this.workingMemory = objectArray;
    }

    public Object[] getWorkingMemory() {
        return this.workingMemory;
    }

    public void setInterceptorClassNameUsed(String string) {
        this.interceptorClassNameUsed = string;
    }

    public String getInterceptorClassNameUsed() {
        return this.interceptorClassNameUsed;
    }

    public void setWarnings(ArrayList arrayList) {
        this.warnings = arrayList;
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    public void setErrors(ArrayList arrayList) {
        this.errors = arrayList;
    }

    public void addError(String string) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        this.errors.add(string);
    }

    public ArrayList getErrors() {
        return this.errors;
    }

    public void setOutputString(String string) {
        this.outputString = string;
    }

    public String getOutputString() {
        return this.outputString;
    }

    public void toMap(Map map, IlrSessionFilter ilrSessionFilter) {
        if (ilrSessionFilter.infoNumRulesFired()) {
            map.put(NUM_RULES_FIRED, new Long(this.numRulesFired));
        }
        if (ilrSessionFilter.infoRulesFired()) {
            map.put(RULES_FIRED, this.rulesFired);
        }
        if (ilrSessionFilter.infoNumRulesNotFired()) {
            map.put(NUM_RULES_NOT_FIRED, new Long(this.numRulesNotFired));
            if (ilrSessionFilter.infoNumRulesFired()) {
                map.put(ALL_RULES, this.allRules);
            }
        }
        if (ilrSessionFilter.infoNumTasksExecuted()) {
            map.put(NUM_TASKS_EXECUTED, new Long(this.numTasksExecuted));
        }
        if (ilrSessionFilter.infoTasksExecuted()) {
            map.put(TASKS_EXECUTED, this.tasksExecuted);
        }
        if (ilrSessionFilter.infoTasksNotExecuted()) {
            map.put(NUM_TASKS_NOT_EXECUTED, new Long(this.numTasksNotExecuted));
            if (ilrSessionFilter.infoNumTasksExecuted()) {
                map.put(ALL_TASKS, this.allTasks);
            }
        }
        if (ilrSessionFilter.infoExecutionDuration()) {
            map.put(EXECUTION_DURATION, new Long(this.executionDuration));
        }
        if (ilrSessionFilter.infoOutputString() && this.outputString != null) {
            map.put(CONTEXT_OUT, this.outputString);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[numRulesFired=");
        stringBuffer.append(this.numRulesFired);
        stringBuffer.append("][rulesFired=");
        this.printList(this.rulesFired, stringBuffer);
        stringBuffer.append("][numRulesNotFired=");
        stringBuffer.append(this.numRulesNotFired);
        stringBuffer.append("][numTasksExecuted=");
        stringBuffer.append(this.numTasksExecuted);
        stringBuffer.append("[tasksExecuted=");
        this.printList(this.tasksExecuted, stringBuffer);
        stringBuffer.append("][numTasksNotExecuted=");
        stringBuffer.append(this.numTasksNotExecuted);
        stringBuffer.append("][workingMemory=");
        this.printArray(this.workingMemory, stringBuffer);
        stringBuffer.append("][outputString=");
        stringBuffer.append(this.outputString);
        stringBuffer.append("][executionDuration=");
        stringBuffer.append(this.executionDuration);
        stringBuffer.append("][interceptorClassNameUsed=");
        stringBuffer.append(this.interceptorClassNameUsed);
        stringBuffer.append("][warnings=");
        this.printList(this.warnings, stringBuffer);
        stringBuffer.append("][errors=");
        this.printList(this.errors, stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void printList(ArrayList arrayList, StringBuffer stringBuffer) {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                stringBuffer.append(string);
                if (i >= n - 1) continue;
                stringBuffer.append(",");
            }
        }
    }

    private void printArray(Object[] objectArray, StringBuffer stringBuffer) {
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(objectArray[i]);
                if (i >= n - 1) continue;
                stringBuffer.append(",");
            }
        }
    }

    void copyTo(IlrExecutionTrace ilrExecutionTrace) {
        if (this.outputParameters != null) {
            ilrExecutionTrace.setOutputParameters(this.outputParameters.getParameters());
        }
        ilrExecutionTrace.setInterceptorClassNameUsed(this.interceptorClassNameUsed);
        ilrExecutionTrace.setNumRulesFired(this.numRulesFired);
        ilrExecutionTrace.setNumRulesNotFired(this.numRulesNotFired);
        ilrExecutionTrace.setNumTasksExecuted(this.numTasksExecuted);
        ilrExecutionTrace.setNumTasksNotExecuted(this.numTasksNotExecuted);
        ilrExecutionTrace.setExecutionDuration(this.executionDuration);
        ilrExecutionTrace.setOutputString(this.outputString);
        ilrExecutionTrace.setWorkingMemory(this.workingMemory);
        Iterator iterator = null;
        if (this.rulesFired != null && this.rulesFired.size() > 0) {
            iterator = this.rulesFired.iterator();
            while (iterator.hasNext()) {
                ilrExecutionTrace.addRuleFired((String)iterator.next());
            }
        }
        if (this.allRules != null && this.allRules.size() > 0) {
            iterator = this.allRules.iterator();
            while (iterator.hasNext()) {
                ilrExecutionTrace.addToAllRules((String)iterator.next());
            }
        }
        if (this.tasksExecuted != null && this.tasksExecuted.size() > 0) {
            iterator = this.tasksExecuted.iterator();
            while (iterator.hasNext()) {
                ilrExecutionTrace.addTaskExecuted((String)iterator.next());
            }
        }
        if (this.allTasks != null && this.allTasks.size() > 0) {
            iterator = this.allTasks.iterator();
            while (iterator.hasNext()) {
                ilrExecutionTrace.addToAllTasks((String)iterator.next());
            }
        }
        if (this.warnings != null && this.warnings.size() > 0) {
            iterator = this.warnings.iterator();
            while (iterator.hasNext()) {
                ilrExecutionTrace.addWarningMessage((String)iterator.next());
            }
        }
        if (this.errors != null && this.errors.size() > 0) {
            iterator = this.errors.iterator();
            while (iterator.hasNext()) {
                ilrExecutionTrace.addErrorMessage((String)iterator.next());
            }
        }
    }
}

