/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.session.util.IlrMessages;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class IlrSessionParameters
implements Serializable {
    protected Map parameters;

    public IlrSessionParameters() {
        this.parameters = new HashMap();
    }

    public IlrSessionParameters(Map map) {
        this.parameters = map;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map map) {
        this.parameters.putAll(map);
    }

    public void setParameter(String string, boolean bl) {
        this.parameters.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setParameter(String string, byte by) {
        this.parameters.put(string, new Byte(by));
    }

    public void setParameter(String string, char c) {
        this.parameters.put(string, new Character(c));
    }

    public void setParameter(String string, int n) {
        this.parameters.put(string, new Integer(n));
    }

    public void setParameter(String string, float f) {
        this.parameters.put(string, new Float(f));
    }

    public void setParameter(String string, double d) {
        this.parameters.put(string, new Double(d));
    }

    public void setParameter(String string, short s) {
        this.parameters.put(string, new Short(s));
    }

    public void setParameter(String string, long l) {
        this.parameters.put(string, new Long(l));
    }

    public void setParameter(String string, Object object) {
        this.parameters.put(string, object);
    }

    public void setParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    private void checkKnownParameter(String string) {
        boolean bl = this.parameters.containsKey(string);
        if (!bl) {
            IlrMessages.getMessages();
            String string2 = IlrMessages.getMessage("10001", string);
            throw new IllegalArgumentException(string2);
        }
    }

    public boolean getBooleanValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10002", string);
        throw new ClassCastException(string2);
    }

    public byte getByteValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v instanceof Byte) {
            return (Byte)v;
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10003", string);
        throw new ClassCastException(string2);
    }

    public char getCharValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v instanceof Character) {
            return ((Character)v).charValue();
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10004", string);
        throw new ClassCastException(string2);
    }

    public int getIntValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10005", string);
        throw new ClassCastException(string2);
    }

    public float getFloatValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v instanceof Float) {
            return ((Float)v).floatValue();
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10006", string);
        throw new ClassCastException(string2);
    }

    public double getDoubleValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v instanceof Double) {
            return (Double)v;
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10007", string);
        throw new ClassCastException(string2);
    }

    public short getShortValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v instanceof Short) {
            return (Short)v;
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10008", string);
        throw new ClassCastException(string2);
    }

    public long getLongValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v instanceof Long) {
            return (Long)v;
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10009", string);
        throw new ClassCastException(string2);
    }

    public Object getObjectValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        return v;
    }

    public String getStringValue(String string) {
        this.checkKnownParameter(string);
        Object v = this.parameters.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        IlrMessages.getMessages();
        String string2 = IlrMessages.getMessage("10010", string);
        throw new ClassCastException(string2);
    }

    public void clear() {
        this.parameters.clear();
    }
}

