/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.ras.model.IlrExecutionTrace;
import ilog.rules.bres.ras.model.IlrExecutionTraceSerializationException;
import ilog.rules.bres.session.IlrSessionDescriptor;
import ilog.rules.bres.session.IlrSessionExecutionSettings;
import ilog.rules.bres.session.IlrSessionStatefulExecutionSettings;
import java.io.Serializable;

public class IlrSessionRequest
implements Serializable {
    protected IlrSessionExecutionSettings executionSettings;
    protected IlrSessionDescriptor sessionDescriptor;

    private IlrSessionRequest(IlrSessionDescriptor ilrSessionDescriptor, IlrSessionExecutionSettings ilrSessionExecutionSettings) {
        this.sessionDescriptor = ilrSessionDescriptor;
        this.executionSettings = ilrSessionExecutionSettings;
    }

    public IlrSessionRequest(String string) {
        this(new IlrSessionDescriptor(string), new IlrSessionExecutionSettings());
    }

    public IlrSessionRequest(String string, boolean bl) {
        this(new IlrSessionDescriptor(string), new IlrSessionStatefulExecutionSettings(bl));
    }

    public IlrSessionExecutionSettings getExecutionSettings() {
        return this.executionSettings;
    }

    public IlrSessionDescriptor getSessionDescriptor() {
        return this.sessionDescriptor;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.executionSettings != null) {
            stringBuffer.append(this.executionSettings.toString());
        }
        if (this.sessionDescriptor != null) {
            stringBuffer.append(this.sessionDescriptor.toString());
        }
        return stringBuffer.toString();
    }

    public static IlrSessionRequest createRequest(IlrExecutionTrace ilrExecutionTrace) throws IlrExecutionTraceSerializationException {
        IlrSessionRequest ilrSessionRequest = new IlrSessionRequest(ilrExecutionTrace.getRulesetPath());
        IlrSessionDescriptor ilrSessionDescriptor = ilrSessionRequest.getSessionDescriptor();
        ilrSessionDescriptor.copyFrom(ilrExecutionTrace);
        IlrSessionExecutionSettings ilrSessionExecutionSettings = ilrSessionRequest.getExecutionSettings();
        ilrSessionExecutionSettings.copyFrom(ilrExecutionTrace);
        return ilrSessionRequest;
    }
}

