/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session;

import ilog.rules.bres.ras.plugin.IlrExecutionTraceInteractionSpec;
import ilog.rules.bres.session.IlrRuleExecutionResult;
import ilog.rules.bres.session.IlrRuleSessionExecuteImpl;
import ilog.rules.bres.session.IlrSessionDescriptor;
import ilog.rules.bres.session.IlrSessionExecutionProperties;
import ilog.rules.bres.session.IlrSessionExecutionResult;
import ilog.rules.bres.session.IlrSessionFilter;
import ilog.rules.bres.session.IlrSessionMappingUtilities;
import ilog.rules.bres.session.IlrSessionParameters;
import ilog.rules.bres.session.IlrSessionStatefulExecutionSettings;
import ilog.rules.bres.session.util.IlrHandleList;
import ilog.rules.bres.session.util.IlrHandleMap;
import ilog.rules.bres.session.util.IlrRuleSessionHandle;
import ilog.rules.bres.xu.cci.IlrRuleEngineInteractionSpec;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;

public abstract class IlrStatefulRuleSessionImpl
extends IlrRuleSessionExecuteImpl
implements Serializable {
    protected IlrRuleSessionExecuteImpl.Warnings warnings = null;
    protected Serializable userData = null;
    protected IlrSessionDescriptor requestDescriptor;
    protected String interceptorClassNameUsed;
    protected String irlOutputString;
    protected IlrSessionExecutionProperties executionPpties;

    protected void add(ConnectionFactory connectionFactory, Connection connection, IlrHandleList ilrHandleList) throws Exception {
        if (ilrHandleList != null) {
            IndexedRecord indexedRecord = this.createIndexedRecord("input", connectionFactory);
            Iterator iterator = ilrHandleList.getIteratorOfHandle();
            while (iterator.hasNext()) {
                IlrRuleSessionHandle ilrRuleSessionHandle = (IlrRuleSessionHandle)iterator.next();
                indexedRecord.add((Object)ilrRuleSessionHandle.getGuid());
                Integer n = new Integer(ilrRuleSessionHandle.getType());
                indexedRecord.add((Object)n);
                indexedRecord.add(ilrRuleSessionHandle.getValue());
            }
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INSERT_WITH_ID);
            this.createAndExecuteInteraction(connection, (Record)indexedRecord, this.warnings);
        }
    }

    protected void remove(ConnectionFactory connectionFactory, Connection connection, IlrHandleList ilrHandleList) throws ResourceException {
        if (ilrHandleList != null) {
            IndexedRecord indexedRecord = this.createIndexedRecord("input", connectionFactory);
            Iterator iterator = ilrHandleList.getIteratorOfHandle();
            while (iterator.hasNext()) {
                IlrRuleSessionHandle ilrRuleSessionHandle = (IlrRuleSessionHandle)iterator.next();
                indexedRecord.add((Object)ilrRuleSessionHandle.getGuid());
            }
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RETRACT_BY_ID);
            this.createAndExecuteInteraction(connection, (Record)indexedRecord, this.warnings);
        }
    }

    protected void change(ConnectionFactory connectionFactory, Connection connection, IlrHandleList ilrHandleList) throws Exception {
        if (ilrHandleList != null) {
            IndexedRecord indexedRecord = this.createIndexedRecord("input", connectionFactory);
            IndexedRecord indexedRecord2 = this.createIndexedRecord("input", connectionFactory);
            Iterator iterator = ilrHandleList.getIteratorOfHandle();
            while (iterator.hasNext()) {
                IlrRuleSessionHandle ilrRuleSessionHandle = (IlrRuleSessionHandle)iterator.next();
                indexedRecord.add((Object)ilrRuleSessionHandle.getGuid());
                indexedRecord2.add((Object)ilrRuleSessionHandle.getGuid());
                Integer n = new Integer(ilrRuleSessionHandle.getType());
                indexedRecord2.add((Object)n);
                indexedRecord2.add(ilrRuleSessionHandle.getValue());
            }
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RETRACT_BY_ID);
            this.createAndExecuteInteraction(connection, (Record)indexedRecord, this.warnings);
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INSERT_WITH_ID);
            this.createAndExecuteInteraction(connection, (Record)indexedRecord2, this.warnings);
        }
    }

    protected List getWorkingMemoryObject(ConnectionFactory connectionFactory, Connection connection) throws ResourceException {
        this.interactionSpec.setFunctionName("ruleEngine.getWorkingMemory");
        return (IndexedRecord)this.createAndExecuteInteraction(connection, null, this.warnings);
    }

    protected Map getWorkingMemoryObjectWithID(ConnectionFactory connectionFactory, Connection connection) throws ResourceException {
        this.interactionSpec.setFunctionName("ruleEngine.getWorkingMemoryWithId");
        return (MappedRecord)this.createAndExecuteInteraction(connection, null, this.warnings);
    }

    protected IlrHandleList getAllKnownWorkingMemoryAsHandle(ConnectionFactory connectionFactory, Connection connection) throws ResourceException {
        Map map = this.getWorkingMemoryObjectWithID(connectionFactory, connection);
        if (map != null) {
            IlrHandleList ilrHandleList = new IlrHandleList();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ilrHandleList.addHandle(new IlrRuleSessionHandle(entry.getKey(), entry.getValue(), 0));
            }
            return ilrHandleList;
        }
        return null;
    }

    protected IlrSessionExecutionResult execute(ConnectionFactory connectionFactory, IlrSessionStatefulExecutionSettings ilrSessionStatefulExecutionSettings, Interaction interaction) throws Exception {
        boolean bl = ilrSessionStatefulExecutionSettings.getResetRuleflow();
        String string = ilrSessionStatefulExecutionSettings.getTaskName();
        IlrSessionParameters ilrSessionParameters = ilrSessionStatefulExecutionSettings.getInputParameters();
        boolean bl2 = ilrSessionStatefulExecutionSettings.isBOMAccess();
        IlrSessionFilter ilrSessionFilter = this.requestDescriptor.getFilters();
        IlrSessionExecutionResult ilrSessionExecutionResult = new IlrSessionExecutionResult();
        MappedRecord mappedRecord = null;
        MappedRecord mappedRecord2 = null;
        long l = 0L;
        if (this.requestDescriptor.isTraceEnabled()) {
            this.executionPpties = new IlrSessionExecutionProperties();
            this.executionPpties.updateExecutionPropertiesWithEnvElements();
            mappedRecord = this.createMappedRecord("input", connectionFactory);
            mappedRecord2 = this.createMappedRecord("output", connectionFactory);
            mappedRecord.putAll(IlrSessionMappingUtilities.toMap(this.requestDescriptor, ilrSessionStatefulExecutionSettings));
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_ENABLE_RULESET_EXECUTION_INFORMATION);
            this.executeInteraction(interaction, (Record)mappedRecord, this.warnings);
            if (ilrSessionFilter.infoBoundObjectsByRulesFired()) {
                this.interactionSpec.setRulesetExecutionInformationFilter(1);
            }
            l = System.currentTimeMillis();
        }
        HashMap hashMap = this.execute(connectionFactory, string, ilrSessionParameters.getParameters(), this.warnings, bl2, false, interaction);
        if (this.requestDescriptor.isTraceEnabled()) {
            long l2 = System.currentTimeMillis();
            IlrExecutionTraceInteractionSpec ilrExecutionTraceInteractionSpec = new IlrExecutionTraceInteractionSpec();
            ilrExecutionTraceInteractionSpec.setFunctionName(IlrExecutionTraceInteractionSpec.FUNCTION_NAME_EXECUTION_TRACE);
            this.executeRasInteraction(ilrExecutionTraceInteractionSpec, interaction, (Record)mappedRecord, (Record)mappedRecord2, this.warnings);
            IlrSessionMappingUtilities.fromMap((Map)mappedRecord2, ilrSessionExecutionResult, this.executionPpties, ilrSessionFilter);
            if (ilrSessionFilter.infoExecutionDuration()) {
                ilrSessionExecutionResult.setExecutionDuration(l2 - l);
            }
        }
        if (bl) {
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RULEFLOW_RESET);
            this.executeInteraction(interaction, null, this.warnings);
        }
        if (ilrSessionFilter == null || ilrSessionFilter.infoOutputParameters()) {
            IlrSessionParameters ilrSessionParameters2 = new IlrSessionParameters(hashMap);
            ilrSessionExecutionResult.setOutputParameters(ilrSessionParameters2);
        } else {
            ilrSessionExecutionResult.setOutputParameters(new IlrSessionParameters());
        }
        this.irlOutputString = this.getIlrContextOutput(interaction, this.warnings);
        if (ilrSessionFilter == null || ilrSessionFilter.infoOutputString()) {
            ilrSessionExecutionResult.setOutputString(this.irlOutputString);
        }
        if (this.interceptorClassNameUsed != null) {
            ilrSessionExecutionResult.setInterceptorClassNameUsed(this.interceptorClassNameUsed);
        }
        return ilrSessionExecutionResult;
    }

    protected HashMap execute(ConnectionFactory connectionFactory, String string, Map map, boolean bl, Interaction interaction) throws Exception {
        HashMap hashMap = null;
        hashMap = this.execute(connectionFactory, string, map, this.warnings, false, true, interaction);
        if (bl) {
            this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RULEFLOW_RESET);
            this.executeInteraction(interaction, null, this.warnings);
        }
        return hashMap;
    }

    protected IlrRuleExecutionResult executeDeprecated(ConnectionFactory connectionFactory, IlrHandleMap ilrHandleMap, boolean bl, Interaction interaction) throws Exception {
        HashMap hashMap = null;
        String string = null;
        if (ilrHandleMap != null) {
            hashMap = new HashMap(ilrHandleMap.size());
            ilrHandleMap.fillWithNoHandle(hashMap);
            string = ilrHandleMap.getMainTask();
        }
        HashMap hashMap2 = this.execute(connectionFactory, string, hashMap, bl, interaction);
        String string2 = this.getIlrContextOutput(interaction, this.warnings);
        IlrRuleExecutionResult ilrRuleExecutionResult = new IlrRuleExecutionResult();
        if (hashMap2 != null) {
            ilrRuleExecutionResult.parametersOut = new IlrHandleMap();
            ilrRuleExecutionResult.parametersOut.putAll(hashMap2);
        }
        ilrRuleExecutionResult.output = string2;
        return ilrRuleExecutionResult;
    }

    protected Serializable evaluateIrl(ConnectionFactory connectionFactory, Connection connection, String string) throws ResourceException {
        IndexedRecord indexedRecord = this.createIndexedRecord("input", connectionFactory);
        this.interactionSpec.setFunctionName(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EVALUATE);
        indexedRecord.add((Object)string);
        IndexedRecord indexedRecord2 = (IndexedRecord)this.createAndExecuteInteraction(connection, (Record)indexedRecord, this.warnings);
        return (Serializable)indexedRecord2.get(0);
    }

    protected void createWarning() {
        this.warnings = new IlrRuleSessionExecuteImpl.Warnings();
    }

    protected void serializeWarning() {
        this.warnings = null;
    }

    protected void reinit(ConnectionFactory connectionFactory, Connection connection) throws ResourceException {
        this.cleanContext(connectionFactory, connection, this.warnings);
    }

    protected String[] buildandClearWarnings() {
        String[] stringArray = this.warnings.getWarnings();
        this.warnings.clear();
        return stringArray;
    }
}

