/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.dispatch;

import ilog.rules.bres.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.bres.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.IlrRepository;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.impl.IlrRepositoryFactoryImpl;
import ilog.rules.bres.persistence.IlrAbstractTransactionalResourceProvider;
import ilog.rules.bres.persistence.IlrResourceProviderException;
import ilog.rules.bres.persistence.file.IlrFileResourceProvider;
import ilog.rules.bres.persistence.jdbc.IlrDbResourceProvider;
import ilog.rules.bres.session.dispatch.IlrModelExplorer;
import ilog.rules.bres.session.dispatch.IlrRuleAppViewImpl;
import ilog.rules.bres.session.interceptor.IlrRuleAppView;
import ilog.rules.bres.xu.cmanager.IlrConfigProperty;
import ilog.rules.bres.xu.cmanager.IlrDescriptor;
import ilog.rules.bres.xu.cmanager.IlrDescriptorException;
import ilog.rules.bres.xu.cmanager.IlrDescriptorParser;
import ilog.rules.bres.xu.util.IlrPropertiesParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class IlrJ2SEModelExplorer
extends IlrModelExplorer {
    static String PROVIDER_CLASS = "rulesetArchiveInformationProviderClass";
    static String PROVIDER_PROPERTIES = "rulesetArchiveInformationProviderProperties";
    static String PROVIDER_J2EE_DB = "ilog.rules.bres.xu.ruleset.jdbc.IlrJdbcRulesetInformationProvider";
    static String PROVIDER_J2SE_DB = "ilog.rules.bres.xu.ruleset.jdbc.IlrJ2SERulesetInformationProvider";
    static String PROVIDER_J2SE_FILE = "ilog.rules.bres.xu.ruleset.fs.IlrFileRulesetInformationProvider";
    static String PATH_TO_DIR = "ilog.rules.bres.xu.ruleset.fs.IlrFileRulesetInformationProvider.repositoryDirPath";
    static String DATASOURCE_NAME = "DATASOURCE_NAME";
    static String DRIVER_CLASS = "DRIVERCLASS_NAME";
    static String URL = "URL";
    static String USER = "USER";
    static String PASSWD = "PASSWORD";
    private InputStream streamOnRaXml;
    private Properties properties;

    public IlrJ2SEModelExplorer(InputStream inputStream) {
        this.streamOnRaXml = inputStream;
    }

    IlrRuleAppInformation getRuleAppInformation(IlrPath ilrPath) throws Exception {
        IlrRepository ilrRepository = this.initializeModel();
        IlrRuleAppInformation ilrRuleAppInformation = ilrPath.getRuleAppVersion() == null ? ilrRepository.getGreatestRuleApp(ilrPath.getRuleAppName()) : ilrRepository.getRuleApp(ilrPath.getRuleAppName(), ilrPath.getRuleAppVersion());
        if (ilrRuleAppInformation == null) {
            throw new IllegalArgumentException(ilrPath.toString());
        }
        return ilrRuleAppInformation;
    }

    IlrRuleAppView getRuleAppView(IlrPath ilrPath) throws Exception {
        IlrRepository ilrRepository = this.initializeModel();
        IlrRuleAppInformation ilrRuleAppInformation = ilrPath.getRuleAppVersion() == null ? ilrRepository.getGreatestRuleApp(ilrPath.getRuleAppName()) : ilrRepository.getRuleApp(ilrPath.getRuleAppName(), ilrPath.getRuleAppVersion());
        if (ilrRuleAppInformation == null) {
            throw new IllegalArgumentException(ilrPath.toString());
        }
        IlrRuleAppViewImpl ilrRuleAppViewImpl = new IlrRuleAppViewImpl();
        ilrRuleAppViewImpl.setRuleAppPath(ilrRuleAppInformation.getName(), ilrRuleAppInformation.getVersion().toString());
        ilrRuleAppViewImpl.setRuleAppProperties(ilrRuleAppInformation.getProperties().toProperties());
        Iterator iterator = ilrRuleAppInformation.getRulesets().iterator();
        while (iterator.hasNext()) {
            IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation = (IlrMutableRulesetArchiveInformation)iterator.next();
            ilrRuleAppViewImpl.addRuleset(ilrMutableRulesetArchiveInformation.getName(), ilrMutableRulesetArchiveInformation.getVersion().toString(), ilrMutableRulesetArchiveInformation.getProperties().toProperties());
        }
        return ilrRuleAppViewImpl;
    }

    public IlrRepository initializeModel() throws IlrResourceProviderException, IOException, IlrIllegalArgumentRuntimeException, IlrDescriptorException {
        Serializable serializable;
        IlrAbstractTransactionalResourceProvider ilrAbstractTransactionalResourceProvider;
        this.parseProperties();
        if (this.properties.getProperty(PROVIDER_CLASS).equals(PROVIDER_J2SE_DB)) {
            ilrAbstractTransactionalResourceProvider = new IlrDbResourceProvider(this.getClass().getClassLoader(), this.properties.getProperty(DRIVER_CLASS), this.properties.getProperty(URL), this.properties.getProperty(USER), this.properties.getProperty(PASSWD));
        } else if (this.properties.getProperty(PROVIDER_CLASS).equals(PROVIDER_J2SE_FILE)) {
            if (this.properties.getProperty(PATH_TO_DIR) == null) {
                ilrAbstractTransactionalResourceProvider = new IlrFileResourceProvider();
            } else {
                serializable = new File(this.properties.getProperty(PATH_TO_DIR));
                ilrAbstractTransactionalResourceProvider = new IlrFileResourceProvider(((File)serializable).getCanonicalPath());
            }
        } else if (this.properties.getProperty(PROVIDER_CLASS).equals(PROVIDER_J2EE_DB)) {
            ilrAbstractTransactionalResourceProvider = new IlrDbResourceProvider(this.properties.getProperty(DATASOURCE_NAME));
        } else {
            throw new IllegalArgumentException(this.properties.toString());
        }
        serializable = new IlrRepositoryFactoryImpl();
        return ((IlrRepositoryFactoryImpl)serializable).createRepository(ilrAbstractTransactionalResourceProvider);
    }

    protected void parseProperties() throws IlrDescriptorException {
        IlrDescriptorParser ilrDescriptorParser = new IlrDescriptorParser();
        IlrDescriptor ilrDescriptor = ilrDescriptorParser.parse(this.streamOnRaXml);
        List list = ilrDescriptor.getConfigProperties();
        this.properties = new Properties();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IlrConfigProperty ilrConfigProperty = (IlrConfigProperty)iterator.next();
            if (ilrConfigProperty.getName().equalsIgnoreCase(PROVIDER_CLASS)) {
                this.properties.setProperty(PROVIDER_CLASS, ilrConfigProperty.getValue().toString());
            }
            if (!ilrConfigProperty.getName().equalsIgnoreCase(PROVIDER_PROPERTIES)) continue;
            IlrPropertiesParser ilrPropertiesParser = new IlrPropertiesParser();
            this.properties.putAll((Map<?, ?>)ilrPropertiesParser.parse(ilrConfigProperty.getValue().toString()));
        }
    }
}

