/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.ejb;

import ilog.rules.bres.session.IlrRuleExecutionResult;
import ilog.rules.bres.session.IlrRuleSessionCreationException;
import ilog.rules.bres.session.IlrRuleSessionException;
import ilog.rules.bres.session.IlrRuleSessionMetaData;
import ilog.rules.bres.session.IlrRulesetExecutionRequest;
import ilog.rules.bres.session.IlrSessionExecutionProperties;
import ilog.rules.bres.session.IlrSessionExecutionResult;
import ilog.rules.bres.session.IlrSessionParameters;
import ilog.rules.bres.session.IlrSessionRequest;
import ilog.rules.bres.session.IlrSessionStatefulExecutionSettings;
import ilog.rules.bres.session.IlrStatefulRuleSessionImpl;
import ilog.rules.bres.session.connectmngt.IlrJ2EEConnectionFactoryFinder;
import ilog.rules.bres.session.ejb.IlrJndiEnvVariablesReader;
import ilog.rules.bres.session.util.IlrHandleList;
import ilog.rules.bres.session.util.IlrHandleMap;
import ilog.rules.bres.session.util.IlrJavaClassResolver;
import ilog.rules.bres.session.util.IlrRuleSessionExecutionHelper;
import ilog.rules.bres.session.util.IlrStatefulRuleSessionHelper;
import ilog.rules.bres.session.util.IlrTracePrinter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.Interaction;

public class IlrStatefulRuleSessionEJB
extends IlrStatefulRuleSessionImpl
implements SessionBean,
SessionSynchronization {
    private SessionContext ejbContext = null;
    private boolean freeContext;
    protected ConnectionFactory connectionFactory = null;
    protected Connection connection = null;
    protected Serializable connectionId;
    protected boolean isTraceOn = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbCreate(String string, Serializable serializable, IlrJavaClassResolver ilrJavaClassResolver) throws IlrRuleSessionCreationException {
        Interaction interaction = null;
        try {
            try {
                this.createWarning();
                this.initTrace();
                IlrJ2EEConnectionFactoryFinder ilrJ2EEConnectionFactoryFinder = new IlrJ2EEConnectionFactoryFinder();
                this.connectionFactory = ilrJ2EEConnectionFactoryFinder.getConnectionFactory("java:comp/env/eis/XUConnectionFactory");
                this.connection = this.createConnection(this.connectionFactory, string, serializable, ilrJavaClassResolver, true);
                interaction = this.connection.createInteraction();
                this.connectionId = this.getConnectionId(interaction, this.warnings);
                this.userData = serializable;
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "ejbCreate", string + " " + serializable);
                }
            }
            catch (Exception exception) {
                throw new IlrRuleSessionCreationException(exception);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (interaction == null) throw throwable;
                this.warnings.addWarning(interaction.getWarnings());
                interaction.close();
                throw throwable;
            }
            catch (ResourceException resourceException) {
                throw new IlrRuleSessionCreationException(resourceException);
            }
        }
        try {}
        catch (ResourceException resourceException) {
            throw new IlrRuleSessionCreationException(resourceException);
        }
        if (interaction != null) {
            this.warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        this.freeContext = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbCreate(IlrRulesetExecutionRequest ilrRulesetExecutionRequest, IlrJavaClassResolver ilrJavaClassResolver, boolean bl) throws IlrRuleSessionCreationException {
        block10: {
            Interaction interaction = null;
            try {
                try {
                    this.createWarning();
                    this.initTrace();
                    IlrJ2EEConnectionFactoryFinder ilrJ2EEConnectionFactoryFinder = new IlrJ2EEConnectionFactoryFinder();
                    this.connectionFactory = ilrJ2EEConnectionFactoryFinder.getConnectionFactory("java:comp/env/eis/XUConnectionFactory");
                    if (bl) {
                        if (this.isTraceOn) {
                            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "ejbCreate before interceptor", ilrRulesetExecutionRequest);
                        }
                        ilrRulesetExecutionRequest = this.callInterceptor(ilrRulesetExecutionRequest);
                    }
                    this.connection = this.createConnection(this.connectionFactory, ilrRulesetExecutionRequest.getPath(), ilrRulesetExecutionRequest.getUserData(), ilrJavaClassResolver, true);
                    interaction = this.connection.createInteraction();
                    this.connectionId = this.getConnectionId(interaction, this.warnings);
                    this.userData = ilrRulesetExecutionRequest.getUserData();
                    if (this.isTraceOn) {
                        IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "ejbCreate", ilrRulesetExecutionRequest);
                    }
                }
                catch (Exception exception) {
                    throw new IlrRuleSessionCreationException(exception);
                }
                Object var7_7 = null;
                if (interaction == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (interaction == null) throw throwable;
                try {
                    this.warnings.addWarning(interaction.getWarnings());
                    interaction.close();
                    throw throwable;
                }
                catch (ResourceException resourceException) {
                    throw new IlrRuleSessionCreationException(resourceException);
                }
            }
            try {}
            catch (ResourceException resourceException) {
                throw new IlrRuleSessionCreationException(resourceException);
            }
            this.warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        this.freeContext = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbCreate(IlrSessionRequest ilrSessionRequest, IlrJavaClassResolver ilrJavaClassResolver) throws IlrRuleSessionCreationException {
        block10: {
            Interaction interaction = null;
            try {
                try {
                    this.createWarning();
                    this.requestDescriptor = ilrSessionRequest.getSessionDescriptor();
                    this.initTrace();
                    IlrJ2EEConnectionFactoryFinder ilrJ2EEConnectionFactoryFinder = new IlrJ2EEConnectionFactoryFinder();
                    this.connectionFactory = ilrJ2EEConnectionFactoryFinder.getConnectionFactory("java:comp/env/eis/XUConnectionFactory");
                    if (this.requestDescriptor.isInterceptorEnabled()) {
                        if (this.isTraceOn) {
                            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "ejbCreate before interceptor", ilrSessionRequest);
                        }
                        ilrSessionRequest = this.callInterceptor(ilrSessionRequest);
                        this.requestDescriptor = ilrSessionRequest.getSessionDescriptor();
                    }
                    this.connection = this.createConnection(this.connectionFactory, this.requestDescriptor.getRulesetPath(), this.requestDescriptor.getUserData(), ilrJavaClassResolver, true);
                    interaction = this.connection.createInteraction();
                    this.connectionId = this.getConnectionId(interaction, this.warnings);
                    this.userData = this.requestDescriptor.getUserData();
                    if (this.isTraceOn) {
                        IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "ejbCreate", ilrSessionRequest);
                    }
                }
                catch (Exception exception) {
                    throw new IlrRuleSessionCreationException(exception);
                }
                Object var6_6 = null;
                if (interaction == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (interaction == null) throw throwable;
                try {
                    this.warnings.addWarning(interaction.getWarnings());
                    interaction.close();
                    throw throwable;
                }
                catch (ResourceException resourceException) {
                    throw new IlrRuleSessionCreationException(resourceException);
                }
            }
            try {}
            catch (ResourceException resourceException) {
                throw new IlrRuleSessionCreationException(resourceException);
            }
            this.warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        this.freeContext = false;
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException {
        this.ejbContext = sessionContext;
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "setSessionContext", null);
        }
    }

    protected SessionContext getSessionContext() {
        return this.ejbContext;
    }

    public void ejbRemove() throws EJBException {
        try {
            this.freeAllResources();
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "ejbRemove", null);
        }
    }

    public void ejbActivate() throws EJBException {
        try {
            IlrJ2EEConnectionFactoryFinder ilrJ2EEConnectionFactoryFinder = new IlrJ2EEConnectionFactoryFinder();
            this.connectionFactory = ilrJ2EEConnectionFactoryFinder.getConnectionFactory("java:comp/env/eis/XUConnectionFactory");
            this.createWarning();
            this.connection = this.reopenConnection(this.connectionFactory, this.connectionId);
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "ejbActivate", null);
        }
    }

    public void ejbPassivate() throws EJBException {
        this.connection = null;
        this.connectionFactory = null;
        this.serializeWarning();
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "ejbPassivate", null);
        }
    }

    public void afterBegin() throws EJBException {
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "afterBegin", null);
        }
    }

    public void beforeCompletion() throws EJBException {
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "beforeCompletion", null);
        }
    }

    public void afterCompletion(boolean bl) throws EJBException {
        if (this.isTraceOn) {
            Boolean bl2 = new Boolean(bl);
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "afterCompletion", bl2);
        }
    }

    public void insertObjects(IlrHandleList ilrHandleList) throws IlrRuleSessionException {
        this.doBeginTransaction("insertObjects");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "insertObjects", ilrHandleList);
        }
        try {
            this.add(this.connectionFactory, this.connection, ilrHandleList);
        }
        catch (Exception exception) {
            this.doRollbackTransaction("insertObjects", exception);
            throw new IlrRuleSessionException(exception);
        }
        this.doCommitTransaction("insertObjects");
    }

    public void insertObjects(IlrStatefulRuleSessionHelper ilrStatefulRuleSessionHelper) throws IlrRuleSessionException {
        this.doBeginTransaction("insertObjects");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "insertObjects", ilrStatefulRuleSessionHelper);
        }
        try {
            this.add(this.connectionFactory, this.connection, ilrStatefulRuleSessionHelper != null ? ilrStatefulRuleSessionHelper.getObjectsToAssertOrToUpdate() : null);
        }
        catch (Exception exception) {
            this.doRollbackTransaction("insertObjects", exception);
            throw new IlrRuleSessionException(exception);
        }
        this.doCommitTransaction("insertObjects");
    }

    public void retractObjects(IlrHandleList ilrHandleList) throws IlrRuleSessionException {
        this.doBeginTransaction("retractObjects");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "retractObjects", ilrHandleList);
        }
        try {
            this.remove(this.connectionFactory, this.connection, ilrHandleList);
        }
        catch (Exception exception) {
            this.doRollbackTransaction("retractObjects", exception);
            throw new IlrRuleSessionException(exception);
        }
        this.doCommitTransaction("retractObjects");
    }

    public void retractObjects(IlrStatefulRuleSessionHelper ilrStatefulRuleSessionHelper) throws IlrRuleSessionException {
        this.doBeginTransaction("retractObjects");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "retractObjects", ilrStatefulRuleSessionHelper);
        }
        try {
            this.remove(this.connectionFactory, this.connection, ilrStatefulRuleSessionHelper != null ? ilrStatefulRuleSessionHelper.getObjectsToAssertOrToUpdate() : null);
        }
        catch (Exception exception) {
            this.doRollbackTransaction("retractObjects", exception);
            throw new IlrRuleSessionException(exception);
        }
        this.doCommitTransaction("retractObjects");
    }

    public void updateObjects(IlrHandleList ilrHandleList) throws IlrRuleSessionException {
        this.doBeginTransaction("updateObjects");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "updateObjects", ilrHandleList);
        }
        try {
            this.change(this.connectionFactory, this.connection, ilrHandleList);
        }
        catch (Exception exception) {
            this.doRollbackTransaction("updateObjects", exception);
            throw new IlrRuleSessionException(exception);
        }
        this.doCommitTransaction("updateObjects");
    }

    public void updateObjects(IlrStatefulRuleSessionHelper ilrStatefulRuleSessionHelper) throws IlrRuleSessionException {
        this.doBeginTransaction("updateObjects");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "updateObjects", ilrStatefulRuleSessionHelper);
        }
        try {
            this.change(this.connectionFactory, this.connection, ilrStatefulRuleSessionHelper != null ? ilrStatefulRuleSessionHelper.getObjectsToAssertOrToUpdate() : null);
        }
        catch (Exception exception) {
            this.doRollbackTransaction("updateObjects", exception);
            throw new IlrRuleSessionException(exception);
        }
        this.doCommitTransaction("updateObjects");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap executeRules(String string, HashMap hashMap, boolean bl) throws IlrRuleSessionException {
        this.doBeginTransaction("executeRules");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "executeRules before", hashMap);
        }
        HashMap hashMap2 = null;
        Interaction interaction = null;
        try {
            try {
                interaction = this.connection.createInteraction();
                hashMap2 = this.execute(this.connectionFactory, string, hashMap, bl, interaction);
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "executeRules after", hashMap2);
                }
            }
            catch (Exception exception) {
                this.doRollbackTransaction("executeRules", exception);
                throw new IlrRuleSessionException(exception);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                this.warnings.addWarning(interaction.getWarnings());
                interaction.close();
                throw throwable;
            }
            catch (ResourceException resourceException) {
                throw new IlrRuleSessionException(resourceException);
            }
        }
        try {}
        catch (ResourceException resourceException) {
            throw new IlrRuleSessionException(resourceException);
        }
        this.warnings.addWarning(interaction.getWarnings());
        interaction.close();
        this.doCommitTransaction("executeRules");
        return hashMap2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IlrRuleExecutionResult executeRules(IlrHandleMap ilrHandleMap, boolean bl) throws IlrRuleSessionException {
        this.doBeginTransaction("executeRules");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "executeRules before", ilrHandleMap);
        }
        IlrRuleExecutionResult ilrRuleExecutionResult = null;
        Interaction interaction = null;
        try {
            try {
                interaction = this.connection.createInteraction();
                ilrRuleExecutionResult = this.executeDeprecated(this.connectionFactory, ilrHandleMap, bl, interaction);
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "executeRules after", ilrRuleExecutionResult);
                }
            }
            catch (Exception exception) {
                this.doRollbackTransaction("executeRules", exception);
                throw new IlrRuleSessionException(exception);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                if (interaction != null) {
                    this.warnings.addWarning(interaction.getWarnings());
                    interaction.close();
                }
            }
            catch (ResourceException resourceException) {
                this.doRollbackTransaction("executeRules", (Exception)((Object)resourceException));
                throw new IlrRuleSessionException(resourceException);
            }
            if (ilrRuleExecutionResult != null) {
                ilrRuleExecutionResult.warnings = this.warnings.getWarnings();
            }
            throw throwable;
        }
        try {}
        catch (ResourceException resourceException) {
            this.doRollbackTransaction("executeRules", (Exception)((Object)resourceException));
            throw new IlrRuleSessionException(resourceException);
        }
        if (interaction != null) {
            this.warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        if (ilrRuleExecutionResult != null) {
            ilrRuleExecutionResult.warnings = this.warnings.getWarnings();
        }
        this.doCommitTransaction("executeRules");
        return ilrRuleExecutionResult;
    }

    public IlrRuleExecutionResult executeRules(IlrRuleSessionExecutionHelper ilrRuleSessionExecutionHelper, boolean bl) throws IlrRuleSessionException {
        return this.executeRules(ilrRuleSessionExecutionHelper != null ? ilrRuleSessionExecutionHelper.getParameters() : null, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IlrSessionExecutionResult executeRules(IlrSessionStatefulExecutionSettings ilrSessionStatefulExecutionSettings) throws IlrRuleSessionException {
        this.doBeginTransaction("executeRules");
        IlrSessionParameters ilrSessionParameters = ilrSessionStatefulExecutionSettings.getInputParameters();
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "executeRules before", ilrSessionParameters);
        }
        Map map = null;
        IlrSessionExecutionResult ilrSessionExecutionResult = null;
        Interaction interaction = null;
        try {
            try {
                interaction = this.connection.createInteraction();
                String string = ilrSessionStatefulExecutionSettings.getTaskName();
                boolean bl = ilrSessionStatefulExecutionSettings.getResetRuleflow();
                ilrSessionExecutionResult = this.execute(this.connectionFactory, ilrSessionStatefulExecutionSettings, interaction);
                if (this.isTraceOn) {
                    map = ilrSessionExecutionResult.getOutputParameters().getParameters();
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "executeRules after", map);
                }
            }
            catch (Exception exception) {
                this.doRollbackTransaction("executeRules", exception);
                throw new IlrRuleSessionException(exception);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (interaction != null) {
                    this.warnings.addWarning(interaction.getWarnings());
                    interaction.close();
                }
            }
            catch (ResourceException resourceException) {
                this.doRollbackTransaction("executeRules", (Exception)((Object)resourceException));
                throw new IlrRuleSessionException(resourceException);
            }
            if (ilrSessionExecutionResult != null) {
                ilrSessionExecutionResult.setWarnings(this.warnings);
            }
            throw throwable;
        }
        try {}
        catch (ResourceException resourceException) {
            this.doRollbackTransaction("executeRules", (Exception)((Object)resourceException));
            throw new IlrRuleSessionException(resourceException);
        }
        if (interaction != null) {
            this.warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        if (ilrSessionExecutionResult != null) {
            ilrSessionExecutionResult.setWarnings(this.warnings);
        }
        this.doCommitTransaction("executeRules");
        return ilrSessionExecutionResult;
    }

    public Serializable evaluate(String string) throws IlrRuleSessionException {
        Serializable serializable;
        try {
            this.doBeginTransaction("evaluate");
            if (this.isTraceOn) {
                IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "evaluate before", string);
            }
            serializable = this.evaluateIrl(this.connectionFactory, this.connection, string);
            if (this.isTraceOn) {
                IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "evaluate after", serializable);
            }
        }
        catch (Exception exception) {
            this.doRollbackTransaction("evaluate", exception);
            throw new IlrRuleSessionException(exception);
        }
        this.doCommitTransaction("evaluate");
        return serializable;
    }

    public String getOutputString() throws IlrRuleSessionException {
        String string;
        this.doBeginTransaction("getOutputString");
        try {
            if (this.irlOutputString != null) {
                string = this.irlOutputString;
                this.irlOutputString = null;
            } else {
                string = "";
            }
            if (this.isTraceOn) {
                IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "getOutputString", string);
            }
        }
        catch (Exception exception) {
            this.doRollbackTransaction("getOutputString", exception);
            throw new IlrRuleSessionException(exception);
        }
        this.doCommitTransaction("getOutputString");
        return string;
    }

    public void endSession() throws IlrRuleSessionException {
        this.doBeginTransaction("endSession");
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "endSession", null);
        }
        this.freeAllResources();
        this.doCommitTransaction("endSession");
    }

    public String[] getWarnings() throws IlrRuleSessionException {
        this.doBeginTransaction("getWarnings");
        String[] stringArray = this.buildandClearWarnings();
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "getWarnings", stringArray);
        }
        this.doCommitTransaction("getWarnings");
        return stringArray;
    }

    public void reset() throws IlrRuleSessionException {
        this.doBeginTransaction("reset");
        try {
            if (this.isTraceOn) {
                IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "reset", null);
            }
            this.reinit(this.connectionFactory, this.connection);
        }
        catch (ResourceException resourceException) {
            this.doRollbackTransaction("reset", (Exception)((Object)resourceException));
            throw new IlrRuleSessionException(resourceException);
        }
        this.doCommitTransaction("reset");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IlrRuleSessionMetaData getRuleSessionMetaData() throws IlrRuleSessionException {
        this.doBeginTransaction("getRuleSessionMetaData");
        IlrRuleSessionMetaData ilrRuleSessionMetaData = null;
        Interaction interaction = null;
        try {
            try {
                interaction = this.connection.createInteraction();
                ilrRuleSessionMetaData = this.calculateMetaData(interaction, this.warnings, this.userData);
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "getRuleSessionMetaData", ilrRuleSessionMetaData);
                }
            }
            catch (ResourceException resourceException) {
                this.doRollbackTransaction("getRuleSessionMetaData", (Exception)((Object)resourceException));
                throw new IlrRuleSessionException(resourceException);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (interaction == null) throw throwable;
                this.warnings.addWarning(interaction.getWarnings());
                interaction.close();
                throw throwable;
            }
            catch (ResourceException resourceException) {
                this.doRollbackTransaction("getRuleSessionMetaData", (Exception)((Object)resourceException));
                throw new IlrRuleSessionException(resourceException);
            }
        }
        try {}
        catch (ResourceException resourceException) {
            this.doRollbackTransaction("getRuleSessionMetaData", (Exception)((Object)resourceException));
            throw new IlrRuleSessionException(resourceException);
        }
        if (interaction != null) {
            this.warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        this.doCommitTransaction("getRuleSessionMetaData");
        return ilrRuleSessionMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IlrSessionExecutionProperties getExecutionProperties() throws IlrRuleSessionException {
        this.doBeginTransaction("getExecutionProperties");
        Interaction interaction = null;
        try {
            try {
                interaction = this.connection.createInteraction();
                if (this.executionPpties == null) {
                    this.executionPpties = new IlrSessionExecutionProperties();
                }
                this.calculateMetaData(interaction, this.executionPpties, this.warnings, this.userData);
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "getExecutionProperties", this.executionPpties);
                }
            }
            catch (ResourceException resourceException) {
                this.doRollbackTransaction("getExecutionProperties", (Exception)((Object)resourceException));
                throw new IlrRuleSessionException(resourceException);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (interaction == null) throw throwable;
                this.warnings.addWarning(interaction.getWarnings());
                interaction.close();
                throw throwable;
            }
            catch (ResourceException resourceException) {
                this.doRollbackTransaction("getExecutionProperties", (Exception)((Object)resourceException));
                throw new IlrRuleSessionException(resourceException);
            }
        }
        try {}
        catch (ResourceException resourceException) {
            this.doRollbackTransaction("getExecutionProperties", (Exception)((Object)resourceException));
            throw new IlrRuleSessionException(resourceException);
        }
        if (interaction != null) {
            this.warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        this.doCommitTransaction("getExecutionProperties");
        return this.executionPpties;
    }

    protected void freeAllResources() {
        if (!this.freeContext) {
            this.finalizeConnection(this.connection);
            this.connectionFactory = null;
            this.connection = null;
            this.freeContext = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTrace() throws NamingException {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            IlrJndiEnvVariablesReader ilrJndiEnvVariablesReader = new IlrJndiEnvVariablesReader(initialContext);
            this.isTraceOn = ilrJndiEnvVariablesReader.isTraceOn();
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
        }
    }

    public IlrRulesetExecutionRequest callInterceptor(IlrRulesetExecutionRequest ilrRulesetExecutionRequest) throws Exception {
        return this.callInterceptor(ilrRulesetExecutionRequest, null, null, null);
    }

    public IlrSessionRequest callInterceptor(IlrSessionRequest ilrSessionRequest) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        ilrSessionRequest = this.callInterceptor(ilrSessionRequest, null, null, stringBuffer);
        this.interceptorClassNameUsed = stringBuffer.toString();
        return ilrSessionRequest;
    }

    protected void doBeginTransaction(String string) {
    }

    protected void doRollbackTransaction(String string, Exception exception) {
        if (!this.ejbContext.getRollbackOnly()) {
            this.ejbContext.setRollbackOnly();
        }
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, this.connectionId, "doRollbackTransaction " + string, exception);
        }
    }

    protected void doCommitTransaction(String string) {
    }
}

