/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.ejb;

import ilog.rules.bres.ras.model.IlrExecutionTrace;
import ilog.rules.bres.session.IlrRuleExecutionResult;
import ilog.rules.bres.session.IlrRuleSessionException;
import ilog.rules.bres.session.IlrRuleSessionExecuteImpl;
import ilog.rules.bres.session.IlrRulesetExecutionRequest;
import ilog.rules.bres.session.IlrRulesetExecutionResponse;
import ilog.rules.bres.session.IlrSessionDescriptor;
import ilog.rules.bres.session.IlrSessionRequest;
import ilog.rules.bres.session.IlrSessionResponse;
import ilog.rules.bres.session.connectmngt.IlrJ2EEConnectionFactoryFinder;
import ilog.rules.bres.session.ejb.IlrJndiEnvVariablesReader;
import ilog.rules.bres.session.util.IlrHandleMap;
import ilog.rules.bres.session.util.IlrJavaClassResolver;
import ilog.rules.bres.session.util.IlrMigrationRSAPI;
import ilog.rules.bres.session.util.IlrRuleSessionExecutionHelper;
import ilog.rules.bres.session.util.IlrTracePrinter;
import java.io.IOException;
import java.io.Serializable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.Interaction;

public class IlrStatelessRuleSessionEJB
extends IlrRuleSessionExecuteImpl
implements SessionBean {
    private SessionContext ejbContext = null;
    private boolean isTraceOn = false;

    public void ejbCreate() throws CreateException {
        InitialContext initialContext;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            throw new CreateException(namingException.getExplanation());
        }
        IlrJndiEnvVariablesReader ilrJndiEnvVariablesReader = new IlrJndiEnvVariablesReader(initialContext);
        this.isTraceOn = ilrJndiEnvVariablesReader.isTraceOn();
        try {
            initialContext.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "ejbCreate", null);
        }
    }

    public void ejbRemove() throws EJBException {
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "ejbRemove", null);
        }
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException {
        this.ejbContext = sessionContext;
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "setSessionContext", null);
        }
    }

    protected SessionContext getSessionContext() {
        return this.ejbContext;
    }

    public IlrRuleExecutionResult executeRules(String string, IlrRuleSessionExecutionHelper ilrRuleSessionExecutionHelper) throws IlrRuleSessionException {
        IlrJavaClassResolver ilrJavaClassResolver = null;
        IlrHandleMap ilrHandleMap = null;
        String string2 = null;
        if (ilrRuleSessionExecutionHelper != null) {
            try {
                ilrJavaClassResolver = ilrRuleSessionExecutionHelper.getJavaClassResolver();
                ilrHandleMap = ilrRuleSessionExecutionHelper.getParameters();
                string2 = ilrRuleSessionExecutionHelper.getUserData();
            }
            catch (IOException iOException) {
                throw new IlrRuleSessionException(iOException);
            }
        }
        return this.executeRules(string, (Serializable)((Object)string2), ilrJavaClassResolver, ilrHandleMap);
    }

    public IlrRuleExecutionResult executeRules(String string, Serializable serializable, IlrJavaClassResolver ilrJavaClassResolver, IlrHandleMap ilrHandleMap) throws IlrRuleSessionException {
        IlrRulesetExecutionRequest ilrRulesetExecutionRequest = IlrMigrationRSAPI.buildRequest(string, ilrHandleMap, serializable);
        this.javaClassResolver = ilrJavaClassResolver;
        IlrRulesetExecutionResponse ilrRulesetExecutionResponse = this.executeRules(ilrRulesetExecutionRequest, false);
        return IlrMigrationRSAPI.buildResult(ilrRulesetExecutionResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IlrRulesetExecutionResponse executeRules(IlrRulesetExecutionRequest ilrRulesetExecutionRequest, boolean bl) throws IlrRuleSessionException {
        IlrRulesetExecutionResponse ilrRulesetExecutionResponse = null;
        Connection connection = null;
        Interaction interaction = null;
        IlrRuleSessionExecuteImpl.Warnings warnings = new IlrRuleSessionExecuteImpl.Warnings();
        try {
            try {
                IlrJ2EEConnectionFactoryFinder ilrJ2EEConnectionFactoryFinder = new IlrJ2EEConnectionFactoryFinder();
                ConnectionFactory connectionFactory = ilrJ2EEConnectionFactoryFinder.getConnectionFactory("java:comp/env/eis/XUConnectionFactory");
                if (bl) {
                    if (this.isTraceOn) {
                        IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "executeRules before interceptor", ilrRulesetExecutionRequest);
                    }
                    ilrRulesetExecutionRequest = this.callInterceptor(ilrRulesetExecutionRequest);
                }
                connection = this.createConnection(connectionFactory, ilrRulesetExecutionRequest.getPath(), ilrRulesetExecutionRequest.getUserData(), this.javaClassResolver, false);
                interaction = connection.createInteraction();
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "executeRules", ilrRulesetExecutionRequest);
                }
                this.doBeginTransaction();
                ilrRulesetExecutionResponse = this.executeStateless(connectionFactory, interaction, ilrRulesetExecutionRequest, warnings);
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "executeRules after execution", ilrRulesetExecutionResponse);
                }
            }
            catch (Exception exception) {
                this.doRollbackTransaction(exception);
                throw new IlrRuleSessionException(exception);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (interaction != null) {
                    warnings.addWarning(interaction.getWarnings());
                    interaction.close();
                }
            }
            catch (ResourceException resourceException) {
                this.doRollbackTransaction((Exception)((Object)resourceException));
                throw new IlrRuleSessionException(resourceException);
            }
            if (ilrRulesetExecutionResponse != null) {
                ilrRulesetExecutionResponse.setWarnings(warnings.getWarnings());
            }
            this.finalizeConnection(connection);
            throw throwable;
        }
        try {}
        catch (ResourceException resourceException) {
            this.doRollbackTransaction((Exception)((Object)resourceException));
            throw new IlrRuleSessionException(resourceException);
        }
        if (interaction != null) {
            warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        if (ilrRulesetExecutionResponse != null) {
            ilrRulesetExecutionResponse.setWarnings(warnings.getWarnings());
        }
        this.finalizeConnection(connection);
        this.doCommitTransaction();
        return ilrRulesetExecutionResponse;
    }

    public IlrExecutionTrace executeRules(IlrExecutionTrace ilrExecutionTrace) throws IlrRuleSessionException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IlrSessionResponse executeRules(IlrSessionRequest ilrSessionRequest) throws IlrRuleSessionException {
        IlrSessionResponse ilrSessionResponse = null;
        Connection connection = null;
        ConnectionFactory connectionFactory = null;
        Interaction interaction = null;
        IlrRuleSessionExecuteImpl.Warnings warnings = new IlrRuleSessionExecuteImpl.Warnings();
        IlrSessionDescriptor ilrSessionDescriptor = ilrSessionRequest.getSessionDescriptor();
        try {
            try {
                IlrJ2EEConnectionFactoryFinder ilrJ2EEConnectionFactoryFinder = new IlrJ2EEConnectionFactoryFinder();
                connectionFactory = ilrJ2EEConnectionFactoryFinder.getConnectionFactory("java:comp/env/eis/XUConnectionFactory");
                if (ilrSessionDescriptor.isInterceptorEnabled()) {
                    if (this.isTraceOn) {
                        IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "executeRules before interceptor", ilrSessionRequest);
                    }
                    ilrSessionRequest = this.callInterceptor(ilrSessionRequest);
                }
                ilrSessionDescriptor = ilrSessionRequest.getSessionDescriptor();
                connection = this.createConnection(connectionFactory, ilrSessionDescriptor.getRulesetPath(), ilrSessionDescriptor.getUserData(), this.javaClassResolver, false);
                interaction = connection.createInteraction();
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "executeRules", ilrSessionRequest);
                }
                this.doBeginTransaction();
                ilrSessionResponse = this.executeStateless(connectionFactory, connection, interaction, ilrSessionRequest, warnings);
                if (this.isTraceOn) {
                    IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "executeRules after execution", ilrSessionResponse);
                }
            }
            catch (Exception exception) {
                this.doRollbackTransaction(exception);
                throw new IlrRuleSessionException(exception);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (interaction != null) {
                    warnings.addWarning(interaction.getWarnings());
                    interaction.close();
                }
            }
            catch (ResourceException resourceException) {
                this.doRollbackTransaction((Exception)((Object)resourceException));
                throw new IlrRuleSessionException(resourceException);
            }
            if (ilrSessionResponse != null) {
                ilrSessionResponse.getExecutionResult().setWarnings(warnings.getWarningsAsList());
            }
            this.finalizeConnection(connection);
            throw throwable;
        }
        try {}
        catch (ResourceException resourceException) {
            this.doRollbackTransaction((Exception)((Object)resourceException));
            throw new IlrRuleSessionException(resourceException);
        }
        if (interaction != null) {
            warnings.addWarning(interaction.getWarnings());
            interaction.close();
        }
        if (ilrSessionResponse != null) {
            ilrSessionResponse.getExecutionResult().setWarnings(warnings.getWarningsAsList());
        }
        this.finalizeConnection(connection);
        this.doCommitTransaction();
        return ilrSessionResponse;
    }

    public IlrRulesetExecutionRequest callInterceptor(IlrRulesetExecutionRequest ilrRulesetExecutionRequest) throws Exception {
        return this.callInterceptor(ilrRulesetExecutionRequest, null, null, null);
    }

    public IlrSessionRequest callInterceptor(IlrSessionRequest ilrSessionRequest) throws Exception {
        return this.callInterceptor(ilrSessionRequest, null, null, null);
    }

    protected void doBeginTransaction() {
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "doBeginTransaction", null);
        }
    }

    protected void doRollbackTransaction(Exception exception) {
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "doRollbackTransaction", exception);
        }
        if (!this.ejbContext.getRollbackOnly()) {
            this.ejbContext.setRollbackOnly();
        }
    }

    protected void doCommitTransaction() {
        if (this.isTraceOn) {
            IlrTracePrinter.printTrace(System.out, (EnterpriseBean)this, null, "doCommitTransaction", null);
        }
    }
}

