/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.j2se;

import ilog.rules.bres.model.IlrRepository;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.model.impl.IlrRepositoryFactoryImpl;
import ilog.rules.bres.session.IlrManagementSession;
import ilog.rules.bres.session.IlrRuleSessionException;
import ilog.rules.bres.session.connectmngt.IlrJ2SEConnectionFactoryFinder;
import ilog.rules.bres.session.dispatch.IlrJ2SEModelExplorer;
import java.io.InputStream;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;

public class IlrManagementSessionImpl
extends ilog.rules.bres.session.IlrManagementSessionImpl
implements IlrManagementSession {
    private IlrRepositoryFactory repositoryFactory = new IlrRepositoryFactoryImpl(){

        public IlrRepository createRepository() {
            IlrJ2SEConnectionFactoryFinder ilrJ2SEConnectionFactoryFinder = new IlrJ2SEConnectionFactoryFinder();
            InputStream inputStream = ilrJ2SEConnectionFactoryFinder.findDescriptorStream();
            IlrJ2SEModelExplorer ilrJ2SEModelExplorer = new IlrJ2SEModelExplorer(inputStream);
            try {
                return ilrJ2SEModelExplorer.initializeModel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    };

    public IlrRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    IlrManagementSessionImpl(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String[] solveRulesetPath(String[] stringArray) throws IlrRuleSessionException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String[] stringArray2 = this.solveRulesetPath(connection, stringArray);
            connection.close();
            return stringArray2;
        }
        catch (ResourceException resourceException) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (ResourceException resourceException2) {
                throw new IlrRuleSessionException(resourceException2);
            }
            throw new IlrRuleSessionException(resourceException);
        }
    }

    public void invalidate(String string) throws IlrRuleSessionException {
        this.invalidate(new String[]{string});
    }

    public void invalidate(String[] stringArray) throws IlrRuleSessionException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.invalidate(connection, stringArray);
            connection.close();
        }
        catch (ResourceException resourceException) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (ResourceException resourceException2) {
                throw new IlrRuleSessionException(resourceException2);
            }
            throw new IlrRuleSessionException(resourceException);
        }
    }
}

