/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.util;

import ilog.rules.bres.session.util.IlrDateFormatException;
import ilog.rules.bres.session.util.IlrTimeZone;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class IlrDateTime
extends IlrTimeZone {
    private boolean positive = true;
    private short century = 0;
    private short year = 0;
    private short month = 0;
    private short day = 0;
    private short hour = 0;
    private short minute = 0;
    private short second = 0;
    private short millisecond = 0;

    public IlrDateTime() {
    }

    public IlrDateTime(long l) {
        this.set(new Date(l));
    }

    public IlrDateTime(Date date) {
        this.set(date);
    }

    public IlrDateTime(Date date, TimeZone timeZone) {
        this.set(date, timeZone);
    }

    public IlrDateTime(String string) throws IlrDateFormatException {
        Parser parser = new Parser();
        parser.parse(string, this);
    }

    public void set(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        short s = (short)gregorianCalendar.get(1);
        this.setPositive(gregorianCalendar.get(0) == 1);
        this.setDate((short)(s / 100), (short)(s % 100), (short)(gregorianCalendar.get(2) + 1), (short)gregorianCalendar.get(5));
        this.setTime((short)gregorianCalendar.get(11), (short)gregorianCalendar.get(12), (short)gregorianCalendar.get(13), (short)gregorianCalendar.get(14));
        this.unsetUTC();
    }

    public void set(Date date, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(date);
        short s = (short)gregorianCalendar.get(1);
        this.setPositive(gregorianCalendar.get(0) == 1);
        this.setDate((short)(s / 100), (short)(s % 100), (short)(gregorianCalendar.get(2) + 1), (short)gregorianCalendar.get(5));
        this.setTime((short)gregorianCalendar.get(11), (short)gregorianCalendar.get(12), (short)gregorianCalendar.get(13), (short)gregorianCalendar.get(14));
        this.setTimeZoneInMillis(gregorianCalendar.get(15));
    }

    public void setPositive(boolean bl) {
        this.positive = bl;
    }

    public void setDate(short s, short s2, short s3, short s4) {
        this.century = s;
        this.year = s2;
        this.month = s3;
        this.day = s4;
    }

    public void setTime(short s, short s2, short s3, short s4) {
        this.hour = s;
        this.minute = s2;
        this.second = s3;
        this.millisecond = s4;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public short getCentury() {
        return this.century;
    }

    public short getYear() {
        return this.year;
    }

    public short getMonth() {
        return this.month;
    }

    public short getDay() {
        return this.day;
    }

    public short getHour() {
        return this.hour;
    }

    public short getMinute() {
        return this.minute;
    }

    public short getSecond() {
        return this.second;
    }

    public short getMillisecond() {
        return this.millisecond;
    }

    public Date toDate() throws IlrDateFormatException {
        GregorianCalendar gregorianCalendar = this.toCalendar();
        return gregorianCalendar.getTime();
    }

    public GregorianCalendar toCalendar() {
        TimeZone timeZone = this.toTimeZone();
        GregorianCalendar gregorianCalendar = timeZone == null ? new GregorianCalendar() : new GregorianCalendar(timeZone);
        int n = this.positive ? 1 : 0;
        gregorianCalendar.set(0, n);
        gregorianCalendar.set(1, this.century * 100 + this.year);
        gregorianCalendar.set(2, this.month - 1);
        gregorianCalendar.set(5, this.day);
        gregorianCalendar.set(11, this.hour);
        gregorianCalendar.set(12, this.minute);
        gregorianCalendar.set(13, this.second);
        gregorianCalendar.set(14, this.millisecond);
        return gregorianCalendar;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isPositive()) {
            stringBuffer.append('-');
        }
        IlrTimeZone.formatToString(this.century, 2, stringBuffer);
        IlrTimeZone.formatToString(this.year, 2, stringBuffer);
        stringBuffer.append('-');
        IlrTimeZone.formatToString(this.month, 2, stringBuffer);
        stringBuffer.append('-');
        IlrTimeZone.formatToString(this.day, 2, stringBuffer);
        stringBuffer.append('T');
        IlrTimeZone.formatToString(this.hour, 2, stringBuffer);
        stringBuffer.append(':');
        IlrTimeZone.formatToString(this.minute, 2, stringBuffer);
        stringBuffer.append(':');
        IlrTimeZone.formatToString(this.second, 2, stringBuffer);
        if (this.millisecond != 0) {
            stringBuffer.append('.');
            stringBuffer.append(this.millisecond);
        }
        IlrTimeZone.formatToString(this, stringBuffer);
        return stringBuffer.toString();
    }

    public boolean isEqual(IlrDateTime ilrDateTime) {
        return this.toDate().equals(ilrDateTime.toDate());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IlrDateTime) {
            return this.isEqual((IlrDateTime)object);
        }
        return false;
    }

    public int compareTo(IlrDateTime ilrDateTime) {
        Date date;
        Date date2 = this.toDate();
        if (date2.equals(date = ilrDateTime.toDate())) {
            return 0;
        }
        if (date2.before(date)) {
            return -1;
        }
        return 1;
    }

    public static IlrDateTime parse(String string) throws IlrDateFormatException {
        Parser parser = new Parser();
        IlrDateTime ilrDateTime = new IlrDateTime();
        parser.parse(string, ilrDateTime);
        return ilrDateTime;
    }

    public static IlrDateTime parse(String string, Parser parser) throws IlrDateFormatException {
        IlrDateTime ilrDateTime = new IlrDateTime();
        parser.parse(string, ilrDateTime);
        return ilrDateTime;
    }

    public static class Parser
    extends IlrTimeZone.TimeZoneParser {
        protected synchronized void parse(String string, IlrDateTime ilrDateTime) throws IlrDateFormatException {
            this.initParser(string);
            if (this.tryParseChar('-')) {
                ilrDateTime.setPositive(false);
            }
            ilrDateTime.century = this.parseNumber(2);
            ilrDateTime.year = this.parseNumberGroup(2, '-');
            ilrDateTime.month = this.parseNumberGroup(2, '-');
            ilrDateTime.day = this.parseNumberGroup(2, 'T');
            ilrDateTime.hour = this.parseNumberGroup(2, ':');
            ilrDateTime.minute = this.parseNumberGroup(2, ':');
            ilrDateTime.second = this.parseNumber(2);
            if (this.tryParseChar('.')) {
                ilrDateTime.millisecond = this.parseNumber();
            }
            this.parseTimeZone(ilrDateTime);
            if (!this.isStringParsed()) {
                this.throwException();
            }
        }

        public void throwException() {
            throw new IlrDateFormatException("Invalid DateTime format", new String(this.chars), this.ix);
        }
    }
}

