/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.util;

import java.io.IOException;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.rmi.CORBA.Util;

public final class IlrJavaClassResolver
implements Serializable {
    static final int CLASSLOADER = 0;
    static final int RMI = 4;
    static final int RMI_IIOP = 5;
    private transient ClassLoader classLoader = null;
    private int type = -1;
    private String codebase = null;
    private String[] classesInString;

    public IlrJavaClassResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.type = 0;
    }

    public IlrJavaClassResolver(String string, boolean bl) throws IOException {
        if (bl) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            JarFile[] jarFileArray = new JarFile[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                URL uRL = new URL("jar:" + (String)stringTokenizer.nextElement() + "!/");
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                jarFileArray[n++] = jarURLConnection.getJarFile();
            }
            this.init(jarFileArray, string);
        } else {
            this.init(string);
        }
    }

    private void init(String string) {
        this.codebase = string;
        this.type = 4;
    }

    private void init(JarFile[] jarFileArray, String string) {
        this.codebase = string;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < jarFileArray.length; ++i) {
            Enumeration<JarEntry> enumeration = jarFileArray[i].entries();
            while (enumeration.hasMoreElements()) {
                int n;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || (n = jarEntry.getName().lastIndexOf(".class")) <= 0) continue;
                char[] cArray = jarEntry.getName().toCharArray();
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < n; ++j) {
                    if (cArray[j] == '/') {
                        stringBuffer.append('.');
                        continue;
                    }
                    stringBuffer.append(cArray[j]);
                }
                linkedList.add(stringBuffer.toString());
            }
        }
        this.classesInString = new String[linkedList.size()];
        this.classesInString = linkedList.toArray(this.classesInString);
        this.type = 5;
    }

    int getTypeOfResolution() {
        return this.type;
    }

    ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return IlrJavaClassResolver.getThreadClassLoader();
    }

    ClassLoader getCodebaseRMIClassLoader() throws MalformedURLException {
        System.out.println("RMI codebase = " + this.codebase);
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return RMIClassLoader.getClassLoader(IlrJavaClassResolver.this.codebase);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (MalformedURLException)privilegedActionException.getException();
        }
    }

    ClassLoader getCodeBaseCorbaClassLoader() throws ClassNotFoundException {
        System.out.println(" CORBA :codebase = " + this.codebase);
        try {
            Class[] classArray = (Class[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class[] classArray = new Class[IlrJavaClassResolver.this.classesInString.length];
                    for (int i = 0; i < IlrJavaClassResolver.this.classesInString.length; ++i) {
                        classArray[i] = Util.loadClass((String)IlrJavaClassResolver.this.classesInString[i], (String)IlrJavaClassResolver.this.codebase, null);
                    }
                    return classArray;
                }
            });
            if (classArray != null) {
                return classArray[this.classesInString.length - 1].getClassLoader();
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    static ClassLoader getThreadClassLoader() {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return classLoader;
    }
}

