/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class IlrMessages {
    private static IlrMessages messages;
    private static ResourceBundle resource;

    public static IlrMessages getMessages() {
        if (messages == null) {
            IlrMessages.init();
        }
        return messages;
    }

    private static synchronized void init() {
        if (messages == null) {
            messages = new IlrMessages();
            resource = ResourceBundle.getBundle("ilog.rules.bres.session");
        }
    }

    public static String getMessage(String string) {
        return IlrMessages.getMessage(string, null);
    }

    public static String getMessage(String string, Object object) {
        return IlrMessages.getMessage(string, new Object[]{object});
    }

    public static String getMessage(String string, Object[] objectArray) {
        try {
            if (objectArray == null) {
                return resource.getString(string);
            }
            MessageFormat messageFormat = new MessageFormat(resource.getString(string));
            return messageFormat.format(objectArray);
        }
        catch (RuntimeException runtimeException) {
            StringBuffer stringBuffer = new StringBuffer("ilog.rules.bres.session");
            stringBuffer.append(", Message code: ");
            stringBuffer.append(string);
            if (objectArray != null) {
                stringBuffer.append(", parameters: ");
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(objectArray[i]);
                    if (i == objectArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
            return stringBuffer.toString();
        }
    }
}

