/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.util;

import ilog.rules.bres.session.IlrRuleExecutionResult;
import ilog.rules.bres.session.IlrRulesetExecutionResponse;
import ilog.rules.bres.session.util.IlrGuidGenerator;
import ilog.rules.bres.session.util.IlrHandleList;
import ilog.rules.bres.session.util.IlrHandleMap;
import ilog.rules.bres.session.util.IlrJavaClassResolver;
import ilog.rules.bres.session.util.IlrRuleSessionExecutionHelper;
import ilog.rules.bres.session.util.IlrRuleSessionHandle;
import ilog.rules.bres.session.util.IlrStatefulRuleSessionHelper;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class IlrRuleSessionHelper
implements IlrRuleSessionExecutionHelper,
IlrStatefulRuleSessionHelper {
    private static final String CODEBASE = "java.rmi.server.codebase";
    private transient boolean j2ee_remote = false;
    private HashMap parameters = null;
    private ArrayList handleToAssert = null;
    private String urls;
    private transient ClassLoader classLoader = null;
    private String mainTask;
    private String userData;
    private String contextOut;
    private String canonicalRulesetPath;

    public static byte getXmlBindingType() {
        return 1;
    }

    public static byte getWsdlBindingType() {
        return 2;
    }

    public static byte getJavaObjectType() {
        return 0;
    }

    public static IlrHandleList buildWorkingMemoryHandles(List list, byte by) {
        if (list == null) {
            throw new NullPointerException(" list should not be null ");
        }
        IlrRuleSessionHelper ilrRuleSessionHelper = new IlrRuleSessionHelper(true);
        Iterator iterator = list.iterator();
        block5: while (iterator.hasNext()) {
            Object e = iterator.next();
            switch (by) {
                case 0: {
                    ilrRuleSessionHelper.add(e);
                    continue block5;
                }
                case 2: {
                    if (e instanceof String) {
                        ilrRuleSessionHelper.addXMLDocument((String)e, (byte)2);
                        continue block5;
                    }
                    throw new IllegalArgumentException(e.toString());
                }
                case 1: {
                    if (e instanceof String) {
                        ilrRuleSessionHelper.addXMLDocument((String)e, (byte)1);
                        continue block5;
                    }
                    throw new IllegalArgumentException(e.toString());
                }
            }
            Byte by2 = new Byte(by);
            throw new IllegalArgumentException(by2.toString());
        }
        return ilrRuleSessionHelper.getObjectsToAssertOrToUpdate();
    }

    public static IlrHandleMap buildParametersMapHandles(Map map, byte by) {
        if (map == null) {
            throw new NullPointerException(" map should not be null ");
        }
        IlrRuleSessionHelper ilrRuleSessionHelper = new IlrRuleSessionHelper(true);
        Iterator iterator = map.entrySet().iterator();
        block5: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException(entry.getKey().toString());
            }
            switch (by) {
                case 0: {
                    ilrRuleSessionHelper.addParameter((String)entry.getKey(), entry.getValue());
                    continue block5;
                }
                case 2: {
                    if (entry.getValue() instanceof String) {
                        ilrRuleSessionHelper.addXMLDocumentAsParameter((String)entry.getKey(), (String)entry.getValue(), (byte)2);
                        continue block5;
                    }
                    throw new IllegalArgumentException(entry.getValue().toString());
                }
                case 1: {
                    if (entry.getValue() instanceof String) {
                        ilrRuleSessionHelper.addXMLDocumentAsParameter((String)entry.getKey(), (String)entry.getValue(), (byte)1);
                        continue block5;
                    }
                    throw new IllegalArgumentException(entry.getValue().toString());
                }
            }
            Byte by2 = new Byte(by);
            throw new IllegalArgumentException(by2.toString());
        }
        return ilrRuleSessionHelper.getParameters();
    }

    public static IlrJavaClassResolver buildJavaClassResolver(boolean bl, Object object) throws IOException {
        IlrRuleSessionHelper ilrRuleSessionHelper = new IlrRuleSessionHelper(bl);
        return ilrRuleSessionHelper.getJavaClassResolver(object);
    }

    public static IlrRuleSessionHandle createHandle(byte by, Object object, boolean bl) {
        IlrRuleSessionHandle ilrRuleSessionHandle = new IlrRuleSessionHandle(by, object);
        if (!bl) {
            ilrRuleSessionHandle.setGuid(IlrGuidGenerator.getInstance().getGuid());
        }
        return ilrRuleSessionHandle;
    }

    public IlrRuleSessionHelper() {
        this(false);
    }

    public IlrRuleSessionHelper(boolean bl) {
        this.j2ee_remote = bl;
        this.urls = new String();
    }

    public IlrRuleSessionHelper(IlrRuleExecutionResult ilrRuleExecutionResult) {
        if (ilrRuleExecutionResult != null) {
            this.parameters = ilrRuleExecutionResult.parametersOut.getInternalMap();
            this.contextOut = ilrRuleExecutionResult.output;
        }
    }

    public IlrRuleSessionHelper(IlrRulesetExecutionResponse ilrRulesetExecutionResponse) {
        if (ilrRulesetExecutionResponse != null) {
            if (ilrRulesetExecutionResponse.getOutputParameters() != null) {
                IlrHandleMap ilrHandleMap = new IlrHandleMap();
                ilrHandleMap.putAll(ilrRulesetExecutionResponse.getOutputParameters());
                this.parameters = ilrHandleMap.getInternalMap();
            }
            this.contextOut = ilrRulesetExecutionResponse.getOutputString();
            this.canonicalRulesetPath = ilrRulesetExecutionResponse.getCanonicalRulesetPath();
            this.userData = ilrRulesetExecutionResponse.getUserData().toString();
        }
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String string) {
        this.userData = string;
    }

    public String[] getParametersName() {
        if (this.parameters != null) {
            String[] stringArray = new String[this.parameters.size()];
            stringArray = this.parameters.keySet().toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    public void addParameter(String string, Object object) {
        if (string != null && object != null) {
            this.initParameters();
            IlrRuleSessionHandle ilrRuleSessionHandle = IlrRuleSessionHelper.createHandle((byte)0, object, true);
            this.parameters.put(string, ilrRuleSessionHandle);
        }
    }

    public IlrRuleSessionHandle add(Object object) {
        if (object != null) {
            this.initHandleToAsserts();
            IlrRuleSessionHandle ilrRuleSessionHandle = IlrRuleSessionHelper.createHandle((byte)0, object, false);
            this.handleToAssert.add(ilrRuleSessionHandle);
            return ilrRuleSessionHandle;
        }
        return null;
    }

    public Object getParameter(String string) {
        IlrRuleSessionHandle ilrRuleSessionHandle;
        if (this.parameters != null && string != null && (ilrRuleSessionHandle = (IlrRuleSessionHandle)this.parameters.get(string)) != null) {
            return ilrRuleSessionHandle.value;
        }
        return null;
    }

    public void addParameter(String string, int n) {
        this.addParameter(string, new Integer(n));
    }

    public int getIntParameter(String string) {
        return this.getNumber(string).intValue();
    }

    public void addParameter(String string, short s) {
        this.addParameter(string, new Short(s));
    }

    public short getShortParameter(String string) {
        return this.getNumber(string).shortValue();
    }

    public void addParameter(String string, long l) {
        this.addParameter(string, new Long(l));
    }

    public long getLongParameter(String string) {
        return this.getNumber(string).longValue();
    }

    public void addParameter(String string, float f) {
        this.addParameter(string, new Float(f));
    }

    public float getFloatParameter(String string) {
        return this.getNumber(string).floatValue();
    }

    public void addParameter(String string, double d) {
        this.addParameter(string, new Double(d));
    }

    public double getDoubleParameter(String string) {
        return this.getNumber(string).doubleValue();
    }

    public void addParameter(String string, byte by) {
        this.addParameter(string, new Byte(by));
    }

    public byte getByteParameter(String string) {
        return this.getNumber(string).byteValue();
    }

    public void addParameter(String string, boolean bl) {
        this.addParameter(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getBooleanParameter(String string) {
        return (Boolean)this.getParameter(string);
    }

    public void addParameter(String string, char c) {
        this.addParameter(string, new Character(c));
    }

    public char getCharParameter(String string) {
        return ((Character)this.getParameter(string)).charValue();
    }

    public void addJarPath(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (this.j2ee_remote) {
            string = System.getProperty(CODEBASE);
            if (string == null) {
                string = new String();
            }
        } else {
            string = this.urls;
        }
        if (string != null && string.indexOf(uRL.toString()) < 0) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        stringBuffer.append(uRL.toString());
        if (this.j2ee_remote) {
            System.setProperty(CODEBASE, stringBuffer.toString());
        } else {
            this.urls = stringBuffer.toString();
        }
    }

    public void addXMLDocumentAsParameter(String string, String string2, byte by) {
        if (string != null && string2 != null) {
            this.initParameters();
            IlrRuleSessionHandle ilrRuleSessionHandle = IlrRuleSessionHelper.createHandle(by, string2, true);
            this.parameters.put(string, ilrRuleSessionHandle);
        }
    }

    public String getXMLDocumentAsParameter(String string) {
        IlrRuleSessionHandle ilrRuleSessionHandle;
        if (this.parameters != null && string != null && (ilrRuleSessionHandle = (IlrRuleSessionHandle)this.parameters.get(string)) != null) {
            return (String)ilrRuleSessionHandle.value;
        }
        return null;
    }

    public IlrRuleSessionHandle addXMLDocument(String string, byte by) {
        this.initHandleToAsserts();
        IlrRuleSessionHandle ilrRuleSessionHandle = IlrRuleSessionHelper.createHandle(by, string, false);
        this.handleToAssert.add(ilrRuleSessionHandle);
        return ilrRuleSessionHandle;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public IlrJavaClassResolver getJavaClassResolver(Object object) throws IOException {
        if (this.j2ee_remote) {
            if (System.getProperty(CODEBASE) != null) {
                return new IlrJavaClassResolver(System.getProperty(CODEBASE), true);
            }
            return null;
        }
        if (this.urls.length() > 0) {
            return new IlrJavaClassResolver(this.urls, false);
        }
        if (object != null) {
            ClassLoader classLoader = this.getClassLoaderFromInstance(object);
            return new IlrJavaClassResolver(classLoader);
        }
        if (this.classLoader != null) {
            return new IlrJavaClassResolver(this.classLoader);
        }
        ClassLoader classLoader = this.guessClassLoader();
        return new IlrJavaClassResolver(classLoader);
    }

    public IlrJavaClassResolver getJavaClassResolver() throws IOException {
        return this.getJavaClassResolver(null);
    }

    protected ClassLoader guessClassLoader() {
        ClassLoader classLoader = null;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            Iterator iterator = this.parameters.values().iterator();
            do {
                Object object;
                ClassLoader classLoader2;
                if ((classLoader2 = this.getClassLoaderFromInstance(object = ((IlrRuleSessionHandle)iterator.next()).getValue())) == ClassLoader.getSystemClassLoader()) continue;
                classLoader = classLoader2;
            } while (iterator.hasNext() && classLoader == null);
        }
        if (classLoader == null) {
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return classLoader;
    }

    protected ClassLoader getClassLoaderFromInstance(final Object object) {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return object.getClass().getClassLoader();
            }
        });
        return classLoader;
    }

    public IlrHandleMap getParameters() {
        if (this.parameters != null || this.mainTask != null) {
            IlrHandleMap ilrHandleMap = new IlrHandleMap(this.parameters);
            ilrHandleMap.setMainTask(this.mainTask);
            return ilrHandleMap;
        }
        return null;
    }

    public IlrHandleList getObjectsToAssertOrToUpdate() {
        if (this.handleToAssert == null) {
            return null;
        }
        return new IlrHandleList(this.handleToAssert);
    }

    public IlrHandleList getObjectToRetract(boolean bl) {
        if (this.handleToAssert == null) {
            return null;
        }
        if (bl) {
            ArrayList<IlrRuleSessionHandle> arrayList = new ArrayList<IlrRuleSessionHandle>(this.handleToAssert.size());
            Iterator iterator = this.handleToAssert.iterator();
            while (iterator.hasNext()) {
                IlrRuleSessionHandle ilrRuleSessionHandle = (IlrRuleSessionHandle)iterator.next();
                IlrRuleSessionHandle ilrRuleSessionHandle2 = new IlrRuleSessionHandle(ilrRuleSessionHandle.getType(), null);
                ilrRuleSessionHandle2.setGuid(ilrRuleSessionHandle.getGuid());
                arrayList.add(ilrRuleSessionHandle2);
            }
            return new IlrHandleList(arrayList);
        }
        return new IlrHandleList(this.handleToAssert);
    }

    public void modifyValueOfHandle(IlrRuleSessionHandle ilrRuleSessionHandle, Object object) {
        ilrRuleSessionHandle.setNewValue(object);
    }

    public void setMainTask(String string) {
        this.mainTask = string;
    }

    public void reset() {
        if (this.parameters != null) {
            this.parameters.clear();
            this.parameters = null;
        }
        if (this.handleToAssert != null) {
            this.handleToAssert.clear();
            this.handleToAssert = null;
        }
    }

    public int getNumberOfRulesFired() {
        Integer n;
        if (this.parameters != null && (n = (Integer)this.getParameter("ilog.rules.firedRulesCount")) != null) {
            return n;
        }
        return 0;
    }

    public String getContextOut() {
        return this.contextOut;
    }

    public String getCanonicalRulesetPathUsed() {
        return this.canonicalRulesetPath;
    }

    private void initParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
    }

    private void initHandleToAsserts() {
        if (this.handleToAssert == null) {
            this.handleToAssert = new ArrayList();
        }
    }

    private Number getNumber(String string) {
        Object object = this.getParameter(string);
        if (object == null && !(object instanceof Number)) {
            return null;
        }
        return (Number)object;
    }
}

