/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.session.util;

import ilog.rules.bres.session.util.IlrDateFormatException;
import java.io.Serializable;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class IlrTimeZone
implements Serializable {
    public static final int EQUAL = 0;
    public static final int LOWER = -1;
    public static final int GREATER = 1;
    public static final int NOT_COMPARABLE = 2;
    private boolean flagUTC = false;
    private short zoneHour = 0;
    private short zoneMinute = 0;
    private boolean zonePositive = true;

    public IlrTimeZone() {
    }

    public IlrTimeZone(boolean bl) {
        this.setUTC(bl);
    }

    public IlrTimeZone(boolean bl, short s, short s2) {
        this.setTimeZone(bl, s, s2);
    }

    protected void setTimeZoneInMillis(int n) {
        int n2 = Math.abs(n) / 60000;
        this.setTimeZone(n >= 0, (short)(n2 / 60), (short)(n2 % 60));
    }

    public void setTimeZone(boolean bl, short s, short s2) {
        this.flagUTC = true;
        this.zoneHour = s;
        this.zoneMinute = s2;
        this.zonePositive = bl;
    }

    public void unsetUTC() {
        this.flagUTC = false;
        this.zoneHour = 0;
        this.zoneMinute = 0;
        this.zonePositive = true;
    }

    protected int getTimeZoneInMillis() {
        if (this.isUTC()) {
            int n = (this.zoneHour * 60 + this.zoneMinute) * 60000;
            return this.zonePositive ? n : -n;
        }
        return 0;
    }

    public short getZoneHour() {
        return this.zoneHour;
    }

    public short getZoneMinute() {
        return this.zoneMinute;
    }

    public void setUTC(boolean bl) {
        this.flagUTC = bl;
    }

    public boolean isZonePositive() {
        return this.zonePositive;
    }

    public boolean isUTC() {
        return this.flagUTC;
    }

    public final TimeZone toTimeZone() {
        SimpleTimeZone simpleTimeZone = null;
        if (this.isUTC()) {
            simpleTimeZone = new SimpleTimeZone(0, "UTC");
            int n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZonePositive() ? n : -n;
            simpleTimeZone.setRawOffset(n);
            String[] stringArray = TimeZone.getAvailableIDs(n);
            if (stringArray.length > 0) {
                simpleTimeZone.setID(stringArray[0]);
            }
        }
        return simpleTimeZone;
    }

    protected static void formatToString(IlrTimeZone ilrTimeZone, StringBuffer stringBuffer) {
        if (ilrTimeZone.isUTC()) {
            if (ilrTimeZone.getZoneHour() == 0 && ilrTimeZone.getZoneMinute() == 0) {
                stringBuffer.append('Z');
            } else {
                if (!ilrTimeZone.isZonePositive()) {
                    stringBuffer.append('-');
                } else {
                    stringBuffer.append('+');
                }
                IlrTimeZone.formatToString(ilrTimeZone.zoneHour, 2, stringBuffer);
                stringBuffer.append(':');
                IlrTimeZone.formatToString(ilrTimeZone.zoneMinute, 2, stringBuffer);
            }
        }
    }

    protected static void formatToString(short s, int n, StringBuffer stringBuffer) {
        String string = Short.toString(s);
        if (string.length() > n) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('*');
            }
        } else {
            for (int i = string.length(); i < n; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        IlrTimeZone.formatToString(this, stringBuffer);
        return stringBuffer.toString();
    }

    public boolean isEqual(IlrTimeZone ilrTimeZone) {
        return this.flagUTC == ilrTimeZone.flagUTC && this.zonePositive == ilrTimeZone.zonePositive && this.zoneHour == ilrTimeZone.zoneHour && this.zoneMinute == ilrTimeZone.zoneMinute;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IlrTimeZone) {
            return this.isEqual((IlrTimeZone)object);
        }
        return false;
    }

    public static abstract class TimeZoneParser {
        protected int ix = 0;
        protected char[] chars = null;

        protected abstract void throwException() throws IlrDateFormatException;

        protected void parseTimeZone(IlrTimeZone ilrTimeZone) throws IlrDateFormatException {
            if (this.tryParseChar('Z')) {
                ilrTimeZone.setUTC(true);
            } else if (this.ix < this.chars.length) {
                boolean bl = true;
                if (this.tryParseChar('-')) {
                    bl = false;
                } else if (this.tryParseChar('+')) {
                    bl = true;
                } else {
                    this.throwException();
                }
                short s = this.parseNumberGroup(2, ':');
                short s2 = this.parseNumber(2);
                ilrTimeZone.setTimeZone(bl, s, s2);
            }
        }

        protected void initParser(String string) {
            this.chars = string.toCharArray();
            this.ix = 0;
        }

        protected boolean isStringParsed() {
            return this.ix == this.chars.length;
        }

        protected final short parseNumberGroup(int n, char c) throws IlrDateFormatException {
            short s = this.parseNumber(n);
            if (!this.tryParseChar(c)) {
                this.throwException();
            }
            return s;
        }

        protected final boolean tryParseChar(char c) {
            if (this.ix < this.chars.length && c == this.chars[this.ix]) {
                ++this.ix;
                return true;
            }
            return false;
        }

        protected final short parseNumber(int n) throws IlrDateFormatException {
            int n2 = 0;
            while (this.ix < this.chars.length && n > 0) {
                char c = this.chars[this.ix];
                if (Character.isDigit(c)) {
                    if ((n2 = n2 * 10 + (c - 48)) > Short.MAX_VALUE) {
                        this.throwException();
                    }
                    ++this.ix;
                    --n;
                    continue;
                }
                this.throwException();
            }
            if (n != 0) {
                this.throwException();
            }
            return (short)n2;
        }

        protected final short parseNumber() throws IlrDateFormatException {
            char c;
            int n = 0;
            boolean bl = false;
            while (this.ix < this.chars.length && Character.isDigit(c = this.chars[this.ix])) {
                bl = true;
                if ((n = n * 10 + (c - 48)) > Short.MAX_VALUE) {
                    this.throwException();
                }
                ++this.ix;
            }
            if (!bl) {
                this.throwException();
            }
            return (short)n;
        }
    }
}

