/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.util;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.archive.IlrRulesetArchiveBuilderBase;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class DeprecatedRulesetHelper {
    protected static final String CHARSET = "UTF-8";
    protected static final String RULESET_ENTRY = "ruleset";
    protected static final String XOM_ENTRY = "ruleset.xom";
    protected static final int MAGIC_MAJOR_NUMBER = 1357111317;
    protected static final int MAGIC_MINOR_NUMBER = -248163264;

    public static IlrRulesetArchive createRulesetArchive(String string, String string2) {
        IlrRulesetArchiveBuilderBase ilrRulesetArchiveBuilderBase = new IlrRulesetArchiveBuilderBase();
        ilrRulesetArchiveBuilderBase.setVersion(1357111317, -248163264);
        StringWriter stringWriter = new StringWriter();
        ilrRulesetArchiveBuilderBase.setMessageWriter(new PrintWriter(stringWriter));
        try {
            ilrRulesetArchiveBuilderBase.addIRLEntry(RULESET_ENTRY, new ByteArrayInputStream(string.getBytes(CHARSET)));
            if (string2 != null) {
                ilrRulesetArchiveBuilderBase.addDynamicModelEntry(XOM_ENTRY, new ByteArrayInputStream(string2.getBytes(CHARSET)));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        IlrRulesetArchive ilrRulesetArchive = ilrRulesetArchiveBuilderBase.generate();
        String[] stringArray = ilrRulesetArchiveBuilderBase.getErrors();
        if (stringArray != null && stringArray.length > 0) {
            throw new RuntimeException(stringWriter.toString());
        }
        return ilrRulesetArchive;
    }

    public static boolean isDeprecatedRuleset(IlrRulesetArchive ilrRulesetArchive) {
        IlrRulesetArchive.Element element = ilrRulesetArchive.getElement("META-INF/descriptor.xml");
        String string = element.toString();
        return string.indexOf(Integer.toString(1357111317)) > 0 && string.indexOf(Integer.toString(-248163264)) > 0;
    }

    public static String getIRL(IlrRulesetArchive ilrRulesetArchive) {
        return ilrRulesetArchive.getIRL("", RULESET_ENTRY);
    }

    public static String getXOM(IlrRulesetArchive ilrRulesetArchive) {
        IlrRulesetArchive.Element element = ilrRulesetArchive.getElement("RESOURCES/ruleset.xom");
        if (element != null) {
            return element.toString();
        }
        return null;
    }
}

