/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class IlrLocalizedException
extends Exception {
    private final String resourceBundleName;
    private final String messageCode;
    private final Object[] messageParams;

    public IlrLocalizedException() {
        this.resourceBundleName = null;
        this.messageCode = null;
        this.messageParams = null;
    }

    public IlrLocalizedException(String string) {
        super(string);
        this.resourceBundleName = null;
        this.messageCode = null;
        this.messageParams = null;
    }

    public IlrLocalizedException(String string, String string2, Object[] objectArray, Throwable throwable) {
        super(throwable);
        this.resourceBundleName = string;
        this.messageCode = string2;
        this.messageParams = objectArray;
    }

    public IlrLocalizedException(String string, String string2, Object[] objectArray) {
        this.resourceBundleName = string;
        this.messageCode = string2;
        this.messageParams = objectArray;
    }

    public IlrLocalizedException(Throwable throwable) {
        super(throwable);
        this.resourceBundleName = null;
        this.messageCode = null;
        this.messageParams = null;
    }

    public String getMessage() {
        if (this.resourceBundleName == null) {
            return super.getMessage();
        }
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage(locale, null);
    }

    public String getLocalizedMessage(Locale locale, ClassLoader classLoader) {
        if (this.resourceBundleName == null) {
            return super.getMessage();
        }
        try {
            ResourceBundle resourceBundle = classLoader == null ? ResourceBundle.getBundle(this.resourceBundleName, locale) : ResourceBundle.getBundle(this.resourceBundleName, locale, classLoader);
            if (this.messageParams == null) {
                return resourceBundle.getString(this.messageCode);
            }
            MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(this.messageCode), locale);
            return messageFormat.format(this.messageParams);
        }
        catch (RuntimeException runtimeException) {
            StringBuffer stringBuffer = new StringBuffer(this.resourceBundleName);
            stringBuffer.append(", Message code: ");
            stringBuffer.append(this.messageCode);
            if (this.messageParams != null) {
                stringBuffer.append(", parameters: ");
                for (int i = 0; i < this.messageParams.length; ++i) {
                    stringBuffer.append(this.messageParams[i]);
                    if (i == this.messageParams.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
            return stringBuffer.toString();
        }
    }
}

