/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IlrFileUtil {
    public static void copyToDir(File file, File file2) throws IOException {
        File file3 = new File(file2, file.getName());
        if (file.isDirectory()) {
            if (!file3.mkdir()) {
                throw new IOException();
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                IlrFileUtil.copyToDir(fileArray[i], file3);
            }
        } else {
            IlrFileUtil.copy(file, file3);
        }
    }

    public static boolean delete(File file, boolean bl) {
        File[] fileArray = file.listFiles();
        if (file.isDirectory() && bl) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (IlrFileUtil.delete(file2, bl)) continue;
                return false;
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            IlrFileUtil.copy((InputStream)bufferedInputStream, file2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            IlrFileUtil.copy(inputStream, bufferedOutputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static File createTempDir(File file, String string, String string2) throws IOException {
        if (string == null) {
            string = "tmp";
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String string3 = string + i + string2;
            File file2 = new File(file, string3);
            if (file2.exists() || !file2.mkdir()) continue;
            return file2;
        }
        throw new IOException("Cannot create temporary directory");
    }

    public static boolean rdiff(File file, File file2) throws IOException {
        boolean bl = false;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                if (!file4.exists()) {
                    bl = true;
                    continue;
                }
                if (file4.isDirectory()) {
                    if (!IlrFileUtil.rdiff(file3, file4)) continue;
                    bl = true;
                    continue;
                }
                bl = true;
                continue;
            }
            if (!file4.exists()) {
                bl = true;
                continue;
            }
            if (file4.isFile()) {
                if (!IlrFileUtil.diff(file3, file4)) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        return bl;
    }

    public static boolean diff(File file, File file2) throws IOException {
        int n;
        int n2;
        boolean bl = false;
        if (file.length() != file2.length()) {
            return true;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStream fileInputStream2 = new FileInputStream(file2);
        while ((n2 = ((InputStream)fileInputStream).read()) != -1) {
            n = ((InputStream)fileInputStream2).read();
            if (n2 == n) continue;
            bl = true;
        }
        while ((n = ((InputStream)fileInputStream2).read()) != -1) {
            bl = true;
        }
        ((InputStream)fileInputStream).close();
        ((InputStream)fileInputStream2).close();
        return bl;
    }
}

