/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.xu.cci;

import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.xu.IlrXUContext;
import ilog.rules.bres.xu.IlrXUDump;
import ilog.rules.bres.xu.cci.IlrConnectionContext;
import ilog.rules.bres.xu.cci.IlrConnectionId;
import ilog.rules.bres.xu.cci.IlrConnectionInformation;
import ilog.rules.bres.xu.cci.IlrInteractionExtension;
import ilog.rules.bres.xu.cci.IlrLocalTransactionDemarcation;
import ilog.rules.bres.xu.cci.IlrXUConnectionMetaData;
import ilog.rules.bres.xu.cci.IlrXUConnectionSpec;
import ilog.rules.bres.xu.cci.IlrXUInteraction;
import ilog.rules.bres.xu.event.IlrConnectionEvent;
import ilog.rules.bres.xu.event.IlrProfilingConnectionEvent;
import ilog.rules.bres.xu.event.IlrXUEventListener;
import ilog.rules.bres.xu.log.IlrLogHandler;
import ilog.rules.bres.xu.log.IlrMessages;
import ilog.rules.bres.xu.profiling.IlrProfilingHelper;
import ilog.rules.bres.xu.spi.IlrManagedXUConnection;
import ilog.rules.bres.xu.util.IlrResourceExceptionHelper;
import ilog.rules.engine.IlrRulesetParameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.Record;
import javax.resource.cci.ResultSetInfo;

public class IlrXUConnection
implements Connection {
    public static byte STATE_UNKNOWN = 0;
    public static byte STATE_ACTIVE = 1;
    public static byte STATE_CLOSED = (byte)2;
    protected IlrManagedXUConnection managedConnection = null;
    protected IlrProfilingHelper profilingHelper = null;
    protected IlrProfilingConnectionEvent profilingEvent = null;
    protected byte state = STATE_UNKNOWN;
    protected IlrLogHandler logger = null;
    protected LocalTransaction localTransactionDemarcation = new IlrLocalTransactionDemarcation(this);
    protected IlrConnectionInformation information = null;
    protected IlrConnectionContext context = null;

    public IlrXUConnection(IlrConnectionId ilrConnectionId, IlrManagedXUConnection ilrManagedXUConnection, IlrXUConnectionSpec ilrXUConnectionSpec) {
        this.information = new IlrConnectionInformation(ilrConnectionId, ilrManagedXUConnection.getId(), ilrXUConnectionSpec);
        this.context = new IlrConnectionContext(this.information);
        this.setManagedConnection(ilrManagedXUConnection);
        this.profilingHelper = ilrManagedXUConnection.getProfiling();
        this.profilingEvent = this.profilingHelper.startConnectionMeasure(1, this.context);
        this.state = STATE_ACTIVE;
        IlrConnectionEvent ilrConnectionEvent = new IlrConnectionEvent(0, (Object)this, this.context);
        ilrManagedXUConnection.getEventDispatcher().connectionEventRaised(ilrConnectionEvent);
    }

    public IlrInteractionExtension[] getInteractionExtensions() {
        return this.managedConnection.getInteractionExtensions();
    }

    public IlrConnectionInformation getInformation() {
        return this.information;
    }

    public IlrConnectionContext getContext() {
        return this.context;
    }

    public IlrXUConnectionSpec getSpec() {
        return this.information.getConnectionSpec();
    }

    protected IlrLogHandler getLogHandler() {
        return this.logger;
    }

    public IlrManagedXUConnection getManagedConnection() {
        return this.managedConnection;
    }

    public IlrConnectionId getId() {
        return this.information.getConnectionId();
    }

    public void setManagedConnection(IlrManagedXUConnection ilrManagedXUConnection) {
        this.managedConnection = ilrManagedXUConnection;
        this.information.setSPIConnectionId(ilrManagedXUConnection.getId());
        this.logger = ilrManagedXUConnection.getLogHandler();
    }

    public synchronized void checkConnectionActive() throws ResourceException {
        if (this.state == STATE_CLOSED) {
            throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10044);
        }
    }

    protected synchronized void checkConnection(byte by) throws ResourceException {
        this.checkConnectionActive();
        if (by == -1) {
            return;
        }
        if (this.managedConnection.getType() != -1 && this.managedConnection.getType() != by) {
            throw IlrResourceExceptionHelper.createNotSupportedException((IlrMessages)this.getLogHandler().getMessages(), (int)10043);
        }
    }

    protected void prepareOperation(byte by, boolean bl) throws ResourceException {
        this.getLogHandler().finest("CCI Connection prepareOperation", null, (IlrXUContext)this.context);
        this.checkConnection(by);
    }

    public boolean executeInteractionExtension(IlrInteractionExtension ilrInteractionExtension, InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        this.prepareOperation(ilrInteractionExtension.getConnectionType(), ilrInteractionExtension.isStateModified(interactionSpec, record, record2));
        return ilrInteractionExtension.execute(this, interactionSpec, record, record2);
    }

    public void writeLog(String[] stringArray) throws ResourceException {
        this.prepareOperation((byte)-1, false);
        this.managedConnection.writeLog(stringArray);
    }

    public String getXUInformation() throws ResourceException {
        this.prepareOperation((byte)1, false);
        return this.managedConnection.getXUInformation(this);
    }

    public IlrXUDump getXUDump() throws ResourceException {
        this.prepareOperation((byte)1, false);
        return this.managedConnection.getXUDump(this);
    }

    public String solveRulesetPath(String string) throws ResourceException {
        this.prepareOperation((byte)1, false);
        return this.managedConnection.solveRulesetPath(string);
    }

    public void notifyRulesetArchiveChanged(String string) throws ResourceException {
        this.prepareOperation((byte)1, false);
        this.managedConnection.notifyRulesetArchiveChanged(string, (IlrXUContext)this.context);
    }

    public void startProfilingSession(Properties properties) throws ResourceException {
        this.prepareOperation((byte)1, false);
        this.managedConnection.startProfilingSession(properties, (IlrXUContext)this.context);
    }

    public void stopProfilingSession(Properties properties) throws ResourceException {
        this.prepareOperation((byte)1, false);
        this.managedConnection.stopProfilingSession(properties, (IlrXUContext)this.context);
    }

    public void enableRulesetExecutionInformation(int n) throws ResourceException {
        this.prepareOperation((byte)0, false);
        this.managedConnection.enableRulesetExecutionInformation(this, n);
    }

    public Map contextGetInformation() throws ResourceException {
        this.prepareOperation((byte)0, false);
        return this.managedConnection.contextGetInformation(this);
    }

    public Object[] contextGetWorkingMemory() throws ResourceException {
        this.prepareOperation((byte)0, false);
        return this.managedConnection.contextGetWorkingMemory(this);
    }

    public Map contextGetWorkingMemoryWithId() throws ResourceException {
        this.prepareOperation((byte)0, false);
        return this.managedConnection.contextGetWorkingMemoryWithId(this);
    }

    public Object[] contextEvaluate(String[] stringArray) throws ResourceException {
        this.prepareOperation((byte)0, false);
        return this.managedConnection.contextEvaluate(this, stringArray);
    }

    public HashMap contextExecute() throws ResourceException {
        this.prepareOperation((byte)0, true);
        return this.managedConnection.contextExecute(this);
    }

    public HashMap contextGetParameters() throws ResourceException {
        this.prepareOperation((byte)0, false);
        return this.managedConnection.contextGetParameters(this);
    }

    public HashMap contextGetBOMParameters() throws ResourceException {
        this.prepareOperation((byte)0, false);
        return this.managedConnection.contextGetBOMParameters(this);
    }

    public Object contextExecuteMain(Object object) throws ResourceException {
        this.prepareOperation((byte)0, true);
        return this.managedConnection.contextExecuteMain(this, object);
    }

    public HashMap contextExecuteTask(String string) throws ResourceException {
        this.prepareOperation((byte)0, true);
        return this.managedConnection.contextExecuteTask(this, string);
    }

    public void contextInsert(List list) throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.contextInsert(this, list);
    }

    public void contextInsertWithId(List list) throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.contextInsertWithId(this, list);
    }

    public void contextRetract(Object[] objectArray) throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.contextRetract(this, objectArray);
    }

    public void contextRetractById(Object[] objectArray) throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.contextRetractById(this, objectArray);
    }

    public void contextUpdate(Object[] objectArray) throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.contextUpdate(this, objectArray);
    }

    public void contextSetParameters(HashMap hashMap) throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.contextSetParameters(this, hashMap);
    }

    public void contextSetBOMParameters(HashMap hashMap) throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.contextSetBOMParameters(this, hashMap);
    }

    public String contextGetOutput() throws ResourceException {
        this.prepareOperation((byte)0, true);
        return this.managedConnection.contextGetOutput(this);
    }

    public void contextReset() throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.contextReset(this);
    }

    public void ruleflowReset() throws ResourceException {
        this.prepareOperation((byte)0, true);
        this.managedConnection.ruleflowReset(this);
    }

    public IlrRulesetParameter[] getRulesetParameters() throws ResourceException {
        this.prepareOperation((byte)0, false);
        return this.managedConnection.getRulesetParameters(this);
    }

    public IlrRulesetArchiveInformation getRulesetArchiveInformation() throws ResourceException {
        this.prepareOperation((byte)0, false);
        return this.managedConnection.getRulesetArchiveInformation(this);
    }

    public Interaction createInteraction() throws ResourceException {
        this.checkConnectionActive();
        return new IlrXUInteraction(this);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        this.getLogHandler().finest("CCI Connection getLocalTransaction", null, (IlrXUContext)this.context);
        return this.localTransactionDemarcation;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return new IlrXUConnectionMetaData();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        int n = 10002;
        String string = this.getMessages().formatMessage(n, new Object[]{"Connection.getResultSetInfo()"});
        this.getMessages();
        throw new NotSupportedException(string, IlrMessages.codeToString((int)n));
    }

    public synchronized void close() throws ResourceException {
        this.getLogHandler().finer(4101, new Object[]{this}, (IlrXUContext)this.context);
        try {
            if (this.state == STATE_ACTIVE) {
                this.managedConnection.close((Connection)this);
            } else if (this.state == STATE_CLOSED) {
                throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10044);
            }
        }
        catch (ResourceException resourceException) {
            ResourceException resourceException2 = IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10037, (Exception)((Object)resourceException));
            this.getLogHandler().severe(10037, (Throwable)resourceException2, null, (IlrXUContext)this.context);
            throw resourceException2;
        }
    }

    public synchronized byte getState() {
        return this.state;
    }

    public void closed() throws ResourceException {
        if (this.getLogHandler().isLoggable(Level.FINEST)) {
            this.getLogHandler().finest("CCI Connection closing " + this, null, (IlrXUContext)this.context);
        }
        if (this.state == STATE_CLOSED) {
            throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10044);
        }
        this.state = STATE_CLOSED;
        IlrConnectionEvent ilrConnectionEvent = new IlrConnectionEvent(1, (Object)this, this.context);
        this.managedConnection.getEventDispatcher().connectionEventRaised(ilrConnectionEvent);
        this.profilingHelper.stopConnectionMeasure(this.profilingEvent);
        this.profilingHelper.sendConnectionEvent(this.profilingEvent);
        this.managedConnection = null;
        this.profilingHelper = null;
        this.profilingEvent = null;
        this.getLogHandler().finer(4102, new Object[]{this}, (IlrXUContext)this.context);
        if (this.getLogHandler().isLoggable(Level.FINEST)) {
            this.getLogHandler().finest("CCI Connection closed " + this, null, (IlrXUContext)this.context);
        }
    }

    protected IlrMessages getMessages() {
        return this.getLogHandler().getMessages();
    }

    public void close(IlrXUInteraction ilrXUInteraction) {
        this.getLogHandler().finest("CCI Connection Unregister interaction warning listener", null, (IlrXUContext)this.context);
        this.managedConnection.getEventDispatcher().removeListener((IlrXUEventListener)ilrXUInteraction, 4L);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

