/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.xu.cci;

import ilog.rules.bres.xu.cci.IlrConnectionId;
import ilog.rules.bres.xu.cci.IlrXUConnectionSpec;
import ilog.rules.bres.xu.cci.IlrXURecordFactory;
import ilog.rules.bres.xu.cci.IlrXUResourceAdapterMetaData;
import ilog.rules.bres.xu.log.IlrLogHandler;
import ilog.rules.bres.xu.log.IlrMessages;
import ilog.rules.bres.xu.spi.IlrManagedXUConnectionFactory;
import ilog.rules.bres.xu.spi.IlrXUConnectionRequestInfo;
import ilog.rules.bres.xu.util.IlrResourceExceptionHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class IlrXUConnectionFactory
implements ConnectionFactory,
Referenceable,
Serializable {
    protected Reference reference = null;
    protected IlrManagedXUConnectionFactory managedConnectionFactory = null;
    protected ConnectionManager connectionManager = null;
    protected transient RecordFactory recordFactory = new IlrXURecordFactory();
    protected ResourceAdapterMetaData resourceAdapterMetaData = null;

    public IlrXUConnectionFactory(IlrManagedXUConnectionFactory ilrManagedXUConnectionFactory, ConnectionManager connectionManager) {
        this.managedConnectionFactory = ilrManagedXUConnectionFactory;
        this.connectionManager = connectionManager;
        this.resourceAdapterMetaData = new IlrXUResourceAdapterMetaData();
    }

    public IlrXUConnectionFactory(ConnectionManager connectionManager) {
        this(new IlrManagedXUConnectionFactory(), connectionManager);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Connection getConnection() throws ResourceException {
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10002, (Object)"ConnectionFactory.getConnection()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        if (this.getLogHandler().isLoggable(Level.FINEST)) {
            this.getLogHandler().finest("ConnectionFactory.getConnection: " + connectionSpec);
        }
        try {
            IlrXUConnectionSpec ilrXUConnectionSpec = this.createConnectionSpec(connectionSpec);
            this.checkConnectionSpec(ilrXUConnectionSpec);
            IlrXUConnectionRequestInfo ilrXUConnectionRequestInfo = this.createConnectionRequestInfo(ilrXUConnectionSpec);
            if (ilrXUConnectionRequestInfo.getType() == 2) {
                IlrConnectionId ilrConnectionId = ilrXUConnectionRequestInfo.getConnectionId();
                return this.managedConnectionFactory.getConnection((Serializable)ilrConnectionId);
            }
            if (this.managedConnectionFactory.isConcurrentOpenClose() == Boolean.TRUE) {
                Connection connection = (Connection)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, (ConnectionRequestInfo)ilrXUConnectionRequestInfo);
                return connection;
            }
            Object object = this.managedConnectionFactory.connectionManagerLock;
            synchronized (object) {
                Connection connection = (Connection)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, (ConnectionRequestInfo)ilrXUConnectionRequestInfo);
                return connection;
            }
        }
        catch (ResourceException resourceException) {
            this.getLogHandler().severe(10011, (Throwable)resourceException, (Object)connectionSpec);
            throw resourceException;
        }
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        return this.recordFactory;
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return this.resourceAdapterMetaData;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() throws NamingException {
        return this.reference;
    }

    protected IlrXUConnectionSpec createConnectionSpec(ConnectionSpec connectionSpec) throws ResourceException {
        if (connectionSpec instanceof IlrXUConnectionSpec) {
            this.getLogHandler().finest("Client connection spec in the same classloader");
            return (IlrXUConnectionSpec)connectionSpec;
        }
        this.getLogHandler().finest("Client connection spec not in the same classloader");
        try {
            IlrXUConnectionSpec ilrXUConnectionSpec = new IlrXUConnectionSpec();
            ilrXUConnectionSpec.init(connectionSpec);
            return ilrXUConnectionSpec;
        }
        catch (Exception exception) {
            throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10010, (Object)connectionSpec, (Exception)exception);
        }
    }

    protected IlrXUConnectionRequestInfo createConnectionRequestInfo(IlrXUConnectionSpec ilrXUConnectionSpec) throws ResourceException {
        return new IlrXUConnectionRequestInfo(ilrXUConnectionSpec);
    }

    protected void checkConnectionSpec(IlrXUConnectionSpec ilrXUConnectionSpec) throws ResourceException {
        String string = ilrXUConnectionSpec.getClientJRulesImplementationVersion();
        String string2 = "6.5.3.22";
        if (string == null || !string.equals(string2)) {
            this.getLogHandler().warning(9007, null, new Object[]{string2, string}, (Object)this, null);
        }
        byte by = ilrXUConnectionSpec.getType();
        String string3 = ilrXUConnectionSpec.getRulesetPath();
        IlrConnectionId ilrConnectionId = ilrXUConnectionSpec.getConnectionId();
        ClassLoader classLoader = ilrXUConnectionSpec.getXOMClassLoader();
        boolean bl = true;
        switch (by) {
            case 0: {
                bl = string3 != null && ilrConnectionId == null;
                break;
            }
            case 1: {
                bl = string3 == null && ilrConnectionId == null && classLoader == null;
                break;
            }
            case 2: {
                bl = string3 == null && ilrConnectionId != null && classLoader == null;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10010, (Object)ilrXUConnectionSpec);
        }
    }

    public IlrLogHandler getLogHandler() {
        return this.managedConnectionFactory.getLogHandler();
    }

    protected IlrMessages getMessages() {
        return this.getLogHandler().getMessages();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.recordFactory = new IlrXURecordFactory();
    }
}

