/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.xu.cci;

import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.xu.IlrXUContext;
import ilog.rules.bres.xu.cci.IlrConnectionContext;
import ilog.rules.bres.xu.cci.IlrConnectionId;
import ilog.rules.bres.xu.cci.IlrInteractionExtension;
import ilog.rules.bres.xu.cci.IlrRuleEngineInteractionSpec;
import ilog.rules.bres.xu.cci.IlrXUConnection;
import ilog.rules.bres.xu.cci.IlrXUInteractionSpec;
import ilog.rules.bres.xu.cci.IlrXUManagementInteractionSpec;
import ilog.rules.bres.xu.cci.IlrXURecordFactory;
import ilog.rules.bres.xu.event.IlrInteractionEvent;
import ilog.rules.bres.xu.event.IlrWarningEvent;
import ilog.rules.bres.xu.event.IlrWarningEventListener;
import ilog.rules.bres.xu.event.IlrXUEventDispatcher;
import ilog.rules.bres.xu.event.IlrXUEventListener;
import ilog.rules.bres.xu.log.IlrLogHandler;
import ilog.rules.bres.xu.log.IlrMessages;
import ilog.rules.bres.xu.spi.IlrManagedConnectionContext;
import ilog.rules.bres.xu.util.IlrResourceExceptionHelper;
import ilog.rules.engine.IlrRulesetParameter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;

public class IlrXUInteraction
implements Interaction,
IlrWarningEventListener {
    public static final byte STATE_ACTIVE = 0;
    public static final byte STATE_CLOSED = 1;
    protected IlrXUConnection connection = null;
    protected IlrConnectionId connectionId = null;
    protected ResourceWarning warning = null;
    protected IlrLogHandler logger = null;
    protected byte state = 0;

    public IlrXUInteraction(IlrXUConnection ilrXUConnection) {
        this.connection = ilrXUConnection;
        this.connectionId = ilrXUConnection.getId();
        this.logger = ilrXUConnection.getLogHandler();
        IlrXUEventDispatcher ilrXUEventDispatcher = ilrXUConnection.getManagedConnection().getEventDispatcher();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("CCI interaction register warnings listener", null, this.getXUContext());
        }
        ilrXUEventDispatcher.addListener((IlrXUEventListener)this, 4L);
    }

    protected IlrMessages getMessages() {
        return this.getLogHandler().getMessages();
    }

    protected IlrLogHandler getLogHandler() {
        return this.logger;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected boolean dispatchExecution(String string, InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE) {
            return this.contextExecute(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_PARAMETERS) {
            return this.contextGetParameters(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_BOM_PARAMETERS) {
            return this.contextGetBOMParameters(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE_MAIN) {
            return this.contextExecuteMain(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE_TASK) {
            return this.contextExecuteTask(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_SET_PARAMETERS) {
            return this.contextSetParameters(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_SET_BOM_PARAMETERS) {
            return this.contextSetBOMParameters(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INSERT) {
            return this.contextInsert(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_INSERT_WITH_ID) {
            return this.contextInsertWithId(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RETRACT) {
            return this.contextRetract(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RETRACT_BY_ID) {
            return this.contextRetractById(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_UPDATE) {
            return this.contextUpdate(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_OUTPUT) {
            return this.contextGetOutput(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RESET) {
            return this.contextReset();
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_RULEFLOW_RESET) {
            return this.ruleflowReset();
        }
        if (string == IlrXUManagementInteractionSpec.FUNCTION_NAME_START_PROFILING_SESSION) {
            return this.startProfilingSession(interactionSpec, record, record2);
        }
        if (string == IlrXUManagementInteractionSpec.FUNCTION_NAME_STOP_PROFILING_SESSION) {
            return this.stopProfilingSession(interactionSpec, record, record2);
        }
        if (string == "connectionId") {
            return this.getConnectionId(record2);
        }
        if (string == "ruleset.getInformation") {
            return this.getRulesetInformation(record2);
        }
        if (string == IlrXUManagementInteractionSpec.FUNCTION_NAME_SOLVE_RULESET_PATH) {
            return this.solveRulesetPath(interactionSpec, record2);
        }
        if (string == IlrXUManagementInteractionSpec.FUNCTION_NAME_RULESET_ARCHIVE_CHANGED) {
            return this.notifyRulesetArchiveChanged(interactionSpec, record, record2);
        }
        if (string == "ruleEngine.getWorkingMemory") {
            return this.contextGetWorkingMemory(record2);
        }
        if (string == "ruleEngine.getWorkingMemoryWithId") {
            return this.contextGetWorkingMemoryWithId(record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EVALUATE) {
            return this.contextEvaluate(record, record2);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_INFORMATION) {
            return this.contextGetInformation(record2);
        }
        if (string == "log.write") {
            return this.writeLog(record);
        }
        if (string == IlrRuleEngineInteractionSpec.FUNCTION_NAME_ENABLE_RULESET_EXECUTION_INFORMATION) {
            return this.enableRulesetExecutionInformation(interactionSpec);
        }
        if (string == IlrXUManagementInteractionSpec.FUNCTION_NAME_GET_XU_INFORMATION) {
            return this.getXUInformation(interactionSpec, record2);
        }
        return this.executeInteractionExtension(interactionSpec, record, record2);
    }

    public boolean executeInteractionExtension(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        IlrInteractionExtension[] ilrInteractionExtensionArray = this.connection.getInteractionExtensions();
        for (int i = 0; i < ilrInteractionExtensionArray.length; ++i) {
            IlrInteractionExtension ilrInteractionExtension = ilrInteractionExtensionArray[i];
            if (!ilrInteractionExtension.isSupported(interactionSpec)) continue;
            return this.connection.executeInteractionExtension(ilrInteractionExtension, interactionSpec, record, record2);
        }
        return false;
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException, RuntimeException {
        Object object;
        String string = null;
        boolean bl = false;
        IlrXUEventDispatcher ilrXUEventDispatcher = null;
        IlrManagedConnectionContext ilrManagedConnectionContext = null;
        IlrConnectionContext ilrConnectionContext = null;
        if (this.connection != null) {
            ilrConnectionContext = this.connection.getContext();
            object = this.connection.getManagedConnection();
            ilrManagedConnectionContext = object.getManagedConnectionContext(this.connection);
            ilrXUEventDispatcher = object.getEventDispatcher();
        }
        try {
            if (this.getLogHandler().isLoggable(Level.FINEST)) {
                this.getLogHandler().finest("Interaction.execute", new Object[]{interactionSpec}, (IlrXUContext)ilrManagedConnectionContext);
            }
            if (this.state == 1) {
                throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10501);
            }
            string = this.getFunctionName(interactionSpec).intern();
            object = new IlrInteractionEvent(0, this, string, ilrConnectionContext);
            ilrXUEventDispatcher.interactionEventRaised((IlrInteractionEvent)object);
            bl = this.dispatchExecution(string, interactionSpec, record, record2);
        }
        catch (ResourceException resourceException) {
            if (this.connection != null) {
                ilrManagedConnectionContext = this.connection.getManagedConnection().getManagedConnectionContext(this.connection);
            }
            this.getLogHandler().severe(10001, (Throwable)resourceException, string, (IlrXUContext)ilrManagedConnectionContext);
            throw resourceException;
        }
        catch (RuntimeException runtimeException) {
            if (this.connection != null) {
                ilrManagedConnectionContext = this.connection.getManagedConnection().getManagedConnectionContext(this.connection);
            }
            this.getLogHandler().severe(10001, (Throwable)runtimeException, string, (IlrXUContext)ilrManagedConnectionContext);
            throw runtimeException;
        }
        if (this.connection != null) {
            ilrManagedConnectionContext = this.connection.getManagedConnection().getManagedConnectionContext(this.connection);
        }
        if (bl) {
            object = new IlrInteractionEvent(1, this, string, ilrConnectionContext);
            ilrXUEventDispatcher.interactionEventRaised((IlrInteractionEvent)object);
            return true;
        }
        object = IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10012, (Object)string);
        this.getLogHandler().severe(10001, (Throwable)object, (Object)string, (IlrXUContext)ilrManagedConnectionContext);
        throw object;
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        Cloneable cloneable = null;
        String string = null;
        try {
            string = this.getFunctionName(interactionSpec);
            cloneable = string.equals(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE) || string.equals(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_EXECUTE_TASK) || string.equals(IlrRuleEngineInteractionSpec.FUNCTION_NAME_GET_INFORMATION) || string.equals(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_PARAMETERS) || string.equals(IlrRuleEngineInteractionSpec.FUNCTION_NAME_RULE_ENGINE_GET_BOM_PARAMETERS) || string.equals("ruleset.getInformation") || string.equals("ruleEngine.getWorkingMemoryWithId") ? new IlrXURecordFactory.MappedRecord("output") : new IlrXURecordFactory.IndexedRecord("output");
        }
        catch (ResourceException resourceException) {
            IlrConnectionContext ilrConnectionContext = null;
            if (this.connection != null) {
                ilrConnectionContext = this.connection.getContext();
            }
            this.getLogHandler().severe(10001, (Throwable)resourceException, (Object)string, (IlrXUContext)ilrConnectionContext);
        }
        if (this.execute(interactionSpec, record, (Record)cloneable)) {
            return cloneable;
        }
        return null;
    }

    public synchronized void close() throws ResourceException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("CCI interaction close ", null, this.getXUContext());
        }
        if (this.state == 1) {
            ResourceException resourceException = IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10500);
            this.getLogHandler().severe(10502, (Throwable)resourceException);
            throw resourceException;
        }
        this.state = 1;
        this.connection.close(this);
        this.connection = null;
    }

    public ResourceWarning getWarnings() throws ResourceException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("CCI interaction getWarnings " + this.warning, null, this.getXUContext());
        }
        return this.warning;
    }

    public void clearWarnings() throws ResourceException {
        this.logger.finest("CCI interaction clearWarnings", null, this.getXUContext());
        this.warning = null;
    }

    protected boolean notifyRulesetArchiveChanged(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        String string = this.getCanonicalRulesetPath(interactionSpec);
        if (string != null) {
            this.connection.notifyRulesetArchiveChanged(string);
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10012, (Object)interactionSpec);
    }

    protected boolean solveRulesetPath(InteractionSpec interactionSpec, Record record) throws ResourceException {
        String string = this.getRulesetPath(interactionSpec);
        if (string == null) {
            throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10012, (Object)interactionSpec);
        }
        if (record == null || !(record instanceof IndexedRecord)) {
            throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
        }
        ((IndexedRecord)record).add((Object)this.connection.solveRulesetPath(string));
        return true;
    }

    protected boolean startProfilingSession(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        if (record != null && record instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)mappedRecord);
            this.connection.startProfilingSession(properties);
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean stopProfilingSession(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        if (record != null && record instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)mappedRecord);
            this.connection.stopProfilingSession(properties);
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean enableRulesetExecutionInformation(InteractionSpec interactionSpec) throws ResourceException {
        this.connection.enableRulesetExecutionInformation(this.getRulesetExecutionInformationFilter(interactionSpec));
        return true;
    }

    protected boolean writeLog(Record record) throws ResourceException {
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            Object[] objectArray = new String[]{};
            this.connection.writeLog((String[])indexedRecord.toArray(objectArray));
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextEvaluate(Record record, Record record2) throws ResourceException {
        if (record2 instanceof IndexedRecord && record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            Object[] objectArray = new String[]{};
            Object[] objectArray2 = this.connection.contextEvaluate((String[])indexedRecord.toArray(objectArray));
            ((IndexedRecord)record2).addAll(Arrays.asList(objectArray2));
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextGetInformation(Record record) throws ResourceException {
        if (record instanceof MappedRecord) {
            ((MappedRecord)record).putAll(this.connection.contextGetInformation());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextExecute(Record record, Record record2) throws ResourceException {
        if (record2 instanceof MappedRecord) {
            ((MappedRecord)record2).putAll((Map)this.connection.contextExecute());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextGetParameters(Record record, Record record2) throws ResourceException {
        if (record2 instanceof MappedRecord) {
            ((MappedRecord)record2).putAll((Map)this.connection.contextGetParameters());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextGetBOMParameters(Record record, Record record2) throws ResourceException {
        if (record2 instanceof MappedRecord) {
            ((MappedRecord)record2).putAll((Map)this.connection.contextGetBOMParameters());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean getConnectionId(Record record) throws ResourceException {
        if (record instanceof IndexedRecord) {
            ((IndexedRecord)record).add((Object)this.connection.getId());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean getRulesetInformation(Record record) throws ResourceException {
        if (record instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record;
            IlrRulesetParameter[] ilrRulesetParameterArray = this.connection.getRulesetParameters();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (int i = 0; i < ilrRulesetParameterArray.length; ++i) {
                IlrRulesetParameter ilrRulesetParameter = ilrRulesetParameterArray[i];
                hashMap.put(ilrRulesetParameter.getName() + ".kind", new Integer(ilrRulesetParameter.getKind()));
            }
            mappedRecord.put((Object)"parameters", Collections.unmodifiableMap(hashMap));
            mappedRecord.put((Object)"path", (Object)this.connection.getSpec().getRulesetPath());
            IlrRulesetArchiveInformation ilrRulesetArchiveInformation = this.connection.getRulesetArchiveInformation();
            mappedRecord.put((Object)"path.canonical", (Object)ilrRulesetArchiveInformation.getCanonicalRulesetPath());
            mappedRecord.put((Object)"properties", (Object)ilrRulesetArchiveInformation.getProperties().toProperties());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextExecuteMain(Record record, Record record2) throws ResourceException {
        if (record2 instanceof IndexedRecord) {
            Object object = null;
            if (record instanceof IndexedRecord) {
                IndexedRecord indexedRecord = (IndexedRecord)record;
                if (indexedRecord.size() == 1) {
                    object = ((IndexedRecord)record).get(0);
                } else if (indexedRecord.size() > 1) {
                    throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
                }
            } else if (record != null) {
                throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
            }
            ((IndexedRecord)record2).add(this.connection.contextExecuteMain(object));
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextExecuteTask(Record record, Record record2) throws ResourceException {
        IndexedRecord indexedRecord;
        if (record instanceof IndexedRecord && record2 instanceof MappedRecord && (indexedRecord = (IndexedRecord)record).size() == 1) {
            Object object = indexedRecord.get(0);
            if (object instanceof String) {
                String string = (String)object;
                ((MappedRecord)record2).putAll((Map)this.connection.contextExecuteTask(string));
            }
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextSetParameters(Record record, Record record2) throws ResourceException {
        HashMap hashMap = null;
        if (record != null && record instanceof MappedRecord) {
            if (record instanceof HashMap) {
                hashMap = (HashMap)record;
            } else if (record instanceof Map) {
                hashMap = new HashMap();
                hashMap.putAll((Map)record);
            }
        }
        if (hashMap != null) {
            this.connection.contextSetParameters(hashMap);
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextSetBOMParameters(Record record, Record record2) throws ResourceException {
        HashMap hashMap = null;
        if (record != null && record instanceof MappedRecord) {
            if (record instanceof HashMap) {
                hashMap = (HashMap)record;
            } else if (record instanceof Map) {
                hashMap = new HashMap();
                hashMap.putAll((Map)record);
            }
        }
        if (hashMap != null) {
            this.connection.contextSetBOMParameters(hashMap);
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextInsert(Record record, Record record2) throws ResourceException {
        if (record instanceof IndexedRecord && ((List)record).size() % 2 == 0) {
            this.connection.contextInsert((List)record);
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextInsertWithId(Record record, Record record2) throws ResourceException {
        if (record instanceof IndexedRecord && ((List)record).size() % 3 == 0) {
            this.connection.contextInsertWithId((List)record);
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextRetract(Record record, Record record2) throws ResourceException {
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            this.connection.contextRetract(indexedRecord.toArray());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextRetractById(Record record, Record record2) throws ResourceException {
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            this.connection.contextRetractById(indexedRecord.toArray());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextUpdate(Record record, Record record2) throws ResourceException {
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            this.connection.contextUpdate(indexedRecord.toArray());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextGetWorkingMemory(Record record) throws ResourceException {
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            indexedRecord.addAll(Arrays.asList(this.connection.contextGetWorkingMemory()));
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextGetWorkingMemoryWithId(Record record) throws ResourceException {
        if (record instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record;
            mappedRecord.putAll(this.connection.contextGetWorkingMemoryWithId());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextGetOutput(Record record, Record record2) throws ResourceException {
        if (record2 instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record2;
            indexedRecord.add((Object)this.connection.contextGetOutput());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    public boolean getXUInformation(InteractionSpec interactionSpec, Record record) throws ResourceException {
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            indexedRecord.add((Object)this.connection.getXUInformation());
            indexedRecord.add((Object)this.connection.getXUDump().toXMLString());
            return true;
        }
        throw IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10013);
    }

    protected boolean contextReset() throws ResourceException {
        this.connection.contextReset();
        return true;
    }

    protected boolean ruleflowReset() throws ResourceException {
        this.connection.ruleflowReset();
        return true;
    }

    public void warningRaised(IlrWarningEvent ilrWarningEvent) {
        this.logger.finest("CCI interaction Received: " + ilrWarningEvent, null, this.getXUContext());
        IlrXUContext ilrXUContext = ilrWarningEvent.getXUContext();
        IlrConnectionContext ilrConnectionContext = null;
        if (ilrXUContext instanceof IlrConnectionContext) {
            ilrConnectionContext = (IlrConnectionContext)ilrXUContext;
        } else if (ilrXUContext instanceof IlrManagedConnectionContext) {
            ilrConnectionContext = ((IlrManagedConnectionContext)ilrXUContext).getConnectionContext();
        }
        if (ilrConnectionContext != null && this.connectionId.equals(ilrConnectionContext.getConnectionInformation().getConnectionId())) {
            this.logger.finest("CCI interaction Received: " + ilrWarningEvent + " concerning: " + ilrConnectionContext.getConnectionInformation().getConnectionId(), null, this.getXUContext());
            IlrMessages ilrMessages = this.getMessages();
            String string = ilrMessages.formatMessage(ilrWarningEvent.getMessageCode(), (Object[])ilrWarningEvent.getMessageVariableValues());
            ResourceWarning resourceWarning = new ResourceWarning(string, IlrMessages.codeToString((int)ilrWarningEvent.getCode()));
            if (this.warning != null) {
                resourceWarning.setLinkedWarning(this.warning);
            }
            this.warning = resourceWarning;
        }
    }

    protected String getFunctionName(InteractionSpec interactionSpec) throws ResourceException {
        try {
            Object object;
            String string = null;
            if (interactionSpec instanceof IlrXUInteractionSpec) {
                string = ((IlrXUInteractionSpec)interactionSpec).getFunctionName();
            } else {
                object = interactionSpec.getClass();
                Method method = object.getMethod("getFunctionName", null);
                string = (String)method.invoke((Object)interactionSpec, null);
            }
            if (string == null) {
                object = IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10012, (Object)interactionSpec, null);
                throw object;
            }
            return string;
        }
        catch (Exception exception) {
            ResourceException resourceException = IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10012, (Object)interactionSpec, (Exception)exception);
            throw resourceException;
        }
    }

    protected String getCanonicalRulesetPath(InteractionSpec interactionSpec) throws ResourceException {
        try {
            if (interactionSpec instanceof IlrXUManagementInteractionSpec) {
                return ((IlrXUManagementInteractionSpec)interactionSpec).getCanonicalRulesetPath();
            }
            Class<?> clazz = interactionSpec.getClass();
            Method method = clazz.getMethod("getCanonicalRulesetPath", null);
            return (String)method.invoke((Object)interactionSpec, null);
        }
        catch (Exception exception) {
            ResourceException resourceException = IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10012, (Object)interactionSpec, (Exception)exception);
            throw resourceException;
        }
    }

    protected int getRulesetExecutionInformationFilter(InteractionSpec interactionSpec) throws ResourceException {
        try {
            if (interactionSpec instanceof IlrRuleEngineInteractionSpec) {
                return ((IlrRuleEngineInteractionSpec)interactionSpec).getRulesetExecutionInformationFilter();
            }
            Class<?> clazz = interactionSpec.getClass();
            Method method = clazz.getMethod("getRulesetExecutionInformationFilter", null);
            return (Integer)method.invoke((Object)interactionSpec, null);
        }
        catch (Exception exception) {
            ResourceException resourceException = IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10012, (Object)interactionSpec, (Exception)exception);
            throw resourceException;
        }
    }

    protected String getRulesetPath(InteractionSpec interactionSpec) throws ResourceException {
        try {
            if (interactionSpec instanceof IlrXUManagementInteractionSpec) {
                return ((IlrXUManagementInteractionSpec)interactionSpec).getRulesetPath();
            }
            Class<?> clazz = interactionSpec.getClass();
            Method method = clazz.getMethod("getRulesetPath", null);
            return (String)method.invoke((Object)interactionSpec, null);
        }
        catch (Exception exception) {
            ResourceException resourceException = IlrResourceExceptionHelper.createResourceException((IlrMessages)this.getMessages(), (int)10012, (Object)interactionSpec, (Exception)exception);
            throw resourceException;
        }
    }

    protected IlrXUContext getXUContext() {
        return this.connection != null ? this.connection.getContext() : null;
    }
}

