/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.base.IlrDefaultErrorManager;
import ilog.rules.base.IlrMutableStringMap;
import ilog.rules.base.IlrStringMap;
import ilog.rules.datasource.IlrDefaultTableModel;
import ilog.rules.datasource.IlrMutableTableDataSourceModel;
import ilog.rules.datasource.IlrTableDataSourceModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class IlrDefaultDataSourceModel
implements IlrMutableTableDataSourceModel {
    private HashMap tableFromName = new HashMap();
    private IlrMutableStringMap properties;

    public IlrDefaultDataSourceModel() {
        this.properties = new IlrMutableStringMap();
    }

    public IlrDefaultDataSourceModel(IlrMutableStringMap ilrMutableStringMap) {
        this.properties = ilrMutableStringMap;
    }

    public IlrMutableTableDataSourceModel.MutableTable createTable(String string) {
        return new IlrDefaultTableModel(string);
    }

    public IlrMutableTableDataSourceModel.MutableTable getMutableTable(String string) {
        return (IlrMutableTableDataSourceModel.MutableTable)this.tableFromName.get(string);
    }

    public IlrTableDataSourceModel.Table[] getTables() {
        Collection collection = this.tableFromName.values();
        IlrTableDataSourceModel.Table[] tableArray = new IlrTableDataSourceModel.Table[collection.size()];
        return collection.toArray(tableArray);
    }

    public IlrMutableStringMap getMutableProperties() {
        return this.properties;
    }

    public void addTable(IlrMutableTableDataSourceModel.MutableTable mutableTable) {
        this.tableFromName.put(mutableTable.getName(), mutableTable);
    }

    public boolean removeTable(String string) {
        return this.tableFromName.remove(string) != null;
    }

    public IlrTableDataSourceModel.Table getTable(String string) {
        return this.getMutableTable(string);
    }

    public IlrStringMap getProperties() {
        return this.properties;
    }

    public static void checkModel(IlrTableDataSourceModel ilrTableDataSourceModel, IlrDefaultErrorManager ilrDefaultErrorManager) {
        IlrTableDataSourceModel.Table[] tableArray = ilrTableDataSourceModel.getTables();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < tableArray.length; ++i) {
            IlrTableDataSourceModel.Table table = tableArray[i];
            if (table.getName() == null) {
                ilrDefaultErrorManager.addError("ERROR_DS_002", new String[]{Integer.toString(i)});
            } else if (hashSet.contains(table.getName())) {
                ilrDefaultErrorManager.addError("ERROR_DS_004", new String[]{table.getName()});
            } else {
                hashSet.add(table.getName());
            }
            hashSet2.clear();
            IlrTableDataSourceModel.Column[] columnArray = table.getColumns();
            for (int j = 0; j < columnArray.length; ++j) {
                IlrTableDataSourceModel.Column column = columnArray[i];
                if (column.getName() == null) {
                    ilrDefaultErrorManager.addError("ERROR_DS_003", new String[]{Integer.toString(i), table.getName()});
                } else if (hashSet2.contains(column.getName())) {
                    ilrDefaultErrorManager.addError("ERROR_DS_005", new String[]{column.getName(), table.getName()});
                } else {
                    hashSet2.add(column.getName());
                }
                if (column.getType() != null) continue;
                ilrDefaultErrorManager.addError("ERROR_DS_006", new String[]{column.getName(), table.getName()});
            }
        }
    }
}

