/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.base.IlrArrayIndexer;
import ilog.rules.base.IlrDefaultErrorManager;
import ilog.rules.base.IlrErrorException;
import ilog.rules.base.IlrErrorManager;
import ilog.rules.base.IlrWarning;
import ilog.rules.datasource.IlrDefaultDataSourceModel;
import ilog.rules.datasource.IlrMutableTableDataSource;
import ilog.rules.datasource.IlrTableDataSource;
import ilog.rules.datasource.IlrTableDataSourceModel;
import java.util.ArrayList;
import java.util.HashMap;

public class IlrMemTableDataSource
implements IlrMutableTableDataSource {
    private IlrTableDataSourceModel model;
    private String name;
    private transient HashMap tableDSFromName = new HashMap();
    private static String NULL_VALUE = "";

    public IlrMemTableDataSource(String string, IlrTableDataSourceModel ilrTableDataSourceModel) {
        this.name = string;
        this.model = ilrTableDataSourceModel;
        IlrTableDataSourceModel.Table[] tableArray = ilrTableDataSourceModel.getTables();
        for (int i = 0; i < tableArray.length; ++i) {
            this.tableDSFromName.put(tableArray[i].getName(), new TableDS(tableArray[i]));
        }
    }

    public static IlrMemTableDataSource createDataSource(IlrTableDataSource ilrTableDataSource, String string) throws Exception {
        IlrMemTableDataSource ilrMemTableDataSource = new IlrMemTableDataSource(string, ilrTableDataSource.getModel());
        boolean bl = ilrTableDataSource.isConnected();
        if (!bl) {
            ilrTableDataSource.connectDevice();
        }
        IlrTableDataSourceModel.Table[] tableArray = ilrTableDataSource.getModel().getTables();
        for (int i = 0; i < tableArray.length; ++i) {
            String string2 = tableArray[i].getName();
            IlrTableDataSource.RowIterator rowIterator = ilrTableDataSource.iterateRows(string2);
            while (rowIterator.hasNext()) {
                IlrTableDataSource.Row row = rowIterator.nextRow();
                IlrMutableTableDataSource.MutableRow mutableRow = ilrMemTableDataSource.addRow(string2);
                mutableRow.setCells(row.getCells());
            }
        }
        if (!bl) {
            ilrTableDataSource.disconnectDevice();
        }
        return ilrMemTableDataSource;
    }

    public IlrTableDataSourceModel getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void connectDevice() throws Exception {
    }

    public void disconnectDevice() throws Exception {
    }

    public boolean isConnected() {
        return true;
    }

    public boolean isQuerySupported() {
        return false;
    }

    public void synchronizeDevice() throws Exception {
    }

    public IlrMutableTableDataSource.MutableRowIterator iterateMutableRows(String string, String string2) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void connectDevice(String string) throws Exception {
    }

    public IlrTableDataSource.RowIterator iterateRows(String string, String string2) throws Exception {
        throw new UnsupportedOperationException();
    }

    public IlrTableDataSource.RowIterator iterateRows(String string) {
        TableDS tableDS = (TableDS)this.tableDSFromName.get(string);
        if (tableDS == null) {
            return null;
        }
        return tableDS.iterateMutableRows();
    }

    public IlrMutableTableDataSource.MutableRowIterator iterateMutableRows(String string) {
        TableDS tableDS = (TableDS)this.tableDSFromName.get(string);
        if (tableDS == null) {
            return null;
        }
        return tableDS.iterateMutableRows();
    }

    public IlrWarning[] check() throws IlrErrorException {
        IlrDefaultErrorManager ilrDefaultErrorManager = new IlrDefaultErrorManager();
        IlrDefaultDataSourceModel.checkModel(this.model, ilrDefaultErrorManager);
        IlrTableDataSourceModel.Table[] tableArray = this.model.getTables();
        for (int i = 0; i < tableArray.length; ++i) {
            this.checkContent(tableArray[i], ilrDefaultErrorManager);
        }
        if (ilrDefaultErrorManager.hasErrors()) {
            throw ilrDefaultErrorManager.createException();
        }
        return ilrDefaultErrorManager.getWarnings();
    }

    private void checkContent(IlrTableDataSourceModel.Table table, IlrErrorManager ilrErrorManager) throws IlrErrorException {
        IlrTableDataSource.RowIterator rowIterator = this.iterateRows(table.getName());
        IlrTableDataSourceModel.Column[] columnArray = table.getColumns();
        int n = columnArray.length;
        try {
            while (rowIterator.hasNext()) {
                IlrTableDataSource.Row row = rowIterator.nextRow();
                for (int i = 0; i < n; ++i) {
                    Object object = row.getCell(i);
                    if (this.isNullValue(object)) continue;
                    if (object == null) {
                        ilrErrorManager.addError("ERROR_DS_007", new String[]{columnArray[i].getName(), table.getName()});
                        continue;
                    }
                    if (object.getClass() == columnArray[i].getType()) continue;
                    String string = columnArray[i].getType() == null ? "null" : columnArray[i].getType().getName();
                    ilrErrorManager.addError("ERROR_DS_008", new String[]{columnArray[i].getName(), table.getName(), object.getClass().getName(), string});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IlrMutableTableDataSource.MutableRow addRow(String string) throws Exception {
        TableDS tableDS = (TableDS)this.tableDSFromName.get(string);
        if (tableDS != null) {
            return tableDS.addRow();
        }
        return null;
    }

    public void removeRow(String string, int n) throws Exception {
        TableDS tableDS = (TableDS)this.tableDSFromName.get(string);
        if (tableDS != null) {
            tableDS.removeRow(n);
        }
    }

    public Object getNullValue() {
        return NULL_VALUE;
    }

    public boolean isNullValue(Object object) {
        return object == NULL_VALUE;
    }

    public void setModel(IlrTableDataSourceModel ilrTableDataSourceModel) {
        this.model = ilrTableDataSourceModel;
    }

    private static final class RowDS
    implements IlrMutableTableDataSource.MutableRow {
        IlrArrayIndexer tableIndexer;
        final Object[] cells;
        int index = -1;

        public RowDS(Object[] objectArray, IlrArrayIndexer ilrArrayIndexer, int n) {
            this.tableIndexer = ilrArrayIndexer;
            this.cells = objectArray;
            this.index = n;
        }

        public Object getCell(String string) {
            return this.cells[this.tableIndexer.getIndex(string)];
        }

        public Object getCell(int n) {
            return this.cells[n];
        }

        public Object[] getCells() {
            return this.cells;
        }

        public void setCell(int n, Object object) {
            this.cells[n] = object;
        }

        public void setCell(String string, Object object) {
            this.cells[this.tableIndexer.getIndex((String)string)] = object;
        }

        public int getIndex() {
            return this.index;
        }

        public void setCells(Object[] objectArray) {
            System.arraycopy(objectArray, 0, this.cells, 0, this.cells.length);
        }
    }

    private static final class MutableIteratorDS
    implements IlrMutableTableDataSource.MutableRowIterator {
        ArrayList rows;
        int nextIx;

        public MutableIteratorDS(ArrayList arrayList) {
            this.rows = arrayList;
        }

        public IlrMutableTableDataSource.MutableRow nextMutableRow() {
            return (IlrMutableTableDataSource.MutableRow)this.nextRow();
        }

        public boolean hasNext() {
            return this.nextIx < this.rows.size();
        }

        public IlrTableDataSource.Row nextRow() {
            if (this.nextIx < this.rows.size()) {
                return (IlrTableDataSource.Row)this.rows.get(this.nextIx++);
            }
            return null;
        }

        public void remove() {
            if (this.nextIx < this.rows.size()) {
                this.rows.remove(this.nextIx);
                --this.nextIx;
            }
        }

        public IlrTableDataSource.Row[] toRowArray() throws Exception {
            IlrTableDataSource.Row[] rowArray = new IlrTableDataSource.Row[this.rows.size()];
            return this.rows.toArray(rowArray);
        }
    }

    private static final class TableDS {
        ArrayList rows = new ArrayList();
        IlrArrayIndexer tableIndexer;
        int rowSize;

        public TableDS(IlrTableDataSourceModel.Table table) {
            this.rowSize = table.getColumnCount();
            String[] stringArray = new String[this.rowSize];
            for (int i = 0; i < this.rowSize; ++i) {
                stringArray[i] = table.getColumn(i).getName();
            }
            this.tableIndexer = new IlrArrayIndexer(stringArray);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public IlrMutableTableDataSource.MutableRowIterator iterateMutableRows() {
            return new MutableIteratorDS(this.rows);
        }

        public IlrMutableTableDataSource.MutableRow addRow() throws Exception {
            RowDS rowDS = new RowDS(new Object[this.rowSize], this.tableIndexer, this.rows.size());
            this.rows.add(rowDS);
            return rowDS;
        }

        public void removeRow(int n) throws Exception {
            this.rows.remove(n);
            for (int i = n; i < this.rows.size(); ++i) {
                RowDS rowDS = (RowDS)this.rows.get(i);
                --rowDS.index;
            }
        }
    }
}

