/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.base.IlrDefaultErrorManager;
import ilog.rules.base.IlrErrorException;
import ilog.rules.base.IlrErrorManager;
import ilog.rules.base.IlrMutableStringMap;
import ilog.rules.base.IlrUtil;
import ilog.rules.base.xml.IlrQName;
import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlConverterProvider;
import ilog.rules.base.xml.IlrXmlDefaultService;
import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import ilog.rules.base.xml.converter.IlrBooleanConverter;
import ilog.rules.base.xml.converter.IlrByteConverter;
import ilog.rules.base.xml.converter.IlrDoubleConverter;
import ilog.rules.base.xml.converter.IlrFloatConverter;
import ilog.rules.base.xml.converter.IlrIntConverter;
import ilog.rules.base.xml.converter.IlrLongConverter;
import ilog.rules.base.xml.converter.IlrShortConverter;
import ilog.rules.base.xml.converter.IlrStringConverter;
import ilog.rules.datasource.IlrDefaultColumnModel;
import ilog.rules.datasource.IlrDefaultDataSourceModel;
import ilog.rules.datasource.IlrDefaultTableModel;
import ilog.rules.datasource.IlrMemTableDataSource;
import ilog.rules.datasource.IlrMutableTableDataSource;
import ilog.rules.datasource.IlrMutableTableDataSourceModel;
import ilog.rules.datasource.IlrTableDataSource;
import ilog.rules.datasource.IlrTableDataSourceModel;
import ilog.rules.datasource.IlrXmlConstants;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IlrXmlDataSourceReaderWriter
extends IlrXmlDefaultService {
    static /* synthetic */ Class class$ilog$rules$datasource$IlrTableDataSource;
    static /* synthetic */ Class class$ilog$rules$datasource$IlrTableDataSourceModel;
    static /* synthetic */ Class class$ilog$rules$datasource$IlrMemTableDataSource;
    static /* synthetic */ Class class$ilog$rules$base$IlrMutableStringMap;
    static /* synthetic */ Class class$ilog$rules$datasource$IlrDefaultDataSourceModel;

    public IlrXmlDataSourceReaderWriter() {
        this(new IlrDefaultErrorManager());
    }

    public IlrXmlDataSourceReaderWriter(IlrErrorManager ilrErrorManager) {
        super(ilrErrorManager, false);
        ArrayList arrayList = new ArrayList();
        ConverterProvider converterProvider = new ConverterProvider();
        converterProvider.declareConverters(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.addConverter((IlrXmlConverter)arrayList.get(i));
        }
    }

    public void write(IlrTableDataSource ilrTableDataSource, Writer writer) throws IlrErrorException {
        this.writeObject(ilrTableDataSource, writer, new HashMap());
    }

    public IlrTableDataSource read(Reader reader, String string) throws IlrErrorException {
        HashMap hashMap = new HashMap();
        return (IlrTableDataSource)this.readObject(reader, string, hashMap, class$ilog$rules$datasource$IlrTableDataSource == null ? (class$ilog$rules$datasource$IlrTableDataSource = IlrXmlDataSourceReaderWriter.class$("ilog.rules.datasource.IlrTableDataSource")) : class$ilog$rules$datasource$IlrTableDataSource);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class IlrMutableStringMapConverter
    implements IlrXmlConverter,
    IlrXmlConstants {
        private IlrMutableStringMapConverter() {
        }

        public Class[] getSupportedClasses() {
            return new Class[]{class$ilog$rules$base$IlrMutableStringMap == null ? (class$ilog$rules$base$IlrMutableStringMap = IlrXmlDataSourceReaderWriter.class$("ilog.rules.base.IlrMutableStringMap")) : class$ilog$rules$base$IlrMutableStringMap};
        }

        public IlrQName getXmlElement() {
            return IlrXmlConstants.PROPERTIES_ELEMENT;
        }

        public IlrQName getXmlType() {
            return IlrXmlConstants.PROPERTIES_TYPE;
        }

        public IlrQName getSchemaLocation() {
            return IlrXmlConstants.SCHEMA_LOCATION_QNAME;
        }

        public boolean isReferenceWorthy() {
            return true;
        }

        public Object readObject(Element element, IlrXmlUnmarshallingContext ilrXmlUnmarshallingContext) throws IlrErrorException {
            IlrMutableStringMap ilrMutableStringMap = new IlrMutableStringMap();
            NodeList nodeList = element.getElementsByTagName("property");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                ilrMutableStringMap.addProperty(element2.getAttribute("key"), element2.getAttribute("value"));
            }
            return ilrMutableStringMap;
        }

        public void writeObject(Object object, Element element, IlrXmlMarshallingContext ilrXmlMarshallingContext) throws IlrErrorException {
            IlrMutableStringMap ilrMutableStringMap = (IlrMutableStringMap)object;
            Document document = ilrXmlMarshallingContext.getDocument();
            String[] stringArray = ilrMutableStringMap.getKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = document.createElement("property");
                element2.setAttribute("key", stringArray[i]);
                element2.setAttribute("value", ilrMutableStringMap.getValue(stringArray[i]));
                element.appendChild(element2);
            }
        }
    }

    private static class IlrDefaultDataSourceModelConverter
    implements IlrXmlConverter,
    IlrXmlConstants {
        private IlrDefaultDataSourceModelConverter() {
        }

        public void writeObject(Object object, Element element, IlrXmlMarshallingContext ilrXmlMarshallingContext) throws IlrErrorException {
            IlrDefaultDataSourceModel ilrDefaultDataSourceModel = (IlrDefaultDataSourceModel)object;
            Document document = ilrXmlMarshallingContext.getDocument();
            ilrXmlMarshallingContext.writeObject(ilrDefaultDataSourceModel.getProperties(), element);
            Element element2 = ilrXmlMarshallingContext.createElement("http://schemas.ilog.com/JRules/1.0/datasource", "tables");
            element.appendChild(element2);
            IlrTableDataSourceModel.Table[] tableArray = ilrDefaultDataSourceModel.getTables();
            for (int i = 0; i < tableArray.length; ++i) {
                element2.appendChild(this.writeTable(tableArray[i], document, ilrXmlMarshallingContext));
            }
        }

        private Element writeTable(IlrTableDataSourceModel.Table table, Document document, IlrXmlMarshallingContext ilrXmlMarshallingContext) throws IlrErrorException {
            Element element = document.createElement("table");
            element.setAttribute("name", table.getName());
            ilrXmlMarshallingContext.writeObject(table.getProperties(), element);
            Element element2 = document.createElement("columns");
            element.appendChild(element2);
            IlrTableDataSourceModel.Column[] columnArray = table.getColumns();
            for (int i = 0; i < columnArray.length; ++i) {
                IlrTableDataSourceModel.Column column = columnArray[i];
                Element element3 = document.createElement("column");
                element2.appendChild(element3);
                element3.setAttribute("name", column.getName());
                element3.setAttribute("type", column.getType().getName());
                ilrXmlMarshallingContext.writeObject(column.getProperties(), element3);
            }
            return element;
        }

        public Object readObject(Element element, IlrXmlUnmarshallingContext ilrXmlUnmarshallingContext) throws IlrErrorException {
            Element element2 = ilrXmlUnmarshallingContext.getFirstElement(element, IlrXmlConstants.PROPERTIES_ELEMENT.getNamespaceURI(), IlrXmlConstants.PROPERTIES_ELEMENT.getLocalPart());
            IlrMutableStringMap ilrMutableStringMap = (IlrMutableStringMap)ilrXmlUnmarshallingContext.readObject(null, element2, class$ilog$rules$base$IlrMutableStringMap == null ? (class$ilog$rules$base$IlrMutableStringMap = IlrXmlDataSourceReaderWriter.class$("ilog.rules.base.IlrMutableStringMap")) : class$ilog$rules$base$IlrMutableStringMap);
            IlrDefaultDataSourceModel ilrDefaultDataSourceModel = new IlrDefaultDataSourceModel(ilrMutableStringMap);
            Element element3 = ilrXmlUnmarshallingContext.getNextElement(element2, null, "tables");
            NodeList nodeList = element3.getElementsByTagName("table");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element4 = (Element)nodeList.item(i);
                IlrMutableTableDataSourceModel.MutableTable mutableTable = this.readTable(element4, ilrXmlUnmarshallingContext);
                ilrDefaultDataSourceModel.addTable(mutableTable);
            }
            return ilrDefaultDataSourceModel;
        }

        private IlrMutableTableDataSourceModel.MutableTable readTable(Element element, IlrXmlUnmarshallingContext ilrXmlUnmarshallingContext) throws IlrErrorException {
            String string = element.getAttribute("name");
            Element element2 = ilrXmlUnmarshallingContext.getFirstElement(element, IlrXmlConstants.PROPERTIES_ELEMENT.getNamespaceURI(), IlrXmlConstants.PROPERTIES_ELEMENT.getLocalPart());
            IlrMutableStringMap ilrMutableStringMap = (IlrMutableStringMap)ilrXmlUnmarshallingContext.readObject(null, element2, class$ilog$rules$base$IlrMutableStringMap == null ? (class$ilog$rules$base$IlrMutableStringMap = IlrXmlDataSourceReaderWriter.class$("ilog.rules.base.IlrMutableStringMap")) : class$ilog$rules$base$IlrMutableStringMap);
            IlrDefaultTableModel ilrDefaultTableModel = new IlrDefaultTableModel(string, ilrMutableStringMap);
            Element element3 = ilrXmlUnmarshallingContext.getNextElement(element2, null, "columns");
            NodeList nodeList = element3.getElementsByTagName("column");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element4 = (Element)nodeList.item(i);
                String string2 = element4.getAttribute("name");
                String string3 = element4.getAttribute("type");
                Class clazz = null;
                if (string3 != null) {
                    try {
                        clazz = IlrUtil.getClassFromName(string3);
                    }
                    catch (Exception exception) {
                        ilrXmlUnmarshallingContext.getErrorManager().addError("ERROR_DS_001", new String[]{string3, string2, string});
                    }
                }
                Element element5 = ilrXmlUnmarshallingContext.getFirstElement(element4, IlrXmlConstants.PROPERTIES_ELEMENT.getNamespaceURI(), IlrXmlConstants.PROPERTIES_ELEMENT.getLocalPart());
                IlrMutableStringMap ilrMutableStringMap2 = (IlrMutableStringMap)ilrXmlUnmarshallingContext.readObject(null, element5, class$ilog$rules$base$IlrMutableStringMap == null ? IlrXmlDataSourceReaderWriter.class$("ilog.rules.base.IlrMutableStringMap") : class$ilog$rules$base$IlrMutableStringMap);
                IlrDefaultColumnModel ilrDefaultColumnModel = new IlrDefaultColumnModel(string2, clazz, ilrMutableStringMap2);
                ilrDefaultTableModel.addColumn(ilrDefaultColumnModel);
            }
            return ilrDefaultTableModel;
        }

        public Class[] getSupportedClasses() {
            return new Class[]{class$ilog$rules$datasource$IlrDefaultDataSourceModel == null ? (class$ilog$rules$datasource$IlrDefaultDataSourceModel = IlrXmlDataSourceReaderWriter.class$("ilog.rules.datasource.IlrDefaultDataSourceModel")) : class$ilog$rules$datasource$IlrDefaultDataSourceModel};
        }

        public IlrQName getXmlElement() {
            return IlrXmlConstants.DEFAULT_MODEL_ELEMENT;
        }

        public IlrQName getXmlType() {
            return IlrXmlConstants.DEFAULT_MODEL_TYPE;
        }

        public IlrQName getSchemaLocation() {
            return IlrXmlConstants.SCHEMA_LOCATION_QNAME;
        }

        public boolean isReferenceWorthy() {
            return true;
        }
    }

    private static class IlrMemDataSourceConverter
    implements IlrXmlConverter,
    IlrXmlConstants {
        private IlrMemDataSourceConverter() {
        }

        public void writeObject(Object object, Element element, IlrXmlMarshallingContext ilrXmlMarshallingContext) throws IlrErrorException {
            IlrMemTableDataSource ilrMemTableDataSource = (IlrMemTableDataSource)object;
            Document document = ilrXmlMarshallingContext.getDocument();
            element.setAttribute("name", ilrMemTableDataSource.getName());
            ilrXmlMarshallingContext.writeObject(ilrMemTableDataSource.getModel(), element);
            try {
                this.writeRows(element, ilrMemTableDataSource, document, ilrXmlMarshallingContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void writeRows(Element element, IlrMemTableDataSource ilrMemTableDataSource, Document document, IlrXmlMarshallingContext ilrXmlMarshallingContext) throws Exception {
            Element element2 = document.createElement("tables");
            element.appendChild(element2);
            IlrTableDataSourceModel.Table[] tableArray = ilrMemTableDataSource.getModel().getTables();
            for (int i = 0; i < tableArray.length; ++i) {
                Element element3 = document.createElement("table");
                String string = tableArray[i].getName();
                element3.setAttribute("name", string);
                element2.appendChild(element3);
                IlrTableDataSource.RowIterator rowIterator = ilrMemTableDataSource.iterateRows(string);
                while (rowIterator.hasNext()) {
                    IlrTableDataSource.Row row = rowIterator.nextRow();
                    Element element4 = document.createElement("row");
                    element3.appendChild(element4);
                    this.writeRow(row, element4, document, ilrXmlMarshallingContext);
                }
            }
        }

        private void writeRow(IlrTableDataSource.Row row, Element element, Document document, IlrXmlMarshallingContext ilrXmlMarshallingContext) throws IlrErrorException {
            Object[] objectArray = row.getCells();
            for (int i = 0; i < objectArray.length; ++i) {
                ilrXmlMarshallingContext.writeObject(objectArray[i], element, new IlrQName("cell"));
            }
        }

        public Object readObject(Element element, IlrXmlUnmarshallingContext ilrXmlUnmarshallingContext) throws IlrErrorException {
            String string = element.getAttribute("name");
            Element element2 = ilrXmlUnmarshallingContext.getFirstElement(element, null, null);
            IlrTableDataSourceModel ilrTableDataSourceModel = (IlrTableDataSourceModel)ilrXmlUnmarshallingContext.readObject(null, element2, class$ilog$rules$datasource$IlrTableDataSourceModel == null ? (class$ilog$rules$datasource$IlrTableDataSourceModel = IlrXmlDataSourceReaderWriter.class$("ilog.rules.datasource.IlrTableDataSourceModel")) : class$ilog$rules$datasource$IlrTableDataSourceModel);
            if (ilrTableDataSourceModel != null) {
                Element element3 = ilrXmlUnmarshallingContext.getNextElement(element2, null, "tables");
                if (element3 == null) {
                    ilrXmlUnmarshallingContext.getErrorManager().addError("xml.data.ERROR_XML_009", new String[]{"tables", element2.toString()});
                } else {
                    IlrMemTableDataSource ilrMemTableDataSource = new IlrMemTableDataSource(string, ilrTableDataSourceModel);
                    this.readTables(element3, ilrMemTableDataSource, ilrXmlUnmarshallingContext);
                    return ilrMemTableDataSource;
                }
            }
            return null;
        }

        private void readTables(Element element, IlrMemTableDataSource ilrMemTableDataSource, IlrXmlUnmarshallingContext ilrXmlUnmarshallingContext) {
            NodeList nodeList = element.getElementsByTagName("table");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("name");
                IlrTableDataSourceModel.Table table = ilrMemTableDataSource.getModel().getTable(string);
                NodeList nodeList2 = element2.getElementsByTagName("row");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    try {
                        IlrMutableTableDataSource.MutableRow mutableRow = ilrMemTableDataSource.addRow(string);
                        this.readCell(element3, table, mutableRow, ilrXmlUnmarshallingContext);
                        continue;
                    }
                    catch (Exception exception) {
                        ilrXmlUnmarshallingContext.getErrorManager().addError("xml.data.ERROR_XML_007", new String[]{exception.getMessage()}, exception);
                    }
                }
            }
        }

        private void readCell(Element element, IlrTableDataSourceModel.Table table, IlrMutableTableDataSource.MutableRow mutableRow, IlrXmlUnmarshallingContext ilrXmlUnmarshallingContext) throws IlrErrorException {
            NodeList nodeList = element.getElementsByTagName("cell");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                IlrTableDataSourceModel.Column column = table.getColumn(i);
                Class clazz = column.getType();
                Object object = null;
                IlrXmlConverter ilrXmlConverter = ilrXmlUnmarshallingContext.getConverterFromClass(clazz);
                if (ilrXmlConverter == null) {
                    ilrXmlUnmarshallingContext.getErrorManager().addError("ERROR_DS_001", new String[]{clazz.getName(), column.getName(), table.getName()});
                } else {
                    object = ilrXmlConverter.readObject(element2, ilrXmlUnmarshallingContext);
                }
                mutableRow.setCell(i, object);
            }
        }

        public Class[] getSupportedClasses() {
            return new Class[]{class$ilog$rules$datasource$IlrMemTableDataSource == null ? (class$ilog$rules$datasource$IlrMemTableDataSource = IlrXmlDataSourceReaderWriter.class$("ilog.rules.datasource.IlrMemTableDataSource")) : class$ilog$rules$datasource$IlrMemTableDataSource};
        }

        public IlrQName getXmlElement() {
            return IlrXmlConstants.MEM_DATASOURCE_ELEMENT;
        }

        public IlrQName getXmlType() {
            return IlrXmlConstants.MEM_DATASOURCE_TYPE;
        }

        public IlrQName getSchemaLocation() {
            return IlrXmlConstants.SCHEMA_LOCATION_QNAME;
        }

        public boolean isReferenceWorthy() {
            return true;
        }
    }

    public static class ConverterProvider
    implements IlrXmlConverterProvider {
        public void declareConverters(ArrayList arrayList) {
            arrayList.add(new IlrMemDataSourceConverter());
            arrayList.add(new IlrDefaultDataSourceModelConverter());
            arrayList.add(new IlrMutableStringMapConverter());
            arrayList.add(new IlrBooleanConverter());
            arrayList.add(new IlrByteConverter());
            arrayList.add(new IlrDoubleConverter());
            arrayList.add(new IlrFloatConverter());
            arrayList.add(new IlrIntConverter());
            arrayList.add(new IlrLongConverter());
            arrayList.add(new IlrShortConverter());
            arrayList.add(new IlrStringConverter());
        }
    }
}

