/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrAuthorMap;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class IlrAuthorWriter
extends FilterWriter {
    List entries = new ArrayList();
    int counter;
    int authorStart;
    Object currentAuthor;

    public IlrAuthorWriter(Writer writer) {
        super(writer);
        this.reset();
    }

    public void reset() {
        this.entries = new ArrayList();
        this.counter = 0;
        this.currentAuthor = null;
    }

    public void resetAuthor() {
        if (this.currentAuthor != null && this.counter > 0) {
            this.entries.add(new Entry(this.currentAuthor, this.authorStart, this.counter));
        }
        this.currentAuthor = null;
    }

    public void setAuthor(Object object) {
        this.resetAuthor();
        this.authorStart = this.counter;
        this.currentAuthor = object;
    }

    public IlrAuthorMap getAuthorMap() {
        return new IlrAuthorMap(this.entries);
    }

    public void write(int n) throws IOException {
        int n2 = this.counter + 1;
        this.out.write(n);
        this.counter = n2;
    }

    public void write(char[] cArray) throws IOException {
        int n = this.counter + cArray.length;
        this.out.write(cArray);
        this.counter = n;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.counter + n2;
        this.out.write(cArray, n, n2);
        this.counter = n3;
    }

    public void write(String string) throws IOException {
        int n = this.counter + string.length();
        this.out.write(string);
        this.counter = n;
    }

    public void write(String string, int n, int n2) throws IOException {
        int n3 = this.counter + n2;
        this.out.write(string, n, n2);
        this.counter = n3;
    }

    static class Entry {
        Object author;
        int start;
        int end;

        Entry(Object object, int n, int n2) {
            this.author = object;
            this.start = n;
            this.end = n2;
        }
    }
}

