/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IlrCSVParser {
    private String _string;
    private List _columns;
    private String _currentColumn = "";
    private StringBuffer _columnBuffer = new StringBuffer();
    private int _state = 0;
    static final int stateDelim = 0;
    static final int stateInWord = 1;
    static final int stateInQuoteWord = 2;
    static final int stateQuoteInQuoteWord = 3;
    static final int stateEscapeInQuote = 4;

    public static Map mapFrom(List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); i += 2) {
            hashMap.put((String)list.get(i), (String)list.get(i + 1));
        }
        return hashMap;
    }

    public List parse(String string) throws Exception {
        this.resetColumns();
        this.newColumn();
        for (int i = 0; i < string.length(); ++i) {
            this.charEvent(string.charAt(i));
        }
        this.endOfStringEvent();
        return this.getCurrentColumns();
    }

    List getCurrentColumns() {
        if (this._columns == null) {
            this._columns = new ArrayList();
        }
        return this._columns;
    }

    int getState() {
        return this._state;
    }

    void resetColumns() {
        this._state = 0;
        this._columns = null;
    }

    String getCurrentColumn() {
        return this._columnBuffer.toString();
    }

    void charEvent(char c) {
        switch (c) {
            case ',': {
                this.commaEvent();
                break;
            }
            case '\"': {
                this.doubleQuoteEvent();
                break;
            }
            case '\t': 
            case ' ': {
                this.whitespaceEvent(c);
                break;
            }
            case '\\': {
                this.backslashEvent(c);
                break;
            }
            default: {
                this.defaultCharEvent(c);
            }
        }
    }

    void backslashEvent(char c) {
        if (this._state == 2) {
            this._state = 4;
        } else {
            this.defaultCharEvent(c);
        }
    }

    void whitespaceEvent(char c) {
        if (this._state != 0) {
            this.defaultCharEvent(c);
        }
    }

    void commaEvent() {
        switch (this._state) {
            case 1: {
                this.writeEndTrimColumn();
                this.newColumn();
                this._state = 0;
                break;
            }
            case 0: {
                this.writeColumn();
                break;
            }
            case 2: {
                this.append(',');
                break;
            }
            case 3: {
                this._state = 0;
            }
        }
    }

    void doubleQuoteEvent() {
        switch (this._state) {
            case 0: {
                this._state = 2;
                break;
            }
            case 1: {
                this.append('\"');
                break;
            }
            case 2: {
                this._state = 3;
                this.writeColumn();
                this.newColumn();
                break;
            }
            case 4: {
                this._state = 2;
                this.append('\"');
            }
        }
    }

    void defaultCharEvent(char c) {
        switch (this._state) {
            case 0: {
                this._state = 1;
                this.append(c);
                break;
            }
            case 1: {
                this.append(c);
                break;
            }
            case 2: {
                this.append(c);
                break;
            }
            case 4: {
                this.append('\\');
                this.append(c);
                this._state = 2;
            }
        }
    }

    void writeColumn() {
        this.getCurrentColumns().add(this.getCurrentColumn());
    }

    void newColumn() {
        this._columnBuffer.delete(0, this._columnBuffer.length());
    }

    void append(char c) {
        this._columnBuffer.append(c);
    }

    void endOfStringEvent() throws Exception {
        switch (this._state) {
            case 1: {
                this.writeEndTrimColumn();
                break;
            }
            case 2: {
                throw new Exception("Badly formed record: quoted string not terminated");
            }
            case 3: {
                break;
            }
            default: {
                this.writeColumn();
            }
        }
    }

    void writeEndTrimColumn() {
        this.getCurrentColumns().add(this.endTrim(this.getCurrentColumn()));
    }

    String endTrim(String string) {
        int n;
        for (n = string.length() - 1; n > -1 && this.isWhitespace(string.charAt(n)); --n) {
        }
        return string.substring(0, n + 1);
    }

    boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }
}

