/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrCSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IlrCSVReader
implements Iterator {
    private IlrCSVParser parser = new IlrCSVParser();
    private BufferedReader reader;
    private String currentLine;

    public IlrCSVReader(Reader reader) throws IOException {
        this.reader = new BufferedReader(reader);
        this.readNextLine();
    }

    public boolean hasNext() {
        return this.currentLine != null;
    }

    public Object next() {
        if (this.currentLine == null) {
            throw new NoSuchElementException();
        }
        try {
            List list = this.parser.parse(this.currentLine);
            this.readNextLine();
            return list.iterator();
        }
        catch (Exception exception) {
            throw new NoSuchElementException(exception.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private void readNextLine() throws IOException {
        do {
            this.currentLine = this.reader.readLine();
        } while (this.currentLine != null && this.isCommentLine(this.currentLine));
        if (this.currentLine == null) {
            this.close();
        }
    }

    private boolean isCommentLine(String string) {
        if (string.length() == 0) {
            return false;
        }
        return string.charAt(0) == '#';
    }
}

