/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.IOException;
import java.io.Writer;

public class IlrCSVWriter {
    private static final char DEFAULT_SEP = ',';
    private char fieldSep;
    private Writer writer;
    private boolean needSeparator = false;
    private StringBuffer buf = new StringBuffer();

    public IlrCSVWriter(Writer writer, char c) throws IOException {
        this.writer = writer;
        this.fieldSep = c;
    }

    public IlrCSVWriter(Writer writer) throws IOException {
        this(writer, ',');
    }

    public void endRecord() throws IOException {
        this.needSeparator = false;
        this.writer.write(10);
    }

    public void writeField(Object object) throws IOException {
        String string = object.toString();
        if (this.needSeparator) {
            this.writer.write(this.fieldSep);
            this.writer.write(32);
        }
        if (!string.equals("")) {
            this.writer.write("\"" + this.quotedValue(string) + "\"");
        }
        this.needSeparator = true;
    }

    private String quotedValue(String string) {
        if (string.indexOf("\"") != -1) {
            this.buf.setLength(0);
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\"') {
                    this.buf.append("\"\"");
                    continue;
                }
                this.buf.append(string.charAt(i));
            }
            return this.buf.toString();
        }
        return string;
    }
}

