/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrAuthorMap;
import ilog.rules.util.IlrAuthorWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class IlrCodePrintWriter
extends PrintWriter {
    private int indentSize = 4;
    private int indentLevel = 0;
    private boolean needIndent = true;
    private IlrAuthorWriter authorWriter = null;

    public IlrCodePrintWriter(Writer writer) {
        super(writer);
    }

    public IlrCodePrintWriter(Writer writer, int n) {
        super(writer);
        this.indentSize = n;
    }

    public IlrCodePrintWriter(IlrAuthorWriter ilrAuthorWriter) {
        this((Writer)ilrAuthorWriter);
        this.authorWriter = ilrAuthorWriter;
    }

    public IlrCodePrintWriter(IlrAuthorWriter ilrAuthorWriter, int n) {
        this((Writer)ilrAuthorWriter, n);
        this.authorWriter = ilrAuthorWriter;
    }

    private void indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.write(32);
        }
    }

    private void indentIfNeeded() {
        if (this.needIndent) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.write(32);
            }
        }
        this.needIndent = false;
    }

    public void addIndent(int n) {
        this.indentLevel += n * this.indentSize;
    }

    public void print(boolean bl) {
        this.indentIfNeeded();
        super.print(bl);
    }

    public void print(char c) {
        this.indentIfNeeded();
        super.print(c);
    }

    public void print(int n) {
        this.indentIfNeeded();
        super.print(n);
    }

    public void print(long l) {
        this.indentIfNeeded();
        super.print(l);
    }

    public void print(float f) {
        this.indentIfNeeded();
        super.print(f);
    }

    public void print(double d) {
        this.indentIfNeeded();
        super.print(d);
    }

    public void print(char[] cArray) {
        this.indentIfNeeded();
        super.print(cArray);
    }

    public void print(String string) {
        this.indentIfNeeded();
        super.print(string);
    }

    public void print(Object object) {
        this.indentIfNeeded();
        super.print(object);
    }

    public void println() {
        this.indentIfNeeded();
        super.println();
        this.needIndent = true;
    }

    public void println(boolean bl) {
        this.indentIfNeeded();
        super.println(bl);
        this.needIndent = true;
    }

    public void println(char c) {
        this.indentIfNeeded();
        super.println(c);
        this.needIndent = true;
    }

    public void println(int n) {
        this.indentIfNeeded();
        super.println(n);
        this.needIndent = true;
    }

    public void println(long l) {
        this.indentIfNeeded();
        super.println(l);
        this.needIndent = true;
    }

    public void println(float f) {
        this.indentIfNeeded();
        super.println(f);
        this.needIndent = true;
    }

    public void println(double d) {
        this.indentIfNeeded();
        super.println(d);
        this.needIndent = true;
    }

    public void println(char[] cArray) {
        this.indentIfNeeded();
        super.println(cArray);
        this.needIndent = true;
    }

    public void println(String string) {
        this.indentIfNeeded();
        super.println(string);
        this.needIndent = true;
    }

    public void println(Object object) {
        this.indentIfNeeded();
        super.println(object);
        this.needIndent = true;
    }

    public void openBlock() {
        this.println('{');
        this.addIndent(1);
    }

    public void closeBlock(boolean bl) {
        this.addIndent(-1);
        this.print('}');
        if (bl) {
            this.print(';');
        }
        this.println();
    }

    public void endline() {
        this.println(";");
    }

    public void reset() {
        if (this.authorWriter == null) {
            throw new IllegalStateException("No Author Writer");
        }
        this.authorWriter.reset();
    }

    public void resetAuthor() {
        this.authorWriter.resetAuthor();
    }

    public void setAuthor(Object object) {
        if (object == null) {
            this.resetAuthor();
        } else if (this.authorWriter != null) {
            this.authorWriter.setAuthor(object);
        } else {
            throw new IllegalStateException("No Author Writer");
        }
    }

    public IlrAuthorMap getAuthorMap() {
        if (this.authorWriter != null) {
            return this.authorWriter.getAuthorMap();
        }
        throw new IllegalStateException("No Author Writer");
    }
}

