/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrFileUtil;
import ilog.rules.util.IlrURI;
import ilog.rules.util.IlrURIUtils;
import ilog.rules.util.prefs.IlrMessages;
import java.io.File;

public class IlrFile
extends File
implements IlrURI {
    public static final String PROTOCOL = "file";
    private String rootId;

    public IlrFile(String string) {
        super(IlrFileUtil.ensureFileSeparator(IlrURIUtils.extractPathname(string)));
        this.rootId = IlrURIUtils.extractRootId(string);
    }

    public IlrFile(String string, String string2) {
        super(IlrFileUtil.ensureFileSeparator(string), IlrFileUtil.ensureFileSeparator(string2));
    }

    public IlrFile(File file, String string) {
        this(IlrFileUtil.ensureFileSeparator(file.getPath()), IlrFileUtil.ensureFileSeparator(string));
    }

    public IlrFile(File file) {
        super(IlrFileUtil.ensureFileSeparator(file.getPath()));
    }

    public IlrFile(String string, File file) {
        super(IlrFileUtil.ensureFileSeparator(file.getPath()));
        this.setRootId(string);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new IlrFile(this.rootId, this.getPath());
    }

    public void setRootId(String string) {
        this.rootId = string;
    }

    public String getRootId() {
        return this.rootId;
    }

    public boolean isFiltered() {
        return false;
    }

    public File getAbsoluteFile() {
        if (this.rootId != null) {
            String string = "rootID != null [" + this.rootId + "]: Cannot resolve absolute path\n";
            string = string + "relative path is " + this.getPath() + "\n";
            string = string + "Hints: use the IlrRepository.resolveFile method if applicable.";
            throw new UnsupportedOperationException(string);
        }
        return super.getAbsoluteFile();
    }

    public String getAbsolutePath() {
        if (this.rootId != null) {
            String string = "rootID != null [" + this.rootId + "]: Cannot resolve absolute path\n";
            string = string + "relative path is " + this.getPath() + "\n";
            string = string + "Hints: use the IlrRepository.resolveFile method if applicable.";
            throw new UnsupportedOperationException(string);
        }
        return super.getAbsolutePath();
    }

    public String getDisplayRootId() {
        return IlrMessages.getMessage(this.rootId);
    }

    public String getDisplayPath() {
        return IlrURIUtils.makeRelativeDisplayPathName(this.getPath(), this.rootId);
    }

    public String getType() {
        return PROTOCOL;
    }

    public IlrFile[] listIlrFiles() {
        IlrFile[] ilrFileArray = null;
        File[] fileArray = this.listFiles();
        if (fileArray != null) {
            ilrFileArray = new IlrFile[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                ilrFileArray[i] = new IlrFile(this.getRootId(), fileArray[i]);
            }
        }
        return ilrFileArray;
    }

    public static IlrFile[] fileList(File[] fileArray) {
        IlrFile[] ilrFileArray = null;
        if (fileArray != null) {
            ilrFileArray = new IlrFile[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                ilrFileArray[i] = new IlrFile(fileArray[i]);
            }
        }
        return ilrFileArray;
    }

    public boolean equals(Object object) {
        if (object instanceof IlrFile) {
            IlrFile ilrFile = (IlrFile)object;
            if (this.rootId != null) {
                return this.rootId.equals(ilrFile.getRootId()) && super.equals(object);
            }
        }
        return super.equals(object);
    }

    public String toString() {
        if (this.rootId != null) {
            return IlrURIUtils.makeRelativePathName(this.getPath(), this.rootId);
        }
        return this.getPath();
    }
}

