/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrFileChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class IlrFileMonitor {
    private Timer timer = new Timer(true);
    private Hashtable timerEntries = new Hashtable();

    public static IlrFileMonitor createInstance() {
        return new IlrFileMonitor();
    }

    protected IlrFileMonitor() {
    }

    public void removeAllListeners() {
        ArrayList arrayList = new ArrayList(this.timerEntries.values());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FileMonitorTask fileMonitorTask = (FileMonitorTask)iterator.next();
            fileMonitorTask.cancel();
        }
        this.timerEntries.clear();
    }

    public void addFileChangeListener(IlrFileChangeListener ilrFileChangeListener, String string, long l) {
        this.removeFileChangeListener(ilrFileChangeListener, string);
        try {
            FileMonitorTask fileMonitorTask = new FileMonitorTask(ilrFileChangeListener, string);
            this.timerEntries.put(string + ilrFileChangeListener.hashCode(), fileMonitorTask);
            this.timer.schedule((TimerTask)fileMonitorTask, l, l);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void removeFileChangeListener(IlrFileChangeListener ilrFileChangeListener, String string) {
        FileMonitorTask fileMonitorTask = (FileMonitorTask)this.timerEntries.remove(string + ilrFileChangeListener.hashCode());
        if (fileMonitorTask != null) {
            fileMonitorTask.cancel();
        }
    }

    protected void fireFileChangeEvent(IlrFileChangeListener ilrFileChangeListener, String string) {
        ilrFileChangeListener.fileChanged(string);
    }

    protected void fireFileRemovedEvent(IlrFileChangeListener ilrFileChangeListener, String string) {
        ilrFileChangeListener.fileRemoved(string);
    }

    class FileMonitorTask
    extends TimerTask {
        IlrFileChangeListener listener;
        String fileName;
        File monitoredFile;
        boolean canWrite;
        long lastModified;

        public FileMonitorTask(IlrFileChangeListener ilrFileChangeListener, String string) throws FileNotFoundException {
            this.listener = ilrFileChangeListener;
            this.fileName = string;
            this.canWrite = true;
            this.lastModified = 0L;
            this.monitoredFile = new File(string);
            if (!this.monitoredFile.exists()) {
                URL uRL = ilrFileChangeListener.getClass().getClassLoader().getResource(string);
                if (uRL != null) {
                    this.monitoredFile = new File(uRL.getFile());
                } else {
                    throw new FileNotFoundException("File Not Found: " + string);
                }
            }
            this.lastModified = this.monitoredFile.lastModified();
            this.canWrite = this.monitoredFile.canWrite();
        }

        public void run() {
            URL uRL;
            long l = this.monitoredFile.lastModified();
            boolean bl = this.monitoredFile.canWrite();
            if (!this.monitoredFile.exists() && (uRL = this.listener.getClass().getClassLoader().getResource(this.fileName)) == null) {
                IlrFileMonitor.this.fireFileRemovedEvent(this.listener, this.fileName);
                return;
            }
            if (l != this.lastModified || bl != this.canWrite) {
                this.lastModified = l;
                this.canWrite = bl;
                IlrFileMonitor.this.fireFileChangeEvent(this.listener, this.fileName);
            }
        }
    }
}

